/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.DVResolver;
import gnu.jel.LocalField;
import gnu.jel.LocalMethod;
import gnu.jel.OP;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Hashtable names;
    private Hashtable dynIDs;
    private Hashtable stateless;
    private Hashtable dotClasses;
    private boolean noDotSecurity = false;
    public DVResolver resolver;
    public Hashtable cnmap;

    public Library(Class[] staticLib, Class[] dynamicLib) {
        this(staticLib, dynamicLib, null);
    }

    public Library(Class[] staticLib, Class[] dynamicLib, Class[] dotClasses) {
        this(staticLib, dynamicLib, dotClasses, null);
    }

    public Library(Class[] staticLib, Class[] dynamicLib, Class[] dotClasses, DVResolver resolver) {
        this(staticLib, dynamicLib, dotClasses, resolver, null);
    }

    public Library(Class[] staticLib, Class[] dynamicLib, Class[] dotClasses, DVResolver resolver, Hashtable cnmap) {
        this.cnmap = cnmap;
        this.resolver = resolver;
        if (dotClasses == null) {
            this.dotClasses = null;
        } else {
            this.noDotSecurity = dotClasses.length == 0;
            this.dotClasses = new Hashtable();
            Class[] temp = new Class[1];
            int i = 0;
            while (i < dotClasses.length) {
                this.rehash(dotClasses[i]);
                ++i;
            }
        }
        this.names = new Hashtable();
        this.dynIDs = new Hashtable();
        this.stateless = new Hashtable();
        if (staticLib != null) {
            Library.rehash(staticLib, this.names, null, this.stateless);
        }
        if (dynamicLib != null) {
            Library.rehash(dynamicLib, this.names, this.dynIDs, null);
        }
    }

    private void rehash(Class cls) {
        Hashtable tempNames = new Hashtable();
        Class[] temp = new Class[]{cls};
        Library.rehash(temp, tempNames, new Hashtable(), null);
        this.dotClasses.put(cls, tempNames);
    }

    private static void rehash(Class[] arr, Hashtable hashedNames, Hashtable dynIDs, Hashtable stateless) {
        int i = 0;
        while (i < arr.length) {
            Integer dynID = new Integer(i);
            Method[] marr = arr[i].getMethods();
            Field[] farr = arr[i].getFields();
            int totalMethods = marr.length;
            int totalMembers = totalMethods + farr.length;
            int j = 0;
            while (j < totalMembers) {
                Method m;
                AccessibleObject accessibleObject = m = j < totalMethods ? marr[j] : farr[j - totalMethods];
                if ((m.getModifiers() & 8) > 0) {
                    if (stateless != null && Library.rehash(hashedNames, m)) {
                        stateless.put(m, Boolean.TRUE);
                    }
                } else if (dynIDs != null && Library.rehash(hashedNames, m)) {
                    dynIDs.put(m, dynID);
                }
                ++j;
            }
            ++i;
        }
    }

    private static boolean rehash(Hashtable hashedNames, Member m) {
        Hashtable signatures;
        String name = m.getName();
        String signature = Library.getSignature(m);
        if (Library.isField(m)) {
            signature = "()" + signature;
        }
        if ((signatures = (Hashtable)hashedNames.get(name)) == null) {
            Hashtable<String, Member> signatures_new = new Hashtable<String, Member>();
            signatures_new.put(signature, m);
            hashedNames.put(name, signatures_new);
            return true;
        }
        Object conflicting_method = signatures.get(signature);
        if (conflicting_method == null) {
            signatures.put(signature, m);
            return true;
        }
        return false;
    }

    public void markStateDependent(String name, Class[] params) throws CompilationException {
        Member m = this.getMember(null, name, params);
        Object removed = this.stateless.remove(m);
        Debug.assert(removed != null, "State dependent methos \"" + m + "\"is made state dependend again.");
    }

    public boolean isStateless(Member o) {
        return this.stateless.containsKey(o);
    }

    public Member getMember(Class container, String name, Class[] params) throws CompilationException {
        Hashtable signatures;
        Hashtable hashedMembers = this.names;
        if (container != null) {
            if (this.dotClasses == null) {
                throw new CompilationException(11, null);
            }
            if (!this.noDotSecurity && !this.dotClasses.containsKey(container)) {
                Object[] paramsExc = new Object[]{container};
                throw new CompilationException(12, paramsExc);
            }
            hashedMembers = (Hashtable)this.dotClasses.get(container);
            if (hashedMembers == null) {
                this.rehash(container);
                hashedMembers = (Hashtable)this.dotClasses.get(container);
            }
        }
        if ((signatures = (Hashtable)hashedMembers.get(name)) == null) {
            Object[] paramsExc = new Object[]{name, container};
            throw new CompilationException(container == null ? 5 : 6, paramsExc);
        }
        Vector<Member> applicable_methods = new Vector<Member>();
        Enumeration e = signatures.elements();
        while (e.hasMoreElements()) {
            Member cm = (Member)e.nextElement();
            Class[] cp = Library.getParameterTypes(cm);
            boolean applicable = false;
            if (params != null) {
                if (cp.length == params.length) {
                    applicable = true;
                    int i = 0;
                    while (i < cp.length && applicable) {
                        applicable = OP.isWidening(params[i], cp[i]);
                        ++i;
                    }
                }
            } else {
                boolean bl = applicable = cp.length == 0;
            }
            if (!applicable) continue;
            applicable_methods.addElement(cm);
        }
        if (applicable_methods.size() == 0) {
            Object[] paramsExc = new Object[]{name, Library.describe(name, params), container};
            throw new CompilationException(container == null ? 7 : 8, paramsExc);
        }
        if (applicable_methods.size() == 1) {
            return (Member)applicable_methods.firstElement();
        }
        Enumeration e2 = applicable_methods.elements();
        Member most_specific = (Member)e2.nextElement();
        Class[] most_specific_params = Library.getParameterTypes(most_specific);
        while (e2.hasMoreElements()) {
            Member cm = (Member)e2.nextElement();
            Class[] cp = Library.getParameterTypes(cm);
            boolean moreSpecific = true;
            boolean lessSpecific = true;
            int i = 0;
            while (i < cp.length) {
                moreSpecific = moreSpecific && OP.isWidening(cp[i], most_specific_params[i]);
                lessSpecific = lessSpecific && OP.isWidening(most_specific_params[i], cp[i]);
                ++i;
            }
            if (moreSpecific && !lessSpecific) {
                most_specific = cm;
                most_specific_params = cp;
            }
            if (moreSpecific ^ lessSpecific) continue;
            Object[] paramsExc = new Object[]{Library.describe(name, most_specific_params), Library.describe(name, cp), Library.describe(name, params), container};
            throw new CompilationException(container == null ? 9 : 10, paramsExc);
        }
        return most_specific;
    }

    protected static String describe(String name, Class[] params) {
        StringBuffer invp = new StringBuffer();
        invp.append(name);
        invp.append('(');
        if (params != null) {
            int k = 0;
            while (k < params.length) {
                if (k != 0) {
                    invp.append(',');
                }
                invp.append(params[k].toString());
                ++k;
            }
        }
        invp.append(')');
        return invp.toString();
    }

    public int getDynamicMethodClassID(Member m) {
        Integer id = (Integer)this.dynIDs.get(m);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public static Class getType(Member m) {
        if (m instanceof Method) {
            return ((Method)m).getReturnType();
        }
        if (m instanceof Field) {
            return ((Field)m).getType();
        }
        if (m instanceof LocalField) {
            return ((LocalField)m).getType();
        }
        Debug.assert(m instanceof Constructor);
        return OP.specialTypes[9];
    }

    public static Class[] getParameterTypes(Member m) {
        if (m instanceof Method) {
            return ((Method)m).getParameterTypes();
        }
        if (m instanceof LocalMethod) {
            return ((LocalMethod)m).getParameterTypes();
        }
        if (m instanceof Constructor) {
            return ((Constructor)m).getParameterTypes();
        }
        Debug.assert(m instanceof Field || m instanceof LocalField);
        return new Class[0];
    }

    public static String getSignature(Member m) {
        StringBuffer signature = new StringBuffer();
        if (!Library.isField(m)) {
            Class[] parameters = Library.getParameterTypes(m);
            signature.append('(');
            int i = 0;
            while (i < parameters.length) {
                Library.appendSignature(signature, parameters[i]);
                ++i;
            }
            signature.append(')');
        }
        Library.appendSignature(signature, Library.getType(m));
        return signature.toString();
    }

    public static boolean isField(Member m) {
        return m instanceof Field || m instanceof LocalField && !(m instanceof LocalMethod);
    }

    public static String getSignature(Class cls) {
        return Library.appendSignature(new StringBuffer(), cls).toString();
    }

    private static StringBuffer appendSignature(StringBuffer buff, Class cls) {
        if (cls.isPrimitive()) {
            int tid = OP.typeID(cls);
            buff.append(tid > 9 ? (char)'L' : "ZBCSIJFDLV".charAt(tid));
        } else if (cls.isArray()) {
            buff.append('[');
            Library.appendSignature(buff, cls.getComponentType());
        } else {
            buff.append('L');
            Library.appendHistoricalForm(buff, cls.getName());
            buff.append(';');
        }
        return buff;
    }

    public static String toHistoricalForm(String className) {
        return Library.appendHistoricalForm(new StringBuffer(), className).toString();
    }

    private static StringBuffer appendHistoricalForm(StringBuffer buff, String className) {
        int namelen = className.length();
        int i = 0;
        while (i < className.length()) {
            char cch = className.charAt(i);
            if (cch == '.') {
                cch = '/';
            }
            buff.append(cch);
            ++i;
        }
        return buff;
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        Library.test(t);
        t.summarize();
    }

    public static void test(Tester t) {
        Member mf;
        Class[] params;
        Class[] par1;
        Member mf2;
        Class[] par;
        Library ll = null;
        Class<?> math = null;
        try {
            math = Class.forName("java.lang.Math");
        }
        catch (ClassNotFoundException e) {
            Debug.println("It is IMPOSSIBLE :)");
        }
        t.startTest("Creating the library of java.lang.Math");
        try {
            Library l;
            Class[] sl = new Class[]{math};
            ll = l = new Library(sl, null);
            t.testOK();
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(double)");
        try {
            par = new Class[]{Double.TYPE};
            mf2 = ll.getMember(null, "round", par);
            if (mf2 != null && mf2.equals(math.getMethod("round", par))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(float)");
        try {
            par = new Class[]{Float.TYPE};
            mf2 = ll.getMember(null, "round", par);
            if (mf2 != null && mf2.equals(math.getMethod("round", par))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(int) best is round(float)");
        try {
            par = new Class[]{Integer.TYPE};
            mf2 = ll.getMember(null, "round", par);
            par1 = new Class[]{Float.TYPE};
            if (mf2 != null && mf2.equals(math.getMethod("round", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(int) best is abs(int)");
        try {
            par = new Class[]{Integer.TYPE};
            mf2 = ll.getMember(null, "abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf2 != null && mf2.equals(math.getMethod("abs", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(byte) best is abs(int)");
        try {
            par = new Class[]{Byte.TYPE};
            mf2 = ll.getMember(null, "abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf2 != null && mf2.equals(math.getMethod("abs", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(char) best is abs(int)");
        try {
            par = new Class[]{Character.TYPE};
            mf2 = ll.getMember(null, "abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf2 != null && mf2.equals(math.getMethod("abs", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation min(int,float) best is min(float,float)");
        try {
            par = new Class[]{Integer.TYPE, Float.TYPE};
            mf2 = ll.getMember(null, "min", par);
            par1 = new Class[]{Float.TYPE, Float.TYPE};
            if (mf2 != null && mf2.equals(math.getMethod("min", par1))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of access to the field PI");
        try {
            par = new Class[]{};
            Member f = ll.getMember(null, "PI", par);
            if (f != null && f.getName().equals("PI")) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Checking assignment of state dependence ");
        try {
            ll.markStateDependent("random", null);
            if (!ll.isStateless(ll.getMember(null, "random", null))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Creating a library with dot operations allowed ");
        Library ldot = null;
        try {
            Class[] stl = new Class[1];
            Class[] dynl = new Class[1];
            Class[] dotl = new Class[2];
            stl[0] = Class.forName("java.lang.Math");
            dynl[0] = Class.forName("java.util.Random");
            dotl[0] = Class.forName("java.util.Hashtable");
            dotl[1] = Class.forName("java.util.Vector");
            ldot = new Library(stl, dynl, dotl);
            t.testOK();
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Resolving size() on Hashtable");
        try {
            params = new Class[]{};
            Class<?> htable = Class.forName("java.util.Hashtable");
            mf = ldot.getMember(htable, "size", params);
            if (mf != null && mf.equals(htable.getMethod("size", params))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Resolving size() on Vector");
        try {
            params = new Class[]{};
            Class<?> vctr = Class.forName("java.util.Vector");
            mf = ldot.getMember(vctr, "size", params);
            if (mf != null && mf.equals(vctr.getMethod("size", params))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Ensuring size() is not leaked to global context.");
        try {
            params = new Class[]{};
            try {
                Member mf3 = ldot.getMember(null, "size", params);
                t.testFail();
            }
            catch (CompilationException exc) {
                t.testOK();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
    }
}

