/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "hlp.h"
#include "hlp-internal.h"

int
_lw6hlp_populate_references_funcs (lw6sys_context_t * sys_context, lw6sys_hash_t * references)
{
  int ret = 0;

  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_GETTEXT,
			 _x_
			 ("Calls GNU gettext to convert string in current locale. Note that '_' (plain underscode) is exported as well, so that code can be written using '_' as a function."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_SET_MEMORY_BAZOOKA_SIZE, _x_ ("Wrapper on lw6sys_set_memory_bazooka_size."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_MEMORY_BAZOOKA_SIZE, _x_ ("Wrapper on lw6sys_get_memory_bazooka_size."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_SET_MEMORY_BAZOOKA_ERASER, _x_ ("Wrapper on lw6sys_set_memory_bazooka_eraser."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_MEMORY_BAZOOKA_ERASER, _x_ ("Wrapper on lw6sys_get_memory_bazooka_eraser."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_PACKAGE_TARNAME, _x_ ("Wrapper on lw6sys_build_get_package_tarname."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_PACKAGE_NAME, _x_ ("Wrapper on lw6sys_build_get_package_name."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_PACKAGE_STRING, _x_ ("Wrapper on lw6sys_build_get_package_string."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_PACKAGE_ID, _x_ ("Wrapper on lw6sys_build_get_package_id."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_VERSION, _x_ ("Wrapper on lw6sys_build_get_version."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_CODENAME, _x_ ("Wrapper on lw6sys_build_get_codename."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_VERSION_BASE, _x_ ("Wrapper on lw6sys_build_get_version_base."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_VERSION_MAJOR, _x_ ("Wrapper on lw6sys_build_get_version_major."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_VERSION_MINOR, _x_ ("Wrapper on lw6sys_build_get_version_minor."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_STAMP, _x_ ("Wrapper on lw6sys_build_get_stamp."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_MD5SUM, _x_ ("Wrapper on lw6sys_build_get_md5sum."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_COPYRIGHT, _x_ ("Wrapper on lw6sys_build_get_copyright."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_LICENSE, _x_ ("Wrapper on lw6sys_build_get_license."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_HOME_URL, _x_ ("Wrapper on lw6sys_build_get_home_url."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_BUGS_URL, _x_ ("Wrapper on lw6sys_build_get_bugs_url."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_CONFIGURE_ARGS, _x_ ("Wrapper on lw6sys_build_get_configure_args."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_GCC_VERSION, _x_ ("Wrapper on lw6sys_build_get_gcc_version."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_CFLAGS, _x_ ("Wrapper on lw6sys_build_get_cflags."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_LDFLAGS, _x_ ("Wrapper on lw6sys_build_get_ldflags."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_HOSTNAME, _x_ ("Wrapper on lw6sys_build_get_hostname."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_DATE, _x_ ("Wrapper on lw6sys_build_get_date."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_TIME, _x_ ("Wrapper on lw6sys_build_get_time."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_HOST_CPU, _x_ ("Wrapper on lw6sys_build_get_host_cpu."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENDIANNESS, _x_ ("Wrapper on lw6sys_build_get_endianness."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_POINTER_SIZE, _x_ ("Wrapper on lw6sys_build_get_pointer_size."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_IS_X86, _x_ ("Wrapper on lw6sys_build_is_x86."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_IS_AMD64, _x_ ("Wrapper on lw6sys_build_is_amd64."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_HOST_OS, _x_ ("Wrapper on lw6sys_build_get_host_os."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_IS_GNU, _x_ ("Wrapper on lw6sys_build_is_gnu."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_IS_UNIX, _x_ ("Wrapper on lw6sys_build_is_unix."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_IS_MS_WINDOWS, _x_ ("Wrapper on lw6sys_build_is_ms_windows."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_IS_MAC_OS_X, _x_ ("Wrapper on lw6sys_build_is_mac_os_x."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_IS_GP2X, _x_ ("Wrapper on lw6sys_build_is_gp2x."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_TOP_SRCDIR, _x_ ("Wrapper on lw6sys_build_get_top_srcdir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ABS_SRCDIR, _x_ ("Wrapper on lw6sys_build_get_abs_srcdir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_PREFIX, _x_ ("Wrapper on lw6sys_build_get_prefix."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_DATADIR, _x_ ("Wrapper on lw6sys_build_get_datadir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_LIBDIR, _x_ ("Wrapper on lw6sys_build_get_libdir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_INCLUDEDIR, _x_ ("Wrapper on lw6sys_build_get_includedir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_LOCALEDIR, _x_ ("Wrapper on lw6sys_build_get_localedir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_DOCDIR, _x_ ("Wrapper on lw6sys_build_get_docdir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_CONSOLE, _x_ ("Wrapper on lw6sys_build_get_enable_console."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_GTK, _x_ ("Wrapper on lw6sys_build_get_enable_gtk."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_MOD_GL1, _x_ ("Wrapper on lw6sys_build_get_enable_mod_gl1."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_MOD_GLES2, _x_ ("Wrapper on lw6sys_build_get_enable_mod_gles2."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_MOD_SOFT, _x_ ("Wrapper on lw6sys_build_get_enable_mod_soft."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_MOD_CACA, _x_ ("Wrapper on lw6sys_build_get_enable_mod_caca."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_MOD_CSOUND, _x_ ("Wrapper on lw6sys_build_get_enable_mod_csound."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_MOD_OGG, _x_ ("Wrapper on lw6sys_build_get_enable_mod_ogg."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_MOD_HTTP, _x_ ("Wrapper on lw6sys_build_get_enable_mod_http."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_OPENMP, _x_ ("Wrapper on lw6sys_build_get_enable_openmp."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_OPTIMIZE, _x_ ("Wrapper on lw6sys_build_get_enable_optimize."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_ALLINONE, _x_ ("Wrapper on lw6sys_build_get_enable_allinone."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_FULLSTATIC, _x_ ("Wrapper on lw6sys_build_get_enable_fullstatic."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_PARANOID, _x_ ("Wrapper on lw6sys_build_get_enable_paranoid."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_GPROF, _x_ ("Wrapper on lw6sys_build_get_enable_gprof."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_INSTRUMENT, _x_ ("Wrapper on lw6sys_build_get_enable_instrument."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_PROFILER, _x_ ("Wrapper on lw6sys_build_get_enable_profiler."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_GCOV, _x_ ("Wrapper on lw6sys_build_get_enable_gcov."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_ENABLE_VALGRIND, _x_ ("Wrapper on lw6sys_build_get_enable_valgrind."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_BUILD_GET_BIN_ID, _x_ ("Wrapper on lw6sys_build_get_bin_id."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_DEBUG_GET, _x_ ("Wrapper on lw6sys_debug_get."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_DEBUG_SET, _x_ ("Wrapper on lw6sys_debug_set."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_DUMP, _x_ ("Wrapper on lw6sys_dump."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_DUMP_CLEAR, _x_ ("Wrapper on lw6sys_dump_clear."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_USERNAME, _x_ ("Wrapper on lw6sys_get_username."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_HOSTNAME, _x_ ("Wrapper on lw6sys_get_hostname."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GETENV, _x_ ("Wrapper on lw6sys_getenv."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GETENV_PREFIXED, _x_ ("Wrapper on lw6sys_getenv_prefixed."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GENERATE_ID_16, _x_ ("Wrapper on lw6sys_generate_id_16."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GENERATE_ID_32, _x_ ("Wrapper on lw6sys_generate_id_32."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GENERATE_ID_64, _x_ ("Wrapper on lw6sys_generate_id_64."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_LOG, _x_ ("Wrapper on lw6sys_log."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_LOG_SET_DIALOG_TIMEOUT, _x_ ("Wrapper on lw6sys_log_set_dialog_timeout."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_LOG_GET_LEVEL, _x_ ("Wrapper on lw6sys_log_get_level."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_LOG_SET_LEVEL, _x_ ("Wrapper on lw6sys_log_set_level."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_LOG_GET_BACKTRACE_MODE, _x_ ("Wrapper on lw6sys_log_get_backtrace_mode."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_LOG_SET_BACKTRACE_MODE, _x_ ("Wrapper on lw6sys_log_set_backtrace_mode."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_MEGABYTES_AVAILABLE, _x_ ("Wrapper on lw6sys_megabytes_available."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_OPENMP_GET_NUM_PROCS, _x_ ("Wrapper on lw6sys_openmp_get_num_procs."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_USER_DIR, _x_ ("Wrapper on lw6sys_get_default_user_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_CONFIG_FILE, _x_ ("Wrapper on lw6sys_get_default_config_file."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_LOG_FILE, _x_ ("Wrapper on lw6sys_get_default_log_file."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_PREFIX, _x_ ("Wrapper on lw6sys_get_default_prefix."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_MOD_DIR, _x_ ("Wrapper on lw6sys_get_default_mod_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_DATA_DIR, _x_ ("Wrapper on lw6sys_get_default_data_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_MUSIC_DIR, _x_ ("Wrapper on lw6sys_get_default_music_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_MUSIC_PATH, _x_ ("Wrapper on lw6sys_get_default_music_path."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_MAP_DIR, _x_ ("Wrapper on lw6sys_get_default_map_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_MAP_PATH, _x_ ("Wrapper on lw6sys_get_default_map_path."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DEFAULT_SCRIPT_FILE, _x_ ("Wrapper on lw6sys_get_default_script_file."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_CWD, _x_ ("Wrapper on lw6sys_get_cwd."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_RUN_DIR, _x_ ("Wrapper on lw6sys_get_run_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_USER_DIR, _x_ ("Wrapper on lw6sys_get_user_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_CONFIG_FILE, _x_ ("Wrapper on lw6sys_get_config_file."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_LOG_FILE, _x_ ("Wrapper on lw6sys_get_log_file."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_PREFIX, _x_ ("Wrapper on lw6sys_get_prefix."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_MOD_DIR, _x_ ("Wrapper on lw6sys_get_mod_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_DATA_DIR, _x_ ("Wrapper on lw6sys_get_data_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_MUSIC_DIR, _x_ ("Wrapper on lw6sys_get_music_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_MUSIC_PATH, _x_ ("Wrapper on lw6sys_get_music_path."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_MAP_DIR, _x_ ("Wrapper on lw6sys_get_map_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_MAP_PATH, _x_ ("Wrapper on lw6sys_get_map_path."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_SCRIPT_FILE, _x_ ("Wrapper on lw6sys_get_script_file."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_PATH_CONCAT, _x_ ("Wrapper on lw6sys_path_concat."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_PATH_FILE_ONLY, _x_ ("Wrapper on lw6sys_path_file_only."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_PATH_PARENT, _x_ ("Wrapper on lw6sys_path_parent."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_PATH_SPLIT, _x_ ("Wrapper on lw6sys_path_split."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_SIGNAL_CUSTOM, _x_ ("Wrapper on lw6sys_signal_custom."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_SIGNAL_DEFAULT, _x_ ("Wrapper on lw6sys_signal_default."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_SIGNAL_SEND_QUIT, _x_ ("Wrapper on lw6sys_signal_send_quit."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_SIGNAL_POLL_QUIT, _x_ ("Wrapper on lw6sys_signal_poll_quit."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_TIMESTAMP, _x_ ("Wrapper on lw6sys_get_timestamp."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_UPTIME, _x_ ("Wrapper on lw6sys_get_uptime."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_GET_CYCLE, _x_ ("Wrapper on lw6sys_get_cycle."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_SLEEP, _x_ ("Wrapper on lw6sys_sleep."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_DELAY, _x_ ("Wrapper on lw6sys_delay."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_IDLE, _x_ ("Wrapper on lw6sys_idle."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_SNOOZE, _x_ ("Wrapper on lw6sys_snooze."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SYS_URL_CANONIZE, _x_ ("Wrapper on lw6sys_url_canonize."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_ABOUT, _x_ ("Wrapper on lw6hlp_about."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_GET_DEFAULT_VALUE, _x_ ("Wrapper on lw6hlp_get_default_value."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_QUICK, _x_ ("Wrapper on lw6hlp_list_quick."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_DOC, _x_ ("Wrapper on lw6hlp_list_doc."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_SHOW, _x_ ("Wrapper on lw6hlp_list_show."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_PATH, _x_ ("Wrapper on lw6hlp_list_path."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_PLAYERS, _x_ ("Wrapper on lw6hlp_list_players."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_INPUT, _x_ ("Wrapper on lw6hlp_list_input."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_GRAPHICS, _x_ ("Wrapper on lw6hlp_list_graphics."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_SOUND, _x_ ("Wrapper on lw6hlp_list_sound."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_NETWORK, _x_ ("Wrapper on lw6hlp_list_network."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_MAP, _x_ ("Wrapper on lw6hlp_list_map."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_MAP_RULES, _x_ ("Wrapper on lw6hlp_list_map_rules."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_MAP_HINTS, _x_ ("Wrapper on lw6hlp_list_map_hints."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_MAP_STYLE, _x_ ("Wrapper on lw6hlp_list_map_style."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_MAP_TEAMS, _x_ ("Wrapper on lw6hlp_list_map_teams."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_FUNCS, _x_ ("Wrapper on lw6hlp_list_funcs."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_HOOKS, _x_ ("Wrapper on lw6hlp_list_hooks."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_ADVANCED, _x_ ("Wrapper on lw6hlp_list_advanced."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_ALIASES, _x_ ("Wrapper on lw6hlp_list_aliases."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_TEAM_COLORS, _x_ ("Wrapper on lw6hlp_list_team_colors."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST_WEAPONS, _x_ ("Wrapper on lw6hlp_list_weapons."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6HLP_LIST, _x_ ("Wrapper on lw6hlp_list."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_DEFAULTS, _x_ ("Wrapper on lw6cfg_defaults."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_LOAD, _x_ ("Wrapper on lw6cfg_load."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_OPTION_EXISTS, _x_ ("Wrapper on lw6cfg_option_exists."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_GET_OPTION, _x_ ("Wrapper on lw6cfg_get_option."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_SET_OPTION, _x_ ("Wrapper on lw6cfg_set_option."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_SAVE, _x_ ("Wrapper on lw6cfg_save."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_INIT, _x_ ("Wrapper on lw6cfg_init."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_QUIT, _x_ ("Wrapper on lw6cfg_quit."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_UNIFIED_GET_USER_DIR, _x_ ("Wrapper on lw6cfg_unified_get_user_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_UNIFIED_GET_LOG_FILE, _x_ ("Wrapper on lw6cfg_unified_get_log_file."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_UNIFIED_GET_MUSIC_PATH, _x_ ("Wrapper on lw6cfg_unified_get_music_path."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CFG_UNIFIED_GET_MAP_PATH, _x_ ("Wrapper on lw6cfg_unified_get_map_path."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_NEW, _x_ ("Wrapper on lw6gui_menu_new."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_APPEND, _x_ ("Wrapper on lw6gui_menu_append."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_REMOVE, _x_ ("Wrapper on lw6gui_menu_remove."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_REMOVE_ALL, _x_ ("Wrapper on lw6gui_menu_remove_all."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_SYNC, _x_ ("Wrapper on lw6gui_menu_sync."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_SELECT, _x_ ("Wrapper on lw6gui_menu_select."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_SELECT_ESC, _x_ ("Wrapper on lw6gui_menu_select_esc."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_ENABLE_ESC, _x_ ("Wrapper on lw6gui_menu_enable_esc."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_SCROLL_UP, _x_ ("Wrapper on lw6gui_menu_scroll_up."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_SCROLL_DOWN, _x_ ("Wrapper on lw6gui_menu_scroll_down."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_SET_BREADCRUMBS, _x_ ("Wrapper on lw6gui_menu_set_breadcrumbs."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_CLOSE_POPUP, _x_ ("Wrapper on lw6gui_menu_close_popup."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MENU_HAS_POPUP, _x_ ("Wrapper on lw6gui_menu_has_popup."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_DEFAULT_LOOK, _x_ ("Wrapper on lw6gui_default_look."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_LOOK_SET, _x_ ("Wrapper on lw6gui_look_set."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_LOOK_GET, _x_ ("Wrapper on lw6gui_look_get."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_LOOK_ZOOM_IN, _x_ ("Wrapper on lw6gui_look_zoom_in."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_LOOK_ZOOM_OUT, _x_ ("Wrapper on lw6gui_look_zoom_out."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_INPUT_RESET, _x_ ("Wrapper on lw6gui_input_reset."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_POLL_MOVE, _x_ ("Wrapper on lw6gui_mouse_poll_move."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_GET_STATE, _x_ ("Wrapper on lw6gui_mouse_get_state."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_IS_PRESSED, _x_ ("Wrapper on lw6gui_keyboard_is_pressed."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_GET_MOVE_PAD, _x_ ("Wrapper on lw6gui_keyboard_get_move_pad."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_GET_MOVE_PAD, _x_ ("Wrapper on lw6gui_joystick1_get_move_pad."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_GET_MOVE_PAD, _x_ ("Wrapper on lw6gui_joystick2_get_move_pad."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_POP_BUTTON_LEFT, _x_ ("Wrapper on lw6gui_mouse_pop_button_left."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_POP_BUTTON_RIGHT, _x_ ("Wrapper on lw6gui_mouse_pop_button_right."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_POP_BUTTON_MIDDLE, _x_ ("Wrapper on lw6gui_mouse_pop_button_middle."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_POP_SIMPLE_CLICK, _x_ ("Wrapper on lw6gui_mouse_pop_simple_click."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_POP_DOUBLE_CLICK, _x_ ("Wrapper on lw6gui_mouse_pop_double_click."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_POP_TRIPLE_CLICK, _x_ ("Wrapper on lw6gui_mouse_pop_triple_click."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_POP_WHEEL_UP, _x_ ("Wrapper on lw6gui_mouse_pop_wheel_up."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_MOUSE_POP_WHEEL_DOWN, _x_ ("Wrapper on lw6gui_mouse_pop_wheel_down."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_ARROW_UP, _x_ ("Wrapper on lw6gui_keyboard_pop_arrow_up."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_ARROW_DOWN, _x_ ("Wrapper on lw6gui_keyboard_pop_arrow_down."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_ARROW_LEFT, _x_ ("Wrapper on lw6gui_keyboard_pop_arrow_left."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_ARROW_RIGHT, _x_ ("Wrapper on lw6gui_keyboard_pop_arrow_right."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_KEY_ENTER, _x_ ("Wrapper on lw6gui_keyboard_pop_key_enter."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_KEY_ESC, _x_ ("Wrapper on lw6gui_keyboard_pop_key_esc."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_KEY_CTRL, _x_ ("Wrapper on lw6gui_keyboard_pop_key_ctrl."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_KEY_ALT, _x_ ("Wrapper on lw6gui_keyboard_pop_key_alt."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_KEY_PGUP, _x_ ("Wrapper on lw6gui_keyboard_pop_key_pgup."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_KEYBOARD_POP_KEY_PGDOWN, _x_ ("Wrapper on lw6gui_keyboard_pop_key_pgdown."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_PAD_UP, _x_ ("Wrapper on lw6gui_joystick1_pop_pad_up."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_PAD_DOWN, _x_ ("Wrapper on lw6gui_joystick1_pop_pad_down."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_PAD_LEFT, _x_ ("Wrapper on lw6gui_joystick1_pop_pad_left."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_PAD_RIGHT, _x_ ("Wrapper on lw6gui_joystick1_pop_pad_right."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_BUTTON_A, _x_ ("Wrapper on lw6gui_joystick1_pop_button_a."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_BUTTON_B, _x_ ("Wrapper on lw6gui_joystick1_pop_button_b."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_BUTTON_C, _x_ ("Wrapper on lw6gui_joystick1_pop_button_c."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_BUTTON_D, _x_ ("Wrapper on lw6gui_joystick1_pop_button_d."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_BUTTON_E, _x_ ("Wrapper on lw6gui_joystick1_pop_button_e."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK1_POP_BUTTON_F, _x_ ("Wrapper on lw6gui_joystick1_pop_button_f."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_PAD_UP, _x_ ("Wrapper on lw6gui_joystick2_pop_pad_up."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_PAD_DOWN, _x_ ("Wrapper on lw6gui_joystick2_pop_pad_down."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_PAD_LEFT, _x_ ("Wrapper on lw6gui_joystick2_pop_pad_left."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_PAD_RIGHT, _x_ ("Wrapper on lw6gui_joystick2_pop_pad_right."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_BUTTON_A, _x_ ("Wrapper on lw6gui_joystick2_pop_button_a."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_BUTTON_B, _x_ ("Wrapper on lw6gui_joystick2_pop_button_b."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_BUTTON_C, _x_ ("Wrapper on lw6gui_joystick2_pop_button_c."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_BUTTON_D, _x_ ("Wrapper on lw6gui_joystick2_pop_button_d."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_BUTTON_E, _x_ ("Wrapper on lw6gui_joystick2_pop_button_e."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GUI_JOYSTICK2_POP_BUTTON_F, _x_ ("Wrapper on lw6gui_joystick2_pop_button_f."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GFX_GET_BACKENDS, _x_ ("Wrapper on lw6gfx_get_backends."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6DSP_NEW, _x_ ("Wrapper on lw6dsp_new."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6DSP_RELEASE, _x_ ("Wrapper on lw6dsp_release."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6DSP_UPDATE, _x_ ("Wrapper on lw6dsp_update."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6DSP_GET_NB_FRAMES, _x_ ("Wrapper on lw6dsp_get_nb_frames."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6DSP_GET_LAST_FRAME_RENDERING_TIME, _x_ ("Wrapper on lw6dsp_get_last_frame_rendering_time."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6DSP_GET_INSTANT_FPS, _x_ ("Wrapper on lw6dsp_get_instant_fps."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6DSP_GET_AVERAGE_FPS, _x_ ("Wrapper on lw6dsp_get_average_fps."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6DSP_GET_VIDEO_MODE, _x_ ("Wrapper on lw6dsp_get_video_mode."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6DSP_GET_FULLSCREEN_MODES, _x_ ("Wrapper on lw6dsp_get_fullscreen_modes."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6LDR_GET_ENTRIES, _x_ ("Wrapper on lw6ldr_get_entries."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6LDR_READ, _x_ ("Wrapper on lw6ldr_read."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6LDR_READ_RELATIVE, _x_ ("Wrapper on lw6ldr_read_relative."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6LDR_PRINT_EXAMPLES, _x_ ("Wrapper on lw6ldr_print_examples."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6LDR_HINTS_GET_DEFAULT, _x_ ("Wrapper on lw6ldr_hints_get_default."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6LDR_EXP_VALIDATE, _x_ ("Wrapper on lw6ldr_exp_validate."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6LDR_CHAIN_ENTRY, _x_ ("Wrapper on lw6ldr_chain_entry."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_GET_LOOK, _x_ ("Wrapper on lw6map_get_look."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_PARAM_GET, _x_ ("Wrapper on lw6map_param_get."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_GET_TITLE, _x_ ("Wrapper on lw6map_get_title."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_GET_MUSIC_DIR, _x_ ("Wrapper on lw6map_get_music_dir."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_TEAM_COLOR_INDEX_TO_KEY, _x_ ("Wrapper on lw6map_team_color_index_to_key."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_TEAM_COLOR_KEY_TO_INDEX, _x_ ("Wrapper on lw6map_team_color_key_to_index."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_TEAM_COLOR_INDEX_TO_LABEL, _x_ ("Wrapper on lw6map_team_color_index_to_label."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_TEAM_COLOR_LIST, _x_ ("Wrapper on lw6map_team_color_list."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_WEAPON_INDEX_TO_KEY, _x_ ("Wrapper on lw6map_weapon_index_to_key."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_WEAPON_KEY_TO_INDEX, _x_ ("Wrapper on lw6map_weapon_key_to_index."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_WEAPON_INDEX_TO_LABEL, _x_ ("Wrapper on lw6map_weapon_index_to_label."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_WEAPON_LIST, _x_ ("Wrapper on lw6map_weapon_list."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_RULES_GET_DEFAULT, _x_ ("Wrapper on lw6map_rules_get_default."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_RULES_GET_MIN, _x_ ("Wrapper on lw6map_rules_get_min."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_RULES_GET_MAX, _x_ ("Wrapper on lw6map_rules_get_max."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_RULES_GET_INT, _x_ ("Wrapper on lw6map_rules_get_int."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_STYLE_GET_DEFAULT, _x_ ("Wrapper on lw6map_style_get_default."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_TEAMS_GET_DEFAULT, _x_ ("Wrapper on lw6map_teams_get_default."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_EXP_IS_TEAM_COLOR_ALLOWED, _x_ ("Wrapper on lw6map_exp_is_team_color_allowed."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_EXP_IS_WEAPON_ALLOWED, _x_ ("Wrapper on lw6map_exp_is_weapon_allowed."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_EXP_GET_UNLOCKED_TEAM_COLOR, _x_ ("Wrapper on lw6map_exp_get_unlocked_team_color."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_EXP_GET_UNLOCKED_WEAPON, _x_ ("Wrapper on lw6map_exp_get_unlocked_weapon."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_GET_MAX_NB_COLORS, _x_ ("Wrapper on lw6map_get_max_nb_colors."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_GET_MAX_NB_CURSORS, _x_ ("Wrapper on lw6map_get_max_nb_cursors."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6MAP_GET_MAX_NB_NODES, _x_ ("Wrapper on lw6map_get_max_nb_nodes."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_BUILD_GAME_STRUCT, _x_ ("Wrapper on lw6ker_build_game_struct."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_BUILD_GAME_STATE, _x_ ("Wrapper on lw6ker_build_game_state."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_SYNC_GAME_STATE, _x_ ("Wrapper on lw6ker_sync_game_state."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_DUP_GAME_STATE, _x_ ("Wrapper on lw6ker_dup_game_state."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_GAME_STRUCT_CHECKSUM, _x_ ("Wrapper on lw6ker_game_struct_checksum."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_GAME_STATE_CHECKSUM, _x_ ("Wrapper on lw6ker_game_state_checksum."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_REGISTER_NODE, _x_ ("Wrapper on lw6ker_register_node."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_UNREGISTER_NODE, _x_ ("Wrapper on lw6ker_unregister_node."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_NODE_EXISTS, _x_ ("Wrapper on lw6ker_node_exists."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_ADD_CURSOR, _x_ ("Wrapper on lw6ker_add_cursor."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_REMOVE_CURSOR, _x_ ("Wrapper on lw6ker_remove_cursor."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_CURSOR_EXISTS, _x_ ("Wrapper on lw6ker_cursor_exists."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_GET_CURSOR, _x_ ("Wrapper on lw6ker_get_cursor."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_SET_CURSOR, _x_ ("Wrapper on lw6ker_set_cursor."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_DO_ROUND, _x_ ("Wrapper on lw6ker_do_round."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_GET_MOVES, _x_ ("Wrapper on lw6ker_get_moves."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_GET_SPREADS, _x_ ("Wrapper on lw6ker_get_spreads."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_GET_ROUNDS, _x_ ("Wrapper on lw6ker_get_rounds."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_IS_OVER, _x_ ("Wrapper on lw6ker_is_over."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_DID_CURSOR_WIN, _x_ ("Wrapper on lw6ker_did_cursor_win."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_GET_NB_COLORS, _x_ ("Wrapper on lw6ker_game_state_get_nb_colors."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_GET_NB_CURSORS, _x_ ("Wrapper on lw6ker_game_state_get_nb_cursors."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6KER_GET_NB_NODES, _x_ ("Wrapper on lw6ker_game_state_get_nb_nodes."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GEN_CREATE_FROM_SEED, _x_ ("Wrapper on lw6gen_create_from_seed."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GEN_SEED_NEW, _x_ ("Wrapper on lw6gen_seed_new."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6GEN_SEED_NORMALIZE, _x_ ("Wrapper on lw6gen_seed_normalize."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_BENCH, _x_ ("Wrapper on lw6pil_bench."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SEED_COMMAND_GENERATE, _x_ ("Wrapper on lw6pil_seed_command_generate."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_DUMP_COMMAND_GENERATE, _x_ ("Wrapper on lw6pil_dump_command_generate."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_POLL_DUMP, _x_ ("Wrapper on lw6pil_poll_dump."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_BUILD_PILOT, _x_ ("Wrapper on lw6pil_build_pilot."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SEND_COMMAND, _x_ ("Wrapper on lw6pil_send_command."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_LOCAL_COMMAND, _x_ ("Wrapper on lw6pil_local_command."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_COMMIT, _x_ ("Wrapper on lw6pil_commit."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_FIX_COORDS, _x_ ("Wrapper on lw6pil_coords_fix."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_FIX_COORDS_X10, _x_ ("Wrapper on lw6pil_coords_fix_x10."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_EXECUTE_COMMAND, _x_ ("Wrapper on lw6pil_execute_command."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_LOCAL_CURSORS_SET_MAIN, _x_ ("Wrapper on lw6pil_local_cursors_set_main."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_LOCAL_CURSORS_SET_MOUSE_CONTROLLED,
			 _x_ ("Wrapper on lw6pil_local_cursors_set_mouse_controlled."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_MAKE_BACKUP, _x_ ("Wrapper on lw6pil_make_backup."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SYNC_FROM_BACKUP, _x_ ("Wrapper on lw6pil_sync_from_backup."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SYNC_FROM_REFERENCE, _x_ ("Wrapper on lw6pil_sync_from_reference."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SYNC_FROM_DRAFT, _x_ ("Wrapper on lw6pil_sync_from_draft."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_CALIBRATE, _x_ ("Wrapper on lw6pil_calibrate."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SPEED_UP, _x_ ("Wrapper on lw6pil_speed_up."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SLOW_DOWN, _x_ ("Wrapper on lw6pil_slow_down."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_GET_ROUND_0, _x_ ("Wrapper on lw6pil_get_round_0."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_GET_SEQ_0, _x_ ("Wrapper on lw6pil_get_seq_0."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SEQ2ROUND, _x_ ("Wrapper on lw6pil_seq2round."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_ROUND2SEQ, _x_ ("Wrapper on lw6pil_round2seq."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_GET_NEXT_SEQ, _x_ ("Wrapper on lw6pil_get_next_seq."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_GET_LAST_COMMIT_SEQ, _x_ ("Wrapper on lw6pil_get_last_commit_seq."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_GET_REFERENCE_CURRENT_SEQ, _x_ ("Wrapper on lw6pil_get_reference_current_seq."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_GET_REFERENCE_TARGET_SEQ, _x_ ("Wrapper on lw6pil_get_reference_target_seq."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_GET_MAX_SEQ, _x_ ("Wrapper on lw6pil_get_max_seq."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_IS_OVER, _x_ ("Wrapper on lw6pil_is_over."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_DID_CURSOR_WIN, _x_ ("Wrapper on lw6pil_did_cursor_win."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_GET_WINNER, _x_ ("Wrapper on lw6pil_get_winner."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_GET_LOOSER, _x_ ("Wrapper on lw6pil_get_looser."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SEQ_RANDOM_0, _x_ ("Wrapper on lw6pil_seq_random_0."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SUITE_INIT, _x_ ("Wrapper on lw6pil_suite_init."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SUITE_GET_SEQ_0, _x_ ("Wrapper on lw6pil_suite_get_seq_0."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SUITE_GET_NODE_ID, _x_ ("Wrapper on lw6pil_suite_get_node_id."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SUITE_GET_COMMANDS_BY_NODE_INDEX,
			 _x_ ("Wrapper on lw6pil_suite_get_command_by_node_index, returns the list of all steps."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SUITE_GET_COMMANDS_BY_STAGE,
			 _x_ ("Wrapper on lw6pil_suite_get_command_by_stage, returns the list of all steps."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6PIL_SUITE_GET_CHECKPOINT, _x_ ("Wrapper on lw6pil_suite_get_checkpoint."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_GET_BACKENDS, _x_ ("Wrapper on lw6snd_get_backends."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_NEW, _x_ ("Wrapper on lw6snd_new."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_POLL, _x_ ("Wrapper on lw6snd_poll."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_RELEASE, _x_ ("Wrapper on lw6snd_release."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_PLAY_FX, _x_ ("Wrapper on lw6snd_play_fx."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_SET_FX_VOLUME, _x_ ("Wrapper on lw6snd_set_fx_volume."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_SET_WATER_VOLUME, _x_ ("Wrapper on lw6snd_set_water_volume."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_IS_MUSIC_FILE, _x_ ("Wrapper on lw6snd_is_music_file."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_PLAY_MUSIC_FILE, _x_ ("Wrapper on lw6snd_play_music_file."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_PLAY_MUSIC_RANDOM, _x_ ("Wrapper on lw6snd_play_music_random."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_STOP_MUSIC, _x_ ("Wrapper on lw6snd_stop_music."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SND_SET_MUSIC_VOLUME, _x_ ("Wrapper on lw6snd_set_music_volume."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CNS_CONSOLE_SUPPORT, _x_ ("Wrapper on lw6cns_console_support."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CNS_TERM_SUPPORT, _x_ ("Wrapper on lw6cns_term_support."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CNS_INIT, _x_ ("Wrapper on lw6cns_init."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CNS_QUIT, _x_ ("Wrapper on lw6cns_quit."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CNS_POLL, _x_ ("Wrapper on lw6cns_poll."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6TSK_LOADER_NEW, _x_ ("Wrapper on lw6tsk_loader_new."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6TSK_LOADER_PUSH_GEN, _x_ ("Wrapper on lw6tsk_loader_push_gen."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6TSK_LOADER_PUSH_LDR, _x_ ("Wrapper on lw6tsk_loader_push_ldr."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6TSK_LOADER_POP, _x_ ("Wrapper on lw6tsk_loader_pop."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6TSK_LOADER_GET_STAGE, _x_ ("Wrapper on lw6tsk_loader_get_stage."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6IMG_SCREENSHOT, _x_ ("Wrapper on lw6img_screenshot."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6NET_INIT, _x_ ("Wrapper on lw6net_init."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6NET_QUIT, _x_ ("Wrapper on lw6net_quit."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6CLI_GET_BACKENDS, _x_ ("Wrapper on lw6cli_get_backends."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6SRV_GET_BACKENDS, _x_ ("Wrapper on lw6srv_get_backends."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_DB_NEW, _x_ ("Wrapper on lw6p2p_db_new."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_DB_RESET, _x_ ("Wrapper on lw6p2p_db_reset."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_DB_DEFAULT_NAME, _x_ ("Wrapper on lw6p2p_db_default_name."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_NEW, _x_ ("Wrapper on lw6p2p_node_new."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_POLL, _x_ ("Wrapper on lw6p2p_node_poll."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_CLOSE, _x_ ("Wrapper on lw6p2p_node_close."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_ID, _x_ ("Wrapper on lw6p2p_node_get_id."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_ENTRIES, _x_ ("Wrapper on lw6p2p_node_get_entries."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_SERVER_START, _x_ ("Wrapper on lw6p2p_node_server_start."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_CLIENT_JOIN, _x_ ("Wrapper on lw6p2p_node_client_join."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_REFRESH_PEER, _x_ ("Wrapper on lw6p2p_node_refresh_peer."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_DISCONNECT, _x_ ("Wrapper on lw6p2p_node_disconnect."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_UPDATE_INFO, _x_ ("Wrapper on lw6p2p_node_update_info."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_CALIBRATE, _x_ ("Wrapper on lw6p2p_node_calibrate."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_LOCAL_SEQ_0, _x_ ("Wrapper on lw6p2p_node_get_local_seq_0."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_LOCAL_SEQ_LAST, _x_ ("Wrapper on lw6p2p_node_get_local_seq_last."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_SEQ_MIN, _x_ ("Wrapper on lw6p2p_node_get_seq_min."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_SEQ_MAX, _x_ ("Wrapper on lw6p2p_node_get_seq_max."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_SEQ_DRAFT, _x_ ("Wrapper on lw6p2p_node_get_seq_draft."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_SEQ_REFERENCE, _x_ ("Wrapper on lw6p2p_node_get_seq_reference."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_IS_PEER_CONNECTED, _x_ ("Wrapper on lw6p2p_node_is_peer_connected."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_IS_PEER_REGISTERED, _x_ ("Wrapper on lw6p2p_node_is_peer_registered."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_IS_SEED_NEEDED, _x_ ("Wrapper on lw6p2p_node_is_seed_needed."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_IS_DUMP_NEEDED, _x_ ("Wrapper on lw6p2p_node_is_dump_needed."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_PUT_LOCAL_MSG, _x_ ("Wrapper on lw6p2p_node_put_local_msg."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_NEXT_REFERENCE_MSG, _x_ ("Wrapper on lw6p2p_node_get_next_reference_msg."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6P2P_NODE_GET_NEXT_DRAFT_MSG, _x_ ("Wrapper on lw6p2p_node_get_next_draft_msg."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6BOT_GET_BACKENDS, _x_ ("Wrapper on lw6bot_get_backends."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6BOT_NEW, _x_ ("Wrapper on lw6bot_new."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6BOT_NEXT_MOVE, _x_ ("Wrapper on lw6bot_next_move."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6_RELEASE, _x_ ("Wrapper on lw6_release."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6_EXIT, _x_ ("Wrapper on lw6_exit."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6_SET_RET, _x_ ("Wrapper on lw6_set_ret."));
  _LW6HLP_POPULATE_VOID (sys_context, references, LW6DEF_C_LW6_GET_RET, _x_ ("Wrapper on lw6_get_ret."));

  ret = 1;

  return ret;
}
