/*  Motti -- a strategy game
    Copyright (C) 1999 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
#ifndef MAP_H

#define MAP_H 1

#define MASK_PLAYER	31
#define MASK_PLAIN	63
#define MASK_OCCUPIED	32
#define MASK_CAPITAL	64
#define MASK_CROSS	128
#define SEA_VAL 0
#define CROSS_MAX 6
#define MODE_ATT	1
#define MODE_DEF	2
#define MODE_GUE	4
#define UPDATE_TURN	8

/* A hell will probably break loose if this is changed.  */
#define MAXPLAYERS 31

typedef struct
{
  short x, y;
} Coord;

typedef unsigned char map_val;

struct map_struct
{
  /* Dimensions of the map.  */
  unsigned short width, height;
  /* Pointer to an array of the locations of the capital.  One capital
     per player.  */
  Coord *capital;
  /* Array of the crosses.  In game terms, cross is a cell marked to
     be occupied.  */
  Coord cross[CROSS_MAX];
  /* Size of the map array.  Simply width*height.  */
  unsigned short size;
  /* Bit mask of the players still in the game.  */
  int remaining_players;
  /* Bit mask of the players currently active in the game.  */
  int active_players;
  /* Number of active players.  */
  unsigned char n_active_players;
  /* The number of players still in the game.  */
  unsigned char players_left;
  /* Is the map warped.  */
  unsigned char warped;
  /* Number of players.  */
  unsigned char players;
  /* The player in turn.  */
  unsigned char turn;
  /* The player who is next to begin.  */
  unsigned char begin_turn;
  /* The number of crosses currently marked.  */
  unsigned char n_cross;
  /* The number of attacks made this turn.  When ATT_PER_TURN (default
     6) attacks are made, change turn.  */
  unsigned char n_att;
  /* Bit mask of the crosses marked.  */
  unsigned char bit_cross;
  /* Bit mask of possible modes.  (attack, defend, guerilla action) */
  unsigned char modes;
  /* Default mode of action.  Based on the number of crosses, their
     placement, and the most sensible action with those crosses.  */
  unsigned char def_mode;
  /* Selected mode of action.  Changed to default mode of action, if
     becomes impossible.  */
  unsigned char sel_mode;
  /* Pointer to the array of the map.  */
  map_val *map;
};

extern struct map_struct game_map;
extern const Coord round[];

/* NO_CROSS: no cross can be placed here.
   SET_CROSS: a cross is already here.
   ANY_CROSS: a cross can be placed here.
   ONLY_GUERILLA: a cross can be placed here, mode restricted to
   guerilla mode.  */
enum cross_act {
  NO_CROSS, IS_CROSS, ANY_CROSS, ONLY_GUERILLA
};

extern char * load_map (char *);
extern void get_map_real_coord (Coord *);
extern int parse_coord (Coord);
extern int parse_real_coord (Coord);
extern Coord parse_loc (int);
extern map_val get_map_val (Coord);
extern Coord add_coord (Coord, Coord);
extern int cmp_coord (Coord, Coord);
extern void set_map (Coord, map_val);
extern void set_map_bit (Coord, map_val);
extern void clear_map_bit (map_val);
extern enum cross_act check_cross_nocheck (const Coord, const enum cross_act);
extern enum cross_act check_cross (const Coord);
extern int toggle_cross (Coord);
extern int dist_to_capital (int, Coord);
extern char need_update (char *);
extern void select_next (void);
extern void clear_crosses (void);

#endif /* map.h  */
