// { dg-do run { target c++11 } }
// { dg-require-effective-target hosted }

// Copyright (C) 2013-2024 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

#include <memory>
#include <testsuite_hooks.h>

struct X : public std::enable_shared_from_this<X> { };

void test01()
{
  auto x1 = std::make_shared<X>(), x2 = std::make_shared<X>();
  *x1 = *x2;
  VERIFY( x1->shared_from_this() != x2->shared_from_this() );
}

int main()
{
  test01();
}
