/* { dg-do run { target { riscv_v } } } */
/* { dg-options "-O2" } */

#include<cmath>
#include<cstddef>
#include<cstdint>
#include<iomanip>
#include<ios>
#include<iostream>
#include<memory>
#include<type_traits>
#include"riscv_vector.h"

using std::addressof;
using std::cerr;
using std::endl;
using std::int8_t;
using std::int16_t;
using std::int32_t;
using std::int64_t;
using std::uint8_t;
using std::uint16_t;
using std::uint32_t;
using std::uint64_t;
using std::ptrdiff_t;
using std::size_t;
using float16_t = _Float16;
using float32_t = float;
using float64_t = double;

template<class T, class T2>
constexpr T uint_to_float(T2 val) noexcept
{
  return *reinterpret_cast<T*>(&val);
}

constexpr const auto &f16(uint_to_float<float16_t, uint16_t>);
constexpr const auto &f32(uint_to_float<float32_t, uint32_t>);
constexpr const auto &f64(uint_to_float<float64_t, uint64_t>);

template<class T>
struct To_uint
{
  using type = std::conditional_t<
    sizeof(T) == 1, uint8_t, std::conditional_t<
      sizeof(T) == 2, uint16_t, std::conditional_t<
        sizeof(T) == 4, uint32_t, std::conditional_t<
          sizeof(T) == 8, uint64_t, void
        >
      >
    >
  >;
};

// isnan() does not support half type
template<class T>
struct To_float
{
  using type = std::conditional_t<
    std::is_same<T, float16_t>::value, float, std::conditional_t<
      std::is_same<T, float32_t>::value, float, std::conditional_t<
        std::is_same<T, float64_t>::value, double, float
      >
    >
  >;
};

template<class T>
using To_uint_t = typename To_uint<T>::type;

template<class T>
using To_isnan_float = typename To_float<T>::type;

template <class T>
void print_float(std::ostream &os, T val)
{
  using std::setw;
  os << std::hex << std::setfill('0') << setw(sizeof(T) * 2) << *reinterpret_cast<To_uint_t<T>*>(addressof(val)) << setw(0) << std::dec;
}

template <class T>
bool __attribute__((noinline))
check(const T *a, const T *b, size_t size)
{
  bool rv = true;
  for (size_t i = 0; i < (size / sizeof(T)); ++i) {
    if (reinterpret_cast<const To_uint_t<T> *>(a)[i] ==
        reinterpret_cast<const To_uint_t<T> *>(b)[i])
      continue;
    // floating negative zero == positive zero
    if ((std::is_floating_point_v<T> || std::is_same<T, float16_t>::value) &&
        (a[i] == b[i]))
      continue;
    // if both result are NaN, return true
    if ((std::is_same<T, float16_t>::value || std::is_floating_point_v<T>) &&
         std::isnan(static_cast<To_isnan_float<T>>(a[i])) &&
         std::isnan(static_cast<To_isnan_float<T>>(b[i])))
      continue;

    if (std::is_same<T, float16_t>::value) {
      cerr << std::hex << std::setfill('0') << std::setw(sizeof(T) * 2) << "["
           << i
           << "] result/golden:" << reinterpret_cast<const To_uint_t<T> *>(a)[i]
           << " != " << reinterpret_cast<const To_uint_t<T> *>(b)[i]
           << std::setw(0) << std::dec << endl;
    } else if constexpr (std::is_floating_point_v<T>) {
      cerr << "[" << i << "] result/golden:" << a[i] << "(";
      print_float(cerr, a[i]);
      cerr << ") != " << b[i] << "(";
      print_float(cerr, b[i]);
      cerr << ")" << endl;
    } else if constexpr (std::is_unsigned_v<T>) {
      cerr << "[" << i << "] result/golden: " << static_cast<uintmax_t>(a[i])
           << " != " << static_cast<uintmax_t>(b[i]) << endl;
    } else {
      cerr << "[" << i << "] result/golden:" << static_cast<intmax_t>(a[i])
           << " != " << static_cast<intmax_t>(b[i]) << endl;
    }
    rv = false;
  }
  return rv;
}

template <class T>
bool __attribute__((noinline))
check(const T a, const T golden)
{
  return check(addressof(a), addressof(golden), sizeof(T));
}



int main()
{
int return_value = 0;

size_t var_115 = 40u;
int32_t var_114 [] = {-264546306, -442938235, -25165367, 277197762, 209641142, 362684255, -353277837, 71516967, 528078808, 489972595};
size_t var_112 = 108u;
int32_t var_111 [] = {-2, -1776580354, -100935733, 1111812123, 840849367, 0, -6, 2, 7, 1965230406, 6, 587048909, 5, -2, 1549864288, -6, -1153689461, -105253108, -6, -341148625, 630712685, 0, -5, 6, 1447136930, -480839967, 5};
size_t var_109 = 4u;
int32_t var_108 [] = {611390260};
size_t var_106 = 4u;
int32_t var_105 [] = {1840887747};
size_t var_103 = 40u;
int32_t var_102 [] = {-816540887, 1074541498, -1467236483, -23091331, -38787, 1943479342, 1158929439, 360172, -218, 2034278775};
int32_t var_100 [] = {-816540887, 1074541498, -1467236483, -23091331, 1850866656, 1943479342, 1158929439, -1645280479, 33038044, -2008980594};
int32_t var_99 [] = {313288711, -543659156, 1202816796, -810559622, -1270980824, -1377410090, 1638030817, 368815765, -1832418257, 2034278775};
uint32_t var_98 [] = {1066929904u, 2075693420u, 3723502362u, 1157306766u, 3542592783u, 173123118u, 3085340519u, 3279843370u, 3114411799u, 3236429568u};
int32_t var_97 [] = {27471981, 1558226339, 1368532512, 562981792, -699666433, -478438097, 2074857064, 1309781764, 1090945990, -460217404};
int32_t var_96 [] = {611390260, -494288892, -223532379};
int32_t var_95 [] = {-931418771, 2058489875, 1158330749};
uint64_t var_94 [] = {14556376208032475046u, 5833208789700403480u, 1157993479819016279u};
int32_t var_93 [] = {50124977, -2010901333, -323343415, 2042548864, 1762919923, 1578798468, -1943847888, -497410235, -1124767174, 489354840, -1634495923, 918157273, -1716837845, 1823613130, -506989223, 1123131520, -1036186091, -1164004288, 989073199, -685794952, 2118058458, 969467266, -1385934841, 689762453, 420322602, 731411311, -1070492662};
int8_t var_92 [] = {14, -41, -71, -96, -35, 48, 53, -110, 39, -37, 76, -63, -96, 22, -23, -72, 117, -44, 26, -75, -34, -110, -108, 28, 44, -100, 55};
int8_t var_91 [] = {-46, 111, 52, -120, 93, -94, -35, -55, -74, 89, -61, -87, -23, 42, -68, -22, 10, 113, -109, 94, -109, -98, -72, -19, 3, -115, -100};
int32_t var_90 [] = {-477731693, 305877738, 1066229754, -257473693, 229248137, 1851876802, -1844169038, 46508752, 886475787, -1081571363, -5770198, -190018889, -929421817, -1749474005, 1558894777, -1979485493, 172675213, 1733144472, -1366889298, -388099806, -256437022, -1287006017, 116312829, 555170350, 29975705, 474535880, -12572110};
int32_t var_89 [] = {-740841267, 1784734444, 885296255, 232626914, 524344314, -1135004276, -1259604814, 1218604527, -1956328319, -166954010, 1475664307, -820302557, 1319489943, -969946802, -922754621, -1977627704, -1642122010, 801249126, 1530252911, 601726132, -1949657604, 356460809, 1094731169, 244866984, -2134078335, 1355714511, -857890000};
int32_t var_88 [] = {-1252496907, -462718098, -1645171364, 1924878529, 1840728102, -140561770, -1099830450, 1659537665, -735088671, 1575274729, 776451816, 603260147, 1400543513, -664997331, 778304278, -1288440206, -1282898944, 1476453512, -429241306};
int32_t var_87 [] = {1945585950, 864203635, 1209218859, -554887622, 75881186, 972725791, -1748505186, 759028031, 832315667, 1227849569, 912821100, 93899445, 996939460, 70102251, -1281470572, -441799501, 434534834, -1094736801, 183476140};
int32_t var_86 [] = {-662548274, -1016283636, -678529289, -1374767402, 547693855, 39374595, -2100415636, 1045036273, 1585896308, 1254672097, 2119844144, 658593947, 217285688, -599825074, -1272961101, 1376247089, 1097792926, 1938510943, 86458189};
int32_t var_85 [] = {650012133};
uint32_t var_84 [] = {1506339892u, 3032389102u, 2264141340u};
uint32_t var_83 [] = {1244272689u, 3605280174u, 249999445u};
uint16_t var_82 [] = {55425u, 21733u, 24021u};
int8_t var_81 [] = {-96, 56, -51};
int32_t var_80 [] = {906489201, 853207045, 1158615947, 385051420, -1881666604, 1056039959, 2029698451, -822148518, -70147701, -28252531};
int32_t var_79 [] = {-478751518, -686702219, 1850149187};
int32_t var_78 [] = {1517363023};
int64_t var_77 [] = {-6384909153631110263, 478084338400603899, 8674034817296499378};
int32_t var_76 [] = {-295895536, 1165059631, 1083784382, 102253897, -1050158885, 733183529, 649743538, -1370560321};
int32_t var_75 [] = {630173376, 217474599, -392192168, 1169017537, -1981808051, 234785100, 1967357505, -854508923, -2090575119, 1620103754, -1829875160, -558024100, -1502376466, 718985372, -1758479107, 2059513417, 1320348890, -1412351855, 1831776784, -1482351523, -1490370921, -254109356, 1743677237, -1822233845, 406786422, -1160038665, -1555300747};
int32_t var_74 [] = {796081589, 738512040, -1663632409, -417640541, -1531128964, 2137278520, 61292819, 1748365108, -1888868476, -539190547, 625293736, 1387000974, -2034806492, 644312826, 4563553, -1746729006, -47891367, -1851767633, -741826656, -458088927, -898387652, -1465478927, 1785251988, 1042338774, -968373069, 1744789043, 1910249816};
int32_t var_73 [] = {-1000314334, -61728304, 775747052, -514542367, 87389826, -1463823334, 2026550032, 161054669, -736461663, -2063693057};
int32_t var_72 [] = {1437870564, -855381478, -971412573, 95058807, -1546865772, 396939124, 488867202, 1026994048, 1928357960, -2078295055, 1954001616, -475625183, 1266317530, -204668953, -495147822, -1977722900, -1105363833, -605762683, 746509553};
uint32_t var_71 [] = {1070824198u, 1140131026u, 1723265041u, 1043871346u};
int32_t var_70 [] = {2014703800, -1985694148, 1342853562, -1929126064, -1998922839, 459974655, 1705733502, 1212559648, -1995599675, -772689156};
int32_t var_69 [] = {1015011441, 690758444, 336758560, -1949471345, 1165709957, -1143872113, 371210739, -1269178714, 82762617, -1873001954, -1595860537, -957529004, 1852566624, -1214930274, -852146376, -1761152289, 1211999973, -2037874613, 1760794313};
int32_t var_68 [] = {8564075, -1155918688, -521130966, -340145790, -427761651, 445629019, 1120575800, -839574359, 332653814, -1757977059, -682054231, -1724102212, 442667484, 2096140064, 151784864, -73841395};
int32_t var_67 [] = {-1052504337, -1768016279, -92371658, 1120376198, 849413442, 1463253853, -1408397511, 295411381, 2126634640, 1973794481, -1032093961, 595612984, 1676035252, -1444431284, 1558428363, 1964212681, -1145125386, -96689033, 1800758577, -332584550, 639276760, -1358631972, 1569592097, -591212592, 1455701005, -472275892, -1952060344};
int32_t var_66 = 1840887747;
int32_t var_65 = -1272714578;
int16_t var_64 = -23926;
uint64_t var_63 = 10489413838186398175u;
int8_t var_62 = 41;
uint16_t var_61 = 10386u;
int64_t var_60 = -976687698412213326;
__riscv_vsetvl_e32m8(10);
vint32m8_t var_20 = __riscv_vle32_v_i32m8(var_100, 10);
// -816540887, 1074541498, -1467236483, -23091331, 1850866656, 1943479342, 1158929439, -1645280479, 33038044, -2008980594

vint32m8_t var_21 = __riscv_vle32_v_i32m8(var_99, 10);
// 313288711, -543659156, 1202816796, -810559622, -1270980824, -1377410090, 1638030817, 368815765, -1832418257, 2034278775

vuint32m8_t var_22 = __riscv_vle32_v_u32m8(var_98, 10);
// 1066929904, 2075693420, 3723502362, 1157306766, 3542592783, 173123118, 3085340519, 3279843370, 3114411799, 3236429568

__riscv_vsetvl_e32m1(3);
vint32m1_t var_25 = __riscv_vle32_v_i32m1(var_96, 3);
// 611390260, -494288892, -223532379

vint32m1_t var_26 = __riscv_vle32_v_i32m1(var_95, 3);
// -931418771, 2058489875, 1158330749

vuint64m2_t var_27 = __riscv_vle64_v_u64m2(var_94, 3);
// 14556376208032475046, 5833208789700403480, 1157993479819016279

__riscv_vsetvl_e32m8(27);
vint32m8_t var_30 = __riscv_vle32_v_i32m8(var_93, 27);
// 50124977, -2010901333, -323343415, 2042548864, 1762919923, 1578798468, -1943847888, -497410235, -1124767174, 489354840, -1634495923, 918157273, -1716837845, 1823613130, -506989223, 1123131520, -1036186091, -1164004288, 989073199, -685794952, 2118058458, 969467266, -1385934841, 689762453, 420322602, 731411311, -1070492662

vint8m2_t var_31 = __riscv_vle8_v_i8m2(var_92, 27);
// 14, -41, -71, -96, -35, 48, 53, -110, 39, -37, 76, -63, -96, 22, -23, -72, 117, -44, 26, -75, -34, -110, -108, 28, 44, -100, 55

vint8m2_t var_32 = __riscv_vle8_v_i8m2(var_91, 27);
// -46, 111, 52, -120, 93, -94, -35, -55, -74, 89, -61, -87, -23, 42, -68, -22, 10, 113, -109, 94, -109, -98, -72, -19, 3, -115, -100

vint32m8_t var_33 = __riscv_vle32_v_i32m8(var_90, 27);
// -477731693, 305877738, 1066229754, -257473693, 229248137, 1851876802, -1844169038, 46508752, 886475787, -1081571363, -5770198, -190018889, -929421817, -1749474005, 1558894777, -1979485493, 172675213, 1733144472, -1366889298, -388099806, -256437022, -1287006017, 116312829, 555170350, 29975705, 474535880, -12572110

vint32m8_t var_34 = __riscv_vle32_v_i32m8(var_89, 27);
// -740841267, 1784734444, 885296255, 232626914, 524344314, -1135004276, -1259604814, 1218604527, -1956328319, -166954010, 1475664307, -820302557, 1319489943, -969946802, -922754621, -1977627704, -1642122010, 801249126, 1530252911, 601726132, -1949657604, 356460809, 1094731169, 244866984, -2134078335, 1355714511, -857890000

__riscv_vsetvl_e32m8(19);
vint32m8_t var_35 = __riscv_vle32_v_i32m8(var_88, 19);
// -1252496907, -462718098, -1645171364, 1924878529, 1840728102, -140561770, -1099830450, 1659537665, -735088671, 1575274729, 776451816, 603260147, 1400543513, -664997331, 778304278, -1288440206, -1282898944, 1476453512, -429241306

vint32m8_t var_36 = __riscv_vle32_v_i32m8(var_87, 19);
// 1945585950, 864203635, 1209218859, -554887622, 75881186, 972725791, -1748505186, 759028031, 832315667, 1227849569, 912821100, 93899445, 996939460, 70102251, -1281470572, -441799501, 434534834, -1094736801, 183476140

vint32m8_t var_37 = __riscv_vle32_v_i32m8(var_86, 19);
// -662548274, -1016283636, -678529289, -1374767402, 547693855, 39374595, -2100415636, 1045036273, 1585896308, 1254672097, 2119844144, 658593947, 217285688, -599825074, -1272961101, 1376247089, 1097792926, 1938510943, 86458189

__riscv_vsetvl_e32m1(3);
vuint32m1_t var_41 = __riscv_vle32_v_u32m1(var_84, 3);
// 1506339892, 3032389102, 2264141340

vuint32m1_t var_42 = __riscv_vle32_v_u32m1(var_83, 3);
// 1244272689, 3605280174, 249999445

vuint16mf2_t var_43 = __riscv_vle16_v_u16mf2(var_82, 3);
// 55425, 21733, 24021

vint8mf4_t var_44 = __riscv_vle8_v_i8mf4(var_81, 3);
// -96, 56, -51

__riscv_vsetvl_e32m8(10);
vint32m8_t var_45 = __riscv_vle32_v_i32m8(var_80, 10);
// 906489201, 853207045, 1158615947, 385051420, -1881666604, 1056039959, 2029698451, -822148518, -70147701, -28252531

__riscv_vsetvl_e32m2(3);
vint32m2_t var_47 = __riscv_vle32_v_i32m2(var_79, 3);
// -478751518, -686702219, 1850149187

vint64m4_t var_49 = __riscv_vle64_v_i64m4(var_77, 3);
// -6384909153631110263, 478084338400603899, 8674034817296499378

__riscv_vsetvl_e32m2(8);
vint32m2_t var_50 = __riscv_vle32_v_i32m2(var_76, 8);
// -295895536, 1165059631, 1083784382, 102253897, -1050158885, 733183529, 649743538, -1370560321

__riscv_vsetvl_e32m8(27);
vint32m8_t var_51 = __riscv_vle32_v_i32m8(var_75, 27);
// 630173376, 217474599, -392192168, 1169017537, -1981808051, 234785100, 1967357505, -854508923, -2090575119, 1620103754, -1829875160, -558024100, -1502376466, 718985372, -1758479107, 2059513417, 1320348890, -1412351855, 1831776784, -1482351523, -1490370921, -254109356, 1743677237, -1822233845, 406786422, -1160038665, -1555300747

__riscv_vsetvl_e32m8(10);
vint32m8_t var_53 = __riscv_vle32_v_i32m8(var_73, 10);
// -1000314334, -61728304, 775747052, -514542367, 87389826, -1463823334, 2026550032, 161054669, -736461663, -2063693057

__riscv_vsetvl_e32m8(19);
vint32m8_t var_54 = __riscv_vle32_v_i32m8(var_72, 19);
// 1437870564, -855381478, -971412573, 95058807, -1546865772, 396939124, 488867202, 1026994048, 1928357960, -2078295055, 1954001616, -475625183, 1266317530, -204668953, -495147822, -1977722900, -1105363833, -605762683, 746509553

__riscv_vsetvl_e32m1(4);
vuint32m1_t var_55 = __riscv_vle32_v_u32m1(var_71, 4);
// 1070824198, 1140131026, 1723265041, 1043871346

__riscv_vsetvl_e32m8(19);
vint32m8_t var_57 = __riscv_vle32_v_i32m8(var_69, 19);
// 1015011441, 690758444, 336758560, -1949471345, 1165709957, -1143872113, 371210739, -1269178714, 82762617, -1873001954, -1595860537, -957529004, 1852566624, -1214930274, -852146376, -1761152289, 1211999973, -2037874613, 1760794313

__riscv_vsetvl_e32m4(16);
vint32m4_t var_58 = __riscv_vle32_v_i32m4(var_68, 16);
// 8564075, -1155918688, -521130966, -340145790, -427761651, 445629019, 1120575800, -839574359, 332653814, -1757977059, -682054231, -1724102212, 442667484, 2096140064, 151784864, -73841395

__riscv_vsetvl_e32m8(27);
vint32m8_t var_59 = __riscv_vle32_v_i32m8(var_67, 27);
// -1052504337, -1768016279, -92371658, 1120376198, 849413442, 1463253853, -1408397511, 295411381, 2126634640, 1973794481, -1032093961, 595612984, 1676035252, -1444431284, 1558428363, 1964212681, -1145125386, -96689033, 1800758577, -332584550, 639276760, -1358631972, 1569592097, -591212592, 1455701005, -472275892, -1952060344

__riscv_vsetvl_e64m2(3);
vbool32_t var_24 = __riscv_vmsbc_vx_u64m2_b32(var_27, var_63, 3);
// 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8m2(27);
vbool4_t var_29 = __riscv_vmsbc_vv_i8m2_b4(var_31, var_32, 27);
// 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool4_t var_28 = __riscv_vmseq_vv_i32m8_b4(var_33, var_34, 27);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e16mf2(3);
vbool32_t var_40 = __riscv_vmadc_vx_u16mf2_b32(var_43, var_61, 3);
// 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool32_t var_39 = __riscv_vmsgt_vx_i8mf4_b32(var_44, var_62, 3);
// 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e64m4(3);
vbool16_t var_46 = __riscv_vmsge_vx_i64m4_b16(var_49, var_60, 3);
// 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m2(8);
int32_t var_11 = __riscv_vmv_x_s_i32m2_i32(var_50);
// -295895536

__riscv_vsetvl_e32m1(4);
uint32_t var_5 = __riscv_vmv_x_s_u32m1_u32(var_55);
// 1070824198

__riscv_vsetvl_e32m4(16);
int32_t var_1 = __riscv_vmv_x_s_i32m4_i32(var_58);
// 8564075

__riscv_vsetvl_e16mf2(3);
vint32m1_t var_18 = __riscv_vwadd_wx_i32m1_mu(var_24, var_25, var_26, var_64, 3);
// 611390260, 2058465949, 1158306823

__riscv_vsetvl_e32m8(27);
vbool4_t var_17 = __riscv_vmsle_vx_i32m8_b4_mu(var_28, var_29, var_30, var_65, 27);
// 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m1(3);
vbool32_t var_14 = __riscv_vmseq_vv_u32m1_b32_mu(var_39, var_40, var_41, var_42, 3);
// 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m8(27);
vint32m8_t var_0 = __riscv_vssub_vx_i32m8(var_59, var_1, 27);
// -1061068412, -1776580354, -100935733, 1111812123, 840849367, 1454689778, -1416961586, 286847306, 2118070565, 1965230406, -1040658036, 587048909, 1667471177, -1452995359, 1549864288, 1955648606, -1153689461, -105253108, 1792194502, -341148625, 630712685, -1367196047, 1561028022, -599776667, 1447136930, -480839967, -1960624419

__riscv_vsetvl_e32m8(19);
vint32m8_t var_16 = __riscv_vxor_vv_i32m8_mu(var_17, var_35, var_36, var_37, 19);
// -1418389040, -462718098, -1645171364, 1924878529, 1840728102, 1000493340, 352968434, 326378958, 1864039015, 1575274729, 1211288156, 603260147, 933204732, -669857371, 778304278, -1213369982, -1282898944, 1476453512, 264806625

__riscv_vsetvl_e32m8(10);
vint32m8_t var_4 = __riscv_vmulhsu_vx_i32m8(var_0, var_5, 10);
// -264546306, -442938235, -25165367, 277197762, 209641142, 362684255, -353277837, 71516967, 528078808, 489972595

__riscv_vsetvl_e32m8(27);
vint32m8_t var_10 = __riscv_vdiv_vx_i32m8_mu(var_17, var_0, var_51, var_11, 27);
// -2, -1776580354, -100935733, 1111812123, 840849367, 0, -6, 2, 7, 1965230406, 6, 587048909, 5, -2, 1549864288, -6, -1153689461, -105253108, -6, -341148625, 630712685, 0, -5, 6, 1447136930, -480839967, 5

__riscv_vsetvl_e32m8(19);
vbool4_t var_8 = __riscv_vmsne_vv_i32m8_b4(var_16, var_54, 19);
// 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m8(10);
__riscv_vse32_v_i32m8(var_70, var_4, 10);
__riscv_vsetvl_e32m8(27);
__riscv_vse32_v_i32m8(var_74, var_10, 27);
__riscv_vsetvl_e32m8(19);
vint32m8_t var_2 = __riscv_vaadd_vx_i32m8_mu(var_8, var_0, var_57, var_11, 0, 19);
// 359557953, 197431454, 20431512, -1122683440, 434907211, -719883824, 37657602, -782537125, -106566459, -1084448745, -945878036, -626712270, 778335544, -755412905, -574020956, -1028523912, 458052219, -1166885074, 732449389, -341148625, 630712685, -1367196047, 1561028022, -599776667, 1447136930, -480839967, -1960624419

if(!check(var_70, var_114, var_115)) {cerr << "check 113 fails" << endl; return_value = 1;}
if(!check(var_74, var_111, var_112)) {cerr << "check 110 fails" << endl; return_value = 1;}
vint32m8_t var_3 = __riscv_vmulh_vx_i32m8(var_2, var_11, 19);
// -24771224, -13601754, -1407600, 77345645, -29962301, 49595350, -2594366, 53911759, 7341741, 74711521, 65164893, 43176431, -53622298, 52043075, 39546340, 70858661, -31556843, 80390852, -50461038

__riscv_vsetvl_e32m8(3);
vint32m1_t var_6 = __riscv_vredmin_vs_i32m8_i32m1_tu(var_18, var_2, var_18, 3);
// 20431512

__riscv_vsetvl_e32m8(10);
vint32m8_t var_9 = __riscv_vasub_vv_i32m8(var_2, var_53, 0, 10);
// 679936144, 129579879, -377657770, -304070536, 173758693, 371969755, -994446215, -471795897, 314947602, 489622156

__riscv_vsetvl_e32m8(19);
vint32m8_t var_15 = __riscv_vmv_s_x_i32m8_tu(var_3, var_66, 19);
// 1840887747, -13601754, -1407600, 77345645, -29962301, 49595350, -2594366, 53911759, 7341741, 74711521, 65164893, 43176431, -53622298, 52043075, 39546340, 70858661, -31556843, 80390852, -50461038

__riscv_vsetvl_e32m1(1);
vint32m1_t var_7 = __riscv_vrem_vx_i32m1_mu(var_14, var_6, var_18, var_11, 1);
// 19599188, 2058465949, 1158306823

__riscv_vsetvl_e32m8(10);
vbool4_t var_13 = __riscv_vmsge_vv_i32m8_b4(var_9, var_45, 10);
// 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e32m8(1);
__riscv_vse32_v_i32m8(var_85, var_15, 1);
__riscv_vsetvl_e32m2(1);
vint32m1_t var_12 = __riscv_vredxor_vs_i32m2_i32m1_tum(var_46, var_7, var_47, var_18, 1);
// 611390260

__riscv_vsetvl_e32m8(10);
vint32m8_t var_19 = __riscv_vssra_vv_i32m8_mu(var_13, var_20, var_21, var_22, 0, 10);
// -816540887, 1074541498, -1467236483, -23091331, -38787, 1943479342, 1158929439, 360172, -218, 2034278775

if(!check(var_85, var_105, var_106)) {cerr << "check 104 fails" << endl; return_value = 1;}
__riscv_vsetvl_e32m1(1);
__riscv_vse32_v_i32m1(var_78, var_12, 1);
__riscv_vsetvl_e32m8(10);
__riscv_vse32_v_i32m8(var_97, var_19, 10);
if(!check(var_78, var_108, var_109)) {cerr << "check 107 fails" << endl; return_value = 1;}
if(!check(var_97, var_102, var_103)) {cerr << "check 101 fails" << endl; return_value = 1;}
if (return_value)
  __builtin_abort ();
return return_value;
}
