// This implementation only tests support for interactive form validation.
// To check validation for a specific type or a specific other constraint,
// the test can be combined: 
//    - Modernizr.inputtypes.numer && Modernizr.formvalidation (browser supports rangeOverflow, typeMismatch etc. for type=number)
//    - Modernizr.input.required && Modernizr.formvalidation (browser supports valueMissing)
//
(function(document, Modernizr){


Modernizr.formvalidationapi = false;
Modernizr.formvalidationmessage = false;

Modernizr.addTest('formvalidation', function(){
    var form = document.createElement('form');
    if ( !('checkValidity' in form) ) {
        return false;
    }
    var body = document.body,

    html = document.documentElement,

    bodyFaked = false,

    invaildFired = false,

    input;

    Modernizr.formvalidationapi = true;

    // Prevent form from being submitted
    form.onsubmit = function(e) {
        //Opera does not validate form, if submit is prevented
        if ( !window.opera ) {
            e.preventDefault();
        }
        e.stopPropagation();
    };

    // Calling form.submit() doesn't trigger interactive validation, 
    // use a submit button instead
    //older opera browsers need a name attribute
    form.innerHTML = '<input name="modTest" required><button></button>';

    // FF4 doesn't trigger "invalid" event if form is not in the DOM tree
    // Chrome throws error if invalid input is not visible when submitting 
    form.style.position = 'absolute';
    form.style.top = '-99999em';

    // We might in <head> in which case we need to create body manually
    if ( !body ) {
        bodyFaked = true;
        body = document.createElement('body');
        //avoid crashing IE8, if background image is used
        body.style.background = "";
        html.appendChild(body);
    }

    body.appendChild(form);

    input = form.getElementsByTagName('input')[0];	

    // Record whether "invalid" event is fired
    input.oninvalid = function(e) {
        invaildFired = true;
        e.preventDefault();
        e.stopPropagation();
    };

    //Opera does not fully support the validationMessage property
    Modernizr.formvalidationmessage = !!input.validationMessage;

    // Submit form by clicking submit button
    form.getElementsByTagName('button')[0].click();

    // Don't forget to clean up
    body.removeChild(form);
    bodyFaked && html.removeChild(body);

    return invaildFired;
});


})(document, window.Modernizr);