.\" $NCDId: @(#)AuSDAttr.man,v 1.1 1994/09/27 00:34:45 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuSDAttr.man 5 1999-05-08 18:47:16Z jon $
.TH AuSetDeviceAttributes 3 "1.2" "audiolib - device attributes"
.SH \fBName\fP
\fBAuSetDeviceAttributes\fP \- set device attributes
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
void \fBAuSetDeviceAttributes\fP(\fIserver\fP, \fIdevice\fP, \fIvaluemask\fP, \fIattributes\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuDeviceID\fP \fIdevice\fP;
.br
    \fBAuMask\fP \fIvaluemask\fP;
.br
    \fBAuDeviceAttributes\fP *\fIattributes\fP;
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIdevice\fP 1i
Specifies the ID of the device.
.IP \fIvaluemask\fP 1i
Specifies which values in \fIattributes\fP to used.
This must be a bitwise inclusive OR of one or more of these constants: \fBAuCompCommonIDMask\fP, \fBAuCompCommonKindMask\fP, \fBAuCompCommonUseMask\fP, \fBAuCommonFormatMask\fP, \fBAuCommonNumTracksMask\fP, \fBAuCommonAccessMask\fP, \fPAuCommonDescriptionMask\fP, \fBAuCompDeviceGainMask\fP, or \fBAuCompDeviceLineModeMask\fP.
.IP \fIattributes\fP 1i
Specifies the structure from which the values (as specified by the value mask) are to be taken.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuSetDeviceAttributes\fP sets the attributes of \fIdevice\fP using only those values in \fIattributes\fP specified by \fIvaluemask\fP.
Attempting to change attributes not marked as changable will fail with a \fBAuBadValue\fP error.
.SH \fBErrors\fP
\fBAuBadDevice\fP,
\fBAuBadLength\fP,
\fBAuBadValue\fP.
.SH \fBSee Also\fP
\fBAuGetDeviceAttributes\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
