#!/usr/bin/perl

# test_pet
#
# Test of the pet code
#
# Author: MontaVista Software, Inc.
#         Corey Minyard <minyard@mvista.com>
#         source@mvista.com
#
# Copyright 2004 MontaVista Software Inc.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public License
#  as published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#
#  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
#  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
#  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
#  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
#  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
#  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
#  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
#  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this program; if not, write to the Free
#  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

use Lanserv;
use OpenIPMI;

my $errcountholder : shared = 0;
$errcount = \$errcountholder;

my $fru_field_table = {};

sub reg_err {
    my $str = shift;

    $$errcount++;
    print STDERR "***", $str, "\n";
}

sub get_errcount {
    return $$errcount;
}

{
    package CloseDomain;
    sub new {
	my $a = shift;
	my $b = \$a;
	$b = bless $b;
	return $b;
    }

    sub domain_cb {
	my $self = shift;
	my $domain = shift;
	my $rv;

	$domain->close($$self);
    }

    package PetGet;

    sub new {
	my $a = {};
	$a->{handler} = shift;
	return bless \$a;
    }

    sub mc_cb {
	my $self = shift;
	my $mc = shift;
	my $h = $$self->{handler};

	$$h->{pet} = $mc->get_pet(7, "1.2.3.4", "11:22:33:44:55:66",
				     1, 2, 3, 4, $h);
	if ($rv) {
	    main::reg_err("Unable to get pet config: $rv\n");
	    $h->close();
	    return;
	}
    }

    package Handlers;

    sub new {
	my $a = {};
	$a->{keepon} = 1;
	$a->{accmode} = 2;
	return bless \$a;
    }

    sub log {
	my $self = shift;
	my $level = shift;
	my $log = shift;

	print $level, ": ", $log, "\n";
    }

    @lanparm_configs =
	( "0 -1 -1 support_auth_oem bool false",
	  "1 -1 -1 support_auth_straight bool true",
	  "2 -1 -1 support_auth_md5 bool true",
	  "3 -1 -1 support_auth_md2 bool true",
	  "4 -1 -1 support_auth_none bool true",
	  "5 -1 -1 ip_addr_source integer 0",
	  "6 -1 -1 ipv4_ttl integer 0",
	  "7 -1 -1 ipv4_flags integer 0",
	  "8 -1 -1 ipv4_precedence integer 0",
	  "9 -1 -1 ipv4_tos integer 0",
	  "10 0 1 enable_auth_oem bool false",
	  "10 1 2 enable_auth_oem bool false",
	  "10 2 3 enable_auth_oem bool false",
	  "10 3 4 enable_auth_oem bool false",
	  "10 4 -1 enable_auth_oem bool false",
	  "11 0 1 enable_auth_straight bool true",
	  "11 1 2 enable_auth_straight bool true",
	  "11 2 3 enable_auth_straight bool true",
	  "11 3 4 enable_auth_straight bool true",
	  "11 4 -1 enable_auth_straight bool false",
	  "12 0 1 enable_auth_md5 bool true",
	  "12 1 2 enable_auth_md5 bool true",
	  "12 2 3 enable_auth_md5 bool true",
	  "12 3 4 enable_auth_md5 bool true",
	  "12 4 -1 enable_auth_md5 bool false",
	  "13 0 1 enable_auth_md2 bool true",
	  "13 1 2 enable_auth_md2 bool true",
	  "13 2 3 enable_auth_md2 bool true",
	  "13 3 4 enable_auth_md2 bool true",
	  "13 4 -1 enable_auth_md2 bool false",
	  "14 0 1 enable_auth_none bool true",
	  "14 1 2 enable_auth_none bool true",
	  "14 2 3 enable_auth_none bool true",
	  "14 3 4 enable_auth_none bool true",
	  "14 4 -1 enable_auth_none bool false",
	  "15 -1 -1 ip_addr ip 0.0.0.0",
	  "16 -1 -1 mac_addr mac 00:00:00:00:00:00",
	  "17 -1 -1 subnet_mask ip 0.0.0.0",
	  #"18 -1 -1 port_rmcp_primary integer 0",
	  #"19 -1 -1 port_rmcp_secondary integer 0",
	  #"20 -1 -1 bmc_generated_arps bool false",
	  #"21 -1 -1 bmc_generated_garps bool false",
	  #"22 -1 -1 garp_interval integer 0",
	  "23 -1 -1 default_gateway_ip_addr ip 0.0.0.0",
	  "24 -1 -1 default_gateway_mac_addr mac 00:00:00:00:00:00",
	  "25 -1 -1 backup_gateway_ip_addr ip 0.0.0.0",
	  "26 -1 -1 backup_gateway_mac_addr mac 00:00:00:00:00:00",
	  "27 -1 -1 community_string data 0x70%0x75%0x62%0x6c%0x69%0x63%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00",
	  "28 -1 -1 num_alert_destinations integer 0",
	  #"29 0 1 alert_ack bool false",
	  #"29 1 2 alert_ack bool false",
	  #"29 2 3 alert_ack bool false",
	  #"29 3 4 alert_ack bool false",
	  #"29 4 5 alert_ack bool false",
	  #"29 5 6 alert_ack bool false",
	  #"29 6 7 alert_ack bool false",
	  #"29 7 8 alert_ack bool false",
	  #"29 8 9 alert_ack bool false",
	  #"29 9 10 alert_ack bool false",
	  #"29 10 11 alert_ack bool false",
	  #"29 11 12 alert_ack bool false",
	  #"29 12 13 alert_ack bool false",
	  #"29 13 14 alert_ack bool false",
	  #"29 14 15 alert_ack bool false",
	  #"29 15 -1 alert_ack bool false",
	  #"30 0 1 dest_type integer 0",
	  #"30 1 2 dest_type integer 0",
	  #"30 2 3 dest_type integer 0",
	  #"30 3 4 dest_type integer 0",
	  #"30 4 5 dest_type integer 0",
	  #"30 5 6 dest_type integer 0",
	  #"30 6 7 dest_type integer 0",
	  #"30 7 8 dest_type integer 0",
	  #"30 8 9 dest_type integer 0",
	  #"30 9 10 dest_type integer 0",
	  #"30 10 11 dest_type integer 0",
	  #"30 11 12 dest_type integer 0",
	  #"30 12 13 dest_type integer 0",
	  #"30 13 14 dest_type integer 0",
	  #"30 14 15 dest_type integer 0",
	  #"30 15 -1 dest_type integer 0",
	  #"31 0 1 alert_retry_interval integer 0",
	  #"31 1 2 alert_retry_interval integer 0",
	  #"31 2 3 alert_retry_interval integer 0",
	  #"31 3 4 alert_retry_interval integer 0",
	  #"31 4 5 alert_retry_interval integer 0",
	  #"31 5 6 alert_retry_interval integer 0",
	  #"31 6 7 alert_retry_interval integer 0",
	  #"31 7 8 alert_retry_interval integer 0",
	  #"31 8 9 alert_retry_interval integer 0",
	  #"31 9 10 alert_retry_interval integer 0",
	  #"31 10 11 alert_retry_interval integer 0",
	  #"31 11 12 alert_retry_interval integer 0",
	  #"31 12 13 alert_retry_interval integer 0",
	  #"31 13 14 alert_retry_interval integer 0",
	  #"31 14 15 alert_retry_interval integer 0",
	  #"31 15 -1 alert_retry_interval integer 0",
	  #"32 0 1 max_alert_retries integer 0",
	  #"32 1 2 max_alert_retries integer 0",
	  #"32 2 3 max_alert_retries integer 0",
	  #"32 3 4 max_alert_retries integer 0",
	  #"32 4 5 max_alert_retries integer 0",
	  #"32 5 6 max_alert_retries integer 0",
	  #"32 6 7 max_alert_retries integer 0",
	  #"32 7 8 max_alert_retries integer 0",
	  #"32 8 9 max_alert_retries integer 0",
	  #"32 9 10 max_alert_retries integer 0",
	  #"32 10 11 max_alert_retries integer 0",
	  #"32 11 12 max_alert_retries integer 0",
	  #"32 12 13 max_alert_retries integer 0",
	  #"32 13 14 max_alert_retries integer 0",
	  #"32 14 15 max_alert_retries integer 0",
	  #"32 15 -1 max_alert_retries integer 0",
	  #"33 0 1 dest_format integer 0",
	  #"33 1 2 dest_format integer 0",
	  #"33 2 3 dest_format integer 0",
	  #"33 3 4 dest_format integer 0",
	  #"33 4 5 dest_format integer 0",
	  #"33 5 6 dest_format integer 0",
	  #"33 6 7 dest_format integer 0",
	  #"33 7 8 dest_format integer 0",
	  #"33 8 9 dest_format integer 0",
	  #"33 9 10 dest_format integer 0",
	  #"33 10 11 dest_format integer 0",
	  #"33 11 12 dest_format integer 0",
	  #"33 12 13 dest_format integer 0",
	  #"33 13 14 dest_format integer 0",
	  #"33 14 15 dest_format integer 0",
	  #"33 15 -1 dest_format integer 0",
	  #"34 0 1 gw_to_use integer 0",
	  #"34 1 2 gw_to_use integer 0",
	  #"34 2 3 gw_to_use integer 0",
	  #"34 3 4 gw_to_use integer 0",
	  #"34 4 5 gw_to_use integer 0",
	  #"34 5 6 gw_to_use integer 0",
	  #"34 6 7 gw_to_use integer 0",
	  #"34 7 8 gw_to_use integer 0",
	  #"34 8 9 gw_to_use integer 0",
	  #"34 9 10 gw_to_use integer 0",
	  #"34 10 11 gw_to_use integer 0",
	  #"34 11 12 gw_to_use integer 0",
	  #"34 12 13 gw_to_use integer 0",
	  #"34 13 14 gw_to_use integer 0",
	  #"34 14 15 gw_to_use integer 0",
	  #"34 15 -1 gw_to_use integer 0",
	  #"35 0 1 dest_ip_addr ip 0.0.0.0",
	  #"35 1 2 dest_ip_addr ip 0.0.0.0",
	  #"35 2 3 dest_ip_addr ip 0.0.0.0",
	  #"35 3 4 dest_ip_addr ip 0.0.0.0",
	  #"35 4 5 dest_ip_addr ip 0.0.0.0",
	  #"35 5 6 dest_ip_addr ip 0.0.0.0",
	  #"35 6 7 dest_ip_addr ip 0.0.0.0",
	  #"35 7 8 dest_ip_addr ip 0.0.0.0",
	  #"35 8 9 dest_ip_addr ip 0.0.0.0",
	  #"35 9 10 dest_ip_addr ip 0.0.0.0",
	  #"35 10 11 dest_ip_addr ip 0.0.0.0",
	  #"35 11 12 dest_ip_addr ip 0.0.0.0",
	  #"35 12 13 dest_ip_addr ip 0.0.0.0",
	  #"35 13 14 dest_ip_addr ip 0.0.0.0",
	  #"35 14 15 dest_ip_addr ip 0.0.0.0",
	  #"35 15 -1 dest_ip_addr ip 0.0.0.0",
	  #"36 0 1 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 1 2 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 2 3 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 3 4 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 4 5 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 5 6 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 6 7 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 7 8 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 8 9 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 9 10 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 10 11 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 11 12 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 12 13 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 13 14 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 14 15 dest_mac_addr mac 00:00:00:00:00:00",
	  #"36 15 -1 dest_mac_addr mac 00:00:00:00:00:00",
	  #"37 0 1 dest_vlan_tag_type integer 0",
	  #"37 1 2 dest_vlan_tag_type integer 0",
	  #"37 2 3 dest_vlan_tag_type integer 0",
	  #"37 3 4 dest_vlan_tag_type integer 0",
	  #"37 4 5 dest_vlan_tag_type integer 0",
	  #"37 5 6 dest_vlan_tag_type integer 0",
	  #"37 6 7 dest_vlan_tag_type integer 0",
	  #"37 7 8 dest_vlan_tag_type integer 0",
	  #"37 8 9 dest_vlan_tag_type integer 0",
	  #"37 9 10 dest_vlan_tag_type integer 0",
	  #"37 10 11 dest_vlan_tag_type integer 0",
	  #"37 11 12 dest_vlan_tag_type integer 0",
	  #"37 12 13 dest_vlan_tag_type integer 0",
	  #"37 13 14 dest_vlan_tag_type integer 0",
	  #"37 14 15 dest_vlan_tag_type integer 0",
	  #"37 15 -1 dest_vlan_tag_type integer 0",
	  #"38 0 1 dest_vlan_tag integer 0",
	  #"38 1 2 dest_vlan_tag integer 0",
	  #"38 2 3 dest_vlan_tag integer 0",
	  #"38 3 4 dest_vlan_tag integer 0",
	  #"38 4 5 dest_vlan_tag integer 0",
	  #"38 5 6 dest_vlan_tag integer 0",
	  #"38 6 7 dest_vlan_tag integer 0",
	  #"38 7 8 dest_vlan_tag integer 0",
	  #"38 8 9 dest_vlan_tag integer 0",
	  #"38 9 10 dest_vlan_tag integer 0",
	  #"38 10 11 dest_vlan_tag integer 0",
	  #"38 11 12 dest_vlan_tag integer 0",
	  #"38 12 13 dest_vlan_tag integer 0",
	  #"38 13 14 dest_vlan_tag integer 0",
	  #"38 14 15 dest_vlan_tag integer 0",
	  #"38 15 -1 dest_vlan_tag integer 0",
	  "39 -1 -1 vlan_id_enable bool false",
	  "40 -1 -1 vlan_id integer 0",
	  "41 -1 -1 vlan_priority integer 0",
	  "42 -1 -1 num_cipher_suites integer 16",
	  "43 0 1 cipher_suite_entry integer 1",
	  "43 1 2 cipher_suite_entry integer 2",
	  "43 2 3 cipher_suite_entry integer 3",
	  "43 3 4 cipher_suite_entry integer 4",
	  "43 4 5 cipher_suite_entry integer 5",
	  "43 5 6 cipher_suite_entry integer 6",
	  "43 6 7 cipher_suite_entry integer 7",
	  "43 7 8 cipher_suite_entry integer 8",
	  "43 8 9 cipher_suite_entry integer 9",
	  "43 9 10 cipher_suite_entry integer 10",
	  "43 10 11 cipher_suite_entry integer 11",
	  "43 11 12 cipher_suite_entry integer 12",
	  "43 12 13 cipher_suite_entry integer 13",
	  "43 13 14 cipher_suite_entry integer 14",
	  "43 14 15 cipher_suite_entry integer 15",
	  "43 15 -1 cipher_suite_entry integer 16",
	  "44 0 1 max_priv_for_cipher_suite integer 4",
	  "44 1 2 max_priv_for_cipher_suite integer 4",
	  "44 2 3 max_priv_for_cipher_suite integer 4",
	  "44 3 4 max_priv_for_cipher_suite integer 4",
	  "44 4 5 max_priv_for_cipher_suite integer 4",
	  "44 5 6 max_priv_for_cipher_suite integer 4",
	  "44 6 7 max_priv_for_cipher_suite integer 4",
	  "44 7 8 max_priv_for_cipher_suite integer 4",
	  "44 8 9 max_priv_for_cipher_suite integer 4",
	  "44 9 10 max_priv_for_cipher_suite integer 4",
	  "44 10 11 max_priv_for_cipher_suite integer 4",
	  "44 11 12 max_priv_for_cipher_suite integer 4",
	  "44 12 13 max_priv_for_cipher_suite integer 4",
	  "44 13 14 max_priv_for_cipher_suite integer 4",
	  "44 14 15 max_priv_for_cipher_suite integer 4",
	  "44 15 -1 max_priv_for_cipher_suite integer 4" );

    @pef_configs =
	("0 -1 -1 alert_startup_delay_enabled bool false",
         "1 -1 -1 startup_delay_enabled bool false",
	 "2 -1 -1 event_messages_enabled bool false",
	 "3 -1 -1 pef_enabled bool true",
	 "4 -1 -1 diagnostic_interrupt_enabled bool false",
	 "5 -1 -1 oem_action_enabled bool false",
	 "6 -1 -1 power_cycle_enabled bool false",
	 "7 -1 -1 reset_enabled bool false",
	 "8 -1 -1 power_down_enabled bool false",
	 "9 -1 -1 alert_enabled bool true",
	 "10 -1 -1 startup_delay integer 0",
	 "11 -1 -1 alert_startup_delay integer 0",
	 "12 -1 -1 guid_enabled bool false",
	 "13 -1 -1 guid_val data 0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00%0x00",
	 "14 -1 -1 num_event_filters integer 15",
	 "15 0 1 enable_filter bool true",
	 "15 1 2 enable_filter bool false",
	 "15 2 3 enable_filter bool false",
	 "15 3 4 enable_filter bool false",
	 "15 4 5 enable_filter bool false",
	 "15 5 6 enable_filter bool false",
	 "15 6 7 enable_filter bool false",
	 "15 7 8 enable_filter bool false",
	 "15 8 9 enable_filter bool false",
	 "15 9 10 enable_filter bool false",
	 "15 10 11 enable_filter bool false",
	 "15 11 12 enable_filter bool false",
	 "15 12 13 enable_filter bool false",
	 "15 13 14 enable_filter bool false",
	 "15 14 -1 enable_filter bool false",
	 "16 0 1 filter_type integer 0",
	 "16 1 2 filter_type integer 0",
	 "16 2 3 filter_type integer 0",
	 "16 3 4 filter_type integer 0",
	 "16 4 5 filter_type integer 0",
	 "16 5 6 filter_type integer 0",
	 "16 6 7 filter_type integer 0",
	 "16 7 8 filter_type integer 0",
	 "16 8 9 filter_type integer 0",
	 "16 9 10 filter_type integer 0",
	 "16 10 11 filter_type integer 0",
	 "16 11 12 filter_type integer 0",
	 "16 12 13 filter_type integer 0",
	 "16 13 14 filter_type integer 0",
	 "16 14 -1 filter_type integer 0",
	 "17 0 1 diagnostic_interrupt bool false",
	 "17 1 2 diagnostic_interrupt bool false",
	 "17 2 3 diagnostic_interrupt bool false",
	 "17 3 4 diagnostic_interrupt bool false",
	 "17 4 5 diagnostic_interrupt bool false",
	 "17 5 6 diagnostic_interrupt bool false",
	 "17 6 7 diagnostic_interrupt bool false",
	 "17 7 8 diagnostic_interrupt bool false",
	 "17 8 9 diagnostic_interrupt bool false",
	 "17 9 10 diagnostic_interrupt bool false",
	 "17 10 11 diagnostic_interrupt bool false",
	 "17 11 12 diagnostic_interrupt bool false",
	 "17 12 13 diagnostic_interrupt bool false",
	 "17 13 14 diagnostic_interrupt bool false",
	 "17 14 -1 diagnostic_interrupt bool false",
	 "18 0 1 oem_action bool false",
	 "18 1 2 oem_action bool false",
	 "18 2 3 oem_action bool false",
	 "18 3 4 oem_action bool false",
	 "18 4 5 oem_action bool false",
	 "18 5 6 oem_action bool false",
	 "18 6 7 oem_action bool false",
	 "18 7 8 oem_action bool false",
	 "18 8 9 oem_action bool false",
	 "18 9 10 oem_action bool false",
	 "18 10 11 oem_action bool false",
	 "18 11 12 oem_action bool false",
	 "18 12 13 oem_action bool false",
	 "18 13 14 oem_action bool false",
	 "18 14 -1 oem_action bool false",
	 "19 0 1 power_cycle bool false",
	 "19 1 2 power_cycle bool false",
	 "19 2 3 power_cycle bool false",
	 "19 3 4 power_cycle bool false",
	 "19 4 5 power_cycle bool false",
	 "19 5 6 power_cycle bool false",
	 "19 6 7 power_cycle bool false",
	 "19 7 8 power_cycle bool false",
	 "19 8 9 power_cycle bool false",
	 "19 9 10 power_cycle bool false",
	 "19 10 11 power_cycle bool false",
	 "19 11 12 power_cycle bool false",
	 "19 12 13 power_cycle bool false",
	 "19 13 14 power_cycle bool false",
	 "19 14 -1 power_cycle bool false",
	 "20 0 1 reset bool false",
	 "20 1 2 reset bool false",
	 "20 2 3 reset bool false",
	 "20 3 4 reset bool false",
	 "20 4 5 reset bool false",
	 "20 5 6 reset bool false",
	 "20 6 7 reset bool false",
	 "20 7 8 reset bool false",
	 "20 8 9 reset bool false",
	 "20 9 10 reset bool false",
	 "20 10 11 reset bool false",
	 "20 11 12 reset bool false",
	 "20 12 13 reset bool false",
	 "20 13 14 reset bool false",
	 "20 14 -1 reset bool false",
	 "21 0 1 power_down bool false",
	 "21 1 2 power_down bool false",
	 "21 2 3 power_down bool false",
	 "21 3 4 power_down bool false",
	 "21 4 5 power_down bool false",
	 "21 5 6 power_down bool false",
	 "21 6 7 power_down bool false",
	 "21 7 8 power_down bool false",
	 "21 8 9 power_down bool false",
	 "21 9 10 power_down bool false",
	 "21 10 11 power_down bool false",
	 "21 11 12 power_down bool false",
	 "21 12 13 power_down bool false",
	 "21 13 14 power_down bool false",
	 "21 14 -1 power_down bool false",
	 "22 0 1 alert bool true",
	 "22 1 2 alert bool false",
	 "22 2 3 alert bool false",
	 "22 3 4 alert bool false",
	 "22 4 5 alert bool false",
	 "22 5 6 alert bool false",
	 "22 6 7 alert bool false",
	 "22 7 8 alert bool false",
	 "22 8 9 alert bool false",
	 "22 9 10 alert bool false",
	 "22 10 11 alert bool false",
	 "22 11 12 alert bool false",
	 "22 12 13 alert bool false",
	 "22 13 14 alert bool false",
	 "22 14 -1 alert bool false",
	 "23 0 1 alert_policy_number integer 2",
	 "23 1 2 alert_policy_number integer 0",
	 "23 2 3 alert_policy_number integer 0",
	 "23 3 4 alert_policy_number integer 0",
	 "23 4 5 alert_policy_number integer 0",
	 "23 5 6 alert_policy_number integer 0",
	 "23 6 7 alert_policy_number integer 0",
	 "23 7 8 alert_policy_number integer 0",
	 "23 8 9 alert_policy_number integer 0",
	 "23 9 10 alert_policy_number integer 0",
	 "23 10 11 alert_policy_number integer 0",
	 "23 11 12 alert_policy_number integer 0",
	 "23 12 13 alert_policy_number integer 0",
	 "23 13 14 alert_policy_number integer 0",
	 "23 14 -1 alert_policy_number integer 0",
	 "24 0 1 event_severity integer 0",
	 "24 1 2 event_severity integer 0",
	 "24 2 3 event_severity integer 0",
	 "24 3 4 event_severity integer 0",
	 "24 4 5 event_severity integer 0",
	 "24 5 6 event_severity integer 0",
	 "24 6 7 event_severity integer 0",
	 "24 7 8 event_severity integer 0",
	 "24 8 9 event_severity integer 0",
	 "24 9 10 event_severity integer 0",
	 "24 10 11 event_severity integer 0",
	 "24 11 12 event_severity integer 0",
	 "24 12 13 event_severity integer 0",
	 "24 13 14 event_severity integer 0",
	 "24 14 -1 event_severity integer 0",
	 "25 0 1 generator_id_addr integer 255",
	 "25 1 2 generator_id_addr integer 0",
	 "25 2 3 generator_id_addr integer 0",
	 "25 3 4 generator_id_addr integer 0",
	 "25 4 5 generator_id_addr integer 0",
	 "25 5 6 generator_id_addr integer 0",
	 "25 6 7 generator_id_addr integer 0",
	 "25 7 8 generator_id_addr integer 0",
	 "25 8 9 generator_id_addr integer 0",
	 "25 9 10 generator_id_addr integer 0",
	 "25 10 11 generator_id_addr integer 0",
	 "25 11 12 generator_id_addr integer 0",
	 "25 12 13 generator_id_addr integer 0",
	 "25 13 14 generator_id_addr integer 0",
	 "25 14 -1 generator_id_addr integer 0",
	 "26 0 1 generator_id_channel_lun integer 255",
	 "26 1 2 generator_id_channel_lun integer 0",
	 "26 2 3 generator_id_channel_lun integer 0",
	 "26 3 4 generator_id_channel_lun integer 0",
	 "26 4 5 generator_id_channel_lun integer 0",
	 "26 5 6 generator_id_channel_lun integer 0",
	 "26 6 7 generator_id_channel_lun integer 0",
	 "26 7 8 generator_id_channel_lun integer 0",
	 "26 8 9 generator_id_channel_lun integer 0",
	 "26 9 10 generator_id_channel_lun integer 0",
	 "26 10 11 generator_id_channel_lun integer 0",
	 "26 11 12 generator_id_channel_lun integer 0",
	 "26 12 13 generator_id_channel_lun integer 0",
	 "26 13 14 generator_id_channel_lun integer 0",
	 "26 14 -1 generator_id_channel_lun integer 0",
	 "27 0 1 sensor_type integer 255",
	 "27 1 2 sensor_type integer 0",
	 "27 2 3 sensor_type integer 0",
	 "27 3 4 sensor_type integer 0",
	 "27 4 5 sensor_type integer 0",
	 "27 5 6 sensor_type integer 0",
	 "27 6 7 sensor_type integer 0",
	 "27 7 8 sensor_type integer 0",
	 "27 8 9 sensor_type integer 0",
	 "27 9 10 sensor_type integer 0",
	 "27 10 11 sensor_type integer 0",
	 "27 11 12 sensor_type integer 0",
	 "27 12 13 sensor_type integer 0",
	 "27 13 14 sensor_type integer 0",
	 "27 14 -1 sensor_type integer 0",
	 "28 0 1 sensor_number integer 255",
	 "28 1 2 sensor_number integer 0",
	 "28 2 3 sensor_number integer 0",
	 "28 3 4 sensor_number integer 0",
	 "28 4 5 sensor_number integer 0",
	 "28 5 6 sensor_number integer 0",
	 "28 6 7 sensor_number integer 0",
	 "28 7 8 sensor_number integer 0",
	 "28 8 9 sensor_number integer 0",
	 "28 9 10 sensor_number integer 0",
	 "28 10 11 sensor_number integer 0",
	 "28 11 12 sensor_number integer 0",
	 "28 12 13 sensor_number integer 0",
	 "28 13 14 sensor_number integer 0",
	 "28 14 -1 sensor_number integer 0",
	 "29 0 1 event_trigger integer 255",
	 "29 1 2 event_trigger integer 0",
	 "29 2 3 event_trigger integer 0",
	 "29 3 4 event_trigger integer 0",
	 "29 4 5 event_trigger integer 0",
	 "29 5 6 event_trigger integer 0",
	 "29 6 7 event_trigger integer 0",
	 "29 7 8 event_trigger integer 0",
	 "29 8 9 event_trigger integer 0",
	 "29 9 10 event_trigger integer 0",
	 "29 10 11 event_trigger integer 0",
	 "29 11 12 event_trigger integer 0",
	 "29 12 13 event_trigger integer 0",
	 "29 13 14 event_trigger integer 0",
	 "29 14 -1 event_trigger integer 0",
	 "30 0 1 data1_offset_mask integer 65535",
	 "30 1 2 data1_offset_mask integer 0",
	 "30 2 3 data1_offset_mask integer 0",
	 "30 3 4 data1_offset_mask integer 0",
	 "30 4 5 data1_offset_mask integer 0",
	 "30 5 6 data1_offset_mask integer 0",
	 "30 6 7 data1_offset_mask integer 0",
	 "30 7 8 data1_offset_mask integer 0",
	 "30 8 9 data1_offset_mask integer 0",
	 "30 9 10 data1_offset_mask integer 0",
	 "30 10 11 data1_offset_mask integer 0",
	 "30 11 12 data1_offset_mask integer 0",
	 "30 12 13 data1_offset_mask integer 0",
	 "30 13 14 data1_offset_mask integer 0",
	 "30 14 -1 data1_offset_mask integer 0",
	 "31 0 1 data1_mask integer 0",
	 "31 1 2 data1_mask integer 0",
	 "31 2 3 data1_mask integer 0",
	 "31 3 4 data1_mask integer 0",
	 "31 4 5 data1_mask integer 0",
	 "31 5 6 data1_mask integer 0",
	 "31 6 7 data1_mask integer 0",
	 "31 7 8 data1_mask integer 0",
	 "31 8 9 data1_mask integer 0",
	 "31 9 10 data1_mask integer 0",
	 "31 10 11 data1_mask integer 0",
	 "31 11 12 data1_mask integer 0",
	 "31 12 13 data1_mask integer 0",
	 "31 13 14 data1_mask integer 0",
	 "31 14 -1 data1_mask integer 0",
	 "32 0 1 data1_compare1 integer 0",
	 "32 1 2 data1_compare1 integer 0",
	 "32 2 3 data1_compare1 integer 0",
	 "32 3 4 data1_compare1 integer 0",
	 "32 4 5 data1_compare1 integer 0",
	 "32 5 6 data1_compare1 integer 0",
	 "32 6 7 data1_compare1 integer 0",
	 "32 7 8 data1_compare1 integer 0",
	 "32 8 9 data1_compare1 integer 0",
	 "32 9 10 data1_compare1 integer 0",
	 "32 10 11 data1_compare1 integer 0",
	 "32 11 12 data1_compare1 integer 0",
	 "32 12 13 data1_compare1 integer 0",
	 "32 13 14 data1_compare1 integer 0",
	 "32 14 -1 data1_compare1 integer 0",
	 "33 0 1 data1_compare2 integer 0",
	 "33 1 2 data1_compare2 integer 0",
	 "33 2 3 data1_compare2 integer 0",
	 "33 3 4 data1_compare2 integer 0",
	 "33 4 5 data1_compare2 integer 0",
	 "33 5 6 data1_compare2 integer 0",
	 "33 6 7 data1_compare2 integer 0",
	 "33 7 8 data1_compare2 integer 0",
	 "33 8 9 data1_compare2 integer 0",
	 "33 9 10 data1_compare2 integer 0",
	 "33 10 11 data1_compare2 integer 0",
	 "33 11 12 data1_compare2 integer 0",
	 "33 12 13 data1_compare2 integer 0",
	 "33 13 14 data1_compare2 integer 0",
	 "33 14 -1 data1_compare2 integer 0",
	 "34 0 1 data2_mask integer 0",
	 "34 1 2 data2_mask integer 0",
	 "34 2 3 data2_mask integer 0",
	 "34 3 4 data2_mask integer 0",
	 "34 4 5 data2_mask integer 0",
	 "34 5 6 data2_mask integer 0",
	 "34 6 7 data2_mask integer 0",
	 "34 7 8 data2_mask integer 0",
	 "34 8 9 data2_mask integer 0",
	 "34 9 10 data2_mask integer 0",
	 "34 10 11 data2_mask integer 0",
	 "34 11 12 data2_mask integer 0",
	 "34 12 13 data2_mask integer 0",
	 "34 13 14 data2_mask integer 0",
	 "34 14 -1 data2_mask integer 0",
	 "35 0 1 data2_compare1 integer 0",
	 "35 1 2 data2_compare1 integer 0",
	 "35 2 3 data2_compare1 integer 0",
	 "35 3 4 data2_compare1 integer 0",
	 "35 4 5 data2_compare1 integer 0",
	 "35 5 6 data2_compare1 integer 0",
	 "35 6 7 data2_compare1 integer 0",
	 "35 7 8 data2_compare1 integer 0",
	 "35 8 9 data2_compare1 integer 0",
	 "35 9 10 data2_compare1 integer 0",
	 "35 10 11 data2_compare1 integer 0",
	 "35 11 12 data2_compare1 integer 0",
	 "35 12 13 data2_compare1 integer 0",
	 "35 13 14 data2_compare1 integer 0",
	 "35 14 -1 data2_compare1 integer 0",
	 "36 0 1 data2_compare2 integer 0",
	 "36 1 2 data2_compare2 integer 0",
	 "36 2 3 data2_compare2 integer 0",
	 "36 3 4 data2_compare2 integer 0",
	 "36 4 5 data2_compare2 integer 0",
	 "36 5 6 data2_compare2 integer 0",
	 "36 6 7 data2_compare2 integer 0",
	 "36 7 8 data2_compare2 integer 0",
	 "36 8 9 data2_compare2 integer 0",
	 "36 9 10 data2_compare2 integer 0",
	 "36 10 11 data2_compare2 integer 0",
	 "36 11 12 data2_compare2 integer 0",
	 "36 12 13 data2_compare2 integer 0",
	 "36 13 14 data2_compare2 integer 0",
	 "36 14 -1 data2_compare2 integer 0",
	 "37 0 1 data3_mask integer 0",
	 "37 1 2 data3_mask integer 0",
	 "37 2 3 data3_mask integer 0",
	 "37 3 4 data3_mask integer 0",
	 "37 4 5 data3_mask integer 0",
	 "37 5 6 data3_mask integer 0",
	 "37 6 7 data3_mask integer 0",
	 "37 7 8 data3_mask integer 0",
	 "37 8 9 data3_mask integer 0",
	 "37 9 10 data3_mask integer 0",
	 "37 10 11 data3_mask integer 0",
	 "37 11 12 data3_mask integer 0",
	 "37 12 13 data3_mask integer 0",
	 "37 13 14 data3_mask integer 0",
	 "37 14 -1 data3_mask integer 0",
	 "38 0 1 data3_compare1 integer 0",
	 "38 1 2 data3_compare1 integer 0",
	 "38 2 3 data3_compare1 integer 0",
	 "38 3 4 data3_compare1 integer 0",
	 "38 4 5 data3_compare1 integer 0",
	 "38 5 6 data3_compare1 integer 0",
	 "38 6 7 data3_compare1 integer 0",
	 "38 7 8 data3_compare1 integer 0",
	 "38 8 9 data3_compare1 integer 0",
	 "38 9 10 data3_compare1 integer 0",
	 "38 10 11 data3_compare1 integer 0",
	 "38 11 12 data3_compare1 integer 0",
	 "38 12 13 data3_compare1 integer 0",
	 "38 13 14 data3_compare1 integer 0",
	 "38 14 -1 data3_compare1 integer 0",
	 "39 0 1 data3_compare2 integer 0",
	 "39 1 2 data3_compare2 integer 0",
	 "39 2 3 data3_compare2 integer 0",
	 "39 3 4 data3_compare2 integer 0",
	 "39 4 5 data3_compare2 integer 0",
	 "39 5 6 data3_compare2 integer 0",
	 "39 6 7 data3_compare2 integer 0",
	 "39 7 8 data3_compare2 integer 0",
	 "39 8 9 data3_compare2 integer 0",
	 "39 9 10 data3_compare2 integer 0",
	 "39 10 11 data3_compare2 integer 0",
	 "39 11 12 data3_compare2 integer 0",
	 "39 12 13 data3_compare2 integer 0",
	 "39 13 14 data3_compare2 integer 0",
	 "39 14 -1 data3_compare2 integer 0",
	 "40 -1 -1 num_alert_policies integer 15",
	 "41 0 1 policy_num integer 0",
	 "41 1 2 policy_num integer 0",
	 "41 2 3 policy_num integer 2",
	 "41 3 4 policy_num integer 0",
	 "41 4 5 policy_num integer 0",
	 "41 5 6 policy_num integer 0",
	 "41 6 7 policy_num integer 0",
	 "41 7 8 policy_num integer 0",
	 "41 8 9 policy_num integer 0",
	 "41 9 10 policy_num integer 0",
	 "41 10 11 policy_num integer 0",
	 "41 11 12 policy_num integer 0",
	 "41 12 13 policy_num integer 0",
	 "41 13 14 policy_num integer 0",
	 "41 14 -1 policy_num integer 0",
	 "42 0 1 enabled bool false",
	 "42 1 2 enabled bool false",
	 "42 2 3 enabled bool true",
	 "42 3 4 enabled bool false",
	 "42 4 5 enabled bool false",
	 "42 5 6 enabled bool false",
	 "42 6 7 enabled bool false",
	 "42 7 8 enabled bool false",
	 "42 8 9 enabled bool false",
	 "42 9 10 enabled bool false",
	 "42 10 11 enabled bool false",
	 "42 11 12 enabled bool false",
	 "42 12 13 enabled bool false",
	 "42 13 14 enabled bool false",
	 "42 14 -1 enabled bool false",
	 "43 0 1 policy integer 0",
	 "43 1 2 policy integer 0",
	 "43 2 3 policy integer 0",
	 "43 3 4 policy integer 0",
	 "43 4 5 policy integer 0",
	 "43 5 6 policy integer 0",
	 "43 6 7 policy integer 0",
	 "43 7 8 policy integer 0",
	 "43 8 9 policy integer 0",
	 "43 9 10 policy integer 0",
	 "43 10 11 policy integer 0",
	 "43 11 12 policy integer 0",
	 "43 12 13 policy integer 0",
	 "43 13 14 policy integer 0",
	 "43 14 -1 policy integer 0",
	 "44 0 1 channel integer 0",
	 "44 1 2 channel integer 0",
	 "44 2 3 channel integer 7",
	 "44 3 4 channel integer 0",
	 "44 4 5 channel integer 0",
	 "44 5 6 channel integer 0",
	 "44 6 7 channel integer 0",
	 "44 7 8 channel integer 0",
	 "44 8 9 channel integer 0",
	 "44 9 10 channel integer 0",
	 "44 10 11 channel integer 0",
	 "44 11 12 channel integer 0",
	 "44 12 13 channel integer 0",
	 "44 13 14 channel integer 0",
	 "44 14 -1 channel integer 0",
	 "45 0 1 destination_selector integer 0",
	 "45 1 2 destination_selector integer 0",
	 "45 2 3 destination_selector integer 4",
	 "45 3 4 destination_selector integer 0",
	 "45 4 5 destination_selector integer 0",
	 "45 5 6 destination_selector integer 0",
	 "45 6 7 destination_selector integer 0",
	 "45 7 8 destination_selector integer 0",
	 "45 8 9 destination_selector integer 0",
	 "45 9 10 destination_selector integer 0",
	 "45 10 11 destination_selector integer 0",
	 "45 11 12 destination_selector integer 0",
	 "45 12 13 destination_selector integer 0",
	 "45 13 14 destination_selector integer 0",
	 "45 14 -1 destination_selector integer 0",
	 "46 0 1 alert_string_event_specific bool false",
	 "46 1 2 alert_string_event_specific bool false",
	 "46 2 3 alert_string_event_specific bool false",
	 "46 3 4 alert_string_event_specific bool false",
	 "46 4 5 alert_string_event_specific bool false",
	 "46 5 6 alert_string_event_specific bool false",
	 "46 6 7 alert_string_event_specific bool false",
	 "46 7 8 alert_string_event_specific bool false",
	 "46 8 9 alert_string_event_specific bool false",
	 "46 9 10 alert_string_event_specific bool false",
	 "46 10 11 alert_string_event_specific bool false",
	 "46 11 12 alert_string_event_specific bool false",
	 "46 12 13 alert_string_event_specific bool false",
	 "46 13 14 alert_string_event_specific bool false",
	 "46 14 -1 alert_string_event_specific bool false",
	 "47 0 1 alert_string_selector integer 0",
	 "47 1 2 alert_string_selector integer 0",
	 "47 2 3 alert_string_selector integer 0",
	 "47 3 4 alert_string_selector integer 0",
	 "47 4 5 alert_string_selector integer 0",
	 "47 5 6 alert_string_selector integer 0",
	 "47 6 7 alert_string_selector integer 0",
	 "47 7 8 alert_string_selector integer 0",
	 "47 8 9 alert_string_selector integer 0",
	 "47 9 10 alert_string_selector integer 0",
	 "47 10 11 alert_string_selector integer 0",
	 "47 11 12 alert_string_selector integer 0",
	 "47 12 13 alert_string_selector integer 0",
	 "47 13 14 alert_string_selector integer 0",
	 "47 14 -1 alert_string_selector integer 0",
	 "48 -1 -1 num_alert_strings integer 16",
	 "49 0 1 event_filter integer 0",
	 "49 1 2 event_filter integer 0",
	 "49 2 3 event_filter integer 0",
	 "49 3 4 event_filter integer 0",
	 "49 4 5 event_filter integer 0",
	 "49 5 6 event_filter integer 0",
	 "49 6 7 event_filter integer 0",
	 "49 7 8 event_filter integer 0",
	 "49 8 9 event_filter integer 0",
	 "49 9 10 event_filter integer 0",
	 "49 10 11 event_filter integer 0",
	 "49 11 12 event_filter integer 0",
	 "49 12 13 event_filter integer 0",
	 "49 13 14 event_filter integer 0",
	 "49 14 15 event_filter integer 0",
	 "49 15 -1 event_filter integer 0",
	 "50 0 1 alert_string_set integer 0",
	 "50 1 2 alert_string_set integer 0",
	 "50 2 3 alert_string_set integer 0",
	 "50 3 4 alert_string_set integer 0",
	 "50 4 5 alert_string_set integer 0",
	 "50 5 6 alert_string_set integer 0",
	 "50 6 7 alert_string_set integer 0",
	 "50 7 8 alert_string_set integer 0",
	 "50 8 9 alert_string_set integer 0",
	 "50 9 10 alert_string_set integer 0",
	 "50 10 11 alert_string_set integer 0",
	 "50 11 12 alert_string_set integer 0",
	 "50 12 13 alert_string_set integer 0",
	 "50 13 14 alert_string_set integer 0",
	 "50 14 15 alert_string_set integer 0",
	 "50 15 -1 alert_string_set integer 0",
	 "51 0 1 alert_string string",
	 "51 1 2 alert_string string",
	 "51 2 3 alert_string string",
	 "51 3 4 alert_string string",
	 "51 4 5 alert_string string",
	 "51 5 6 alert_string string",
	 "51 6 7 alert_string string",
	 "51 7 8 alert_string string",
	 "51 8 9 alert_string string",
	 "51 9 10 alert_string string",
	 "51 10 11 alert_string string",
	 "51 11 12 alert_string string",
	 "51 12 13 alert_string string",
	 "51 13 14 alert_string string",
	 "51 14 15 alert_string string",
	 "51 15 -1 alert_string string" );

    sub pef_got_config_cb {
	my $self = shift;
	my $pef = shift;
	my $err = shift;
	my $config = shift;
	my $rv;
	my $i;

	if ($err) {
	    main::reg_err("Error getting PEF: $err\n");
	    $self->close();
	    return;
	}

	print "PEF config\n";

	for $i (@pef_configs) {
	    my ($parm, $idx, $nidx, $name, $type, $val) = split /\s+/, $i;
	    if (defined($val)) {
		$val = join(" ", split(/%/, $val));
	    } else {
		$val = "";
	    }
	    $val = join(" ", split(/%/, $val));
	    my $vidx = int($idx);
	    my $v = $config->get_val($parm, \$vidx);
	    my ($vname, $vtype, $vval) = split /\s+/, $v, 3;
	    if ($name ne $vname) {
		main::reg_err("$parm($idx) name mismatch, expected $name, got $vname");
	    }
	    if ($type ne $vtype) {
		main::reg_err("$parm($idx) type mismatch, expected $type, got $vtype");
		print join(" ", $parm, $idx, $nidx, $name, $type, $val), "\n";
	    }
	    if ($val ne $vval) {
		main::reg_err("$parm($idx) val mismatch, expected $val, got $vval");
	    }
	    if ($nidx != $vidx) {
		main::reg_err("$parm($idx) nidx mismatch, expected $nidx, got $vidx");
	    }
	}

	$$self->{accmode}--;
	if ($$self->{accmode} == 0) {
	    $self->close();
	    return;
	}
    }

    sub lanparm_got_config_cb {
	my $self = shift;
	my $lanparm = shift;
	my $err = shift;
	my $config = shift;
	my $rv;
	my $i;

	if ($err) {
	    main::reg_err("Unable to get lanparms: $err\n");
	    $self->close();
	    return;
	}

	print "LANPARM config\n";

	for $i (@lanparm_configs) {
	    my ($parm, $idx, $nidx, $name, $type, $val) = split /\s+/, $i;
	    $val = join(" ", split(/%/, $val));
	    my $vidx = int($idx);
	    my $v = $config->get_val($parm, \$vidx);
	    my ($vname, $vtype, $vval) = split /\s+/, $v, 3;
	    if ($name ne $vname) {
		main::reg_err("$parm($idx) name mismatch, expected $name, got $vname");
	    }
	    if ($type ne $vtype) {
		main::reg_err("$parm($idx) type mismatch, expected $type, got $vtype");
	    }
	    if ($val ne $vval) {
		main::reg_err("$parm($idx) val mismatch, expected $val, got $vval");
	    }
	    if ($nidx != $vidx) {
		main::reg_err("$parm($idx) nidx mismatch, expected $nidx, got $vidx");
	    }
	}

	$$self->{accmode}--;
	if ($$self->{accmode} == 0) {
	    $self->close();
	    return;
	}
    }

    sub got_pet_cb {
	my $self = shift;
	my $pet = shift;
	my $err = shift;

	if ($err) {
	    main::reg_err("Unable to get pet: $err\n");
	    $self->close();
	    return;
	}

	print "Got PET\n";

	$rv = $$self->{pef}->get_config($self);
	if ($rv) {
	    main::reg_err("Unable to get pef config: $rv\n");
	    $self->close();
	    return;
	}

	$rv = $$self->{lanparm}->get_config($self);
	if ($rv) {
	    main::reg_err("Unable to get lanparm config: $rv\n");
	    $self->close();
	    return;
        }
    }

    sub got_pef_cb {
	my $self = shift;
	my $pef = shift;
	my $err = shift;
	my $get;
	my $mcid;

	if ($err) {
	    main::reg_err("Unable to get pef: $err\n");
	    $self->close();
	    return;
	}

	print "Got PEF\n";

	$get = PetGet::new($self);
	$mcid = $pef->get_mc_id();
	$rv = $mcid->to_mc($get);
	if ($rv) {
	    main::reg_err("Unable to convert mcid to mc: $rv\n");
	    $self->close();
	    return;
	}
    }

    sub mc_update_cb {
	my $self = shift;
	my $op = shift;
	my $domain = shift;
	my $mc = shift;
	my $rv;
	my $lanparm;

	if ($op eq "added") {
	    print $op, " MC ", $mc->get_name(), "\n";

	    $$self->{lanparm} = $mc->get_lanparm(7);
	    if (! defined($$self->{lanparm})) {
		main::reg_err("Unable to get lanparm\n");
		$self->close();
		return;
	    }

	    $$self->{pef} = $mc->get_pef($self);
	    if (! defined($$self->{pef})) {
		main::reg_err("Unable to alloc pef\n");
		$self->close();
	        return;
	    }
	}
    }

    sub conn_change_cb {
	my $self = shift;
	my $domain = shift;
	my $err = shift;
	my $conn_num = shift;
	my $port_num = shift;
	my $still_connected = shift;
	my $rv;

	if ($err) {
	    main::reg_err("Error starting up IPMI connection: $err");
	    $self->close();
	    return;
	}

	print "Connection up!\n";
	$rv = $domain->add_mc_update_handler($self);
	if ($rv) {
	    main::reg_err("Unable to add mc updated handler: $rv\n");
	    $self->close();
	    return;
	}
    }

    sub domain_close_done_cb {
	my $self = shift;

	$$self->{keepon} = 0;
    }

    sub close {
	my $self = shift;
	my $domain = shift;

	if (defined $$self->{domain_id}) {
	    my $v = CloseDomain::new($self);
	    $$self->{domain_id}->to_domain($v);
	} else {
	    $$self->{keepon} = 0;
	}
    }

}

package main;

$lanserv = Lanserv->new();
if (! $lanserv) {
    main::reg_err("Unable to start lanserv");
    exit(1);
}

# Add a BMC
$lanserv->cmd("mc_add 0x20 0 has-device-sdrs 0x23 9 8 0x1f 0x1291 0xf02");
$lanserv->cmd("mc_enable 0x20");

sleep 1;

#OpenIPMI::enable_debug_msg();
OpenIPMI::enable_debug_malloc();

# Now start OpenIPMI
$rv = OpenIPMI::init();
if ($rv != 0) {
    print "init failed";
    exit 1;
}

$h = Handlers::new();

OpenIPMI::set_log_handler($h);

@args = ( "-noseteventrcvr",
	  "lan", "-p", "9000", "-U", "minyard", "-P", "test", "localhost");
$$h->{domain_id} = OpenIPMI::open_domain2("test", \@args, $h, \undef);
if (! $$h->{domain_id}) {
    $lanserv->close();
    print "IPMI open failed\n";
    exit 1;
}

while ($$h->{keepon}) {
    OpenIPMI::wait_io(1000);
}

OpenIPMI::set_log_handler(\undef);
$h = undef;

$lanserv->close();
OpenIPMI::shutdown_everything();
if (main::get_errcount() != 0) {
    exit 1;
} else {
    exit 0
}
