// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/common/system/tray/fixed_sized_image_view.h"

namespace ash {

FixedSizedImageView::FixedSizedImageView(int width, int height)
    : width_(width), height_(height) {}

FixedSizedImageView::~FixedSizedImageView() {}

gfx::Size FixedSizedImageView::GetPreferredSize() const {
  gfx::Size size = views::ImageView::GetPreferredSize();
  return gfx::Size(width_ ? width_ : size.width(),
                   height_ ? height_ : size.height());
}

}  // namespace ash
