## RabbitMQ 3.7.7

RabbitMQ `3.7.7` a maintenance release. This release introduces
compatibility with [Erlang/OTP 21](http://www.erlang.org/news/123).

### Upgrades and Compatibility

This release has no known incompatibilities with earlier `3.7.x` releases.

#### Upgrading to Erlang 21.0

When upgrading to this release **and upgrading Erlang to 21.0** at the same time, extra care has to be taken.
Since CLI tools from any earlier RabbitMQ release will fail on Erlang 21, RabbitMQ **must be upgraded before Erlang**.

#### Documentation Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and
compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Enhancements

 * This release is compatible with [Erlang/OTP 21](http://www.erlang.org/news/123), the newest major
   Erlang runtime release.

   GitHub issue: [rabbitmq/rabbitmq-server#1616](https://github.com/rabbitmq/rabbitmq-server/issues/1616)

 * Windows installer will now take default [Erlang cookie](https://www.rabbitmq.com/cli.html#erlang-cookie) location differences between Erlang versions into account.

   GitHub issue: [rabbitmq/rabbitmq-server-release#82](https://github.com/rabbitmq/rabbitmq-server-release/pull/82)


### Management Plugin

#### Enhancements

 * It is now possible to configure Web browser session timeout. Default is still 8 hours.

   GitHub issue: [rabbitmq/rabbitmq-management#584](https://github.com/rabbitmq/rabbitmq-management/pull/584)


### Federation Plugin

#### Bug Fixes

 * Direct connections downstream were not closed in some cases.

   Contributed by Ricardo Gonçalves.

   GitHub issue: [rabbitmq/rabbitmq-federation#76](https://github.com/rabbitmq/rabbitmq-federation/issues/76)
   
   
### LDAP Plugin

#### Bug Fixes

 * It wasn't possible to set `auth_ldap.dn_lookup_bind` to the value of `anon` in the new style config format.
  
   GitHub issue: [rabbitmq/rabbitmq-auth-backend-ldap#94](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/94) 
   
### Consul Peer Discovery Plugin

#### Bug Fixes

  * The following combination of settings was rejected by the plugin, even though they are reasonable
    and were recommended by the docs:
    
    ``` ini
    cluster_formation.consul.svc_addr_auto = true
    # en0 is just an example, it could be any other NIC name
    cluster_formation.consul.svc_addr_nic = en0
    ```

    GitHub issue: [rabbitmq/rabbitmq-peer-discovery-consul#12](https://github.com/rabbitmq/rabbitmq-peer-discovery-consul/issues/12)

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.7.tar.gz`.
