<xsl:stylesheet version = '1.0'
		xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
		xmlns:gir="http://www.gtk.org/introspection/core/1.0"
		xmlns:c="http://www.gtk.org/introspection/c/1.0">
  
  <xsl:template match="gir:type">
    <xsl:text>#TYPE#</xsl:text>
    <xsl:value-of select="@name"/>
    <xsl:text>#TYPE#,</xsl:text>
  </xsl:template>
  <xsl:template match="gir:return-value">
    <xsl:apply-templates select="gir:type"/>
  </xsl:template>
  
  <xsl:template match="gir:parameters">
    <xsl:for-each select="gir:parameter">
      <xsl:apply-templates select="gir:type"/>
    </xsl:for-each>


  </xsl:template>

  <xsl:template match="gir:constructor">
    <xsl:param name="symbol-prefix"/>
    <xsl:text>  this.</xsl:text>
    <xsl:value-of select="$symbol-prefix"/>
    <xsl:text>_</xsl:text>
    <xsl:value-of select="@name"/>
    <xsl:text> = &#xa;    this.lib.declare("</xsl:text>
    <xsl:value-of select="@c:identifier"/>
    <xsl:text>",&#xa;                     ctypes.default_abi,&#xa;                     </xsl:text>
    <xsl:apply-templates select="gir:return-value"/>
    <xsl:apply-templates select="gir:parameters"/>
    <xsl:text>);&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="/">
    <xsl:text>Components.utils.import("resource://gre/modules/ctypes.jsm");
function UnityWebapps() {&#xa;</xsl:text>
    
    <xsl:text>    try {
    this.lib = ctypes.open("libunity-webapps.so.0");
    } catch (e) {
    try {
        this.lib = ctypes.open("/usr/local/lib/libunity-webapps.so.0");
    } catch (e) {
        this.lib = ctypes.open("/usr/lib/libunity-webapps.so.0");
    }
    }</xsl:text>

    <xsl:for-each select="//gir:callback">
      <xsl:text>  this.</xsl:text>
      <xsl:value-of select="@name"/>
      <xsl:text>Type = ctypes.FunctionType(ctypes.default_abi, </xsl:text>
      
      <xsl:apply-templates select="gir:return-value"/>

      <xsl:text>[</xsl:text>
      <xsl:apply-templates select="gir:parameters"/>
      <xsl:text>]</xsl:text>


      <xsl:text>);&#xa;</xsl:text>

    </xsl:for-each>

    <xsl:for-each select="//gir:record">
      <xsl:if test="substring(@name, string-length(@name) - 3, 4) = 'Desc'">
        <xsl:text>  this.</xsl:text>
        <xsl:value-of select="@name"/>

        <xsl:text> = ctypes.StructType(</xsl:text>
        <xsl:text>'</xsl:text>
        <xsl:value-of select="@name"/>
        <xsl:text>', </xsl:text>

        <xsl:text>[</xsl:text>
          <xsl:for-each select="gir:field">
            <xsl:text>  { '</xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:text>' : </xsl:text>

            <xsl:apply-templates select="gir:type"/>
            <xsl:text> }, </xsl:text>
          </xsl:for-each>
        <xsl:text>]</xsl:text>

        <xsl:text>);&#xa;</xsl:text>
      </xsl:if>
    </xsl:for-each>

    <xsl:for-each select="//gir:class">
      <xsl:apply-templates select="gir:constructor">
	<xsl:with-param name="symbol-prefix" select="@c:symbol-prefix"/>
      </xsl:apply-templates>


      <xsl:for-each select="gir:method">
	<xsl:text>  this.</xsl:text>
	<xsl:value-of select="../@c:symbol-prefix"/>
	<xsl:text>_</xsl:text>
	<xsl:value-of select="@name"/>
	<xsl:text> = &#xa;    this.lib.declare("</xsl:text>
	<xsl:value-of select="@c:identifier"/>
	<xsl:text>",&#xa;                     ctypes.default_abi,&#xa;                     </xsl:text>
	<xsl:apply-templates select="gir:return-value"/>
	
	<xsl:choose>
	  <xsl:when test="@c:identifier != 'unity_webapps_context_new_sync'">
	    <xsl:text>ctypes.voidptr_t,</xsl:text>
	  </xsl:when>
	  <xsl:otherwise/>
	</xsl:choose>
	<xsl:apply-templates select="gir:parameters"/>
	
	<xsl:text>);&#xa;</xsl:text>
      </xsl:for-each>

    <xsl:for-each select="gir:function">
      <xsl:text>  this.</xsl:text>
	<xsl:choose>
	  <xsl:when test="../@c:symbol-prefix = 'context'">
	    <xsl:value-of select="../@c:symbol-prefix"/>
	    <xsl:text>_</xsl:text>
	  </xsl:when>
	  <xsl:otherwise/>
	</xsl:choose>
      <xsl:value-of select="@name"/>
      <xsl:text> = &#xa;    this.lib.declare("</xsl:text>
      <xsl:value-of select="@c:identifier"/>
      <xsl:text>",&#xa;                     ctypes.default_abi,&#xa;                     </xsl:text>
      <xsl:apply-templates select="gir:return-value"/>
      <xsl:apply-templates select="gir:parameters"/>
      
      <xsl:text>);&#xa;</xsl:text>
    </xsl:for-each>
    

    </xsl:for-each>

    <xsl:for-each select="//gir:namespace/gir:function">
      <xsl:text>  this.</xsl:text>
      <xsl:value-of select="@name"/>
      <xsl:text> = &#xa;    this.lib.declare("</xsl:text>
      <xsl:value-of select="@c:identifier"/>
      <xsl:text>",&#xa;                     ctypes.default_abi,&#xa;                     </xsl:text>
      <xsl:apply-templates select="gir:return-value"/>
      <xsl:apply-templates select="gir:parameters"/>
      
      <xsl:text>);&#xa;</xsl:text>
    </xsl:for-each>

    <xsl:text>&#xa;}&#xa;var EXPORTED_SYMBOLS=["UnityWebapps"];</xsl:text>
  </xsl:template>
  
</xsl:stylesheet>
