/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

import com.android.dex.DexException;
import com.android.dex.util.ByteInput;
import com.android.dex.util.ByteOutput;

public final class Leb128 {
    private Leb128() {
    }

    public static int unsignedLeb128Size(int n) {
        int n2 = n >> 7;
        int n3 = 0;
        while (n2 != 0) {
            n2 >>= 7;
            ++n3;
        }
        return n3 + 1;
    }

    public static int signedLeb128Size(int n) {
        int n2;
        int n3 = n >> 7;
        int n4 = 0;
        boolean bl = true;
        int n5 = n2 = (n & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (bl) {
            bl = n3 != n2 || (n3 & 1) != (n >> 6 & 1);
            n = n3;
            n3 >>= 7;
            ++n4;
        }
        return n4;
    }

    public static int readSignedLeb128(ByteInput byteInput) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        do {
            n = byteInput.readByte() & 0xFF;
            n2 |= (n & 0x7F) << n3 * 7;
            n4 <<= 7;
        } while ((n & 0x80) == 128 && ++n3 < 5);
        if ((n & 0x80) == 128) {
            throw new DexException("invalid LEB128 sequence");
        }
        if ((n4 >> 1 & n2) != 0) {
            n2 |= n4;
        }
        return n2;
    }

    public static int readUnsignedLeb128(ByteInput byteInput) {
        int n;
        int n2 = 0;
        int n3 = 0;
        do {
            n = byteInput.readByte() & 0xFF;
            n2 |= (n & 0x7F) << n3 * 7;
        } while ((n & 0x80) == 128 && ++n3 < 5);
        if ((n & 0x80) == 128) {
            throw new DexException("invalid LEB128 sequence");
        }
        return n2;
    }

    public static void writeUnsignedLeb128(ByteOutput byteOutput, int n) {
        for (int i = n >>> 7; i != 0; i >>>= 7) {
            byteOutput.writeByte((byte)(n & 0x7F | 0x80));
            n = i;
        }
        byteOutput.writeByte((byte)(n & 0x7F));
    }

    public static void writeSignedLeb128(ByteOutput byteOutput, int n) {
        int n2;
        int n3 = n >> 7;
        boolean bl = true;
        int n4 = n2 = (n & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (bl) {
            bl = n3 != n2 || (n3 & 1) != (n >> 6 & 1);
            byteOutput.writeByte((byte)(n & 0x7F | (bl ? 128 : 0)));
            n = n3;
            n3 >>= 7;
        }
    }
}

