########################################################################
#
#    Vision Node - Python source code - file generated by vision
#    Tuesday 25 July 2006 11:40:00 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/AutoDockTools/VisionInterface/Docking.py,v 1.1 2006/07/25 23:35:30 rhuey Exp $
#
# $Id: Docking.py,v 1.1 2006/07/25 23:35:30 rhuey Exp $
#

# import node's base class node
from NetworkEditor.items import NetworkNode
class Docking(NetworkNode):
    mRequiredTypes = {}
    mRequiredSynonyms = [
    ]
    def __init__(self, constrkw = {},  name='Docking', **kw):
        kw['constrkw'] = constrkw
        kw['name'] = name
        apply( NetworkNode.__init__, (self,), kw)
        code = """def doit(self, docking_logs, rmsTool):
        from AutoDockTools.Docking import Docking
        d = Docking()
        for f in docking_logs:
                d.readDlg(f)
        d.clusterer.rmsTool = rmsTool
        self.outputData(docking = d)           
                    
        
## to ouput data on port docking use
## self.outputData(docking=data)


"""
        self.configure(function=code)
        self.inputPortsDescr.append(
            {'name': 'docking_logs', 'cast': True, 'datatype': 'list', 'balloon': 'list of docking log files to be read into as a single Docking', 'height': 12, 'width': 12, 'shape': 'oval', 'color': 'cyan'})
        self.inputPortsDescr.append(
            {'name': 'rmsTool', 'cast': True, 'datatype': 'None', 'balloon': 'rmsTool to be used for clustering', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.outputPortsDescr.append(
            {'name': 'docking', 'datatype': 'None', 'balloon': 'docking instance', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})


    def beforeAddingToNetwork(self, net):
        try:
            ed = net.getEditor()
        except:
            import traceback; traceback.print_exc()
            print 'Warning! Could not import widgets'

