/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "mfe" locale.
 */
public class LocalizedNamesImpl_mfe extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AL",
        "DE",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AG",
        "AN",
        "AQ",
        "AM",
        "AW",
        "AX",
        "HT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BG",
        "BL",
        "BO",
        "BA",
        "BW",
        "BT",
        "BR",
        "BN",
        "BF",
        "BI",
        "BV",
        "CC",
        "CR",
        "CI",
        "CP",
        "CU",
        "CX",
        "CY",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EA",
        "EH",
        "EC",
        "AE",
        "ER",
        "EE",
        "EU",
        "FJ",
        "PH",
        "FI",
        "FO",
        "GA",
        "GM",
        "GG",
        "GH",
        "GN",
        "GW",
        "GQ",
        "GL",
        "GD",
        "GR",
        "GS",
        "GP",
        "GU",
        "GT",
        "GY",
        "GF",
        "HK",
        "HM",
        "HN",
        "IC",
        "UA",
        "IM",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IT",
        "IL",
        "JE",
        "KH",
        "CM",
        "CA",
        "CV",
        "QA",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "KW",
        "HR",
        "FR",
        "KP",
        "KR",
        "US",
        "LA",
        "SA",
        "RE",
        "RU",
        "AR",
        "CN",
        "SY",
        "SE",
        "CH",
        "VA",
        "IN",
        "ES",
        "ET",
        "LV",
        "EG",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "NF",
        "LT",
        "AU",
        "AT",
        "LU",
        "MG",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MK",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MU",
        "MR",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NU",
        "NE",
        "NG",
        "NO",
        "NC",
        "NZ",
        "NL",
        "OM",
        "HU",
        "UG",
        "UZ",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PT",
        "PR",
        "QO",
        "CZ",
        "CD",
        "DO",
        "CF",
        "RO",
        "RS",
        "RW",
        "KN",
        "SH",
        "LC",
        "SM",
        "PM",
        "VC",
        "SV",
        "WS",
        "AS",
        "ST",
        "SN",
        "CS",
        "SC",
        "CL",
        "ZA",
        "SL",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SO",
        "SD",
        "LK",
        "SR",
        "SZ",
        "TA",
        "TJ",
        "TW",
        "TZ",
        "TD",
        "IO",
        "PS",
        "TF",
        "TH",
        "TL",
        "TN",
        "TR",
        "TG",
        "TK",
        "TO",
        "TT",
        "TM",
        "TV",
        "UM",
        "GB",
        "UY",
        "VU",
        "VE",
        "VN",
        "WF",
        "YE",
        "JM",
        "ZM",
        "JP",
        "GE",
        "GI",
        "CK",
        "KY",
        "FK",
        "MH",
        "MP",
        "SB",
        "TC",
        "VG",
        "VI",
        "ZW",
        "JO",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andor");
    namesMap.put("AE", "Emira arab ini");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua-ek-Barbuda");
    namesMap.put("AL", "Albani");
    namesMap.put("AM", "Armeni");
    namesMap.put("AN", "Antiy neerlande");
    namesMap.put("AR", "Larzantinn");
    namesMap.put("AS", "Samoa amerikin");
    namesMap.put("AT", "Lostris");
    namesMap.put("AU", "Lostrali");
    namesMap.put("AZ", "Azerbaïdjan");
    namesMap.put("BA", "Bosni-Herzegovinn");
    namesMap.put("BB", "Barbad");
    namesMap.put("BD", "Banglades");
    namesMap.put("BE", "Belzik");
    namesMap.put("BG", "Bilgari");
    namesMap.put("BH", "Bahreïn");
    namesMap.put("BM", "Bermid");
    namesMap.put("BO", "Bolivi");
    namesMap.put("BR", "Brezil");
    namesMap.put("BT", "Boutan");
    namesMap.put("BY", "Belaris");
    namesMap.put("BZ", "Beliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Repiblik demokratik Kongo");
    namesMap.put("CF", "Repiblik Lafrik Santral");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Laswis");
    namesMap.put("CI", "Côte d'Ivoire");
    namesMap.put("CK", "Zil Cook");
    namesMap.put("CL", "Shili");
    namesMap.put("CM", "Kamerounn");
    namesMap.put("CN", "Lasinn");
    namesMap.put("CO", "Kolonbi");
    namesMap.put("CS", "Serbi-ek-Montenegro");
    namesMap.put("CV", "Kap-Ver");
    namesMap.put("CZ", "Repiblik Chek");
    namesMap.put("DE", "Almagn");
    namesMap.put("DK", "Dannmark");
    namesMap.put("DM", "Dominik");
    namesMap.put("DO", "Repiblik dominikin");
    namesMap.put("DZ", "Alzeri");
    namesMap.put("EC", "Ekwater");
    namesMap.put("EE", "Estoni");
    namesMap.put("EG", "Lezipt");
    namesMap.put("ER", "Erythre");
    namesMap.put("ES", "Lespagn");
    namesMap.put("ET", "Letiopi");
    namesMap.put("FJ", "Fidji");
    namesMap.put("FK", "Zil malwinn");
    namesMap.put("FM", "Mikronezi");
    namesMap.put("FR", "Lafrans");
    namesMap.put("GD", "Grenad");
    namesMap.put("GE", "Zeorzi");
    namesMap.put("GF", "Gwiyann franse");
    namesMap.put("GI", "Zibraltar");
    namesMap.put("GM", "Gambi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Guadloup");
    namesMap.put("GQ", "Gine ekwatoryal");
    namesMap.put("GR", "Gres");
    namesMap.put("GW", "Gine-Bisau");
    namesMap.put("HR", "Kroasi");
    namesMap.put("HT", "Ayti");
    namesMap.put("HU", "Ongri");
    namesMap.put("ID", "Indonezi");
    namesMap.put("IE", "Irland");
    namesMap.put("IL", "Izrael");
    namesMap.put("IN", "Lenn");
    namesMap.put("IO", "Teritwar Britanik Losean Indien");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Zamaik");
    namesMap.put("JO", "Zordani");
    namesMap.put("JP", "Zapon");
    namesMap.put("KG", "Kirghizistan");
    namesMap.put("KH", "Kambodj");
    namesMap.put("KM", "Komor");
    namesMap.put("KN", "Saint-Christophe-ek-Niévès");
    namesMap.put("KP", "Lakore-dinor");
    namesMap.put("KR", "Lakore-disid");
    namesMap.put("KW", "Koweit");
    namesMap.put("KY", "Zil Kayman");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LB", "Liban");
    namesMap.put("LC", "Sainte-Lucie");
    namesMap.put("LS", "Lezoto");
    namesMap.put("LT", "Lituani");
    namesMap.put("LV", "Letoni");
    namesMap.put("LY", "Libi");
    namesMap.put("MA", "Marok");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavi");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Zil Marshall");
    namesMap.put("MK", "Masedwann");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Mongoli");
    namesMap.put("MP", "Zil Maryann dinor");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Moritani");
    namesMap.put("MS", "Montsera");
    namesMap.put("MT", "Malt");
    namesMap.put("MU", "Moris");
    namesMap.put("MV", "Maldiv");
    namesMap.put("MX", "Mexik");
    namesMap.put("MY", "Malezi");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibi");
    namesMap.put("NC", "Nouvel-Kaledoni");
    namesMap.put("NE", "Nizer");
    namesMap.put("NF", "Lil Norfolk");
    namesMap.put("NG", "Nizeria");
    namesMap.put("NL", "Oland");
    namesMap.put("NO", "Norvez");
    namesMap.put("NU", "Niowe");
    namesMap.put("NZ", "Nouvel Zeland");
    namesMap.put("PE", "Perou");
    namesMap.put("PF", "Polinezi franse");
    namesMap.put("PG", "Papouazi-Nouvel-Gine");
    namesMap.put("PH", "Filipinn");
    namesMap.put("PL", "Pologn");
    namesMap.put("PM", "Saint-Pierre-ek-Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Porto Rico");
    namesMap.put("PS", "Teritwar Palestinn");
    namesMap.put("PT", "Portigal");
    namesMap.put("QA", "Katar");
    namesMap.put("RE", "Larenion");
    namesMap.put("RO", "Roumani");
    namesMap.put("RU", "Larisi");
    namesMap.put("SA", "Larabi Saoudit");
    namesMap.put("SB", "Zil Salomon");
    namesMap.put("SC", "Sesel");
    namesMap.put("SD", "Soudan");
    namesMap.put("SE", "Laswed");
    namesMap.put("SG", "Singapour");
    namesMap.put("SH", "Sainte-Hélène");
    namesMap.put("SI", "Sloveni");
    namesMap.put("SK", "Slovaki");
    namesMap.put("SM", "Saint-Marin");
    namesMap.put("SO", "Somali");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "São Tome-ek-Prínsip");
    namesMap.put("SV", "Salvador");
    namesMap.put("SY", "Lasiri");
    namesMap.put("TC", "Zil Tirk ek Caïcos");
    namesMap.put("TD", "Tchad");
    namesMap.put("TH", "Thayland");
    namesMap.put("TJ", "Tadjikistan");
    namesMap.put("TL", "Timor oriantal");
    namesMap.put("TN", "Tinizi");
    namesMap.put("TR", "Tirki");
    namesMap.put("TT", "Trinite-ek-Tobago");
    namesMap.put("TZ", "Tanzani");
    namesMap.put("UA", "Ikrenn");
    namesMap.put("UG", "Ouganda");
    namesMap.put("US", "Lamerik");
    namesMap.put("UZ", "Ouzbekistan");
    namesMap.put("VA", "Lata Vatikan");
    namesMap.put("VC", "Saint-Vincent-ek-Grenadines");
    namesMap.put("VG", "Zil vierz britanik");
    namesMap.put("VI", "Zil Vierz Lamerik");
    namesMap.put("WF", "Wallis-ek-Futuna");
    namesMap.put("YE", "Yemenn");
    namesMap.put("YT", "Mayot");
    namesMap.put("ZA", "Sid-Afrik");
    namesMap.put("ZM", "Zambi");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andor",
        "AE": "Emira arab ini",
        "AF": "Afganistan",
        "AG": "Antigua-ek-Barbuda",
        "AL": "Albani",
        "AM": "Armeni",
        "AN": "Antiy neerlande",
        "AR": "Larzantinn",
        "AS": "Samoa amerikin",
        "AT": "Lostris",
        "AU": "Lostrali",
        "AZ": "Azerbaïdjan",
        "BA": "Bosni-Herzegovinn",
        "BB": "Barbad",
        "BD": "Banglades",
        "BE": "Belzik",
        "BG": "Bilgari",
        "BH": "Bahreïn",
        "BM": "Bermid",
        "BO": "Bolivi",
        "BR": "Brezil",
        "BT": "Boutan",
        "BY": "Belaris",
        "BZ": "Beliz",
        "CA": "Kanada",
        "CD": "Repiblik demokratik Kongo",
        "CF": "Repiblik Lafrik Santral",
        "CG": "Kongo",
        "CH": "Laswis",
        "CI": "Côte d'Ivoire",
        "CK": "Zil Cook",
        "CL": "Shili",
        "CM": "Kamerounn",
        "CN": "Lasinn",
        "CO": "Kolonbi",
        "CS": "Serbi-ek-Montenegro",
        "CV": "Kap-Ver",
        "CZ": "Repiblik Chek",
        "DE": "Almagn",
        "DK": "Dannmark",
        "DM": "Dominik",
        "DO": "Repiblik dominikin",
        "DZ": "Alzeri",
        "EC": "Ekwater",
        "EE": "Estoni",
        "EG": "Lezipt",
        "ER": "Erythre",
        "ES": "Lespagn",
        "ET": "Letiopi",
        "FJ": "Fidji",
        "FK": "Zil malwinn",
        "FM": "Mikronezi",
        "FR": "Lafrans",
        "GD": "Grenad",
        "GE": "Zeorzi",
        "GF": "Gwiyann franse",
        "GI": "Zibraltar",
        "GM": "Gambi",
        "GN": "Gine",
        "GP": "Guadloup",
        "GQ": "Gine ekwatoryal",
        "GR": "Gres",
        "GW": "Gine-Bisau",
        "HR": "Kroasi",
        "HT": "Ayti",
        "HU": "Ongri",
        "ID": "Indonezi",
        "IE": "Irland",
        "IL": "Izrael",
        "IN": "Lenn",
        "IO": "Teritwar Britanik Losean Indien",
        "IQ": "Irak",
        "IS": "Island",
        "IT": "Itali",
        "JM": "Zamaik",
        "JO": "Zordani",
        "JP": "Zapon",
        "KG": "Kirghizistan",
        "KH": "Kambodj",
        "KM": "Komor",
        "KN": "Saint-Christophe-ek-Niévès",
        "KP": "Lakore-dinor",
        "KR": "Lakore-disid",
        "KW": "Koweit",
        "KY": "Zil Kayman",
        "KZ": "Kazakstan",
        "LB": "Liban",
        "LC": "Sainte-Lucie",
        "LS": "Lezoto",
        "LT": "Lituani",
        "LV": "Letoni",
        "LY": "Libi",
        "MA": "Marok",
        "MC": "Monako",
        "MD": "Moldavi",
        "MG": "Madagaskar",
        "MH": "Zil Marshall",
        "MK": "Masedwann",
        "MM": "Myanmar",
        "MN": "Mongoli",
        "MP": "Zil Maryann dinor",
        "MQ": "Martinik",
        "MR": "Moritani",
        "MS": "Montsera",
        "MT": "Malt",
        "MU": "Moris",
        "MV": "Maldiv",
        "MX": "Mexik",
        "MY": "Malezi",
        "MZ": "Mozambik",
        "NA": "Namibi",
        "NC": "Nouvel-Kaledoni",
        "NE": "Nizer",
        "NF": "Lil Norfolk",
        "NG": "Nizeria",
        "NL": "Oland",
        "NO": "Norvez",
        "NU": "Niowe",
        "NZ": "Nouvel Zeland",
        "PE": "Perou",
        "PF": "Polinezi franse",
        "PG": "Papouazi-Nouvel-Gine",
        "PH": "Filipinn",
        "PL": "Pologn",
        "PM": "Saint-Pierre-ek-Miquelon",
        "PN": "Pitcairn",
        "PR": "Porto Rico",
        "PS": "Teritwar Palestinn",
        "PT": "Portigal",
        "QA": "Katar",
        "RE": "Larenion",
        "RO": "Roumani",
        "RU": "Larisi",
        "SA": "Larabi Saoudit",
        "SB": "Zil Salomon",
        "SC": "Sesel",
        "SD": "Soudan",
        "SE": "Laswed",
        "SG": "Singapour",
        "SH": "Sainte-Hélène",
        "SI": "Sloveni",
        "SK": "Slovaki",
        "SM": "Saint-Marin",
        "SO": "Somali",
        "SR": "Surinam",
        "ST": "São Tome-ek-Prínsip",
        "SV": "Salvador",
        "SY": "Lasiri",
        "TC": "Zil Tirk ek Caïcos",
        "TD": "Tchad",
        "TH": "Thayland",
        "TJ": "Tadjikistan",
        "TL": "Timor oriantal",
        "TN": "Tinizi",
        "TR": "Tirki",
        "TT": "Trinite-ek-Tobago",
        "TZ": "Tanzani",
        "UA": "Ikrenn",
        "UG": "Ouganda",
        "US": "Lamerik",
        "UZ": "Ouzbekistan",
        "VA": "Lata Vatikan",
        "VC": "Saint-Vincent-ek-Grenadines",
        "VG": "Zil vierz britanik",
        "VI": "Zil Vierz Lamerik",
        "WF": "Wallis-ek-Futuna",
        "YE": "Yemenn",
        "YT": "Mayot",
        "ZA": "Sid-Afrik",
        "ZM": "Zambi"
    };
  }-*/;
}
