## Try to find Visual Leak Debugger library (VDL)
## http://vld.codeplex.com
##
## Sets the following variables:
## VLD_FOUND
## VLD_INCLUDE_DIR
## VLD_LIBRARY
##
## Stephen E. Baker 2014
SET(VLD_FOUND FALSE)

IF(${CMAKE_SIZEOF_VOID_P} MATCHES 8)
  SET (VLD_LIB_SUBDIRS lib/Win64 lib)
ELSE(${CMAKE_SIZEOF_VOID_P} MATCHES 8)
  SET (VLD_LIB_SUBDIRS lib/Win32 lib)
ENDIF(${CMAKE_SIZEOF_VOID_P} MATCHES 8)

SET (PROG_FILES_X86_ENV "PROGRAMFILES(X86)")
SET (PROG_FILES_ENV "PROGRAMFILES")

FIND_PATH(VLD_INCLUDE_DIR vld.h
  HINTS
    ENV VLD_HOME
  PATH_SUFFIXES include
  PATHS
  "$ENV{${PROG_FILES_X86_ENV}}/Visual Leak Detector"
  "$ENV{${PROG_FILES_ENV}}/Visual Leak Detector"
)
#MESSAGE("VLD_INCLUDE_DIR=${VLD_INCLUDE_DIR}")

FIND_LIBRARY(VLD_LIBRARY NAMES vld
  HINTS
    ENV VLD_HOME
  PATH_SUFFIXES ${VLD_LIB_SUBDIRS}
  PATHS
  "$ENV{${PROG_FILES_X86_ENV}}/Visual Leak Detector"
  "$ENV{${PROG_FILES_ENV}}/Visual Leak Detector"
)
#MESSAGE("VLD_LIBRARY=${VLD_LIBRARY}")

IF(VLD_INCLUDE_DIR AND VLD_LIBRARY)
  SET(VLD_FOUND TRUE)
ENDIF(VLD_INCLUDE_DIR AND VLD_LIBRARY)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(VLD DEFAULT_MSG VLD_LIBRARY VLD_INCLUDE_DIR)

MARK_AS_ADVANCED(
  VLD_INCLUDE_DIR
  VLD_LIBRARY
)
