/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_PUSH.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfg_push(struct Cfg_Getopt *optstru);

 * Push one indirection state (open response file)
 	The members are initialized with dummy values.

 	Note: If the physical representation of NULL is not the physical
 	representation of '0', this function must be rewritten.

ob(ject): cfg_push
su(bsystem): cmdline
ty(pe): H
sy(nopsis): 
sh(ort description): Create a new input stack item
he(ader files): 
lo(ng description): Create a new input stack item and push it on top
	of the input stack. All item-specific values, such the "read"
	function, are initialized with dummy values.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_push.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdio.h>
#endif
#include <portable.h>
#include <dynstr.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_PUSH.C 1.7 1999/12/13 02:22:03 ska Exp ska $";
#endif


void cfg_push(struct Cfg_Getopt *optstru)
{	struct Cfg_iStackGetopt *p;

	DBG_ENTER("cfg_push", Suppl_cmdline)

	assert(optstru);

	p = cfg_newStackItem();

	chkHeap
	if(C(_stk)) {
		switch(p->C_type = S(type)) {
		case CFG_OPT:	/* we need the current information about the option */
			p->C_ch = C(ch);
			p->C_longname = C(longname);
			p->C_arg = C(arg);
			p->C_bool = C(bool);
			p->C_glbBool = C(_glbBool);
			break;
		/* case CFG_ARG:
			is contained within S(buf) and is automatically saved */
		/* case CFG_NONE:
			case CFG_EOF:
				these state don't have any information to be preserved */
		default:
			break;
		}
	}

	p->C_nxt = C(_stk);
	C(_stk) = p;

	chkHeap
	DBG_EXIT
}
