/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.security;

import amazon.fws.clicommando.exceptions.InternalErrorException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public final class SelfSignedSSLSupport {
    public static void setHttpsTrustManager(boolean trustAll) {
        SSLContext sslContext;
        TrustManager[] trustManager = null;
        if (trustAll) {
            trustManager = new TrustManager[]{new TrustAllTrustManager()};
        }
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManager, new SecureRandom());
        }
        catch (GeneralSecurityException gse) {
            throw new InternalErrorException("In creating trust all manager", gse);
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        EasySSLProtocolSocketFactory easy = new EasySSLProtocolSocketFactory();
        Protocol protocol = new Protocol("https", (ProtocolSocketFactory)easy, 443);
        Protocol.registerProtocol((String)"https", (Protocol)protocol);
    }

    public static class TrustAllTrustManager
    implements X509TrustManager {
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

