static char rcsid[] = "$Id: method.c 224642 2021-08-25 22:03:29Z twu $";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "method.h"

#include <stdlib.h>

char *
Method_string (Method_T method) {
  /* May want to turn on NO_COMPARE in substring.c also */
  switch (method) {
  case TR: return "tr";
  case KMER_EXACT: return "exact";
  case KMER_APPROX: return "approx";
  case EXT: return "ext";
  case SEGMENT1: return "seg1";
  case SEGMENT2: return "seg2";
  case DISTANT_RNA: return "dist-rna";
  case DISTANT_DNA: return "dist-dna";
  case TERMINAL: return "term";
  default: abort();
  }
}


void
Method_samprint (Filestring_T fp, Method_T method) {
  switch (method) {
  case TR: FPRINTF(fp,"\tXG:Z:tr"); break;
  case KMER_EXACT: FPRINTF(fp,"\tXG:Z:exact"); break;
  case KMER_APPROX: FPRINTF(fp,"\tXG:Z:approx"); break;
  case EXT: FPRINTF(fp,"\tXG:Z:ext"); break;
  case SEGMENT1: FPRINTF(fp,"\tXG:Z:seg1"); break;
  case SEGMENT2: FPRINTF(fp,"\tXG:Z:seg2"); break;
  case DISTANT_RNA: FPRINTF(fp,"\tXG:Z:dist-rna"); break;
  case DISTANT_DNA: FPRINTF(fp,"\tXG:Z:dist-dna"); break;
  case TERMINAL: FPRINTF(fp,"\tXG:Z:term"); break;
  default: abort();
  }

  return;
}

void
Method_print (Filestring_T fp, Method_T method) {
  switch (method) {
  case TR: FPRINTF(fp,"\tmethod:tr"); break;
  case KMER_EXACT: FPRINTF(fp,"\tmethod:exact"); break;
  case KMER_APPROX: FPRINTF(fp,"\tmethod:approx"); break;
  case EXT: FPRINTF(fp,"\tmethod:ext"); break;
  case SEGMENT1: FPRINTF(fp,"\tmethod:seg1"); break;
  case SEGMENT2: FPRINTF(fp,"\tmethod:seg2"); break;
  case DISTANT_RNA: FPRINTF(fp,"\tmethod:dist-rna"); break;
  case DISTANT_DNA: FPRINTF(fp,"\tmethod:dist-dna"); break;
  case TERMINAL: FPRINTF(fp,"\tmethod:term"); break;
  default: abort();
  }

  return;
}

