/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Fail;
import org.fest.assertions.PrimitiveAssert;

public class BooleanAssert
extends PrimitiveAssert {
    private final boolean actual;

    protected BooleanAssert(boolean actual) {
        this.actual = actual;
    }

    public BooleanAssert as(String description) {
        this.description(description);
        return this;
    }

    public BooleanAssert describedAs(String description) {
        return this.as(description);
    }

    public BooleanAssert as(Description description) {
        this.description(description);
        return this;
    }

    public BooleanAssert describedAs(Description description) {
        return this.as(description);
    }

    public void isTrue() {
        this.isEqualTo(true);
    }

    public void isFalse() {
        this.isEqualTo(false);
    }

    public BooleanAssert isEqualTo(boolean expected) {
        if (this.actual == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public BooleanAssert isNotEqualTo(boolean other) {
        Fail.failIfEqual(this.customErrorMessage(), this.rawDescription(), this.actual, other);
        return this;
    }

    public BooleanAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

