/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.bcf2.BCF2Utils;
import htsjdk.variant.bcf2.BCFVersion;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.BCF2Encoder;
import htsjdk.variant.variantcontext.writer.BCF2FieldWriter;
import htsjdk.variant.variantcontext.writer.BCF2FieldWriterManager;
import htsjdk.variant.variantcontext.writer.IndexingVariantContextWriter;
import htsjdk.variant.variantcontext.writer.VCFWriter;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class BCF2Writer
extends IndexingVariantContextWriter {
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 1;
    private static final boolean ALLOW_MISSING_CONTIG_LINES = false;
    private final OutputStream outputStream;
    private VCFHeader header;
    private final Map<String, Integer> contigDictionary = new HashMap<String, Integer>();
    private final Map<String, Integer> stringDictionaryMap = new LinkedHashMap<String, Integer>();
    private final boolean doNotWriteGenotypes;
    private String[] sampleNames = null;
    private final BCF2Encoder encoder = new BCF2Encoder();
    final BCF2FieldWriterManager fieldManager = new BCF2FieldWriterManager();
    private VCFHeader lastVCFHeaderOfUnparsedGenotypes = null;
    private boolean canPassOnUnparsedGenotypeDataForLastVCFHeader = false;

    public BCF2Writer(File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes) {
        super(BCF2Writer.writerName(location, output), location, output, refDict, enableOnTheFlyIndexing);
        this.outputStream = this.getOutputStream();
        this.doNotWriteGenotypes = doNotWriteGenotypes;
    }

    public BCF2Writer(File location, OutputStream output, SAMSequenceDictionary refDict, IndexCreator indexCreator, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes) {
        super(BCF2Writer.writerName(location, output), location, output, refDict, enableOnTheFlyIndexing, indexCreator);
        this.outputStream = this.getOutputStream();
        this.doNotWriteGenotypes = doNotWriteGenotypes;
    }

    @Override
    public void writeHeader(VCFHeader header) {
        if ((header = new VCFHeader(header.getMetaDataInSortedOrder(), header.getGenotypeSamples())).getContigLines().isEmpty()) {
            throw new IllegalStateException("Cannot write BCF2 file with missing contig lines");
        }
        this.createContigDictionary(header.getContigLines());
        ArrayList<String> dict = BCF2Utils.makeDictionary(header);
        for (int i = 0; i < dict.size(); ++i) {
            this.stringDictionaryMap.put(dict.get(i), i);
        }
        this.sampleNames = header.getGenotypeSamples().toArray(new String[header.getNGenotypeSamples()]);
        this.fieldManager.setup(header, this.encoder, this.stringDictionaryMap);
        try {
            ByteArrayOutputStream capture = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(capture);
            this.header = VCFWriter.writeHeader(header, writer, this.doNotWriteGenotypes, VCFWriter.getVersionLine(), "BCF2 stream");
            writer.append('\u0000');
            writer.close();
            byte[] headerBytes = capture.toByteArray();
            new BCFVersion(2, 1).write(this.outputStream);
            BCF2Type.INT32.write(headerBytes.length, this.outputStream);
            this.outputStream.write(headerBytes);
        }
        catch (IOException e) {
            throw new RuntimeIOException("BCF2 stream: Got IOException while trying to write BCF2 header", e);
        }
    }

    @Override
    public void add(VariantContext vc) {
        if (this.doNotWriteGenotypes) {
            vc = new VariantContextBuilder(vc).noGenotypes().make();
        }
        vc = vc.fullyDecode(this.header, false);
        super.add(vc);
        try {
            byte[] infoBlock = this.buildSitesData(vc);
            byte[] genotypesBlock = this.buildSamplesData(vc);
            this.writeBlock(infoBlock, genotypesBlock);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error writing record to BCF2 file: " + vc.toString(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Failed to flush BCF2 file");
        }
        super.close();
    }

    private byte[] buildSitesData(VariantContext vc) throws IOException {
        int contigIndex = this.contigDictionary.get(vc.getChr());
        if (contigIndex == -1) {
            throw new IllegalStateException(String.format("Contig %s not found in sequence dictionary from reference", vc.getChr()));
        }
        this.encoder.encodeRawValue(contigIndex, BCF2Type.INT32);
        this.encoder.encodeRawValue(vc.getStart() - 1, BCF2Type.INT32);
        this.encoder.encodeRawValue(vc.getEnd() - vc.getStart() + 1, BCF2Type.INT32);
        if (vc.hasLog10PError()) {
            this.encoder.encodeRawFloat((float)vc.getPhredScaledQual());
        } else {
            this.encoder.encodeRawMissingValue(BCF2Type.FLOAT);
        }
        int nAlleles = vc.getNAlleles();
        int nInfo = vc.getAttributes().size();
        int nGenotypeFormatFields = this.getNGenotypeFormatFields(vc);
        int nSamples = this.header.getNGenotypeSamples();
        this.encoder.encodeRawInt(nAlleles << 16 | nInfo & 0xFFFF, BCF2Type.INT32);
        this.encoder.encodeRawInt(nGenotypeFormatFields << 24 | nSamples & 0xFFFFF, BCF2Type.INT32);
        this.buildID(vc);
        this.buildAlleles(vc);
        this.buildFilter(vc);
        this.buildInfo(vc);
        return this.encoder.getRecordBytes();
    }

    private boolean canSafelyWriteRawGenotypesBytes(BCF2Codec.LazyData lazyData) {
        if (lazyData.header != this.lastVCFHeaderOfUnparsedGenotypes) {
            this.canPassOnUnparsedGenotypeDataForLastVCFHeader = BCF2Utils.headerLinesAreOrderedConsistently(this.header, lazyData.header);
            this.lastVCFHeaderOfUnparsedGenotypes = lazyData.header;
        }
        return this.canPassOnUnparsedGenotypeDataForLastVCFHeader;
    }

    private BCF2Codec.LazyData getLazyData(VariantContext vc) {
        if (vc.getGenotypes().isLazyWithData()) {
            LazyGenotypesContext lgc = (LazyGenotypesContext)vc.getGenotypes();
            if (lgc.getUnparsedGenotypeData() instanceof BCF2Codec.LazyData && this.canSafelyWriteRawGenotypesBytes((BCF2Codec.LazyData)lgc.getUnparsedGenotypeData())) {
                return (BCF2Codec.LazyData)lgc.getUnparsedGenotypeData();
            }
            lgc.decode();
        }
        return null;
    }

    private int getNGenotypeFormatFields(VariantContext vc) {
        BCF2Codec.LazyData lazyData = this.getLazyData(vc);
        return lazyData != null ? lazyData.nGenotypeFields : vc.calcVCFGenotypeKeys(this.header).size();
    }

    private void buildID(VariantContext vc) throws IOException {
        this.encoder.encodeTypedString(vc.getID());
    }

    private void buildAlleles(VariantContext vc) throws IOException {
        for (Allele allele : vc.getAlleles()) {
            byte[] s = allele.getDisplayBases();
            if (s == null) {
                throw new IllegalStateException("BUG: BCF2Writer encountered null padded allele" + allele);
            }
            this.encoder.encodeTypedString(s);
        }
    }

    private void buildFilter(VariantContext vc) throws IOException {
        if (vc.isFiltered()) {
            this.encodeStringsByRef(vc.getFilters());
        } else if (vc.filtersWereApplied()) {
            this.encodeStringsByRef(Collections.singleton("PASS"));
        } else {
            this.encoder.encodeTypedMissing(BCF2Type.INT8);
        }
    }

    private void buildInfo(VariantContext vc) throws IOException {
        for (Map.Entry<String, Object> infoFieldEntry : vc.getAttributes().entrySet()) {
            String field = infoFieldEntry.getKey();
            BCF2FieldWriter.SiteWriter writer = this.fieldManager.getSiteFieldWriter(field);
            if (writer == null) {
                this.errorUnexpectedFieldToWrite(vc, field, "INFO");
            }
            writer.start(this.encoder, vc);
            writer.site(this.encoder, vc);
            writer.done(this.encoder, vc);
        }
    }

    private byte[] buildSamplesData(VariantContext vc) throws IOException {
        BCF2Codec.LazyData lazyData = this.getLazyData(vc);
        if (lazyData != null) {
            return lazyData.bytes;
        }
        List<String> genotypeFields = vc.calcVCFGenotypeKeys(this.header);
        for (String field : genotypeFields) {
            BCF2FieldWriter.GenotypesWriter writer = this.fieldManager.getGenotypeFieldWriter(field);
            if (writer == null) {
                this.errorUnexpectedFieldToWrite(vc, field, "FORMAT");
            }
            assert (writer != null);
            writer.start(this.encoder, vc);
            for (String name : this.sampleNames) {
                Genotype g = vc.getGenotype(name);
                if (g == null) {
                    g = GenotypeBuilder.createMissing(name, writer.nValuesPerGenotype);
                }
                writer.addGenotype(this.encoder, vc, g);
            }
            writer.done(this.encoder, vc);
        }
        return this.encoder.getRecordBytes();
    }

    private void errorUnexpectedFieldToWrite(VariantContext vc, String field, String fieldType) {
        throw new IllegalStateException("Found field " + field + " in the " + fieldType + " fields of VariantContext at " + vc.getChr() + ":" + vc.getStart() + " from " + vc.getSource() + " but this hasn't been defined in the VCFHeader");
    }

    private void writeBlock(byte[] infoBlock, byte[] genotypesBlock) throws IOException {
        BCF2Type.INT32.write(infoBlock.length, this.outputStream);
        BCF2Type.INT32.write(genotypesBlock.length, this.outputStream);
        this.outputStream.write(infoBlock);
        this.outputStream.write(genotypesBlock);
    }

    private BCF2Type encodeStringsByRef(Collection<String> strings) throws IOException {
        ArrayList<Integer> offsets = new ArrayList<Integer>(strings.size());
        for (String string : strings) {
            Integer got = this.stringDictionaryMap.get(string);
            if (got == null) {
                throw new IllegalStateException("Format error: could not find string " + string + " in header as required by BCF");
            }
            int offset = got;
            offsets.add(offset);
        }
        BCF2Type type = BCF2Utils.determineIntegerType(offsets);
        this.encoder.encodeTyped(offsets, type);
        return type;
    }

    private void createContigDictionary(Collection<VCFContigHeaderLine> contigLines) {
        int offset = 0;
        for (VCFContigHeaderLine contig : contigLines) {
            this.contigDictionary.put(contig.getID(), offset++);
        }
    }
}

