/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import org.fest.swing.annotation.RunsInCurrentThread;

class ContainerFocusOwnerFinder {
    ContainerFocusOwnerFinder() {
    }

    @RunsInCurrentThread
    Component focusOwnerOf(Container c) {
        if (!(c instanceof Window)) {
            return null;
        }
        return this.focusOwnerOf((Window)c);
    }

    @RunsInCurrentThread
    private Component focusOwnerOf(Window w) {
        if (!w.isShowing()) {
            return null;
        }
        Component focus = w.getFocusOwner();
        if (focus != null) {
            return focus;
        }
        for (Window o : w.getOwnedWindows()) {
            focus = o.getFocusOwner();
            if (focus == null) continue;
            return focus;
        }
        return null;
    }
}

