/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.distribution.ExponentialDistribution;
import org.apache.commons.math.distribution.ExponentialDistributionImpl;
import org.broadinstitute.gatk.engine.GenomeAnalysisEngine;
import org.broadinstitute.gatk.utils.LRUCache;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class MathUtils {
    public static final double LOG10_P_OF_ZERO = -1000000.0;
    public static final double FAIR_BINOMIAL_PROB_LOG10_0_5 = Math.log10(0.5);
    public static final double LOG_ONE_HALF = -Math.log10(2.0);
    public static final double LOG_ONE_THIRD = -Math.log10(3.0);
    private static final double NATURAL_LOG_OF_TEN = Math.log(10.0);
    private static final double SQUARE_ROOT_OF_TWO_TIMES_PI = Math.sqrt(Math.PI * 2);
    private static final Map<Long, Double> BINOMIAL_CUMULATIVE_PROBABILITY_MEMOIZATION_CACHE = Collections.synchronizedMap(new LRUCache(10000));
    private static final double LOG1MEXP_THRESHOLD = Math.log(0.5);
    private static final double LN_10 = Math.log(10.0);
    private static final double zero = 0.0;
    private static final double one = 1.0;
    private static final double half = 0.5;
    private static final double a0 = 0.07721566490153287;
    private static final double a1 = 0.3224670334241136;
    private static final double a2 = 0.06735230105312927;
    private static final double a3 = 0.020580808432516733;
    private static final double a4 = 0.007385550860814029;
    private static final double a5 = 0.0028905138367341563;
    private static final double a6 = 0.0011927076318336207;
    private static final double a7 = 5.100697921535113E-4;
    private static final double a8 = 2.2086279071390839E-4;
    private static final double a9 = 1.0801156724758394E-4;
    private static final double a10 = 2.5214456545125733E-5;
    private static final double a11 = 4.4864094961891516E-5;
    private static final double tc = 1.4616321449683622;
    private static final double tf = -0.12148629053584961;
    private static final double tt = -3.638676997039505E-18;
    private static final double t0 = 0.48383612272381005;
    private static final double t1 = -0.1475877229945939;
    private static final double t2 = 0.06462494023913339;
    private static final double t3 = -0.032788541075985965;
    private static final double t4 = 0.01797067508118204;
    private static final double t5 = -0.010314224129834144;
    private static final double t6 = 0.006100538702462913;
    private static final double t7 = -0.0036845201678113826;
    private static final double t8 = 0.0022596478090061247;
    private static final double t9 = -0.0014034646998923284;
    private static final double t10 = 8.81081882437654E-4;
    private static final double t11 = -5.385953053567405E-4;
    private static final double t12 = 3.1563207090362595E-4;
    private static final double t13 = -3.1275416837512086E-4;
    private static final double t14 = 3.355291926355191E-4;
    private static final double u0 = -0.07721566490153287;
    private static final double u1 = 0.6328270640250934;
    private static final double u2 = 1.4549225013723477;
    private static final double u3 = 0.9777175279633727;
    private static final double u4 = 0.22896372806469245;
    private static final double u5 = 0.013381091853678766;
    private static final double v1 = 2.4559779371304113;
    private static final double v2 = 2.128489763798934;
    private static final double v3 = 0.7692851504566728;
    private static final double v4 = 0.10422264559336913;
    private static final double v5 = 0.003217092422824239;
    private static final double s0 = -0.07721566490153287;
    private static final double s1 = 0.21498241596060885;
    private static final double s2 = 0.325778796408931;
    private static final double s3 = 0.14635047265246445;
    private static final double s4 = 0.02664227030336386;
    private static final double s5 = 0.0018402845140733772;
    private static final double s6 = 3.194753265841009E-5;
    private static final double r1 = 1.3920053346762105;
    private static final double r2 = 0.7219355475671381;
    private static final double r3 = 0.17193386563280308;
    private static final double r4 = 0.01864591917156529;
    private static final double r5 = 7.779424963818936E-4;
    private static final double r6 = 7.326684307446256E-6;
    private static final double w0 = 0.4189385332046727;
    private static final double w1 = 0.08333333333333297;
    private static final double w2 = -0.0027777777772877554;
    private static final double w3 = 7.936505586430196E-4;
    private static final double w4 = -5.9518755745034E-4;
    private static final double w5 = 8.363399189962821E-4;
    private static final double w6 = -0.0016309293409657527;

    private MathUtils() {
    }

    public static int randomIntegerInRange(int min, int max) {
        return GenomeAnalysisEngine.getRandomGenerator().nextInt(max - min + 1) + min;
    }

    public static int fastRound(double d) {
        return d > 0.0 ? (int)(d + 0.5) : (int)(d - 0.5);
    }

    public static double approximateLog10SumLog10(double[] vals) {
        return MathUtils.approximateLog10SumLog10(vals, vals.length);
    }

    public static double approximateLog10SumLog10(double[] vals, int endIndex) {
        int maxElementIndex = MathUtils.maxElementIndex(vals, endIndex);
        double approxSum = vals[maxElementIndex];
        for (int i = 0; i < endIndex; ++i) {
            double diff;
            if (i == maxElementIndex || vals[i] == Double.NEGATIVE_INFINITY || !((diff = approxSum - vals[i]) < 8.0)) continue;
            approxSum += JacobianLogTable.get(diff);
        }
        return approxSum;
    }

    public static double approximateLog10SumLog10(double a, double b, double c) {
        return MathUtils.approximateLog10SumLog10(a, MathUtils.approximateLog10SumLog10(b, c));
    }

    public static double approximateLog10SumLog10(double small, double big) {
        if (small > big) {
            double t = big;
            big = small;
            small = t;
        }
        if (small == Double.NEGATIVE_INFINITY || big == Double.NEGATIVE_INFINITY) {
            return big;
        }
        double diff = big - small;
        if (diff >= 8.0) {
            return big;
        }
        return big + JacobianLogTable.get(diff);
    }

    public static double sum(double[] values) {
        double s = 0.0;
        for (double v : values) {
            s += v;
        }
        return s;
    }

    public static long sum(int[] x) {
        long total = 0L;
        for (int v : x) {
            total += (long)v;
        }
        return total;
    }

    public static int sum(byte[] x) {
        int total = 0;
        for (byte v : x) {
            total += v;
        }
        return total;
    }

    public static double percentage(int x, int base) {
        return base > 0 ? (double)x / (double)base * 100.0 : 0.0;
    }

    public static double ratio(int num, int denom) {
        if (denom > 0) {
            return (double)num / (double)denom;
        }
        if (num == 0 && denom == 0) {
            return 0.0;
        }
        throw new ReviewedGATKException(String.format("The denominator of a ratio cannot be zero or less than zero: %d/%d", num, denom));
    }

    public static double ratio(long num, long denom) {
        if (denom > 0L) {
            return (double)num / (double)denom;
        }
        if (num == 0L && denom == 0L) {
            return 0.0;
        }
        throw new ReviewedGATKException(String.format("The denominator of a ratio cannot be zero or less than zero: %d/%d", num, denom));
    }

    public static double[] toLog10(double[] prRealSpace) {
        double[] log10s = new double[prRealSpace.length];
        for (int i = 0; i < prRealSpace.length; ++i) {
            log10s[i] = Math.log10(prRealSpace[i]);
        }
        return log10s;
    }

    public static double log10sumLog10(double[] log10p, int start) {
        return MathUtils.log10sumLog10(log10p, start, log10p.length);
    }

    public static double log10sumLog10(double[] log10p, int start, int finish) {
        int maxElementIndex = MathUtils.maxElementIndex(log10p, start, finish);
        double maxValue = log10p[maxElementIndex];
        if (maxValue == Double.NEGATIVE_INFINITY) {
            return maxValue;
        }
        double sum = 1.0;
        for (int i = start; i < finish; ++i) {
            double curVal = log10p[i];
            double scaled_val = curVal - maxValue;
            if (i == maxElementIndex || curVal == Double.NEGATIVE_INFINITY) continue;
            sum += Math.pow(10.0, scaled_val);
        }
        if (Double.isNaN(sum) || sum == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("log10p: Values must be non-infinite and non-NAN");
        }
        return maxValue + (sum != 1.0 ? Math.log10(sum) : 0.0);
    }

    public static double sumLog10(double[] log10values) {
        return Math.pow(10.0, MathUtils.log10sumLog10(log10values));
    }

    public static double log10sumLog10(double[] log10values) {
        return MathUtils.log10sumLog10(log10values, 0);
    }

    public static boolean wellFormedDouble(double val) {
        return !Double.isInfinite(val) && !Double.isNaN(val);
    }

    public static double bound(double value, double minBoundary, double maxBoundary) {
        return Math.max(Math.min(value, maxBoundary), minBoundary);
    }

    public static boolean isBounded(double val, double lower, double upper) {
        return val >= lower && val <= upper;
    }

    public static boolean isPositive(double val) {
        return !MathUtils.isNegativeOrZero(val);
    }

    public static boolean isPositiveOrZero(double val) {
        return MathUtils.isBounded(val, 0.0, Double.POSITIVE_INFINITY);
    }

    public static boolean isNegativeOrZero(double val) {
        return MathUtils.isBounded(val, Double.NEGATIVE_INFINITY, 0.0);
    }

    public static boolean isNegative(double val) {
        return !MathUtils.isPositiveOrZero(val);
    }

    public static byte compareDoubles(double a, double b) {
        return MathUtils.compareDoubles(a, b, 1.0E-6);
    }

    public static byte compareDoubles(double a, double b, double epsilon) {
        if (Math.abs(a - b) < epsilon) {
            return 0;
        }
        if (a > b) {
            return -1;
        }
        return 1;
    }

    public static double normalDistribution(double mean, double sd, double x) {
        if (sd < 0.0) {
            throw new IllegalArgumentException("sd: Standard deviation of normal must be >0");
        }
        if (!(MathUtils.wellFormedDouble(mean) && MathUtils.wellFormedDouble(sd) && MathUtils.wellFormedDouble(x))) {
            throw new IllegalArgumentException("mean, sd, or, x : Normal parameters must be well formatted (non-INF, non-NAN)");
        }
        double a = 1.0 / (sd * Math.sqrt(Math.PI * 2));
        double b = Math.exp(-1.0 * (Math.pow(x - mean, 2.0) / (2.0 * sd * sd)));
        return a * b;
    }

    public static double normalDistributionLog10(double mean, double sd, double x) {
        if (sd < 0.0) {
            throw new IllegalArgumentException("sd: Standard deviation of normal must be >0");
        }
        if (!(MathUtils.wellFormedDouble(mean) && MathUtils.wellFormedDouble(sd) && MathUtils.wellFormedDouble(x))) {
            throw new IllegalArgumentException("mean, sd, or, x : Normal parameters must be well formatted (non-INF, non-NAN)");
        }
        double a = -1.0 * Math.log10(sd * SQUARE_ROOT_OF_TWO_TIMES_PI);
        double b = -1.0 * (MathUtils.square(x - mean) / (2.0 * MathUtils.square(sd))) / NATURAL_LOG_OF_TEN;
        return a + b;
    }

    public static double square(double x) {
        return x * x;
    }

    public static double binomialCoefficient(int n, int k) {
        return Math.pow(10.0, MathUtils.log10BinomialCoefficient(n, k));
    }

    public static double log10BinomialCoefficient(int n, int k) {
        if (n < 0) {
            throw new IllegalArgumentException("n: Must have non-negative number of trials");
        }
        if (k > n || k < 0) {
            throw new IllegalArgumentException("k: Must have non-negative number of successes, and no more successes than number of trials");
        }
        return MathUtils.log10Factorial(n) - MathUtils.log10Factorial(k) - MathUtils.log10Factorial(n - k);
    }

    public static double binomialProbability(int n, int k, double p) {
        return Math.pow(10.0, MathUtils.log10BinomialProbability(n, k, Math.log10(p)));
    }

    public static double log10BinomialProbability(int n, int k, double log10p) {
        if (log10p > 1.0E-18) {
            throw new IllegalArgumentException("log10p: Log-probability must be 0 or less");
        }
        double log10OneMinusP = Math.log10(1.0 - Math.pow(10.0, log10p));
        return MathUtils.log10BinomialCoefficient(n, k) + log10p * (double)k + log10OneMinusP * (double)(n - k);
    }

    public static double binomialProbability(int n, int k) {
        return Math.pow(10.0, MathUtils.log10BinomialProbability(n, k));
    }

    public static double log10BinomialProbability(int n, int k) {
        return MathUtils.log10BinomialCoefficient(n, k) + (double)n * FAIR_BINOMIAL_PROB_LOG10_0_5;
    }

    static Long fastGenerateUniqueHashFromThreeIntegers(int one, int two, int three) {
        if (one < 0 || two < 0 || three < 0 || Short.MAX_VALUE < one || Short.MAX_VALUE < two || Short.MAX_VALUE < three) {
            return null;
        }
        long result = 0L;
        result += (long)((short)one);
        result <<= 16;
        result += (long)((short)two);
        result <<= 16;
        return result += (long)((short)three);
    }

    public static double binomialCumulativeProbability(int n, int k_start, int k_end) {
        double result;
        if (k_end > n) {
            throw new IllegalArgumentException(String.format("Value for k_end (%d) is greater than n (%d)", k_end, n));
        }
        Long memoizationKey = MathUtils.fastGenerateUniqueHashFromThreeIntegers(n, k_start, k_end);
        Double memoizationCacheResult = memoizationKey != null ? BINOMIAL_CUMULATIVE_PROBABILITY_MEMOIZATION_CACHE.get(memoizationKey) : null;
        if (memoizationCacheResult != null) {
            result = memoizationCacheResult;
        } else {
            double cumProb = 0.0;
            BigDecimal probCache = BigDecimal.ZERO;
            for (int hits = k_start; hits <= k_end; ++hits) {
                double prevProb = cumProb;
                double probability = MathUtils.binomialProbability(n, hits);
                cumProb += probability;
                if (!(probability > 0.0) || !(cumProb - prevProb < probability / 2.0)) continue;
                probCache = probCache.add(new BigDecimal(prevProb));
                cumProb = 0.0;
                --hits;
            }
            result = probCache.add(new BigDecimal(cumProb)).doubleValue();
            if (memoizationKey != null) {
                BINOMIAL_CUMULATIVE_PROBABILITY_MEMOIZATION_CACHE.put(memoizationKey, result);
            }
        }
        return result;
    }

    public static double log1mexp(double a) {
        if (a > 0.0) {
            return Double.NaN;
        }
        if (a == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return a < LOG1MEXP_THRESHOLD ? Math.log1p(-Math.exp(a)) : Math.log(-Math.expm1(a));
    }

    public static double log10OneMinusPow10(double a) {
        if (a > 0.0) {
            return Double.NaN;
        }
        if (a == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double b = a * LN_10;
        return MathUtils.log1mexp(b) / LN_10;
    }

    public static double log10MultinomialCoefficient(int n, int[] k) {
        if (n < 0) {
            throw new IllegalArgumentException("n: Must have non-negative number of trials");
        }
        double denominator = 0.0;
        int sum = 0;
        for (int x : k) {
            if (x < 0) {
                throw new IllegalArgumentException("x element of k: Must have non-negative observations of group");
            }
            if (x > n) {
                throw new IllegalArgumentException("x element of k, n: Group observations must be bounded by k");
            }
            denominator += MathUtils.log10Factorial(x);
            sum += x;
        }
        if (sum != n) {
            throw new IllegalArgumentException("k and n: Sum of observations in multinomial must sum to total number of trials");
        }
        return MathUtils.log10Factorial(n) - denominator;
    }

    public static double log10MultinomialProbability(int n, int[] k, double[] log10p) {
        if (log10p.length != k.length) {
            throw new IllegalArgumentException("p and k: Array of log10 probabilities must have the same size as the array of number of sucesses: " + log10p.length + ", " + k.length);
        }
        double log10Prod = 0.0;
        for (int i = 0; i < log10p.length; ++i) {
            if (log10p[i] > 1.0E-18) {
                throw new IllegalArgumentException("log10p: Log-probability must be <= 0");
            }
            log10Prod += log10p[i] * (double)k[i];
        }
        return MathUtils.log10MultinomialCoefficient(n, k) + log10Prod;
    }

    public static double multinomialCoefficient(int[] k) {
        int n = 0;
        for (int xi : k) {
            n += xi;
        }
        return Math.pow(10.0, MathUtils.log10MultinomialCoefficient(n, k));
    }

    public static double multinomialProbability(int[] k, double[] p) {
        if (p.length != k.length) {
            throw new IllegalArgumentException("p and k: Array of log10 probabilities must have the same size as the array of number of sucesses: " + p.length + ", " + k.length);
        }
        int n = 0;
        double[] log10P = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            log10P[i] = Math.log10(p[i]);
            n += k[i];
        }
        return Math.pow(10.0, MathUtils.log10MultinomialProbability(n, k, log10P));
    }

    public static double rms(byte[] x) {
        if (x.length == 0) {
            return 0.0;
        }
        double rms = 0.0;
        for (byte i : x) {
            rms += (double)(i * i);
        }
        return Math.sqrt(rms /= (double)x.length);
    }

    public static double rms(int[] x) {
        if (x.length == 0) {
            return 0.0;
        }
        double rms = 0.0;
        for (int i : x) {
            rms += (double)(i * i);
        }
        return Math.sqrt(rms /= (double)x.length);
    }

    public static double rms(Double[] x) {
        if (x.length == 0) {
            return 0.0;
        }
        double rms = 0.0;
        for (Double i : x) {
            rms += i * i;
        }
        return Math.sqrt(rms /= (double)x.length);
    }

    public static double rms(Collection<Integer> l) {
        if (l.size() == 0) {
            return 0.0;
        }
        double rms = 0.0;
        for (int i : l) {
            rms += (double)(i * i);
        }
        return Math.sqrt(rms /= (double)l.size());
    }

    public static double distanceSquared(double[] x, double[] y) {
        double dist = 0.0;
        for (int iii = 0; iii < x.length; ++iii) {
            dist += (x[iii] - y[iii]) * (x[iii] - y[iii]);
        }
        return dist;
    }

    public static double round(double num, int digits) {
        double result = num * Math.pow(10.0, digits);
        result = Math.round(result);
        return result /= Math.pow(10.0, digits);
    }

    public static double[] normalizeFromLog10(double[] array, boolean takeLog10OfOutput) {
        return MathUtils.normalizeFromLog10(array, takeLog10OfOutput, false);
    }

    public static double[] normalizeFromLog10(double[] array, boolean takeLog10OfOutput, boolean keepInLogSpace) {
        int i;
        double maxValue = MathUtils.arrayMax(array);
        if (keepInLogSpace) {
            int i2 = 0;
            while (i2 < array.length) {
                int n = i2++;
                array[n] = array[n] - maxValue;
            }
            return array;
        }
        double[] normalized = new double[array.length];
        for (int i3 = 0; i3 < array.length; ++i3) {
            normalized[i3] = Math.pow(10.0, array[i3] - maxValue);
        }
        double sum = 0.0;
        for (i = 0; i < array.length; ++i) {
            sum += normalized[i];
        }
        for (i = 0; i < array.length; ++i) {
            double x = normalized[i] / sum;
            if (takeLog10OfOutput && ((x = Math.log10(x)) < -1000000.0 || Double.isInfinite(x))) {
                x = array[i] - maxValue;
            }
            normalized[i] = x;
        }
        return normalized;
    }

    public static double[] normalizeFromLog10(double[] array) {
        return MathUtils.normalizeFromLog10(array, false);
    }

    @Requires(value={"array != null"})
    @Ensures(value={"result != null"})
    public static double[] normalizeFromRealSpace(double[] array) {
        if (array.length == 0) {
            return array;
        }
        double sum = MathUtils.sum(array);
        double[] normalized = new double[array.length];
        if (sum < 0.0) {
            throw new IllegalArgumentException("Values in probability array sum to a negative number " + sum);
        }
        for (int i = 0; i < array.length; ++i) {
            normalized[i] = array[i] / sum;
        }
        return normalized;
    }

    public static int maxElementIndex(double[] array) {
        return MathUtils.maxElementIndex(array, array.length);
    }

    public static int maxElementIndex(double[] array, int start, int endIndex) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        if (start > endIndex) {
            throw new IllegalArgumentException("Start cannot be after end.");
        }
        int maxI = start;
        for (int i = start + 1; i < endIndex; ++i) {
            if (!(array[i] > array[maxI])) continue;
            maxI = i;
        }
        return maxI;
    }

    public static int maxElementIndex(double[] array, int endIndex) {
        return MathUtils.maxElementIndex(array, 0, endIndex);
    }

    public static int maxElementIndex(int[] array) {
        return MathUtils.maxElementIndex(array, array.length);
    }

    public static int maxElementIndex(byte[] array) {
        return MathUtils.maxElementIndex(array, array.length);
    }

    public static int maxElementIndex(int[] array, int endIndex) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int maxI = 0;
        for (int i = 1; i < endIndex; ++i) {
            if (array[i] <= array[maxI]) continue;
            maxI = i;
        }
        return maxI;
    }

    public static int maxElementIndex(byte[] array, int endIndex) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int maxI = 0;
        for (int i = 1; i < endIndex; ++i) {
            if (array[i] <= array[maxI]) continue;
            maxI = i;
        }
        return maxI;
    }

    public static int arrayMax(int[] array) {
        return array[MathUtils.maxElementIndex(array)];
    }

    public static double arrayMax(double[] array) {
        return array[MathUtils.maxElementIndex(array)];
    }

    public static double arrayMax(double[] array, int endIndex) {
        return array[MathUtils.maxElementIndex(array, endIndex)];
    }

    public static double arrayMin(double[] array) {
        return array[MathUtils.minElementIndex(array)];
    }

    public static int arrayMin(int[] array) {
        return array[MathUtils.minElementIndex(array)];
    }

    public static byte arrayMin(byte[] array) {
        return array[MathUtils.minElementIndex(array)];
    }

    public static int arrayMin(List<Integer> array) {
        if (array == null || array.isEmpty()) {
            throw new IllegalArgumentException("Array must be non-null and non-empty");
        }
        int min = array.get(0);
        for (int i : array) {
            if (i >= min) continue;
            min = i;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T median(List<T> array) {
        if (array == null) {
            throw new IllegalArgumentException("Array must be non-null");
        }
        int size = array.size();
        if (size == 0) {
            throw new IllegalArgumentException("Array cannot have size 0");
        }
        if (size == 1) {
            return (T)((Comparable)array.get(0));
        }
        ArrayList<T> sorted = new ArrayList<T>(array);
        Collections.sort(sorted);
        return (T)((Comparable)sorted.get(size / 2));
    }

    public static int minElementIndex(double[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int minI = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < array[minI])) continue;
            minI = i;
        }
        return minI;
    }

    public static int minElementIndex(byte[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int minI = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[minI]) continue;
            minI = i;
        }
        return minI;
    }

    public static int minElementIndex(int[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int minI = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[minI]) continue;
            minI = i;
        }
        return minI;
    }

    public static int arrayMaxInt(List<Integer> array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        if (array.size() == 0) {
            throw new IllegalArgumentException("Array size cannot be 0!");
        }
        int m = array.get(0);
        for (int e : array) {
            m = Math.max(m, e);
        }
        return m;
    }

    public static int sum(List<Integer> list) {
        int sum = 0;
        for (Integer i : list) {
            sum += i.intValue();
        }
        return sum;
    }

    public static double average(List<Long> vals, int maxI) {
        long sum = 0L;
        int i = 0;
        for (long x : vals) {
            if (i > maxI) break;
            sum += x;
            ++i;
        }
        return 1.0 * (double)sum / (double)i;
    }

    public static double average(List<Long> vals) {
        return MathUtils.average(vals, vals.size());
    }

    public static int countOccurrences(char c, String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            count += s.charAt(i) == c ? 1 : 0;
        }
        return count;
    }

    public static <T> int countOccurrences(T x, List<T> l) {
        int count = 0;
        for (T y : l) {
            if (!x.equals(y)) continue;
            ++count;
        }
        return count;
    }

    public static int countOccurrences(byte element, byte[] array) {
        int count = 0;
        for (byte y : array) {
            if (element != y) continue;
            ++count;
        }
        return count;
    }

    public static int countOccurrences(boolean element, boolean[] array) {
        int count = 0;
        for (boolean b : array) {
            if (element != b) continue;
            ++count;
        }
        return count;
    }

    public static ArrayList<Integer> sampleIndicesWithReplacement(int n, int k) {
        ArrayList<Integer> chosen_balls = new ArrayList<Integer>(k);
        for (int i = 0; i < k; ++i) {
            chosen_balls.add(GenomeAnalysisEngine.getRandomGenerator().nextInt(n));
        }
        return chosen_balls;
    }

    public static ArrayList<Integer> sampleIndicesWithoutReplacement(int n, int k) {
        ArrayList<Integer> chosen_balls = new ArrayList<Integer>(k);
        for (int i = 0; i < n; ++i) {
            chosen_balls.add(i);
        }
        Collections.shuffle(chosen_balls, GenomeAnalysisEngine.getRandomGenerator());
        return new ArrayList<Integer>(chosen_balls.subList(0, k));
    }

    public static <T> ArrayList<T> sliceListByIndices(List<Integer> indices, List<T> list) {
        ArrayList<T> subset = new ArrayList<T>();
        for (int i : indices) {
            subset.add(list.get(i));
        }
        return subset;
    }

    public static double logDotProduct(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new ReviewedGATKException("BUG: Vectors of different lengths");
        }
        double[] tmpVec = new double[x.length];
        for (int k = 0; k < tmpVec.length; ++k) {
            tmpVec[k] = x[k] + y[k];
        }
        return MathUtils.log10sumLog10(tmpVec);
    }

    public static boolean goodLog10ProbVector(double[] vector, int expectedSize, boolean shouldSumToOne) {
        if (vector.length != expectedSize) {
            return false;
        }
        for (double pr : vector) {
            if (MathUtils.goodLog10Probability(pr)) continue;
            return false;
        }
        return !shouldSumToOne || MathUtils.compareDoubles(MathUtils.sumLog10(vector), 1.0, 1.0E-4) == 0;
    }

    public static boolean goodLog10Probability(double result) {
        return MathUtils.goodLog10Probability(result, true);
    }

    public static boolean goodLog10Probability(double result, boolean allowNegativeInfinity) {
        return result <= 0.0 && result != Double.POSITIVE_INFINITY && (allowNegativeInfinity || result != Double.NEGATIVE_INFINITY) && !Double.isNaN(result);
    }

    public static boolean goodProbability(double result) {
        return result >= 0.0 && result <= 1.0 && !Double.isInfinite(result) && !Double.isNaN(result);
    }

    public static double max(double x0, double x1, double x2) {
        double a = Math.max(x0, x1);
        return Math.max(a, x2);
    }

    public static double lnToLog10(double ln) {
        return ln * Math.log10(Math.E);
    }

    private static final int HI(double x) {
        return (int)(Double.doubleToLongBits(x) >> 32);
    }

    private static final int LO(double x) {
        return (int)Double.doubleToLongBits(x);
    }

    private static double lnGamma(double x) {
        double r;
        int hx = MathUtils.HI(x);
        int lx = MathUtils.LO(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x7FF00000) {
            return Double.POSITIVE_INFINITY;
        }
        if ((ix | lx) == 0 || hx < 0) {
            return Double.NaN;
        }
        if (ix < 999292928) {
            return -Math.log(x);
        }
        if ((ix - 0x3FF00000 | lx) == 0 || (ix - 0x40000000 | lx) == 0) {
            r = 0.0;
        } else if (ix < 0x40000000) {
            int i;
            double y;
            if (ix <= 1072483532) {
                r = -Math.log(x);
                if (ix >= 1072130372) {
                    y = 1.0 - x;
                    i = 0;
                } else if (ix >= 1070442081) {
                    y = x - 0.46163214496836225;
                    i = 1;
                } else {
                    y = x;
                    i = 2;
                }
            } else {
                r = 0.0;
                if (ix >= 1073460419) {
                    y = 2.0 - x;
                    i = 0;
                } else if (ix >= 1072936132) {
                    y = x - 1.4616321449683622;
                    i = 1;
                } else {
                    y = x - 1.0;
                    i = 2;
                }
            }
            switch (i) {
                case 0: {
                    double z = y * y;
                    double p1 = 0.07721566490153287 + z * (0.06735230105312927 + z * (0.007385550860814029 + z * (0.0011927076318336207 + z * (2.2086279071390839E-4 + z * 2.5214456545125733E-5))));
                    double p2 = z * (0.3224670334241136 + z * (0.020580808432516733 + z * (0.0028905138367341563 + z * (5.100697921535113E-4 + z * (1.0801156724758394E-4 + z * 4.4864094961891516E-5)))));
                    double p = y * p1 + p2;
                    r += p - 0.5 * y;
                    break;
                }
                case 1: {
                    double z = y * y;
                    double w = z * y;
                    double p1 = 0.48383612272381005 + w * (-0.032788541075985965 + w * (0.006100538702462913 + w * (-0.0014034646998923284 + w * 3.1563207090362595E-4)));
                    double p2 = -0.1475877229945939 + w * (0.01797067508118204 + w * (-0.0036845201678113826 + w * (8.81081882437654E-4 + w * -3.1275416837512086E-4)));
                    double p3 = 0.06462494023913339 + w * (-0.010314224129834144 + w * (0.0022596478090061247 + w * (-5.385953053567405E-4 + w * 3.355291926355191E-4)));
                    double p = z * p1 - (-3.638676997039505E-18 - w * (p2 + y * p3));
                    r += -0.12148629053584961 + p;
                    break;
                }
                case 2: {
                    double p1 = y * (-0.07721566490153287 + y * (0.6328270640250934 + y * (1.4549225013723477 + y * (0.9777175279633727 + y * (0.22896372806469245 + y * 0.013381091853678766)))));
                    double p2 = 1.0 + y * (2.4559779371304113 + y * (2.128489763798934 + y * (0.7692851504566728 + y * (0.10422264559336913 + y * 0.003217092422824239))));
                    r += -0.5 * y + p1 / p2;
                }
            }
        } else if (ix < 0x40200000) {
            int i = (int)x;
            double t = 0.0;
            double y = x - (double)i;
            double p = y * (-0.07721566490153287 + y * (0.21498241596060885 + y * (0.325778796408931 + y * (0.14635047265246445 + y * (0.02664227030336386 + y * (0.0018402845140733772 + y * 3.194753265841009E-5))))));
            double q = 1.0 + y * (1.3920053346762105 + y * (0.7219355475671381 + y * (0.17193386563280308 + y * (0.01864591917156529 + y * (7.779424963818936E-4 + y * 7.326684307446256E-6)))));
            r = 0.5 * y + p / q;
            double z = 1.0;
            switch (i) {
                case 7: {
                    z *= y + 6.0;
                }
                case 6: {
                    z *= y + 5.0;
                }
                case 5: {
                    z *= y + 4.0;
                }
                case 4: {
                    z *= y + 3.0;
                }
                case 3: {
                    r += Math.log(z *= y + 2.0);
                }
            }
        } else if (ix < 1133510656) {
            double t = Math.log(x);
            double z = 1.0 / x;
            double y = z * z;
            double w = 0.4189385332046727 + z * (0.08333333333333297 + y * (-0.0027777777772877554 + y * (7.936505586430196E-4 + y * (-5.9518755745034E-4 + y * (8.363399189962821E-4 + y * -0.0016309293409657527)))));
            r = (x - 0.5) * (t - 1.0) + w;
        } else {
            r = x * (Math.log(x) - 1.0);
        }
        return r;
    }

    public static double log10Gamma(double x) {
        return MathUtils.lnToLog10(MathUtils.lnGamma(x));
    }

    public static double factorial(int x) {
        return Math.round(Math.pow(10.0, MathUtils.log10Factorial(x)));
    }

    public static double log10Factorial(int x) {
        if (x >= Log10FactorialCache.size() || x < 0) {
            return MathUtils.log10Gamma(x + 1);
        }
        return Log10FactorialCache.get(x);
    }

    @Requires(value={"a.length == b.length"})
    @Ensures(value={"result.length == a.length"})
    public static int[] addArrays(int[] a, int[] b) {
        int[] c = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    public static double[] vectorSum(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new ReviewedGATKException("BUG: Lengths of x and y must be the same");
        }
        double[] result = new double[x.length];
        for (int k = 0; k < x.length; ++k) {
            result[k] = x[k] + y[k];
        }
        return result;
    }

    public static int[] vectorDiff(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new ReviewedGATKException("BUG: Lengths of x and y must be the same");
        }
        int[] result = new int[x.length];
        for (int k = 0; k < x.length; ++k) {
            result[k] = x[k] - y[k];
        }
        return result;
    }

    public static List<Integer> log10LinearRange(int start, int stop, double eps) {
        LinkedList<Integer> values = new LinkedList<Integer>();
        double log10range = Math.log10(stop - start);
        if (start == 0) {
            values.add(0);
        }
        for (double i = 0.0; i <= log10range; i += eps) {
            int index = (int)Math.round(Math.pow(10.0, i)) + start;
            if (index >= stop || values.peekLast() != null && values.peekLast() == index) continue;
            values.add(index);
        }
        if (values.peekLast() == null || (Integer)values.peekLast() != stop) {
            values.add(stop);
        }
        return values;
    }

    @Requires(value={"x >= 0.0 && x <= 1.0"})
    @Ensures(value={"result <= 0.0"})
    public static double log10OneMinusX(double x) {
        if (x == 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x == 0.0) {
            return 0.0;
        }
        double d = Math.log10(1.0 / x - 1.0) + Math.log10(x);
        return Double.isInfinite(d) || d > 0.0 ? 0.0 : d;
    }

    public static <T> List<T> randomSubset(List<T> list, int N) {
        if (list.size() <= N) {
            return list;
        }
        return MathUtils.sliceListByIndices(MathUtils.sampleIndicesWithoutReplacement(list.size(), N), list);
    }

    public static <T> List<T> randomSample(List<T> list, int N) {
        if (list.isEmpty()) {
            return list;
        }
        return MathUtils.sliceListByIndices(MathUtils.sampleIndicesWithReplacement(list.size(), N), list);
    }

    public static double dirichletMultinomial(double[] dirichletParams, double dirichletSum, int[] counts, int countSum) {
        if (dirichletParams.length != counts.length) {
            throw new IllegalStateException("The number of dirichlet parameters must match the number of categories");
        }
        double likelihood = MathUtils.log10MultinomialCoefficient(countSum, counts);
        likelihood += MathUtils.log10Gamma(dirichletSum);
        likelihood -= MathUtils.log10Gamma(dirichletSum + (double)countSum);
        for (int idx = 0; idx < counts.length; ++idx) {
            likelihood += MathUtils.log10Gamma((double)counts[idx] + dirichletParams[idx]);
            likelihood -= MathUtils.log10Gamma(dirichletParams[idx]);
        }
        return likelihood;
    }

    public static double dirichletMultinomial(double[] params, int[] counts) {
        return MathUtils.dirichletMultinomial(params, MathUtils.sum(params), counts, (int)MathUtils.sum(counts));
    }

    public static ExponentialDistribution exponentialDistribution(double mean) {
        return new ExponentialDistributionImpl(mean);
    }

    private static class Log10FactorialCache {
        private static final int CACHE_SIZE = 10000;
        private static double[] cache = null;

        private Log10FactorialCache() {
        }

        public static int size() {
            return 10000;
        }

        public static double get(int n) {
            if (cache == null) {
                Log10FactorialCache.initialize();
            }
            return cache[n];
        }

        private static synchronized void initialize() {
            if (cache == null) {
                Log10Cache.ensureCacheContains(10000);
                cache = new double[10000];
                Log10FactorialCache.cache[0] = 0.0;
                for (int k = 1; k < cache.length; ++k) {
                    Log10FactorialCache.cache[k] = cache[k - 1] + Log10Cache.get(k);
                }
            }
        }
    }

    public static class RunningAverage {
        private double mean = 0.0;
        private double s = 0.0;
        private long obs_count = 0L;

        public void add(double obs) {
            ++this.obs_count;
            double oldMean = this.mean;
            this.mean += (obs - this.mean) / (double)this.obs_count;
            this.s += (obs - oldMean) * (obs - this.mean);
        }

        public void addAll(Collection<Number> col) {
            for (Number o : col) {
                this.add(o.doubleValue());
            }
        }

        public double mean() {
            return this.mean;
        }

        public double stddev() {
            return Math.sqrt(this.s / (double)(this.obs_count - 1L));
        }

        public double var() {
            return this.s / (double)(this.obs_count - 1L);
        }

        public long observationCount() {
            return this.obs_count;
        }

        public RunningAverage clone() {
            RunningAverage ra = new RunningAverage();
            ra.mean = this.mean;
            ra.s = this.s;
            ra.obs_count = this.obs_count;
            return ra;
        }

        public void merge(RunningAverage other) {
            if (this.obs_count > 0L || other.obs_count > 0L) {
                this.mean = (this.mean * (double)this.obs_count + other.mean * (double)other.obs_count) / (double)(this.obs_count + other.obs_count);
                this.s += other.s;
            }
            this.obs_count += other.obs_count;
        }
    }

    private static class JacobianLogTable {
        public static final double MAX_TOLERANCE = 8.0;
        private static final double TABLE_STEP = 1.0E-4;
        private static final double INV_STEP = 10000.0;
        private static double[] cache = null;

        private JacobianLogTable() {
        }

        public static double get(double difference) {
            if (cache == null) {
                JacobianLogTable.initialize();
            }
            int index = MathUtils.fastRound(difference * 10000.0);
            return cache[index];
        }

        private static synchronized void initialize() {
            if (cache == null) {
                int tableSize = 80001;
                cache = new double[80001];
                for (int k = 0; k < cache.length; ++k) {
                    JacobianLogTable.cache[k] = Math.log10(1.0 + Math.pow(10.0, -((double)k) * 1.0E-4));
                }
            }
        }
    }

    public static class Log10Cache {
        private static double[] cache = new double[]{Double.NEGATIVE_INFINITY};

        public static double get(int n) {
            if (n < 0) {
                throw new ReviewedGATKException(String.format("Can't take the log of a negative number: %d", n));
            }
            if (n >= cache.length) {
                Log10Cache.ensureCacheContains(Math.max(n + 10, 2 * cache.length));
            }
            return cache[n];
        }

        public static synchronized void ensureCacheContains(int n) {
            if (n < cache.length) {
                return;
            }
            double[] newCache = new double[n + 1];
            System.arraycopy(cache, 0, newCache, 0, cache.length);
            for (int i = cache.length; i < newCache.length; ++i) {
                newCache[i] = Math.log10(i);
            }
            cache = newCache;
        }
    }
}

