/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.EscapingClassMarker;

public class EscapingClassFilter
implements ClassVisitor {
    private final ClassVisitor escapingClassVisitor;
    private final ClassVisitor otherClassVisitor;

    public EscapingClassFilter(ClassVisitor classVisitor) {
        this(classVisitor, null);
    }

    public EscapingClassFilter(ClassVisitor classVisitor, ClassVisitor classVisitor2) {
        this.escapingClassVisitor = classVisitor;
        this.otherClassVisitor = classVisitor2;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassVisitor classVisitor;
        ClassVisitor classVisitor2 = classVisitor = EscapingClassMarker.isClassEscaping(libraryClass) ? this.escapingClassVisitor : this.otherClassVisitor;
        if (classVisitor != null) {
            classVisitor.visitLibraryClass(libraryClass);
        }
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classVisitor;
        ClassVisitor classVisitor2 = classVisitor = EscapingClassMarker.isClassEscaping(programClass) ? this.escapingClassVisitor : this.otherClassVisitor;
        if (classVisitor != null) {
            classVisitor.visitProgramClass(programClass);
        }
    }
}

