/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class GammaIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;

    public GammaIntegerCodec(int offset) {
        this.offset = offset;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int length = 1;
        boolean lenCodingBit = false;
        while (!bitInputStream.readBit()) {
            ++length;
        }
        int readBits = bitInputStream.readBits(length - 1);
        int value = readBits | 1 << length - 1;
        return value - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer value) throws IOException {
        if (value + this.offset < 1) {
            throw new IllegalArgumentException("Gamma codec handles only positive values: " + value);
        }
        long newValue = value + this.offset;
        int betaCodeLength = 1 + (int)(Math.log(newValue) / Math.log(2.0));
        if (betaCodeLength > 1) {
            bitOutputStream.write(0L, betaCodeLength - 1);
        }
        bitOutputStream.write(newValue, betaCodeLength);
        return betaCodeLength * 2 - 1;
    }

    @Override
    public final long numberOfBits(Integer value) {
        long newValue = value + this.offset;
        if (newValue < 1L) {
            throw new RuntimeException("Invalid valid: " + newValue);
        }
        int betaCodeLength = 1 + (int)(Math.log(newValue) / Math.log(2.0));
        return betaCodeLength * 2 - 1;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

