

import numpy
import multisdf

display = True

verts = numpy.array([[ -6.35169935e+00,   1.71848381e+00,  -1.25078166e+00],
       [ -5.99447060e+00,   1.76962197e+00,  -1.34229076e+00],
       [ -5.40389919e+00,   1.53262198e+00,  -1.51157653e+00],
       [ -5.98930502e+00,   1.24300659e+00,  -5.87009370e-01],
       [ -6.34768152e+00,   1.30889404e+00,  -6.63340569e-01],
       [ -5.39873362e+00,   1.00600660e+00,  -7.56295085e-01],
       [ -4.88011312e+00,   2.27892351e+00,   1.83224154e+00],
       [ -4.28954172e+00,   2.04192376e+00,   1.66295588e+00],
       [ -5.10275507e+00,   2.47127390e+00,   2.06052113e+00],
       [ -4.84323072e+00,   3.10903239e+00,   2.07303739e+00],
       [ -3.95586777e+00,   2.86189866e+00,   1.67904818e+00],
       [ -4.54643917e+00,   3.09889865e+00,   1.84833384e+00],
       [ -4.31470585e+00,   4.01959705e+00,   1.36778319e+00],
       [ -3.72413445e+00,   3.78259706e+00,   1.19849753e+00],
       [ -3.37632680e+00,   3.86124229e+00,   1.08872020e+00],
       [ -3.39838433e+00,   4.33719301e+00,   3.45438570e-01],
       [ -3.75249410e+00,   4.39453411e+00,   2.42849588e-01],
       [ -4.34306526e+00,   4.63153410e+00,   4.12135303e-01],
       [ -4.55016088e+00,   4.71038198e+00,  -4.20726359e-01],
       [ -3.95958972e+00,   4.47338200e+00,  -5.90012074e-01],
       [ -4.84668064e+00,   4.91685247e+00,  -5.09009361e-01],
       [ -5.16063118e+00,   4.62609816e+00,  -1.19720232e+00],
       [ -4.36323977e+00,   4.09955502e+00,  -1.47483158e+00],
       [ -4.95381117e+00,   4.33655500e+00,  -1.30554581e+00],
       [ -5.24543238e+00,   3.87960124e+00,  -1.68316257e+00],
       [ -4.65486097e+00,   3.64260125e+00,  -1.85244834e+00],
       [ -4.49689198e+00,   3.42957878e+00,  -2.11312652e+00],
       [ -4.92730141e+00,   2.42781091e+00,  -2.21218061e+00],
       [ -5.20824480e+00,   2.35461402e+00,  -1.97980380e+00],
       [ -5.79881620e+00,   2.59161401e+00,  -1.81051803e+00],
       [ -6.17186213e+00,   1.75140464e+00,  -1.28765368e+00],
       [ -6.69312763e+00,   2.31586266e+00,  -1.44922912e+00],
       [ -7.17195559e+00,   2.75110936e+00,  -1.14247215e+00],
       [ -7.50769520e+00,   2.76926565e+00,  -5.10202706e-01],
       [ -7.50367832e+00,   2.35969734e+00,   7.72093162e-02],
       [ -7.16225719e+00,   1.76231778e+00,   2.75669515e-01],
       [ -6.68342972e+00,   1.32706285e+00,  -3.10751759e-02],
       [ -6.16730499e+00,   1.28683460e+00,  -6.21358991e-01],
       [ -6.43344975e+00,   2.53768039e+00,  -1.59743750e+00],
       [ -7.04908562e+00,   3.09728360e+00,  -1.20303571e+00],
       [ -7.48075151e+00,   3.12062740e+00,  -3.90117735e-01],
       [ -7.47558641e+00,   2.59403920e+00,   3.65126252e-01],
       [ -7.03661633e+00,   1.82598007e+00,   6.20289445e-01],
       [ -6.42098045e+00,   1.26636648e+00,   2.25903347e-01],
       [ -5.28495646e+00,   8.54451180e-01,  -1.47193015e-01],
       [ -5.09398603e+00,   8.96619499e-01,   4.59990531e-01],
       [ -4.84623432e+00,   1.12800467e+00,   1.00036037e+00],
       [ -4.56818008e+00,   1.52387607e+00,   1.41616237e+00],
       [ -5.87552786e+00,   1.09145117e+00,   2.20926963e-02],
       [ -5.68455744e+00,   1.13361955e+00,   6.29276276e-01],
       [ -5.43680573e+00,   1.36500466e+00,   1.16964614e+00],
       [ -5.15875149e+00,   1.76087606e+00,   1.58544815e+00],
       [ -4.71540689e+00,   2.29100990e+00,   1.78518307e+00],
       [ -4.43630791e+00,   2.97687101e+00,   1.79864335e+00],
       [ -3.55148077e+00,   3.81475306e+00,   1.13451469e+00],
       [ -3.14082313e+00,   2.95325637e+00,   1.37895155e+00],
       [ -2.46105599e+00,   2.48594284e+00,   7.62382686e-01],
       [ -2.18193436e+00,   2.72239423e+00,  -2.00323954e-01],
       [ -2.50757480e+00,   3.48969817e+00,  -8.05158794e-01],
       [ -3.19984126e+00,   4.22673941e+00,  -6.09818459e-01],
       [ -3.57649827e+00,   4.35457420e+00,   2.91488826e-01],
       [ -2.92264009e+00,   3.21619964e+00,   1.22907352e+00],
       [ -2.39393234e+00,   2.85273337e+00,   7.49520063e-01],
       [ -2.17683792e+00,   3.03663993e+00,   7.48149119e-04],
       [ -2.43011379e+00,   3.63343191e+00,  -4.69678968e-01],
       [ -2.96854305e+00,   4.20668602e+00,  -3.17747772e-01],
       [ -4.43917656e+00,   4.62001371e+00,  -5.33037901e-01],
       [ -4.77711868e+00,   4.30704021e+00,  -1.27382183e+00],
       [ -4.57243013e+00,   3.52865410e+00,  -1.97462285e+00],
       [ -3.68609452e+00,   3.75512099e+00,  -1.76594651e+00],
       [ -2.95125127e+00,   3.10836244e+00,  -1.74696302e+00],
       [ -2.93768239e+00,   2.13125849e+00,  -1.80808771e+00],
       [ -3.65438724e+00,   1.47182965e+00,  -1.90878248e+00],
       [ -4.62604332e+00,   1.56741095e+00,  -1.98226607e+00],
       [ -5.06062317e+00,   2.39239693e+00,  -2.08697510e+00],
       [ -3.74340701e+00,   3.51709414e+00,  -2.04584718e+00],
       [ -3.17186213e+00,   3.01405978e+00,  -2.03108239e+00],
       [ -3.16130829e+00,   2.25409007e+00,  -2.07862377e+00],
       [ -3.71874547e+00,   1.74120069e+00,  -2.15694189e+00],
       [ -4.47447824e+00,   1.81554151e+00,  -2.21409583e+00],
       [ -5.62676096e+00,   3.29255152e+00,  -1.86806536e+00],
       [ -4.79348087e+00,   2.97298455e+00,  -2.25693965e+00],
       [ -5.79935980e+00,   4.13695478e+00,  -1.55056918e+00],
       [ -6.61272240e+00,   4.17190218e+00,  -1.16063535e+00],
       [ -6.93550682e+00,   4.42170238e+00,  -3.55502129e-01],
       [ -6.58579874e+00,   4.74557304e+00,   4.11075175e-01],
       [ -5.76068354e+00,   4.96098804e+00,   7.07070708e-01],
       [ -4.92518187e+00,   4.94654417e+00,   3.65667939e-01],
       [ -5.81828022e+00,   4.47085333e+00,  -1.38777590e+00],
       [ -6.45089531e+00,   4.49803495e+00,  -1.08449399e+00],
       [ -6.70194960e+00,   4.69232368e+00,  -4.58279222e-01],
       [ -6.42995453e+00,   4.94422340e+00,   1.37947485e-01],
       [ -5.78819847e+00,   5.11176825e+00,   3.68166149e-01],
       [ -5.13836384e+00,   5.10053396e+00,   1.02630526e-01],
       [ -4.88935041e+00,   3.95628762e+00,   1.78065467e+00],
       [ -5.73640537e+00,   4.31230021e+00,   1.66647601e+00],
       [ -6.58596087e+00,   3.95609736e+00,   1.57341683e+00],
       [ -6.93489218e+00,   3.09863091e+00,   1.55658877e+00],
       [ -6.57655239e+00,   2.24771047e+00,   1.62595761e+00],
       [ -5.72316122e+00,   1.90726924e+00,   1.74044216e+00],
       [ -5.10993958e+00,   3.77589035e+00,   2.02039814e+00],
       [ -5.76876020e+00,   4.05278921e+00,   1.93159246e+00],
       [ -6.42952538e+00,   3.77574229e+00,   1.85921311e+00],
       [ -6.70091629e+00,   3.10882401e+00,   1.84612465e+00],
       [ -6.42220736e+00,   2.44699717e+00,   1.90007818e+00],
       [ -5.75845861e+00,   2.18220949e+00,   1.98912168e+00],
       [ -6.55912113e+00,   2.42897081e+00,  -1.51273918e+00],
       [ -7.10222292e+00,   2.92264199e+00,  -1.16480541e+00],
       [ -7.48303032e+00,   2.94323540e+00,  -4.47665006e-01],
       [ -7.47847366e+00,   2.47868943e+00,   2.18596578e-01],
       [ -7.09122276e+00,   1.80112243e+00,   4.43696529e-01],
       [ -6.54812098e+00,   1.30744231e+00,   9.57767218e-02],
       [ -3.03691196e+00,   3.08314943e+00,   1.29370236e+00],
       [ -2.43725467e+00,   2.67090821e+00,   7.49795437e-01],
       [ -2.19102740e+00,   2.87949419e+00,  -9.94573608e-02],
       [ -2.47829151e+00,   3.55637217e+00,  -6.33012950e-01],
       [ -3.08897519e+00,   4.20655346e+00,  -4.60693270e-01],
       [ -3.71778822e+00,   3.62791848e+00,  -1.89831126e+00],
       [ -3.06951261e+00,   3.05735064e+00,  -1.88156414e+00],
       [ -3.05754232e+00,   2.19535351e+00,  -1.93548810e+00],
       [ -3.68981647e+00,   1.61360800e+00,  -2.02432060e+00],
       [ -4.54700756e+00,   1.69792950e+00,  -2.08914757e+00],
       [ -6.96899986e+00,   1.45586574e+00,  -5.94785035e-01],
       [ -6.96899986e+00,   1.77244890e+00,  -1.08739805e+00],
       [ -7.40823030e+00,   1.85299993e+00,  -3.02000046e-01],
       [ -7.40823030e+00,   2.15300012e+00,  -8.21615338e-01],
       [ -4.92896605e+00,   4.56303453e+00,   1.28530204e+00],
       [ -5.54699993e+00,   4.71447754e+00,   1.24364018e+00],
       [ -6.16503382e+00,   4.56303453e+00,   1.28530192e+00],
       [ -6.16503382e+00,   1.38914168e+00,   1.02230573e+00],
       [ -6.16503382e+00,   2.90492558e+00,  -1.77861631e+00],
       [ -6.16503382e+00,   3.52894235e+00,  -1.72690856e+00],
       [ -6.72257042e+00,   4.55686855e+00,   7.36194789e-01],
       [ -6.72257042e+00,   4.20612288e+00,   1.26112282e+00],
       [ -6.72257042e+00,   1.91787720e+00,   1.26112282e+00],
       [ -6.72257042e+00,   3.68119502e+00,  -1.37786841e+00],
       [ -7.16503429e+00,   4.23757029e+00,   1.16999999e-01],
       [ -7.16503429e+00,   4.08007383e+00,   7.04785168e-01],
       [ -7.16503429e+00,   3.64978528e+00,   1.13507378e+00],
       [ -7.16503429e+00,   3.06200004e+00,   1.29257035e+00],
       [ -7.16503429e+00,   2.47421479e+00,   1.13507378e+00],
       [ -7.16503429e+00,   3.64978456e+00,  -9.01074171e-01],
       [ -7.16503429e+00,   4.08007336e+00,  -4.70785916e-01],
       [ -7.44911289e+00,   3.68003368e+00,   1.16999999e-01],
       [ -7.44911289e+00,   3.37101674e+00,   6.52232766e-01],
       [ -2.26688719e+00,   1.89096606e+00,  -2.78000057e-01],
       [ -2.26688719e+00,   2.19998312e+00,  -8.13233197e-01],
       [ -2.55096626e+00,   1.92121482e+00,   7.40073919e-01],
       [ -2.55096626e+00,   1.49092615e+00,   3.09785306e-01],
       [ -2.55096626e+00,   1.33342957e+00,  -2.77999818e-01],
       [ -2.55096626e+00,   1.49092603e+00,  -8.65785003e-01],
       [ -2.55096626e+00,   1.92121446e+00,  -1.29607368e+00],
       [ -2.55096626e+00,   2.50899959e+00,  -1.45357049e+00],
       [ -2.55096626e+00,   3.09678459e+00,  -1.29607427e+00],
       [ -2.99342966e+00,   1.88980508e+00,   1.21686840e+00],
       [ -2.99342966e+00,   1.36487722e+00,   8.66122842e-01],
       [ -2.99342966e+00,   1.01413167e+00,   3.41194928e-01],
       [ -2.99342966e+00,   8.90966058e-01,  -2.77999759e-01],
       [ -2.99342966e+00,   1.01413143e+00,  -8.97194445e-01],
       [ -2.99342966e+00,   1.36487687e+00,  -1.42212248e+00],
       [ -2.99342966e+00,   3.65312338e+00,  -1.42212248e+00],
       [ -3.55096626e+00,   2.35192490e+00,   1.61761642e+00],
       [ -3.55096626e+00,   1.74493003e+00,   1.46390450e+00],
       [ -3.55096626e+00,   1.22073400e+00,   1.12143016e+00],
       [ -3.55096626e+00,   8.36141586e-01,   6.27305806e-01],
       [ -3.55096626e+00,   6.32829309e-01,   3.50775719e-02],
       [ -3.55096626e+00,   6.32829309e-01,  -5.91077447e-01],
       [ -3.55096626e+00,   8.36141467e-01,  -1.18330574e+00],
       [ -3.55096626e+00,   1.22073388e+00,  -1.67743003e+00],
       [ -3.55096626e+00,   4.01003599e+00,  -1.44630039e+00],
       [ -3.55096626e+00,   4.30805206e+00,  -8.95612657e-01],
       [ -4.16900015e+00,   1.50899994e+00,   1.45405078e+00],
       [ -4.16900015e+00,   1.04289615e+00,   1.08234537e+00],
       [ -4.16900015e+00,   7.07062244e-01,   5.89767218e-01],
       [ -4.16900015e+00,   5.31338334e-01,   2.00841725e-02],
       [ -4.16900015e+00,   5.31338453e-01,  -5.76084971e-01],
       [ -4.16900015e+00,   7.07062602e-01,  -1.14576793e+00],
       [ -4.16900015e+00,   1.04289675e+00,  -1.63834596e+00],
       [ -4.78703403e+00,   6.32829428e-01,   3.50775719e-02],
       [ -4.78703403e+00,   6.32829428e-01,  -5.91077447e-01],
       [ -4.78703403e+00,   8.36141586e-01,  -1.18330562e+00],
       [ -4.78703403e+00,   1.22073400e+00,  -1.67742991e+00],
       [ -5.68100023e+00,   3.77667785e+00,   2.20158076e+00],
       [ -5.68100023e+00,   3.23964405e+00,   2.40525055e+00],
       [ -5.68100023e+00,   2.66947412e+00,   2.33601952e+00],
       [ -6.28100014e+00,   3.52671194e+00,   2.15931726e+00],
       [ -6.28100014e+00,   2.94710231e+00,   2.24265265e+00],
       [ -2.32576942e+00,   3.76000023e+00,   1.15000002e-01],
       [ -2.32576942e+00,   3.46000004e+00,   6.34615302e-01],
       [ -2.76500010e+00,   4.19923067e+00,   1.15000002e-01],
       [ -2.76500010e+00,   4.03425646e+00,   6.76850438e-01],
       [ -2.76500010e+00,   3.59171224e+00,   1.06031740e+00],
       [ -5.68200016e+00,   5.29300022e+00,  -2.56999999e-01],
       [ -5.68200016e+00,   4.77467775e+00,  -1.24458051e+00],
       [ -5.68200016e+00,   5.15554762e+00,  -8.14667344e-01],
       [ -6.28200006e+00,   5.13223028e+00,  -2.56999999e-01],
       [ -6.28200006e+00,   4.96725607e+00,  -8.18850935e-01],
       [ -3.47900009e+00,   2.43110180e+00,  -2.40565252e+00],
       [ -3.47900009e+00,   3.01071167e+00,  -2.32231760e+00],
       [ -4.07900000e+00,   2.15347385e+00,  -2.49901938e+00],
       [ -4.07900000e+00,   2.72364402e+00,  -2.56825066e+00],
       [ -4.07900000e+00,   3.26067805e+00,  -2.36458039e+00]], "f")


faces = numpy.array([[  2,   0,  30],
       [  2,  30,   1],
       [  5,   3,  37],
       [  5,  37,   4],
       [  0,  31,  30],
       [ 30,  31, 106],
       [ 30, 106,   1],
       [  1, 106,  38],
       [ 31,  32, 106],
       [106,  32, 107],
       [106, 107,  38],
       [ 38, 107,  39],
       [ 32,  33, 107],
       [107,  33, 108],
       [107, 108,  39],
       [ 39, 108,  40],
       [ 33,  34, 108],
       [108,  34, 109],
       [108, 109,  40],
       [ 40, 109,  41],
       [ 34,  35, 109],
       [109,  35, 110],
       [109, 110,  41],
       [ 41, 110,  42],
       [ 35,  36, 110],
       [110,  36, 111],
       [110, 111,  42],
       [ 42, 111,  43],
       [ 36,   4, 111],
       [111,   4,  37],
       [111,  37,  43],
       [ 43,  37,   3],
       [  4,   0,   5],
       [  5,   0,   2],
       [  8,   6,  52],
       [ 52,   6,   7],
       [  5,  44,   3],
       [  3,  44,  48],
       [ 44,  45,  48],
       [ 48,  45,  49],
       [ 45,  46,  49],
       [ 49,  46,  50],
       [ 46,  47,  50],
       [ 50,  47,  51],
       [ 47,   7,  51],
       [ 51,   7,   6],
       [ 11,   9,  53],
       [ 11,  53,  10],
       [  7,  10,  52],
       [ 52,  10,  53],
       [ 52,  53,   8],
       [  8,  53,   9],
       [ 14,  12,  54],
       [ 54,  12,  13],
       [ 10,  13,  11],
       [ 11,  13,  12],
       [ 17,  15,  60],
       [ 17,  60,  16],
       [ 13,  55,  54],
       [ 54,  55, 112],
       [ 54, 112,  14],
       [ 14, 112,  61],
       [ 55,  56, 112],
       [112,  56, 113],
       [112, 113,  61],
       [ 61, 113,  62],
       [ 56,  57, 113],
       [113,  57, 114],
       [113, 114,  62],
       [ 62, 114,  63],
       [ 57,  58, 114],
       [114,  58, 115],
       [114, 115,  63],
       [ 63, 115,  64],
       [ 58,  59, 115],
       [115,  59, 116],
       [115, 116,  64],
       [ 64, 116,  65],
       [ 59,  16, 116],
       [116,  16,  60],
       [116,  60,  65],
       [ 65,  60,  15],
       [ 20,  18,  66],
       [ 66,  18,  19],
       [ 16,  19,  17],
       [ 17,  19,  18],
       [ 23,  21,  67],
       [ 23,  67,  22],
       [ 19,  22,  66],
       [ 66,  22,  67],
       [ 66,  67,  20],
       [ 20,  67,  21],
       [ 26,  24,  68],
       [ 68,  24,  25],
       [ 22,  25,  23],
       [ 23,  25,  24],
       [ 29,  27,  74],
       [ 29,  74,  28],
       [ 25,  69,  68],
       [ 68,  69, 117],
[ 68, 117,  26],
       [ 26, 117,  75],
       [ 69,  70, 117],
       [117,  70, 118],
       [117, 118,  75],
       [ 75, 118,  76],
       [ 70,  71, 118],
       [118,  71, 119],
       [118, 119,  76],
       [ 76, 119,  77],
       [ 71,  72, 119],
       [119,  72, 120],
       [119, 120,  77],
       [ 77, 120,  78],
       [ 72,  73, 120],
       [120,  73, 121],
       [120, 121,  78],
       [ 78, 121,  79],
       [ 73,  28, 121],
       [121,  28,  74],
       [121,  74,  79],
       [ 79,  74,  27],
       [ 28,   2,  29],
       [ 29,   2,   1],
       [ 29,  80,  27],
       [ 27,  80,  81],
       [ 80,  24,  81],
       [ 81,  24,  26],
       [ 23,  82,  21],
       [ 21,  82,  88],
       [ 82,  83,  88],
       [ 88,  83,  89],
       [ 83,  84,  89],
       [ 89,  84,  90],
       [ 84,  85,  90],
       [ 90,  85,  91],
       [ 85,  86,  91],
       [ 91,  86,  92],
       [ 86,  87,  92],
       [ 92,  87,  93],
       [ 87,  18,  93],
       [ 93,  18,  20],
       [ 17,  12,  15],
       [ 15,  12,  14],
       [ 11,  94,   9],
       [  9,  94, 100],
       [ 94,  95, 100],
       [100,  95, 101],
       [ 95,  96, 101],
       [101,  96, 102],
       [ 96,  97, 102],
       [102,  97, 103],
       [ 97,  98, 103],
       [103,  98, 104],
       [ 98,  99, 104],
       [104,  99, 105],
       [ 99,   6, 105],
       [105,   6,   8],
       [122, 124, 125],
       [123, 122, 125],
       [123, 125,  31],
       [123,  31,   0],
       [123,   0,   4],
       [123,   4, 122],
       [122,   4,  36],
       [122,  36, 124],
       [124,  36,  35],
       [124,  35,  34],
       [124,  34, 125],
       [125,  34,  33],
       [125,  33,  32],
       [125,  32,  31],
       [128, 132, 133],
       [132, 136, 137],
       [133, 132, 137],
       [133, 137, 138],
       [137, 136, 143],
       [137, 143, 144],
       [138, 137, 144],
       [139, 138, 144],
       [136, 142, 143],
       [143, 142,  40],
       [143,  40, 144],
       [144,  40,  41],
       [144,  41, 140],
       [144, 140, 139],
       [139, 140,  97],
       [139,  97, 138],
       [138,  97,  96],
       [138,  96, 133],
       [133,  96, 128],
       [128,  96,  95],
       [128,  95, 127],
       [128, 127,  86],
       [128,  86,  85],
       [128,  85, 132],
       [132,  85, 136],
       [136,  85,  84],
       [136,  84, 142],
       [142,  84,  83],
[142,  83, 141],
       [142, 141,  40],
       [ 40, 141,  39],
       [ 39, 141, 135],
       [ 39, 135, 130],
       [ 39, 130,  38],
       [ 38, 130,  29],
       [ 38,  29,   1],
       [ 29, 130,  80],
       [ 80, 130, 131],
       [ 80, 131,  82],
       [ 80,  82,  24],
       [ 24,  82,  23],
       [ 82, 131,  83],
       [ 83, 131, 135],
       [ 83, 135, 141],
       [135, 131, 130],
       [ 86, 127,  87],
       [ 87, 127, 126],
       [ 87, 126,  17],
       [ 87,  17,  18],
       [ 17, 126,  12],
       [ 12, 126,  94],
       [ 12,  94,  11],
       [ 94, 126,  95],
       [ 95, 126, 127],
       [ 97, 140,  98],
       [ 98, 140, 134],
       [ 98, 134,  99],
       [ 99, 134, 129],
       [ 99, 129,  50],
       [ 99,  50,  51],
       [ 99,  51,   6],
       [ 50, 129,  49],
       [ 49, 129,  43],
       [ 49,  43,  48],
       [ 48,  43,   3],
       [ 43, 129,  42],
       [ 42, 129, 134],
       [ 42, 134, 140],
       [ 42, 140,  41],
       [145, 148, 149],
       [145, 149, 150],
       [146, 145, 150],
       [146, 150, 151],
       [146, 151, 152],
       [147, 154, 155],
       [148, 147, 155],
       [148, 155, 156],
       [149, 148, 156],
       [149, 156, 157],
       [149, 157, 158],
       [150, 149, 158],
       [150, 158, 159],
       [151, 150, 159],
       [154, 161, 162],
       [154, 162, 163],
       [155, 154, 163],
       [155, 163, 164],
       [156, 155, 164],
       [156, 164, 165],
       [157, 156, 165],
       [157, 165, 166],
       [158, 157, 166],
       [158, 166, 167],
       [159, 158, 167],
       [159, 167, 168],
       [163, 162, 171],
       [163, 171, 172],
       [164, 163, 172],
       [164, 172, 173],
       [165, 164, 173],
       [165, 173, 174],
       [166, 165, 174],
       [166, 174, 175],
       [166, 175, 176],
       [167, 166, 176],
       [167, 176, 177],
       [168, 167, 177],
       [174, 173, 178],
       [174, 178, 179],
       [175, 174, 179],
       [176, 175, 179],
       [176, 179, 180],
       [177, 176, 180],
       [177, 180, 181],
       [177, 181,  73],
       [177,  73,  72],
       [177,  72, 168],
       [168,  72, 159],
       [159,  72,  71],
       [159,  71, 151],
       [151,  71, 152],
       [152,  71,  70],
       [152,  70, 153],
       [152, 153, 146],
       [146, 153,  57],
       [146,  57, 145],
       [145,  57,  56],
       [145,  56, 147],
       [145, 147, 148],
       [147,  56, 154],
       [154,  56,  55],
       [154,  55, 161],
       [161,  55,  10],
       [161,  10,   7],
       [161,   7, 162],
       [162,   7, 171],
       [171,   7,  47],
       [171,  47, 172],
       [172,  47,  46],
       [172,  46, 173],
       [173,  46,  45],
       [173,  45, 178],
       [178,  45,  44],
       [178,  44, 179],
       [179,  44,   5],
       [179,   5, 180],
       [180,   5,   2],
       [180,   2, 181],
       [181,   2,  73],
       [ 73,   2,  28],
       [ 10,  55,  13],
       [ 57, 153,  58],
       [ 58, 153, 160],
       [ 58, 160,  59],
       [ 59, 160, 170],
       [ 59, 170,  19],
       [ 59,  19,  16],
       [ 19, 170,  22],
       [ 22, 170, 169],
       [ 22, 169,  69],
       [ 22,  69,  25],
       [ 69, 169, 160],
       [ 69, 160,  70],
       [ 70, 160, 153],
       [160, 169, 170],
       [183, 182, 185],
       [183, 185, 186],
       [184, 183, 186],
       [184, 186, 104],
       [184, 104, 105],
       [184, 105,   8],
       [184,   8,   9],
       [184,   9, 183],
       [183,   9, 100],
       [183, 100, 182],
       [182, 100, 101],
       [182, 101, 185],
       [185, 101, 102],
       [185, 102, 103],
       [185, 103, 186],
       [186, 103, 104],
       [188, 187, 190],
       [188, 190, 191],
       [187, 189, 190],
       [190, 189,  15],
       [190,  15,  14],
       [190,  14, 191],
       [191,  14,  61],
       [191,  61,  62],
       [191,  62, 188],
       [188,  62,  63],
       [188,  63, 187],
       [187,  63,  64],
       [187,  64, 189],
       [189,  64,  65],
       [189,  65,  15],
       [194, 193, 196],
       [195, 194, 196],
       [192, 194, 195],
       [195, 196,  90],
       [195,  90,  91],
       [195,  91,  92],
       [195,  92, 192],
       [192,  92,  93],
       [192,  93,  20],
       [192,  20, 194],
       [194,  20,  21],
       [194,  21, 193],
       [193,  21,  88],
       [193,  88,  89],
       [193,  89, 196],
       [196,  89,  90],
       [197, 199, 200],
       [198, 197, 200],
       [198, 200, 201],
       [198, 201,  75],
       [198,  75,  76],
       [198,  76, 197],
       [197,  76,  77],
       [197,  77,  78],
       [197,  78, 199],
       [199,  78,  79],
       [199,  79,  27],
       [199,  27, 200],
       [200,  27,  81],
       [200,  81, 201],
       [201,  81,  26],
       [201,  26,  75]], 'i')

labels = numpy.ones(len(faces), 'i')


multisdf.BB_SCALE = BB_SCALE = 0.2
HUGE = 999999

def get_bbox(vert_list):
    bbox = []
    x_min = HUGE; x_max = -HUGE
    y_min = HUGE; y_max = -HUGE
    z_min = HUGE; z_max = -HUGE
    for i in range(len(vert_list)):
        p = vert_list[i]
        #check x-span
        if p[0] < x_min: 
            x_min = p[0]
        if p[0] > x_max: 
            x_max = p[0]
        #check y-span
        if p[1] < y_min: 
            y_min = p[1]
        if p[1] > y_max: 
            y_max = p[1]
        #check z-span
        if p[2] < z_min: 
            z_min = p[2]
        if p[2] > z_max: 
            z_max = p[2]
   
    bbox.append(x_min - BB_SCALE*(x_max-x_min))
    bbox.append(y_min - BB_SCALE*(y_max-y_min))
    bbox.append(z_min - BB_SCALE*(z_max-z_min))
    
    bbox.append(x_max + BB_SCALE*(x_max-x_min))
    bbox.append(y_max + BB_SCALE*(y_max-y_min))
    bbox.append(z_max + BB_SCALE*(z_max-z_min))
    return bbox






dimx = dimy = dimz = size = 32

datap = multisdf.computeSDF(verts, faces, labels, size, size, size)
#datap = multisdf.computeSDF(verts, faces, labels, size, size, size)
grid_size  = size*size*size
volarr = multisdf.createNumArr(datap, grid_size)
print "data arr shape:", volarr.shape
volarr.shape = (size, size, size)
volarr = numpy.ascontiguousarray(numpy.transpose(volarr), 'f')

bbox = get_bbox(verts)
xmin = bbox[0]; ymin = bbox[1]; zmin = bbox[2]
xmax = bbox[3]; ymax = bbox[4]; zmax = bbox[5]
XSpan = (xmax-xmin)/(dimx-1) 
YSpan = (ymax-ymin)/(dimy-1)
ZSpan = (zmax-zmin)/(dimz-1)


inside = []
outside = []

for k in range(dimz):
    z = zmin + k*ZSpan
    for j in range(dimy):
        y = ymin + j*YSpan
        for i in range(dimx):
            val = volarr[i][j][k]
            x = xmin + i*XSpan
            #if val != 10:
                #vverts.append([x,y,z])
                #labels.append("%.2f"%val)
            if val < 0:
                inside.append([x,y,z])
            else:
                outside.append([x,y,z])

if display:
    from DejaVu.Viewer import Viewer
    vi = Viewer()
    from DejaVu.IndexedPolygons import IndexedPolygons
    obj = IndexedPolygons('obj', vertices=verts, faces=faces, inheritFrontPolyMode=False, frontPolyMode='line')
    vi.AddObject(obj)
    
    from DejaVu.Points import Points
    insideg = Points('inside', vertices=inside, materials=((0,1,0),),
                     inheritMaterial=False, pointWidth=4)
    vi.AddObject(insideg)
    outsideg = Points('outside', vertices=outside, materials=((1,0,0),),
                      inheritMaterial=False, pointWidth=4)
    vi.AddObject(outsideg)

    
    from DejaVu.Box import Box
    bb = Box("bb", cornerPoints = [[xmin, ymin, zmin],[xmax, ymax,zmax]])
    
    vi.AddObject(bb)
