#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 HS-157
set -o errexit

###
# Dreamfall Chapters
# send your bug reports to contact@dotslashplay.it
###

script_version=20240829.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='dreamfall-chapters'
GAME_NAME='Dreamfall Chapters'

ARCHIVE_BASE_GOG_1_NAME='dreamfall_chapters_the_final_cut_5_7_8_26845.sh'
ARCHIVE_BASE_GOG_1_MD5='4971fdb8148d661b4a23119ed289b14e'
ARCHIVE_BASE_GOG_1_VERSION='5.7.8-gog26845'
ARCHIVE_BASE_GOG_1_SIZE='21000000'
ARCHIVE_BASE_GOG_1_URL='https://www.gog.com/game/dreamfall_chapters_season_pass'

ARCHIVE_BASE_GOG_0_NAME='gog_dreamfall_chapters_2.19.0.23.sh'
ARCHIVE_BASE_GOG_0_MD5='3f05c530a0e07b7227e3fb7b6601e19a'
ARCHIVE_BASE_GOG_0_VERSION='5.3.0-gog2.19.0.23'
ARCHIVE_BASE_GOG_0_SIZE='21000000'

ARCHIVE_BASE_HUMBLE_0_NAME='Dreamfall_Chapters_Linux_2017_08_25.zip'
ARCHIVE_BASE_HUMBLE_0_MD5='22bee7bee25920e5cf7febc4b3c12e21'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_HUMBLE_0_SIZE='21000000'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/dreamfall-chapters'

UNITY3D_NAME='Dreamfall Chapters'

ARCHIVE_GAME_BIN_PATH_GOG='data/noarch/game'
ARCHIVE_GAME_BIN_PATH_HUMBLE='.'
## TODO: An explicit list of plugins to include should be set using UNITY3D_PLUGINS
ARCHIVE_GAME0_BIN_FILES="
${UNITY3D_NAME}_Data/Plugins"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## TODO: Update the list of required native libraries.
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libstdc++.so.6
libGL.so.1
libXcursor.so.1
libXrandr.so.2
libX11.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
