#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Escape Goat
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220629.1

GAME_ID='escape-goat'
GAME_NAME='Escape Goat'

ARCHIVE_BASE_0='gog_escape_goat_2.0.0.8.sh'
ARCHIVE_BASE_0_MD5='772eda5c48d59b7528a9d85b3f1f84e3'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='110000'
ARCHIVE_BASE_0_VERSION='1.0.6-gog2.0.0.8'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/escape_goat'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_DOC_DATA_FILES='
Linux.README
ReadMe.txt'
ARCHIVE_GAME_BIN32_FILES='
EscapeGoat.bin.x86
lib'
ARCHIVE_GAME_BIN64_FILES='
EscapeGoat.bin.x86_64
lib64'
ARCHIVE_GAME_DATA_FILES='
EscapeGoat.exe
Escape?Goat.bmp
Content
fr
mono
Common.dll
Lidgren.Network.dll
MonoGame.Framework.dll
Mono.Posix.dll
Mono.Security.dll
mscorlib.dll
Physics.dll
SDL2#.dll
SDL2#.dll.config
System.Configuration.dll
System.Core.dll
System.Data.dll
System.dll
System.Drawing.dll
System.Runtime.Serialization.dll
System.Security.dll
System.Xml.dll'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32='EscapeGoat.bin.x86'
APP_MAIN_EXE_BIN64='EscapeGoat.bin.x86_64'
APP_MAIN_ICON='Escape Goat.bmp'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
