#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Jacek Szafarkiewicz
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hard West
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220627.1

GAME_ID='hard-west'
GAME_NAME='Hard West'

# Archives

## Hard West (base game)

ARCHIVE_BASE_0='gog_hard_west_2.7.0.8.sh'
ARCHIVE_BASE_0_MD5='de81eb547f089d8bdb96b7a2fe38e8c0'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='5700000'
ARCHIVE_BASE_0_VERSION='1.5-gog2.7.0.8'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/hard_west'

## Scars of Freedom

ARCHIVE_BASE_SCARSOFFREEDOM_0='gog_hard_west_scars_of_freedom_dlc_2.3.0.4.sh'
ARCHIVE_BASE_SCARSOFFREEDOM_0_MD5='bb4368afaf670f0d8ebc09f7bb1f3713'
ARCHIVE_BASE_SCARSOFFREEDOM_0_TYPE='mojosetup'
ARCHIVE_BASE_SCARSOFFREEDOM_0_SIZE='200000'
ARCHIVE_BASE_SCARSOFFREEDOM_0_URL='https://www.gog.com/game/hard_west_scars_of_freedom'


UNITY3D_NAME='HardWest'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN32_FILES="
${UNITY3D_NAME}.x86
${UNITY3D_NAME}_Data/Mono/x86
${UNITY3D_NAME}_Data/Plugins/x86"
ARCHIVE_GAME_BIN64_FILES="
${UNITY3D_NAME}.x86_64
${UNITY3D_NAME}_Data/Mono/x86_64
${UNITY3D_NAME}_Data/Plugins/x86_64"
ARCHIVE_GAME_DATA_FILES="
Data
Data_dlc1
${UNITY3D_NAME}_Data"

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32="${UNITY3D_NAME}.x86"
APP_MAIN_EXE_BIN64="${UNITY3D_NAME}.x86_64"
APP_MAIN_ICON="${UNITY3D_NAME}_Data/Resources/UnityPlayer.png"

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libGLU.so.1 libudev.so.1 xcursor libxrandr"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Start pulseaudio if it is available

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Start pulseaudio if it is available
pulseaudio_is_available() {
    command -v pulseaudio >/dev/null 2>&1
}
if pulseaudio_is_available; then
    if ! pulseaudio --check; then
        touch .stop_pulseaudio_on_exit
    fi
    pulseaudio --start
fi'

# Stop pulseaudio if it has been started for this game session

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Stop pulseaudio if it has been started for this game session
if [ -e .stop_pulseaudio_on_exit ]; then
    pulseaudio --kill
    rm .stop_pulseaudio_on_exit
fi'

# Work around crash on launch related to libpulse

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Work around crash on launch related to libpulse
# Some Unity3D games crash on launch if libpulse-simple.so.0 is available but pulseaudio is not running
LIBPULSE_NULL_LINK="${APP_LIBS:=libs}/libpulse-simple.so.0"
if pulseaudio_is_available; then
    rm --force "$LIBPULSE_NULL_LINK"
else
    mkdir --parents "$(dirname "$LIBPULSE_NULL_LINK")"
    ln --force --symbolic /dev/null "$LIBPULSE_NULL_LINK"
fi'

# Use a dedicated log file for the current game session

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Use a dedicated log file for the current game session
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Load Scars of Freedom archive if it is available

archive_initialize_optional \
	'ARCHIVE_SCARSOFFREEDOM' \
	'ARCHIVE_BASE_SCARSOFFREEDOM_0'

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
if [ -n "$ARCHIVE_SCARSOFFREEDOM" ]; then
	(
		ARCHIVE='ARCHIVE_SCARSOFFREEDOM'
		extract_data_from "$ARCHIVE_SCARSOFFREEDOM"
	)
fi
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
