#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# AGS games developed by Wormwood Studios:
# - Primordia
# - Strangeland
###

script_version=20240127.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID_PRIMORDIA='primordia'
GAME_NAME_PRIMORDIA='Primordia'

GAME_ID_STRANGELAND='strangeland'
GAME_NAME_STRANGELAND='Strangeland'

# Game archives

## Primordia

ARCHIVE_BASE_PRIMORDIA_6_NAME='primordia_3_6_70667.sh'
ARCHIVE_BASE_PRIMORDIA_6_MD5='dc254ed674114e4776a91454e35d3741'
ARCHIVE_BASE_PRIMORDIA_6_SIZE='1426928'
ARCHIVE_BASE_PRIMORDIA_6_VERSION='3.6-gog70667'
ARCHIVE_BASE_PRIMORDIA_6_URL='https://www.gog.com/game/primordia'

ARCHIVE_BASE_PRIMORDIA_5_NAME='primordia_3_6_70159.sh'
ARCHIVE_BASE_PRIMORDIA_5_MD5='d1f9eeec2084933463d1b43b5466f5f1'
ARCHIVE_BASE_PRIMORDIA_5_SIZE='1426928'
ARCHIVE_BASE_PRIMORDIA_5_VERSION='3.6-gog70159'

ARCHIVE_BASE_PRIMORDIA_4_NAME='primordia_3_5b_69802.sh'
ARCHIVE_BASE_PRIMORDIA_4_MD5='b3ca4bfa8341f68ec6eb2d6c36f36e0f'
ARCHIVE_BASE_PRIMORDIA_4_SIZE='1426833'
ARCHIVE_BASE_PRIMORDIA_4_VERSION='3.5b-gog69802'

ARCHIVE_BASE_PRIMORDIA_3_NAME='primordia_3_5a_69504.sh'
ARCHIVE_BASE_PRIMORDIA_3_MD5='62d64492018c9b7fe020303040c5dbe9'
ARCHIVE_BASE_PRIMORDIA_3_SIZE='1427316'
ARCHIVE_BASE_PRIMORDIA_3_VERSION='3.5a-gog69504'

ARCHIVE_BASE_PRIMORDIA_2_NAME='primordia_3_0a_65125.sh'
ARCHIVE_BASE_PRIMORDIA_2_MD5='5b096e36b814c16c0ce067046e194c94'
ARCHIVE_BASE_PRIMORDIA_2_SIZE='1500000'
ARCHIVE_BASE_PRIMORDIA_2_VERSION='3.0a-gog65125'

ARCHIVE_BASE_PRIMORDIA_1_NAME='primordia_3_58594.sh'
ARCHIVE_BASE_PRIMORDIA_1_MD5='3cd92a7767d561f2d982014117ee0576'
ARCHIVE_BASE_PRIMORDIA_1_SIZE='1500000'
ARCHIVE_BASE_PRIMORDIA_1_VERSION='3.0-gog58594'

ARCHIVE_BASE_PRIMORDIA_0_NAME='primordia_italian_53699.sh'
ARCHIVE_BASE_PRIMORDIA_0_MD5='812917de017fde37b1c448f156e4ae7d'
ARCHIVE_BASE_PRIMORDIA_0_SIZE='1500000'
ARCHIVE_BASE_PRIMORDIA_0_VERSION='2.6-gog53699'

## Strangeland

ARCHIVE_BASE_STRANGELAND_3_NAME='strangeland_3_57270.sh'
ARCHIVE_BASE_STRANGELAND_3_MD5='68e18616d01d902c0982a3a1d1a8e3cd'
ARCHIVE_BASE_STRANGELAND_3_SIZE='4400000'
ARCHIVE_BASE_STRANGELAND_3_VERSION='3.0-gog57270'
ARCHIVE_BASE_STRANGELAND_3_URL='https://www.gog.com/game/strangeland'

ARCHIVE_BASE_STRANGELAND_2_NAME='strangeland_2_7_55701.sh'
ARCHIVE_BASE_STRANGELAND_2_MD5='719e693167ba8014aea03b858d9cd9c1'
ARCHIVE_BASE_STRANGELAND_2_SIZE='4400000'
ARCHIVE_BASE_STRANGELAND_2_VERSION='2.7-gog55701'

ARCHIVE_BASE_STRANGELAND_1_NAME='strangeland_2_6c_54396.sh'
ARCHIVE_BASE_STRANGELAND_1_MD5='afa5999b3074480966c2226f2356f6b9'
ARCHIVE_BASE_STRANGELAND_1_SIZE='4400000'
ARCHIVE_BASE_STRANGELAND_1_VERSION='2.6c-gog54396'

ARCHIVE_BASE_STRANGELAND_0_NAME='strangeland_2_3a_49446.sh'
ARCHIVE_BASE_STRANGELAND_0_MD5='a313a7ee812815b5e53ebc643c53da76'
ARCHIVE_BASE_STRANGELAND_0_SIZE='4400000'
ARCHIVE_BASE_STRANGELAND_0_VERSION='2.3a-gog49446'


CONTENT_PATH_DEFAULT_PRIMORDIA='data/noarch/game'
CONTENT_PATH_DEFAULT_STRANGELAND='data/noarch/game/data'
CONTENT_GAME_MAIN_FILES='
ENGV.tmp
Music
Sounds
*.ags
*.cfg
*.exe
*.ogv
*.tra
*.vox'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_SCUMMID='ags'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Check for the presence of optional extra archives

case "$(current_archive)" in
	('ARCHIVE_BASE_PRIMORDIA_'*)
		ARCHIVE_OPTIONAL_ICONS_NAME='primordia_icons.tar.xz'
		ARCHIVE_OPTIONAL_ICONS_MD5='66c1d186075708574ee870a9015b4ff6'
		ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/primordia/'
	;;
esac
archive_initialize_optional \
	'ARCHIVE_ICONS' \
	'ARCHIVE_OPTIONAL_ICONS'

# Extract game data

archive_extraction_default
if archive_is_available 'ARCHIVE_ICONS'; then
	archive_extraction 'ARCHIVE_ICONS'
fi

# Include game data

if archive_is_available 'ARCHIVE_ICONS'; then
	case "$(current_archive)" in
		('ARCHIVE_BASE_PRIMORDIA_'*)
			CONTENT_ICONS_DATA_PATH='.'
			CONTENT_ICONS_DATA_FILES='
			16x16
			24x24
			32x32
			48x48
			256x256'
		;;
	esac
	content_inclusion 'ICONS_DATA' 'PKG_MAIN' "$(path_icons)"
else
	case "$(current_archive)" in
		('ARCHIVE_BASE_PRIMORDIA_0'|'ARCHIVE_BASE_PRIMORDIA_1'|'ARCHIVE_BASE_PRIMORDIA_2')
			APP_MAIN_ICON='Primordia.exe'
		;;
		('ARCHIVE_BASE_STRANGELAND_'*)
			## Strangeland.exe is too big, wrestool crashes when trying to handle it.
			APP_MAIN_ICON='winsetup.exe'
		;;
		(*)
			APP_MAIN_ICON='../support/icon.png'
		;;
	esac
	icons_inclusion
fi
content_inclusion_default

# Write launchers

launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
