\name{createMD5Sums}
\alias{createMD5Sums}
\alias{readMD5Sums}
\alias{compareMD5Sums}
\title{Create, Read, or Compare MD5 Checksums}
\description{Utility functions to create, read, or compare MD5 checksums. }
\usage{
createMD5Sums(files, path, out=NULL, recursive=FALSE, full.names=FALSE, 
              NA.remove=TRUE)
readMD5Sums(file)
compareMD5Sums(src, target, target.file=NULL, ignoreAdditionalFiles=FALSE,
               verbose=FALSE)
}
\arguments{
  \item{files}{character vector of files to be checksummed, either absolute
paths or paths relative to \code{path}}
  \item{path}{path to files to be checksummed}
  \item{out}{character string naming output file, if desired}
  \item{recursive}{logical flag specifying whether directories should be
checked recursively}
  \item{full.names}{logical flag specifying whether to use full path names as
checksum labels}
  \item{NA.remove}{logical flag specifying whether to remove NAs from the 
returned data frame}
  \item{file}{character string naming file containing md5 checksums}
  \item{src}{character string naming file containing reference md5 checksums}
  \item{target}{data frame containing md5 checksums to be verified by reference to \code{src}}
  \item{target.file}{character string naming file containing md5 checksums to be verified by reference to \code{src}}
  \item{ignoreAdditionalFiles}{logical flag specifying whether extra files in
\code{target} not in \code{src} should be ignored}
  \item{verbose}{logical flag specifying whether to print verbose output}
}

\examples{
src <- createMD5Sums(path=R.home())
\dontrun{
tgt <- readMD5Sums(file.path(R.home(), "R.md5"))
compareMD5Sums(src, tgt)
}
}
\keyword{programming}
