!{\src2tex{textfont=tt}}
!!****f* ABINIT/nmsq_pure_gkk
!!
!! NAME
!! nmsq_pure_gkk
!!
!! FUNCTION
!!  Calculate gamma matrices for pure gkk case, ie when the
!!  scalar product with the displacement vector is done later
!!  Sum over bands is carried out now.
!!
!! COPYRIGHT
!! Copyright (C) 2004-2007 ABINIT group (MVer)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   displ_red = phonon displacement in reduced coordinates (used to calculate the ph linewidth)
!!   elph_ds = datastructure with gkk matrix elements
!!   FSfullpqtofull = mapping of k+q to k
!!   FSintweight = FS integration weights for each band and kpt
!!   FSkpt = coordinates of kpoints near to FS
!!   h1_mat_el_sq = matrix elements $<psi_{k+q,m} | H^{1} | psi_{k,n}>$ squared
!!   iqptfull = index of present qpoint
!!   phfrq_tmp = phonon frequencies
!!   spqpt = array of qpoint coordinates
!!   wf = gkk matrix element weight with $1/\sqrt{2 M \omega}$
!!
!! OUTPUT
!!   elph_ds%gkq filled
!!   accum_mat = matrix for accumulating FS average of gkk (gamma matrix -> linewidths)
!!   accum_mat2 = complex array whose real part contains the phonon linewidth
!!   gkk_qpt_tmp = tmp matrix for all gamma matrix elements, saved to disk or to memory in nmsq_gam_sumFS
!!
!! NOTES
!!
!! PARENTS
!!      normsq_gkq
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine nmsq_pure_gkk(accum_mat,accum_mat2,displ_red,elph_ds,FSfullpqtofull,FSintweight,FSkpt,gkk_qpt_tmp,&
&   h1_mat_el_sq,iqptfull,phfrq_tmp,spqpt,wf)

 use defs_basis
 use defs_datatypes
 use defs_elphon

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqptfull
 type(elph_type),intent(inout) :: elph_ds
!arrays
 integer,intent(in) :: FSfullpqtofull(elph_ds%nFSkpt,elph_ds%nqpt)
 real(dp),intent(in) :: FSintweight(elph_ds%nFSband,elph_ds%nFSkpt)
 real(dp),intent(in) :: FSkpt(3,elph_ds%nFSkpt)
 real(dp),intent(in) :: displ_red(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp),intent(in) :: h1_mat_el_sq(2,elph_ds%nFSband,elph_ds%nFSband,elph_ds%nbranch,elph_ds%nbranch,elph_ds%nFSkpt)
 real(dp),intent(in) :: phfrq_tmp(elph_ds%nbranch),spqpt(3,elph_ds%nqpt)
 real(dp),intent(in) :: wf(elph_ds%nbranch)
 real(dp),intent(inout) :: accum_mat(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp),intent(inout) :: accum_mat2(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp),intent(inout) :: gkk_qpt_tmp(2,elph_ds%ngkkband,elph_ds%ngkkband,elph_ds%nbranch,elph_ds%nbranch,elph_ds%nFSkpt)

!Local variables-------------------------------
!scalars
 integer :: goodkpq,iFSkpt,iFSkptq,ib1,ib2,ibranch,ipert1,jbranch,kbranch
 real(dp) :: res,sd1,sd2,ss
 character(len=500) :: message
!arrays
 real(dp) :: gkq(3),gkq_sum_bands(2,elph_ds%nbranch,elph_ds%nbranch),kpt(3)
 real(dp) :: redkpt(3),tmp_mat2(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp) :: zgemm_tmp_mat(2,elph_ds%nbranch,elph_ds%nbranch)

! *************************************************************************

#ifdef __VMS
!DEC$ ATTRIBUTES ALIAS:'ZGEMM' :: zgemm
#endif

 if (elph_ds%tkeepbands /= 0) then
  write (message,'(3a)')' nmsq_pure_gkk : BUG- ',ch10,&
&  ' elph_ds%tkeepbands should be 0 to average over bands!'
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if

 !MG20060603 NOTE:
 !           accum_mat and accum_mat2 are real, the imaginary part is used for debugging purpose
 !           accum_mat2 is used to store the phonon-linewidhts before interpolation

  do iFSkpt=1,elph_ds%nFSkpt

     iFSkptq = FSfullpqtofull(iFSkpt,iqptfull)

     gkq_sum_bands(:,:,:) = zero

     !  gkq_sum_bands = \sum_{ib1,ib2} \langle k+q \mid H^{(1)}_{q,\tau_i,\alpha_i} \mid k   \rangle
     !                     \cdot \langle k   \mid H^{(1)}_{q,\tau_j,\alpha_j} \mid k+q \rangle
     !   where ibranch -> \tau_i,\alpha_i  and  jbranch -> \tau_j,\alpha_j

     do ib1=1,elph_ds%nFSband

        sd1 = FSintweight(ib1,iFSkpt)      !  weights for distance from the fermi surface

        do ib2=1,elph_ds%nFSband

           sd2 = FSintweight(ib2,iFSkptq)  !  weights for distance from the fermi surface

           ! index for the reduced direction of each atom
           do jbranch=1,elph_ds%nbranch

              !
              !08/04/2004 do scalar product later in interpolate routine.
              !    Use complex conj of h1_mat_el_sq(jbranch)
              !  WARNING: wf is counted here and not in mode-dependent case when scalar product with
              !     displ is carried out. Is a constant, so dont care too much right now
              ! 27/2/2006: update: wf not counted, to keep gkk matrix pure (no phonon mode info)
              do ibranch=1,elph_ds%nbranch
                 gkq_sum_bands(1,ibranch,jbranch) = gkq_sum_bands(1,ibranch,jbranch) + &
                      &   sd1*sd2*pi*h1_mat_el_sq(1,ib2,ib1,ibranch,jbranch,iFSkpt)

                 gkq_sum_bands(2,ibranch,jbranch) = gkq_sum_bands(2,ibranch,jbranch) + &
                      &   sd1*sd2*pi*h1_mat_el_sq(2,ib2,ib1,ibranch,jbranch,iFSkpt)

              end do !ibranch
           end do !jbranch
        end do !ib2
     end do !ib1
     ! END loops over bands


     !! gamma matrix contribution in cartesian coordinates (ie interpolatable form)
     ! gamma matrix contribution in reduced coordinates (ie interpolatable form)
     gkk_qpt_tmp(:,1,1,:,:,iFSkpt) = gkk_qpt_tmp(:,1,1,:,:,iFSkpt) + gkq_sum_bands(:,:,:)

     accum_mat(:,:,:) = accum_mat(:,:,:) + gkq_sum_bands(:,:,:)
  end do
  !  END loop over FSkpt

!MG20060603
!do scalar product with the displ_red to calculate the ph lwdth before interpolation (stored in accum_mat2)

!OLDVERSION
!  do jbranch=1,elph_ds%nbranch !branch index
!
!   !calculate displ_red^{*T} accum_mat displ_red
!   do ibranch=1,elph_ds%nbranch  !atomic direction
!    do kbranch=1,elph_ds%nbranch !atomic direction
!
!     accum_mat2(1,jbranch,jbranch) = accum_mat2(1,jbranch,jbranch)                            &
!&     +displ_red(1,ibranch,jbranch)*accum_mat(1,ibranch,kbranch)*displ_red(1,kbranch,jbranch) &
!&     +displ_red(2,ibranch,jbranch)*accum_mat(2,ibranch,kbranch)*displ_red(1,kbranch,jbranch) &
!&     -displ_red(1,ibranch,jbranch)*accum_mat(2,ibranch,kbranch)*displ_red(2,kbranch,jbranch) &
!&     +displ_red(2,ibranch,jbranch)*accum_mat(1,ibranch,kbranch)*displ_red(2,kbranch,jbranch)
!
!      accum_mat2(2,jbranch,jbranch) = accum_mat2(2,jbranch,jbranch)                            &
!&      +displ_red(1,ibranch,jbranch)*accum_mat(2,ibranch,kbranch)*displ_red(1,kbranch,jbranch) &
!&      -displ_red(2,ibranch,jbranch)*accum_mat(1,ibranch,kbranch)*displ_red(1,kbranch,jbranch) &
!&      +displ_red(1,ibranch,jbranch)*accum_mat(1,ibranch,kbranch)*displ_red(2,kbranch,jbranch) &
!&      +displ_red(2,ibranch,jbranch)*accum_mat(2,ibranch,kbranch)*displ_red(2,kbranch,jbranch)
!
!    end do
!   end do
!
!   if ( abs(accum_mat2(2,jbranch,jbranch)) > tol8 ) then
!      write (message,'(3a,es16.8)')' nmsq_pure_gkk : WARNING- accum_mat2 not real!',ch10,&
!&     ' Im(accum_mat2) = ',accum_mat2(2,jbranch,jbranch)
!      call wrtout(06,message,'COLL')
!   end if
!
!  end do
!ENDOLDVERSION

  zgemm_tmp_mat=zero
  tmp_mat2 = accum_mat
  call zgemm('c','n',elph_ds%nbranch,elph_ds%nbranch,elph_ds%nbranch,cone,&
    &    displ_red,elph_ds%nbranch,tmp_mat2,&
    &    elph_ds%nbranch,czero,zgemm_tmp_mat,elph_ds%nbranch)

  !MG20060607 there is no explicit dependence on omega in the linewidth.
  !It is better dont use wf at all and employ the same approach as in nmsq_gam or nmsq_pure_gkk
  tmp_mat2=zero
  call zgemm('n','n',elph_ds%nbranch,elph_ds%nbranch,elph_ds%nbranch,cone,&
    &    zgemm_tmp_mat,elph_ds%nbranch,displ_red,&
    &    elph_ds%nbranch,czero,tmp_mat2,elph_ds%nbranch)

  do ipert1=1,elph_ds%nbranch
    accum_mat2(1,ipert1,ipert1) = accum_mat2(1,ipert1,ipert1) + tmp_mat2(1,ipert1,ipert1)
  end do

!ENDMG

!DEBUG
!write(73,'(a,3es16.8)')'#nmsq_pure_gkk QPT ',spqpt(:,iqptfull)
!write(73,'(3es16.8,3(2e16.8))')(accum_mat2(1,jbranch,jbranch), jbranch=1,elph_ds%nbranch)
!ENDDEBUG

end subroutine nmsq_pure_gkk
!!***
