!!****h* BigDFT/lazy_16
!! NAME
!!   lazy_16
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 16)
!!
!! SOURCE
!!
integer, parameter :: m=18
real(dp), dimension(-m:m) :: ch = (/&
     0._dp,0._dp,0._dp,-6.39259815216064453D-6,0.e0_dp,0.000110641121864318848e0_dp,0.e0_dp,&
     -0.000915303826332092285e0_dp,0.e0_dp,0.00484772026538848877e0_dp,0.e0_dp,&
     -0.0186983495950698853e0_dp,0.e0_dp,0.0575909167528152466e0_dp,0.e0_dp,&
     -0.159974768757820129e0_dp,0.e0_dp,0.617045536637306213e0_dp,1.e0_dp,0.617045536637306213e0_dp,&
     0e0_dp,-0.159974768757820129e0_dp,0.e0_dp,0.0575909167528152466e0_dp,0.e0_dp,&
     -0.0186983495950698853e0_dp,0.e0_dp,0.00484772026538848877e0_dp,0.e0_dp,&
     -0.000915303826332092285e0_dp,0.e0_dp,0.000110641121864318848e0_dp,0.e0_dp,&
     -6.39259815216064453D-6,0._dp,0._dp,0._dp&
     /)
real(dp), dimension(-m:m) :: cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1.e0_dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***

