# -*- Autoconf -*-
#
# Copyright (C) 2005-2014 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-dirflags on 2014/07/25 13:53:16 +0000

#
# Per-directory optimization support
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-dirflags
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# ABI_OPTFLAGS_DIRS(FCFLAGS_OPTIM)
# --------------------------------
#
# Initializes optimization flags on a per-directory basis. Currently
# limited to Fortran.
#
AC_DEFUN([ABI_OPTFLAGS_DIRS],[
  dnl Check arguments
  m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

  AC_MSG_CHECKING([whether to apply per-directory optimizations])
  if test "${enable_optim}" = "no" -o "${FCFLAGS}" != ""; then
    AC_MSG_RESULT([no])
  else
    AC_MSG_RESULT([yes])
  fi

  dnl Set default
  fcflags_opt_default="$1"
  echo "fcflags_opt_default='${fcflags_opt_default}'" >config.optim
  fcflags_opt_dirlist=""

  dnl atompaw library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_atompaw}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_atompaw="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for atompaw is ${fcflags_opt_atompaw}])
      echo "fcflags_opt_atompaw='${fcflags_opt_atompaw}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} atompaw"
    fi
  else
    if test "${fcflags_opt_atompaw}" != ""; then
      fcflags_opt_atompaw=""
      AC_MSG_NOTICE([fcflags_opt_atompaw overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_atompaw)

  dnl algo library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_algo}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_algo="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for algo is ${fcflags_opt_algo}])
      echo "fcflags_opt_algo='${fcflags_opt_algo}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} algo"
    fi
  else
    if test "${fcflags_opt_algo}" != ""; then
      fcflags_opt_algo=""
      AC_MSG_NOTICE([fcflags_opt_algo overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_algo)

  dnl bigdft library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_bigdft}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_bigdft="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for bigdft is ${fcflags_opt_bigdft}])
      echo "fcflags_opt_bigdft='${fcflags_opt_bigdft}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} bigdft"
    fi
  else
    if test "${fcflags_opt_bigdft}" != ""; then
      fcflags_opt_bigdft=""
      AC_MSG_NOTICE([fcflags_opt_bigdft overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_bigdft)

  dnl etsf_io library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_etsf_io}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_etsf_io="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for etsf_io is ${fcflags_opt_etsf_io}])
      echo "fcflags_opt_etsf_io='${fcflags_opt_etsf_io}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} etsf_io"
    fi
  else
    if test "${fcflags_opt_etsf_io}" != ""; then
      fcflags_opt_etsf_io=""
      AC_MSG_NOTICE([fcflags_opt_etsf_io overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_etsf_io)

  dnl fox library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_fox}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_fox="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for fox is ${fcflags_opt_fox}])
      echo "fcflags_opt_fox='${fcflags_opt_fox}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} fox"
    fi
  else
    if test "${fcflags_opt_fox}" != ""; then
      fcflags_opt_fox=""
      AC_MSG_NOTICE([fcflags_opt_fox overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_fox)

  dnl libpspio library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_libpspio}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_libpspio="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for libpspio is ${fcflags_opt_libpspio}])
      echo "fcflags_opt_libpspio='${fcflags_opt_libpspio}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} libpspio"
    fi
  else
    if test "${fcflags_opt_libpspio}" != ""; then
      fcflags_opt_libpspio=""
      AC_MSG_NOTICE([fcflags_opt_libpspio overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_libpspio)

  dnl libxc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_libxc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_libxc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for libxc is ${fcflags_opt_libxc}])
      echo "fcflags_opt_libxc='${fcflags_opt_libxc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} libxc"
    fi
  else
    if test "${fcflags_opt_libxc}" != ""; then
      fcflags_opt_libxc=""
      AC_MSG_NOTICE([fcflags_opt_libxc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_libxc)

  dnl linalg library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_linalg}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_linalg="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for linalg is ${fcflags_opt_linalg}])
      echo "fcflags_opt_linalg='${fcflags_opt_linalg}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} linalg"
    fi
  else
    if test "${fcflags_opt_linalg}" != ""; then
      fcflags_opt_linalg=""
      AC_MSG_NOTICE([fcflags_opt_linalg overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_linalg)

  dnl netcdf library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_netcdf}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_netcdf="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for netcdf is ${fcflags_opt_netcdf}])
      echo "fcflags_opt_netcdf='${fcflags_opt_netcdf}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} netcdf"
    fi
  else
    if test "${fcflags_opt_netcdf}" != ""; then
      fcflags_opt_netcdf=""
      AC_MSG_NOTICE([fcflags_opt_netcdf overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_netcdf)

  dnl wannier90 library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_wannier90}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_wannier90="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for wannier90 is ${fcflags_opt_wannier90}])
      echo "fcflags_opt_wannier90='${fcflags_opt_wannier90}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} wannier90"
    fi
  else
    if test "${fcflags_opt_wannier90}" != ""; then
      fcflags_opt_wannier90=""
      AC_MSG_NOTICE([fcflags_opt_wannier90 overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_wannier90)

  dnl yaml library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_yaml}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_yaml="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for yaml is ${fcflags_opt_yaml}])
      echo "fcflags_opt_yaml='${fcflags_opt_yaml}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} yaml"
    fi
  else
    if test "${fcflags_opt_yaml}" != ""; then
      fcflags_opt_yaml=""
      AC_MSG_NOTICE([fcflags_opt_yaml overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_yaml)

  dnl 01_gsl_ext library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_01_gsl_ext}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_01_gsl_ext="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 01_gsl_ext is ${fcflags_opt_01_gsl_ext}])
      echo "fcflags_opt_01_gsl_ext='${fcflags_opt_01_gsl_ext}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 01_gsl_ext"
    fi
  else
    if test "${fcflags_opt_01_gsl_ext}" != ""; then
      fcflags_opt_01_gsl_ext=""
      AC_MSG_NOTICE([fcflags_opt_01_gsl_ext overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_01_gsl_ext)

  dnl 01_interfaces_ext library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_01_interfaces_ext}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_01_interfaces_ext="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 01_interfaces_ext is ${fcflags_opt_01_interfaces_ext}])
      echo "fcflags_opt_01_interfaces_ext='${fcflags_opt_01_interfaces_ext}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 01_interfaces_ext"
    fi
  else
    if test "${fcflags_opt_01_interfaces_ext}" != ""; then
      fcflags_opt_01_interfaces_ext=""
      AC_MSG_NOTICE([fcflags_opt_01_interfaces_ext overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_01_interfaces_ext)

  dnl 01_linalg_ext library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_01_linalg_ext}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_01_linalg_ext="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 01_linalg_ext is ${fcflags_opt_01_linalg_ext}])
      echo "fcflags_opt_01_linalg_ext='${fcflags_opt_01_linalg_ext}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 01_linalg_ext"
    fi
  else
    if test "${fcflags_opt_01_linalg_ext}" != ""; then
      fcflags_opt_01_linalg_ext=""
      AC_MSG_NOTICE([fcflags_opt_01_linalg_ext overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_01_linalg_ext)

  dnl 01_macroavnew_ext library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_01_macroavnew_ext}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_01_macroavnew_ext="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 01_macroavnew_ext is ${fcflags_opt_01_macroavnew_ext}])
      echo "fcflags_opt_01_macroavnew_ext='${fcflags_opt_01_macroavnew_ext}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 01_macroavnew_ext"
    fi
  else
    if test "${fcflags_opt_01_macroavnew_ext}" != ""; then
      fcflags_opt_01_macroavnew_ext=""
      AC_MSG_NOTICE([fcflags_opt_01_macroavnew_ext overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_01_macroavnew_ext)

  dnl 02_clib library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_02_clib}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_02_clib="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 02_clib is ${fcflags_opt_02_clib}])
      echo "fcflags_opt_02_clib='${fcflags_opt_02_clib}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 02_clib"
    fi
  else
    if test "${fcflags_opt_02_clib}" != ""; then
      fcflags_opt_02_clib=""
      AC_MSG_NOTICE([fcflags_opt_02_clib overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_02_clib)

  dnl 10_defs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_10_defs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_10_defs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 10_defs is ${fcflags_opt_10_defs}])
      echo "fcflags_opt_10_defs='${fcflags_opt_10_defs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 10_defs"
    fi
  else
    if test "${fcflags_opt_10_defs}" != ""; then
      fcflags_opt_10_defs=""
      AC_MSG_NOTICE([fcflags_opt_10_defs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_10_defs)

  dnl 10_dumpinfo library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_10_dumpinfo}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_10_dumpinfo="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 10_dumpinfo is ${fcflags_opt_10_dumpinfo}])
      echo "fcflags_opt_10_dumpinfo='${fcflags_opt_10_dumpinfo}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 10_dumpinfo"
    fi
  else
    if test "${fcflags_opt_10_dumpinfo}" != ""; then
      fcflags_opt_10_dumpinfo=""
      AC_MSG_NOTICE([fcflags_opt_10_dumpinfo overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_10_dumpinfo)

  dnl 11_memory_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_11_memory_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_11_memory_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 11_memory_mpi is ${fcflags_opt_11_memory_mpi}])
      echo "fcflags_opt_11_memory_mpi='${fcflags_opt_11_memory_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 11_memory_mpi"
    fi
  else
    if test "${fcflags_opt_11_memory_mpi}" != ""; then
      fcflags_opt_11_memory_mpi=""
      AC_MSG_NOTICE([fcflags_opt_11_memory_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_11_memory_mpi)

  dnl 11_qespresso_ext library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_11_qespresso_ext}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_11_qespresso_ext="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 11_qespresso_ext is ${fcflags_opt_11_qespresso_ext}])
      echo "fcflags_opt_11_qespresso_ext='${fcflags_opt_11_qespresso_ext}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 11_qespresso_ext"
    fi
  else
    if test "${fcflags_opt_11_qespresso_ext}" != ""; then
      fcflags_opt_11_qespresso_ext=""
      AC_MSG_NOTICE([fcflags_opt_11_qespresso_ext overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_11_qespresso_ext)

  dnl 12_hide_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_12_hide_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_12_hide_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 12_hide_mpi is ${fcflags_opt_12_hide_mpi}])
      echo "fcflags_opt_12_hide_mpi='${fcflags_opt_12_hide_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 12_hide_mpi"
    fi
  else
    if test "${fcflags_opt_12_hide_mpi}" != ""; then
      fcflags_opt_12_hide_mpi=""
      AC_MSG_NOTICE([fcflags_opt_12_hide_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_12_hide_mpi)

  dnl 14_hidewrite library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_14_hidewrite}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_14_hidewrite="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 14_hidewrite is ${fcflags_opt_14_hidewrite}])
      echo "fcflags_opt_14_hidewrite='${fcflags_opt_14_hidewrite}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 14_hidewrite"
    fi
  else
    if test "${fcflags_opt_14_hidewrite}" != ""; then
      fcflags_opt_14_hidewrite=""
      AC_MSG_NOTICE([fcflags_opt_14_hidewrite overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_14_hidewrite)

  dnl 15_gpu_toolbox library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_15_gpu_toolbox}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_15_gpu_toolbox="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 15_gpu_toolbox is ${fcflags_opt_15_gpu_toolbox}])
      echo "fcflags_opt_15_gpu_toolbox='${fcflags_opt_15_gpu_toolbox}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 15_gpu_toolbox"
    fi
  else
    if test "${fcflags_opt_15_gpu_toolbox}" != ""; then
      fcflags_opt_15_gpu_toolbox=""
      AC_MSG_NOTICE([fcflags_opt_15_gpu_toolbox overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_15_gpu_toolbox)

  dnl 16_hideleave library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_16_hideleave}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_16_hideleave="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 16_hideleave is ${fcflags_opt_16_hideleave}])
      echo "fcflags_opt_16_hideleave='${fcflags_opt_16_hideleave}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 16_hideleave"
    fi
  else
    if test "${fcflags_opt_16_hideleave}" != ""; then
      fcflags_opt_16_hideleave=""
      AC_MSG_NOTICE([fcflags_opt_16_hideleave overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_16_hideleave)

  dnl 18_timing library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_18_timing}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_18_timing="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 18_timing is ${fcflags_opt_18_timing}])
      echo "fcflags_opt_18_timing='${fcflags_opt_18_timing}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 18_timing"
    fi
  else
    if test "${fcflags_opt_18_timing}" != ""; then
      fcflags_opt_18_timing=""
      AC_MSG_NOTICE([fcflags_opt_18_timing overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_18_timing)

  dnl 21_psiesta_noabirule library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_21_psiesta_noabirule}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_21_psiesta_noabirule="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 21_psiesta_noabirule is ${fcflags_opt_21_psiesta_noabirule}])
      echo "fcflags_opt_21_psiesta_noabirule='${fcflags_opt_21_psiesta_noabirule}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 21_psiesta_noabirule"
    fi
  else
    if test "${fcflags_opt_21_psiesta_noabirule}" != ""; then
      fcflags_opt_21_psiesta_noabirule=""
      AC_MSG_NOTICE([fcflags_opt_21_psiesta_noabirule overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_21_psiesta_noabirule)

  dnl 27_toolbox_oop library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_27_toolbox_oop}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_27_toolbox_oop="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 27_toolbox_oop is ${fcflags_opt_27_toolbox_oop}])
      echo "fcflags_opt_27_toolbox_oop='${fcflags_opt_27_toolbox_oop}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 27_toolbox_oop"
    fi
  else
    if test "${fcflags_opt_27_toolbox_oop}" != ""; then
      fcflags_opt_27_toolbox_oop=""
      AC_MSG_NOTICE([fcflags_opt_27_toolbox_oop overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_27_toolbox_oop)

  dnl 28_numeric_noabirule library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_28_numeric_noabirule}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_28_numeric_noabirule="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 28_numeric_noabirule is ${fcflags_opt_28_numeric_noabirule}])
      echo "fcflags_opt_28_numeric_noabirule='${fcflags_opt_28_numeric_noabirule}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 28_numeric_noabirule"
    fi
  else
    if test "${fcflags_opt_28_numeric_noabirule}" != ""; then
      fcflags_opt_28_numeric_noabirule=""
      AC_MSG_NOTICE([fcflags_opt_28_numeric_noabirule overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_28_numeric_noabirule)

  dnl 32_util library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_32_util}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_32_util="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 32_util is ${fcflags_opt_32_util}])
      echo "fcflags_opt_32_util='${fcflags_opt_32_util}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 32_util"
    fi
  else
    if test "${fcflags_opt_32_util}" != ""; then
      fcflags_opt_32_util=""
      AC_MSG_NOTICE([fcflags_opt_32_util overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_32_util)

  dnl 41_geometry library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_41_geometry}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_41_geometry="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 41_geometry is ${fcflags_opt_41_geometry}])
      echo "fcflags_opt_41_geometry='${fcflags_opt_41_geometry}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 41_geometry"
    fi
  else
    if test "${fcflags_opt_41_geometry}" != ""; then
      fcflags_opt_41_geometry=""
      AC_MSG_NOTICE([fcflags_opt_41_geometry overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_41_geometry)

  dnl 41_xc_lowlevel library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_41_xc_lowlevel}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_41_xc_lowlevel="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 41_xc_lowlevel is ${fcflags_opt_41_xc_lowlevel}])
      echo "fcflags_opt_41_xc_lowlevel='${fcflags_opt_41_xc_lowlevel}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 41_xc_lowlevel"
    fi
  else
    if test "${fcflags_opt_41_xc_lowlevel}" != ""; then
      fcflags_opt_41_xc_lowlevel=""
      AC_MSG_NOTICE([fcflags_opt_41_xc_lowlevel overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_41_xc_lowlevel)

  dnl 42_libpaw library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_42_libpaw}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_42_libpaw="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 42_libpaw is ${fcflags_opt_42_libpaw}])
      echo "fcflags_opt_42_libpaw='${fcflags_opt_42_libpaw}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 42_libpaw"
    fi
  else
    if test "${fcflags_opt_42_libpaw}" != ""; then
      fcflags_opt_42_libpaw=""
      AC_MSG_NOTICE([fcflags_opt_42_libpaw overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_42_libpaw)

  dnl 42_nlstrain library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_42_nlstrain}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_42_nlstrain="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 42_nlstrain is ${fcflags_opt_42_nlstrain}])
      echo "fcflags_opt_42_nlstrain='${fcflags_opt_42_nlstrain}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 42_nlstrain"
    fi
  else
    if test "${fcflags_opt_42_nlstrain}" != ""; then
      fcflags_opt_42_nlstrain=""
      AC_MSG_NOTICE([fcflags_opt_42_nlstrain overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_42_nlstrain)

  dnl 42_parser library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_42_parser}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_42_parser="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 42_parser is ${fcflags_opt_42_parser}])
      echo "fcflags_opt_42_parser='${fcflags_opt_42_parser}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 42_parser"
    fi
  else
    if test "${fcflags_opt_42_parser}" != ""; then
      fcflags_opt_42_parser=""
      AC_MSG_NOTICE([fcflags_opt_42_parser overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_42_parser)

  dnl 43_ptgroups library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_43_ptgroups}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_43_ptgroups="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 43_ptgroups is ${fcflags_opt_43_ptgroups}])
      echo "fcflags_opt_43_ptgroups='${fcflags_opt_43_ptgroups}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 43_ptgroups"
    fi
  else
    if test "${fcflags_opt_43_ptgroups}" != ""; then
      fcflags_opt_43_ptgroups=""
      AC_MSG_NOTICE([fcflags_opt_43_ptgroups overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_43_ptgroups)

  dnl 43_wvl_wrappers library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_43_wvl_wrappers}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_43_wvl_wrappers="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 43_wvl_wrappers is ${fcflags_opt_43_wvl_wrappers}])
      echo "fcflags_opt_43_wvl_wrappers='${fcflags_opt_43_wvl_wrappers}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 43_wvl_wrappers"
    fi
  else
    if test "${fcflags_opt_43_wvl_wrappers}" != ""; then
      fcflags_opt_43_wvl_wrappers=""
      AC_MSG_NOTICE([fcflags_opt_43_wvl_wrappers overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_43_wvl_wrappers)

  dnl 44_abitypes_defs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_44_abitypes_defs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_44_abitypes_defs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 44_abitypes_defs is ${fcflags_opt_44_abitypes_defs}])
      echo "fcflags_opt_44_abitypes_defs='${fcflags_opt_44_abitypes_defs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 44_abitypes_defs"
    fi
  else
    if test "${fcflags_opt_44_abitypes_defs}" != ""; then
      fcflags_opt_44_abitypes_defs=""
      AC_MSG_NOTICE([fcflags_opt_44_abitypes_defs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_44_abitypes_defs)

  dnl 45_geomoptim library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_45_geomoptim}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_45_geomoptim="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 45_geomoptim is ${fcflags_opt_45_geomoptim}])
      echo "fcflags_opt_45_geomoptim='${fcflags_opt_45_geomoptim}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 45_geomoptim"
    fi
  else
    if test "${fcflags_opt_45_geomoptim}" != ""; then
      fcflags_opt_45_geomoptim=""
      AC_MSG_NOTICE([fcflags_opt_45_geomoptim overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_45_geomoptim)

  dnl 47_xml library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_47_xml}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_47_xml="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 47_xml is ${fcflags_opt_47_xml}])
      echo "fcflags_opt_47_xml='${fcflags_opt_47_xml}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 47_xml"
    fi
  else
    if test "${fcflags_opt_47_xml}" != ""; then
      fcflags_opt_47_xml=""
      AC_MSG_NOTICE([fcflags_opt_47_xml overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_47_xml)

  dnl 49_gw_toolbox_oop library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_49_gw_toolbox_oop}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_49_gw_toolbox_oop="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 49_gw_toolbox_oop is ${fcflags_opt_49_gw_toolbox_oop}])
      echo "fcflags_opt_49_gw_toolbox_oop='${fcflags_opt_49_gw_toolbox_oop}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 49_gw_toolbox_oop"
    fi
  else
    if test "${fcflags_opt_49_gw_toolbox_oop}" != ""; then
      fcflags_opt_49_gw_toolbox_oop=""
      AC_MSG_NOTICE([fcflags_opt_49_gw_toolbox_oop overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_49_gw_toolbox_oop)

  dnl 51_manage_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_51_manage_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_51_manage_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 51_manage_mpi is ${fcflags_opt_51_manage_mpi}])
      echo "fcflags_opt_51_manage_mpi='${fcflags_opt_51_manage_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 51_manage_mpi"
    fi
  else
    if test "${fcflags_opt_51_manage_mpi}" != ""; then
      fcflags_opt_51_manage_mpi=""
      AC_MSG_NOTICE([fcflags_opt_51_manage_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_51_manage_mpi)

  dnl 52_fft_mpi_noabirule library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_52_fft_mpi_noabirule}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_52_fft_mpi_noabirule="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 52_fft_mpi_noabirule is ${fcflags_opt_52_fft_mpi_noabirule}])
      echo "fcflags_opt_52_fft_mpi_noabirule='${fcflags_opt_52_fft_mpi_noabirule}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 52_fft_mpi_noabirule"
    fi
  else
    if test "${fcflags_opt_52_fft_mpi_noabirule}" != ""; then
      fcflags_opt_52_fft_mpi_noabirule=""
      AC_MSG_NOTICE([fcflags_opt_52_fft_mpi_noabirule overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_52_fft_mpi_noabirule)

  dnl 52_manage_cuda library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_52_manage_cuda}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_52_manage_cuda="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 52_manage_cuda is ${fcflags_opt_52_manage_cuda}])
      echo "fcflags_opt_52_manage_cuda='${fcflags_opt_52_manage_cuda}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 52_manage_cuda"
    fi
  else
    if test "${fcflags_opt_52_manage_cuda}" != ""; then
      fcflags_opt_52_manage_cuda=""
      AC_MSG_NOTICE([fcflags_opt_52_manage_cuda overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_52_manage_cuda)

  dnl 53_abiutil library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_53_abiutil}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_53_abiutil="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 53_abiutil is ${fcflags_opt_53_abiutil}])
      echo "fcflags_opt_53_abiutil='${fcflags_opt_53_abiutil}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 53_abiutil"
    fi
  else
    if test "${fcflags_opt_53_abiutil}" != ""; then
      fcflags_opt_53_abiutil=""
      AC_MSG_NOTICE([fcflags_opt_53_abiutil overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_53_abiutil)

  dnl 53_ffts library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_53_ffts}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_53_ffts="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 53_ffts is ${fcflags_opt_53_ffts}])
      echo "fcflags_opt_53_ffts='${fcflags_opt_53_ffts}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 53_ffts"
    fi
  else
    if test "${fcflags_opt_53_ffts}" != ""; then
      fcflags_opt_53_ffts=""
      AC_MSG_NOTICE([fcflags_opt_53_ffts overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_53_ffts)

  dnl 53_spacepar library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_53_spacepar}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_53_spacepar="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 53_spacepar is ${fcflags_opt_53_spacepar}])
      echo "fcflags_opt_53_spacepar='${fcflags_opt_53_spacepar}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 53_spacepar"
    fi
  else
    if test "${fcflags_opt_53_spacepar}" != ""; then
      fcflags_opt_53_spacepar=""
      AC_MSG_NOTICE([fcflags_opt_53_spacepar overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_53_spacepar)

  dnl 56_io_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_56_io_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_56_io_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 56_io_mpi is ${fcflags_opt_56_io_mpi}])
      echo "fcflags_opt_56_io_mpi='${fcflags_opt_56_io_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 56_io_mpi"
    fi
  else
    if test "${fcflags_opt_56_io_mpi}" != ""; then
      fcflags_opt_56_io_mpi=""
      AC_MSG_NOTICE([fcflags_opt_56_io_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_56_io_mpi)

  dnl 56_mixing library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_56_mixing}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_56_mixing="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 56_mixing is ${fcflags_opt_56_mixing}])
      echo "fcflags_opt_56_mixing='${fcflags_opt_56_mixing}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 56_mixing"
    fi
  else
    if test "${fcflags_opt_56_mixing}" != ""; then
      fcflags_opt_56_mixing=""
      AC_MSG_NOTICE([fcflags_opt_56_mixing overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_56_mixing)

  dnl 56_recipspace library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_56_recipspace}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_56_recipspace="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 56_recipspace is ${fcflags_opt_56_recipspace}])
      echo "fcflags_opt_56_recipspace='${fcflags_opt_56_recipspace}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 56_recipspace"
    fi
  else
    if test "${fcflags_opt_56_recipspace}" != ""; then
      fcflags_opt_56_recipspace=""
      AC_MSG_NOTICE([fcflags_opt_56_recipspace overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_56_recipspace)

  dnl 56_xc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_56_xc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_56_xc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 56_xc is ${fcflags_opt_56_xc}])
      echo "fcflags_opt_56_xc='${fcflags_opt_56_xc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 56_xc"
    fi
  else
    if test "${fcflags_opt_56_xc}" != ""; then
      fcflags_opt_56_xc=""
      AC_MSG_NOTICE([fcflags_opt_56_xc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_56_xc)

  dnl 57_iopsp_parser library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_57_iopsp_parser}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_57_iopsp_parser="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 57_iopsp_parser is ${fcflags_opt_57_iopsp_parser}])
      echo "fcflags_opt_57_iopsp_parser='${fcflags_opt_57_iopsp_parser}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 57_iopsp_parser"
    fi
  else
    if test "${fcflags_opt_57_iopsp_parser}" != ""; then
      fcflags_opt_57_iopsp_parser=""
      AC_MSG_NOTICE([fcflags_opt_57_iopsp_parser overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_57_iopsp_parser)

  dnl 57_iovars library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_57_iovars}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_57_iovars="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 57_iovars is ${fcflags_opt_57_iovars}])
      echo "fcflags_opt_57_iovars='${fcflags_opt_57_iovars}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 57_iovars"
    fi
  else
    if test "${fcflags_opt_57_iovars}" != ""; then
      fcflags_opt_57_iovars=""
      AC_MSG_NOTICE([fcflags_opt_57_iovars overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_57_iovars)

  dnl 61_ionetcdf library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_61_ionetcdf}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_61_ionetcdf="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 61_ionetcdf is ${fcflags_opt_61_ionetcdf}])
      echo "fcflags_opt_61_ionetcdf='${fcflags_opt_61_ionetcdf}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 61_ionetcdf"
    fi
  else
    if test "${fcflags_opt_61_ionetcdf}" != ""; then
      fcflags_opt_61_ionetcdf=""
      AC_MSG_NOTICE([fcflags_opt_61_ionetcdf overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_61_ionetcdf)

  dnl 62_cg_noabirule library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_cg_noabirule}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_cg_noabirule="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_cg_noabirule is ${fcflags_opt_62_cg_noabirule}])
      echo "fcflags_opt_62_cg_noabirule='${fcflags_opt_62_cg_noabirule}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_cg_noabirule"
    fi
  else
    if test "${fcflags_opt_62_cg_noabirule}" != ""; then
      fcflags_opt_62_cg_noabirule=""
      AC_MSG_NOTICE([fcflags_opt_62_cg_noabirule overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_cg_noabirule)

  dnl 62_ctqmc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_ctqmc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_ctqmc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_ctqmc is ${fcflags_opt_62_ctqmc}])
      echo "fcflags_opt_62_ctqmc='${fcflags_opt_62_ctqmc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_ctqmc"
    fi
  else
    if test "${fcflags_opt_62_ctqmc}" != ""; then
      fcflags_opt_62_ctqmc=""
      AC_MSG_NOTICE([fcflags_opt_62_ctqmc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_ctqmc)

  dnl 62_iowfdenpot library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_iowfdenpot}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_iowfdenpot="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_iowfdenpot is ${fcflags_opt_62_iowfdenpot}])
      echo "fcflags_opt_62_iowfdenpot='${fcflags_opt_62_iowfdenpot}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_iowfdenpot"
    fi
  else
    if test "${fcflags_opt_62_iowfdenpot}" != ""; then
      fcflags_opt_62_iowfdenpot=""
      AC_MSG_NOTICE([fcflags_opt_62_iowfdenpot overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_iowfdenpot)

  dnl 62_occeig library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_occeig}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_occeig="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_occeig is ${fcflags_opt_62_occeig}])
      echo "fcflags_opt_62_occeig='${fcflags_opt_62_occeig}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_occeig"
    fi
  else
    if test "${fcflags_opt_62_occeig}" != ""; then
      fcflags_opt_62_occeig=""
      AC_MSG_NOTICE([fcflags_opt_62_occeig overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_occeig)

  dnl 62_poisson library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_poisson}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_poisson="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_poisson is ${fcflags_opt_62_poisson}])
      echo "fcflags_opt_62_poisson='${fcflags_opt_62_poisson}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_poisson"
    fi
  else
    if test "${fcflags_opt_62_poisson}" != ""; then
      fcflags_opt_62_poisson=""
      AC_MSG_NOTICE([fcflags_opt_62_poisson overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_poisson)

  dnl 62_wvl_wfs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_62_wvl_wfs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_62_wvl_wfs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 62_wvl_wfs is ${fcflags_opt_62_wvl_wfs}])
      echo "fcflags_opt_62_wvl_wfs='${fcflags_opt_62_wvl_wfs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 62_wvl_wfs"
    fi
  else
    if test "${fcflags_opt_62_wvl_wfs}" != ""; then
      fcflags_opt_62_wvl_wfs=""
      AC_MSG_NOTICE([fcflags_opt_62_wvl_wfs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_62_wvl_wfs)

  dnl 63_bader library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_63_bader}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_63_bader="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 63_bader is ${fcflags_opt_63_bader}])
      echo "fcflags_opt_63_bader='${fcflags_opt_63_bader}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 63_bader"
    fi
  else
    if test "${fcflags_opt_63_bader}" != ""; then
      fcflags_opt_63_bader=""
      AC_MSG_NOTICE([fcflags_opt_63_bader overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_63_bader)

  dnl 64_atompaw library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_64_atompaw}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_64_atompaw="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 64_atompaw is ${fcflags_opt_64_atompaw}])
      echo "fcflags_opt_64_atompaw='${fcflags_opt_64_atompaw}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 64_atompaw"
    fi
  else
    if test "${fcflags_opt_64_atompaw}" != ""; then
      fcflags_opt_64_atompaw=""
      AC_MSG_NOTICE([fcflags_opt_64_atompaw overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_64_atompaw)

  dnl 65_lotf_base library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_65_lotf_base}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_65_lotf_base="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 65_lotf_base is ${fcflags_opt_65_lotf_base}])
      echo "fcflags_opt_65_lotf_base='${fcflags_opt_65_lotf_base}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 65_lotf_base"
    fi
  else
    if test "${fcflags_opt_65_lotf_base}" != ""; then
      fcflags_opt_65_lotf_base=""
      AC_MSG_NOTICE([fcflags_opt_65_lotf_base overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_65_lotf_base)

  dnl 65_nonlocal library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_65_nonlocal}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_65_nonlocal="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 65_nonlocal is ${fcflags_opt_65_nonlocal}])
      echo "fcflags_opt_65_nonlocal='${fcflags_opt_65_nonlocal}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 65_nonlocal"
    fi
  else
    if test "${fcflags_opt_65_nonlocal}" != ""; then
      fcflags_opt_65_nonlocal=""
      AC_MSG_NOTICE([fcflags_opt_65_nonlocal overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_65_nonlocal)

  dnl 65_psp library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_65_psp}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_65_psp="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 65_psp is ${fcflags_opt_65_psp}])
      echo "fcflags_opt_65_psp='${fcflags_opt_65_psp}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 65_psp"
    fi
  else
    if test "${fcflags_opt_65_psp}" != ""; then
      fcflags_opt_65_psp=""
      AC_MSG_NOTICE([fcflags_opt_65_psp overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_65_psp)

  dnl 66_fock library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_66_fock}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_66_fock="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 66_fock is ${fcflags_opt_66_fock}])
      echo "fcflags_opt_66_fock='${fcflags_opt_66_fock}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 66_fock"
    fi
  else
    if test "${fcflags_opt_66_fock}" != ""; then
      fcflags_opt_66_fock=""
      AC_MSG_NOTICE([fcflags_opt_66_fock overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_66_fock)

  dnl 66_paw library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_66_paw}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_66_paw="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 66_paw is ${fcflags_opt_66_paw}])
      echo "fcflags_opt_66_paw='${fcflags_opt_66_paw}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 66_paw"
    fi
  else
    if test "${fcflags_opt_66_paw}" != ""; then
      fcflags_opt_66_paw=""
      AC_MSG_NOTICE([fcflags_opt_66_paw overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_66_paw)

  dnl 66_wfs library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_66_wfs}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_66_wfs="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 66_wfs is ${fcflags_opt_66_wfs}])
      echo "fcflags_opt_66_wfs='${fcflags_opt_66_wfs}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 66_wfs"
    fi
  else
    if test "${fcflags_opt_66_wfs}" != ""; then
      fcflags_opt_66_wfs=""
      AC_MSG_NOTICE([fcflags_opt_66_wfs overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_66_wfs)

  dnl 67_common library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_67_common}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_67_common="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 67_common is ${fcflags_opt_67_common}])
      echo "fcflags_opt_67_common='${fcflags_opt_67_common}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 67_common"
    fi
  else
    if test "${fcflags_opt_67_common}" != ""; then
      fcflags_opt_67_common=""
      AC_MSG_NOTICE([fcflags_opt_67_common overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_67_common)

  dnl 68_dmft library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_68_dmft}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_68_dmft="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 68_dmft is ${fcflags_opt_68_dmft}])
      echo "fcflags_opt_68_dmft='${fcflags_opt_68_dmft}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 68_dmft"
    fi
  else
    if test "${fcflags_opt_68_dmft}" != ""; then
      fcflags_opt_68_dmft=""
      AC_MSG_NOTICE([fcflags_opt_68_dmft overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_68_dmft)

  dnl 68_lotf library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_68_lotf}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_68_lotf="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 68_lotf is ${fcflags_opt_68_lotf}])
      echo "fcflags_opt_68_lotf='${fcflags_opt_68_lotf}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 68_lotf"
    fi
  else
    if test "${fcflags_opt_68_lotf}" != ""; then
      fcflags_opt_68_lotf=""
      AC_MSG_NOTICE([fcflags_opt_68_lotf overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_68_lotf)

  dnl 68_recursion library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_68_recursion}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_68_recursion="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 68_recursion is ${fcflags_opt_68_recursion}])
      echo "fcflags_opt_68_recursion='${fcflags_opt_68_recursion}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 68_recursion"
    fi
  else
    if test "${fcflags_opt_68_recursion}" != ""; then
      fcflags_opt_68_recursion=""
      AC_MSG_NOTICE([fcflags_opt_68_recursion overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_68_recursion)

  dnl 68_rsprc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_68_rsprc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_68_rsprc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 68_rsprc is ${fcflags_opt_68_rsprc}])
      echo "fcflags_opt_68_rsprc='${fcflags_opt_68_rsprc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 68_rsprc"
    fi
  else
    if test "${fcflags_opt_68_rsprc}" != ""; then
      fcflags_opt_68_rsprc=""
      AC_MSG_NOTICE([fcflags_opt_68_rsprc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_68_rsprc)

  dnl 69_wfdesc library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_69_wfdesc}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_69_wfdesc="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 69_wfdesc is ${fcflags_opt_69_wfdesc}])
      echo "fcflags_opt_69_wfdesc='${fcflags_opt_69_wfdesc}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 69_wfdesc"
    fi
  else
    if test "${fcflags_opt_69_wfdesc}" != ""; then
      fcflags_opt_69_wfdesc=""
      AC_MSG_NOTICE([fcflags_opt_69_wfdesc overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_69_wfdesc)

  dnl 70_gw library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_70_gw}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_70_gw="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 70_gw is ${fcflags_opt_70_gw}])
      echo "fcflags_opt_70_gw='${fcflags_opt_70_gw}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 70_gw"
    fi
  else
    if test "${fcflags_opt_70_gw}" != ""; then
      fcflags_opt_70_gw=""
      AC_MSG_NOTICE([fcflags_opt_70_gw overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_70_gw)

  dnl 71_bse library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_71_bse}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_71_bse="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 71_bse is ${fcflags_opt_71_bse}])
      echo "fcflags_opt_71_bse='${fcflags_opt_71_bse}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 71_bse"
    fi
  else
    if test "${fcflags_opt_71_bse}" != ""; then
      fcflags_opt_71_bse=""
      AC_MSG_NOTICE([fcflags_opt_71_bse overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_71_bse)

  dnl 72_response library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_72_response}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_72_response="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 72_response is ${fcflags_opt_72_response}])
      echo "fcflags_opt_72_response='${fcflags_opt_72_response}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 72_response"
    fi
  else
    if test "${fcflags_opt_72_response}" != ""; then
      fcflags_opt_72_response=""
      AC_MSG_NOTICE([fcflags_opt_72_response overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_72_response)

  dnl 77_ddb library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_77_ddb}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_77_ddb="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 77_ddb is ${fcflags_opt_77_ddb}])
      echo "fcflags_opt_77_ddb='${fcflags_opt_77_ddb}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 77_ddb"
    fi
  else
    if test "${fcflags_opt_77_ddb}" != ""; then
      fcflags_opt_77_ddb=""
      AC_MSG_NOTICE([fcflags_opt_77_ddb overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_77_ddb)

  dnl 77_suscep library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_77_suscep}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_77_suscep="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 77_suscep is ${fcflags_opt_77_suscep}])
      echo "fcflags_opt_77_suscep='${fcflags_opt_77_suscep}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 77_suscep"
    fi
  else
    if test "${fcflags_opt_77_suscep}" != ""; then
      fcflags_opt_77_suscep=""
      AC_MSG_NOTICE([fcflags_opt_77_suscep overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_77_suscep)

  dnl 79_seqpar_mpi library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_79_seqpar_mpi}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_79_seqpar_mpi="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 79_seqpar_mpi is ${fcflags_opt_79_seqpar_mpi}])
      echo "fcflags_opt_79_seqpar_mpi='${fcflags_opt_79_seqpar_mpi}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 79_seqpar_mpi"
    fi
  else
    if test "${fcflags_opt_79_seqpar_mpi}" != ""; then
      fcflags_opt_79_seqpar_mpi=""
      AC_MSG_NOTICE([fcflags_opt_79_seqpar_mpi overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_79_seqpar_mpi)

  dnl 83_cut3d library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_83_cut3d}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_83_cut3d="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 83_cut3d is ${fcflags_opt_83_cut3d}])
      echo "fcflags_opt_83_cut3d='${fcflags_opt_83_cut3d}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 83_cut3d"
    fi
  else
    if test "${fcflags_opt_83_cut3d}" != ""; then
      fcflags_opt_83_cut3d=""
      AC_MSG_NOTICE([fcflags_opt_83_cut3d overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_83_cut3d)

  dnl 95_drive library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_95_drive}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_95_drive="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 95_drive is ${fcflags_opt_95_drive}])
      echo "fcflags_opt_95_drive='${fcflags_opt_95_drive}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 95_drive"
    fi
  else
    if test "${fcflags_opt_95_drive}" != ""; then
      fcflags_opt_95_drive=""
      AC_MSG_NOTICE([fcflags_opt_95_drive overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_95_drive)

  dnl 98_main library
  if test "${FCFLAGS}" = ""; then
    if test "${fcflags_opt_98_main}" = "" -o "${enable_optim}" = "no"; then
      fcflags_opt_98_main="${fcflags_opt_default}"
    else
      AC_MSG_NOTICE([optimization for 98_main is ${fcflags_opt_98_main}])
      echo "fcflags_opt_98_main='${fcflags_opt_98_main}'" >>config.optim
      fcflags_opt_dirlist="${fcflags_opt_dirlist} 98_main"
    fi
  else
    if test "${fcflags_opt_98_main}" != ""; then
      fcflags_opt_98_main=""
      AC_MSG_NOTICE([fcflags_opt_98_main overriden by FCFLAGS])
    fi
  fi
  AC_SUBST(fcflags_opt_98_main)

  echo "fcflags_opt_dirlist='${fcflags_opt_dirlist}'" >>config.optim
]) # ABI_OPTFLAGS_DIRS
"
