use Net::SMTP;
use Sys::Syslog qw(:DEFAULT setlogsock) ;

sub Report {  # stores errors in a stack, with the last in $Error
    $Error = shift;
    push( @Errors, $Error);
}

sub mail {
   my (@to) = ref($_[0]) ? @{shift @_} : split(/\s*,\s*/, shift);
   my $subject = shift;
   my $data = ( @_ == 1 && ref($_[0])) ? $_[0] : \@_;


   my $mail = new Net::SMTP('mailhost');
   if( !defined $mail ) {
#      Log("Failed to get Net:SMTP session to mailhost", FATAL );
       Log( "Failed to get Net:SMTP session to mailhost");
      return;
   }

#   $mail->mail('argus@$Argus::Local_domain') or
   $mail->mail("argus\@$Argus::Local_domain") or
       Log("Net::smtp::mail failed for 'argus\@$Argus::Local_domain'");
   $mail->to(@to) or Log( "Net::smtp::to failed '$to'");
   my $to = join(',', @to);
   $mail->data([
		 "To: $to\n",
		 "Subject: $subject\n",
		 "\n", @$data
		 ]) or  Log( "Net::smtp:data failed");
 
   $mail->dataend;
   $mail->quit;

}

sub setup_logging {
    my ($n) = @_;

    return unless defined $Argus::LOG_TO;

    if ( $Argus::LOG_TO =~ /SYSLOG/ ) {
	my( $sysl, $name, $facility, $priority, $sock) =
	    split(/:/, $Argus::LOG_TO );

	$name = $n if $n;
	$Argus::Log_priority = defined $priority  ? $priority : 'info'; 
	setlogsock($sock) if $sock;
	openlog( $name, 'pid', $facility);
    } else {
	$Argus::Log_priority = '';
	die "Can't write to $Argus::LOG_TO" unless -w $Argus::LOG_TO;
    }
}

sub Log{  # write log message
    my ($pri, $msg) = @_;
	if( !defined $msg ) {
	    $msg = $pri;
	    $pri = $Argus::Log_priority; 
	}

    if( $Argus::Log_priority ) {
	syslog( $pri, "%s", $msg);
    } elsif ( defined $Argus::LOG_TO ) {
	open (LOG, ">>$Argus::LOG_TO") || die "Can't open log file:$!";
        print LOG "$msg\n";
	close( LOG );
    } else {
	print STDERR shift, "\n";
    }
}

sub cmp_ip {
 
    my ($i, $r);
    my (@a) = split(/\./, $::a);
    my (@b) = split(/\./, $::b);

#    my $n = ( defined $a[4] && defined $b[4] ) ? 5 : 4;
 
#    for($i=0; $i < $n; $i++) {
    for($i=0; $i < 4; $i++) {
        $r = $a[$i] <=> $b[$i];
        return $r if ($r);
    }
    return 0;
}

sub fmt_range { 
    my $i;
    my @oct1 = split(/\./, shift);
    my $oct2 = shift;
    my @oct2 = @{$oct2};
    my $out = "";

    for($i=0; $i < 5 && $oct1[$i]==$oct2[$i]; $i++) {
	$out .= "$oct1[$i].";
    }
    $out .= "$oct1[$i].";
    chop $out;  # trim '.'
    $out .= "-$oct2[$i++].";
    for(; $i < 5; $i++) { $out .= "$oct1[$i].";}
     chop $out;  # trim '.'
    return $out;
}

sub sort_port_list{
    my ( $tcp, $udp, $icmp) = @_;
    my ( $nudp,  $ntcp, $nicmp );
    my $port_string = '';

    if( ($nicmp = scalar @$icmp) + ($ntcp = scalar @$tcp) +
        ($nudp = scalar @$udp) > 10) {
	$nicmp = 2 if $nicmp > 2;
	$nudp = 5 if $nudp > 5;
	$ntcp = 10 - ($nicmp + $nudp) < $ntcp ?  10 - ($nicmp + $nudp) : $ntcp;
    }

    if( $nicmp ) {
	$port_string = "icmp - $icmp->[0]";
	for(my $i= 1; $i < $nicmp; $i++) {
	    $port_string .= ", $icmp->[$i]";
	}
	if( $nicmp < scalar @$icmp) {
	    $port_string .= sprintf(", total - %d ", scalar @$icmp);
	}
	$port_string .= "; ";
    } 

    if( $nudp ) {
	@$udp = sort {$::a <=> $::b} @$udp;
	$port_string .= "udp - $udp->[0]";
	for(my $i= 1; $i < $nudp; $i++) {
	    $port_string .= ", $udp->[$i]";
	}
	if( $nudp < scalar @$udp) {
	    $port_string .= sprintf(", total - %d ", scalar @$udp);
	}
	$port_string .= "; ";
    } 

    if( $ntcp ) {
	@$tcp = sort {$::a <=> $::b} @$tcp;
	$port_string .= "tcp - $tcp->[0]";
	for(my $i= 1; $i < $ntcp; $i++) {
	    $port_string .= ", $tcp->[$i]";
	}
	if( $ntcp < scalar @$tcp) {
	    $port_string .= sprintf(", total - %d ", scalar @$tcp);
	}
	$port_string .= "; ";
    } 

    chop $port_string;  # chop trailing '; '
    chop $port_string;

    return $port_string;
}

sub list_ips{ # ( source_ip, ref to description, ref to list of dest_ip.port )
    my ($sip, $desc, $list) = @_; 

    my	$count = 0;
    my $ii = 0;
    my ( @oct1, @oct2, $start, $i, $j, $ip, $port, $proto);
    my (%ports, %tcp, %udp, %icmp, @tcp, @udp, @icmp);
    my @lines;
    my $last_ip = '';
    my $last_port = '';
    my $c = 0;
    my $ports = 0;
    my $ips = 0;
    my @oc = (0,0,0,0,0);

# collapse port lists

    foreach my $addr (@{$list} ) { # make list of ports for each IP
	($ip, $proto, $port) = $addr =~ /(\d+\.\d+\.\d+\.\d+)\.(\w+)-?([A-Z0-9]+)?/;

# split list into tcp, udp ports and ICMP types

	$port = 0 if ! defined $port;
	$proto = '' if ! defined $proto;

	if( ! defined $ip) {
	    print STDERR "<><><> bad tag in list_ips '$_'\n";
	    next;
	}

	if( $last_ip ne $ip ) {
	    $ports{$last_ip} =
		sort_port_list(\@tcp, \@udp, \@icmp) if $last_ip;
	    undef @tcp; undef @udp; undef @icmp;
	    $ips++;
	    $last_ip = $ip;
	}
	if( $proto eq 'tcp') { #tcp 
	    push( @tcp, $port);
	    $tcp{$port} = 1;         # count number of different tcp ports
	} elsif( $proto eq 'udp' ) {
	    push( @udp, $port);
	    $udp{$port} = 1;         # count number of different udp ports
	} else {
	    push( @icmp, $port);
	    $icmp{$port} = 1;         # count number of different icmp types
	}    
    }

    $ports{$ip} = sort_port_list(\@tcp, \@udp, \@icmp);

    foreach $ip ( sort cmp_ip keys %ports ) {

	@oct1 = split(/\./, $ip);  # collapse address lists

	$oct1[4] = $ports{$ip};
	$ip .= ".$oct1[4]";

	if( scalar @oct2) {  # not first address
	    for( $i=0; $i <  4; $i++ ) {
		if( $oct1[$i] != $oct2[$i] ) { #which bytes differ?
		    $oc[$i] ++;
		}
		if( $oct1[$i] == $oct2[$i]+1 ) {
		    for( $j = $i+1; $j <= 4; $j++) {
			last if( $oct1[$j] ne $oct2[$j] );
		    }
		    last;
		}
	    }
	    if( ($i != 4 && $j == 5) && ($count == 1 || $i == $ii)) {
		$count++; 
		$ii = $i;
	    } else {   # print
		if ($count == 1) {  push(@lines, $start); }
		else { push(@lines, Argus::fmt_range($start, \@oct2)) }
		$start = $ip; $count = 1; $ii = $i;
	    }
	} else { $start = $ip; $count = 1;}
	@oct2 = @oct1;
    }
# handle last record
    if ($count == 1) { push(@lines, "$start"); }
    elsif ($count != 0) {
	push(@lines, Argus::fmt_range($start, \@oct2));
    }

#    return \@lines unless defined $desc;

#  classify the report

     my @tcpports = keys %tcp;
    my $tcpports = scalar( @tcpports);
    my $udpports = scalar keys %udp;
    @tcpports = sort {$::a <=> $::b} @tcpports;

    $ports = $tcpports + $udpports;

    $$desc = 'Network_scan';  # default

    if( $ips <= 0.1*$ports ) { # many more ports than IPs => host scan
	$$desc = 'Host_scan';
	if ($tcpports > 10 and (($tcpports[0] == 21 and $tcpports[2] >= 1024)
			     or ($tcpports[0] == 20 and $tcpports[2] >= 1024))
				and $tcpports < 100) {
	    $$desc = 'ignore- ftp- hi numbered ports';
	} elsif ($tcpports > 10 and $tcpports[0] >= 1024 and $tcpports < 100){
	    $$desc = 'ignore- hi numbered ports';
	}
    } 

# Code red and nimbda use random scans so we can no longer ignore these

#    elsif ( defined $sip and $sip =~ /$Argus::Local_IP_re/o ){#srce is local
#	if( $oc[0] > 7 || $oc[0] > .2 * $ips ) { # more than 8 different /8s
#	    $$desc = 'ignore(random)';
#	}
#    }  



    if( $tcpports + $udpports <= 3 ) {
	$$desc .= '[' ;
	if( $tcpports ) {
	    $$desc .= 'tcp-' . join(', ', keys %tcp) . ';';
	}
	if( $udpports ) {
	    $$desc .= 'udp-' . join(', ', keys %udp) . ';';
	}
	if( scalar keys %icmp ) {
	    $$desc .= 'icmp-' . join(', ', keys %icmp) . ';';
	}
	chop $$desc;  # trim trailing ';' 
	$$desc .= ']' ;
    }

#    push(@lines, "$$desc | $ips, $ports | " . join(', ', @oc));

    return \@lines;
}

#
# Take an array of comma delimited lists of IP addresses.port, port...
# and format them in two columns like
#
#  ip1.port, port, port,       ipn.port, port, port
#      port, port              ipn+1.port, port, port
#  ip2.port, port, port
#   ...
#

sub print_block {
    my $list = shift;
    my $result = "";
    my $count = 0;
    my $maxl = 35;
    my (@l, @line, $i, $j);
    my $x = 0;

    foreach (@{$list}) {  # split comma delimited lists across lines

	if( length() < $maxl ) {
	    $line[$x] = $_;
	} else {
	    @l = split /,\s*/;   # split list into @l
	    $line[$x] = $l[0];
	    for( my $i=1; $i <= $#l; $i++) {
		if( length($line[$x]) + length($l[$i]) +2 < $maxl) {
		    $line[$x] .= ",  $l[$i]";
		} else {
		    $line[$x++] .= ',';
		    $line[$x] = "   $l[$i]";
		}

	    }
	}
	$x++;
    }

    my $half = int((scalar @line)/2);
    $half++ if (scalar @line) % 2 == 1;

    for( my $i = 0; $i < $half; $i++ ) { # format into two columns
	if( $i+$half <= $#line ) {
	    $result .= sprintf("%-35s   %-35s\n", $line[$i], $line[$i+$half]);
	} else {
	    $result .= "$line[$i]\n";
	}
    }
    return $result;
}


1;
