/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:18:47 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.QualifierInfo;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class QualifierInfo_ESTest extends QualifierInfo_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      QualifierInfo qualifierInfo0 = new QualifierInfo("Ii6G`|l6B@m", 0, keyVector0, keyVector0, true);
      Key key0 = new Key("list", true);
      qualifierInfo0.isValidFor(key0);
      assertEquals(0, qualifierInfo0.getType());
      assertTrue(qualifierInfo0.isOnceOnly());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Key key0 = new Key("The array of names must not be null");
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierInfo qualifierInfo0 = new QualifierInfo("The array of names must not be null", (-442), keyVector0, keyVector0, false);
      boolean boolean0 = qualifierInfo0.isOnceOnly();
      assertEquals((-442), qualifierInfo0.getType());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      QualifierInfo qualifierInfo0 = new QualifierInfo("Ii6G`|l6B@m", 0, keyVector0, keyVector0, true);
      qualifierInfo0.getValidKeys();
      assertTrue(qualifierInfo0.isOnceOnly());
      assertEquals(0, qualifierInfo0.getType());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      QualifierInfo qualifierInfo0 = new QualifierInfo("p1!zZ44aw#=<;f", 1898, (KeyVector) null, (KeyVector) null, false);
      int int0 = qualifierInfo0.getType();
      assertFalse(qualifierInfo0.isOnceOnly());
      assertEquals(1898, int0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      QualifierInfo qualifierInfo0 = new QualifierInfo("", (-1100), keyVector0, keyVector0, true);
      int int0 = qualifierInfo0.getType();
      assertEquals((-1100), int0);
      assertTrue(qualifierInfo0.isOnceOnly());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      QualifierInfo qualifierInfo0 = new QualifierInfo((String) null, 0, (KeyVector) null, (KeyVector) null, false);
      qualifierInfo0.getRequiredKeys();
      assertEquals(0, qualifierInfo0.getType());
      assertFalse(qualifierInfo0.isOnceOnly());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Key key0 = new Key("The array of names must not be null");
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierInfo qualifierInfo0 = new QualifierInfo("The array of names must not be null", (-442), keyVector0, keyVector0, false);
      qualifierInfo0.getRequiredKeys();
      assertFalse(qualifierInfo0.isOnceOnly());
      assertEquals((-442), qualifierInfo0.getType());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Key key0 = new Key((String) null);
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierInfo qualifierInfo0 = new QualifierInfo((String) null, 12, keyVector0, keyVector0, true);
      qualifierInfo0.getName();
      assertEquals(12, qualifierInfo0.getType());
      assertTrue(qualifierInfo0.isOnceOnly());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      QualifierInfo qualifierInfo0 = new QualifierInfo("p1!zZ44aw#=<;f", 1898, (KeyVector) null, (KeyVector) null, false);
      qualifierInfo0.getName();
      assertFalse(qualifierInfo0.isOnceOnly());
      assertEquals(1898, qualifierInfo0.getType());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Key key0 = new Key((String) null);
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierInfo qualifierInfo0 = new QualifierInfo((String) null, 12, keyVector0, keyVector0, true);
      // Undeclared exception!
      try { 
        qualifierInfo0.isValidFor(key0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Key", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Key key0 = new Key("");
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierInfo qualifierInfo0 = new QualifierInfo("", 0, keyVector0, keyVector0, true);
      Key key1 = new Key((String) null);
      // Undeclared exception!
      try { 
        qualifierInfo0.isRequiredFor(key1);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Key", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      int int0 = QualifierInfo.getQualifierTypeID("\"opt\"");
      assertEquals(4, int0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      int int0 = QualifierInfo.getQualifierTypeID("none");
      assertEquals(3, int0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      int int0 = QualifierInfo.getQualifierTypeID("text");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      int int0 = QualifierInfo.getQualifierTypeID("\"text\"");
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      int int0 = QualifierInfo.getQualifierTypeID("EC");
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      // Undeclared exception!
      try { 
        QualifierInfo.getQualifierTypeID("htsjdk.variant.vcf.VCFFormatHeaderLine");
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // unknown type string: htsjdk.variant.vcf.VCFFormatHeaderLine
         //
         verifyException("uk.ac.sanger.artemis.io.QualifierInfo", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      QualifierInfo qualifierInfo0 = new QualifierInfo("p1!zZ44aw#=<;f", 1898, (KeyVector) null, (KeyVector) null, false);
      Key key0 = new Key("p1!zZ44aw#=<;f");
      boolean boolean0 = qualifierInfo0.isRequiredFor(key0);
      assertEquals(1898, qualifierInfo0.getType());
      assertFalse(qualifierInfo0.isOnceOnly());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Key key0 = new Key("");
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierInfo qualifierInfo0 = new QualifierInfo("", 0, keyVector0, keyVector0, true);
      boolean boolean0 = qualifierInfo0.isRequiredFor(key0);
      assertTrue(boolean0);
      assertEquals(0, qualifierInfo0.getType());
      assertTrue(qualifierInfo0.isOnceOnly());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      QualifierInfo qualifierInfo0 = new QualifierInfo("p1!zZ44aw#=<;f", 1898, (KeyVector) null, (KeyVector) null, false);
      boolean boolean0 = qualifierInfo0.isValidFor((Key) null);
      assertTrue(boolean0);
      assertEquals(1898, qualifierInfo0.getType());
      assertFalse(qualifierInfo0.isOnceOnly());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      QualifierInfo qualifierInfo0 = new QualifierInfo((String) null, 4518, (KeyVector) null, (KeyVector) null, true);
      qualifierInfo0.getValidKeys();
      assertTrue(qualifierInfo0.isOnceOnly());
      assertEquals(4518, qualifierInfo0.getType());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      QualifierInfo qualifierInfo0 = new QualifierInfo("Cannot find any genotypes in VariantContext: ", 11, keyVector0, keyVector0, true);
      KeyVector keyVector1 = qualifierInfo0.getRequiredKeys();
      assertNotNull(keyVector1);
      assertTrue(qualifierInfo0.isOnceOnly());
      assertEquals(11, qualifierInfo0.getType());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Key key0 = new Key("");
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierInfo qualifierInfo0 = new QualifierInfo("", 0, keyVector0, keyVector0, true);
      qualifierInfo0.getName();
      assertEquals(0, qualifierInfo0.getType());
      assertTrue(qualifierInfo0.isOnceOnly());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      QualifierInfo qualifierInfo0 = new QualifierInfo("Cannot find sample requested: ", 0, keyVector0, keyVector0, true);
      int int0 = qualifierInfo0.getType();
      assertEquals(0, int0);
      assertTrue(qualifierInfo0.isOnceOnly());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      KeyVector keyVector0 = new KeyVector();
      QualifierInfo qualifierInfo0 = new QualifierInfo("##", 725, keyVector0, keyVector0, true);
      boolean boolean0 = qualifierInfo0.isOnceOnly();
      assertEquals(725, qualifierInfo0.getType());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Key key0 = new Key("");
      KeyVector keyVector0 = new KeyVector(key0);
      QualifierInfo qualifierInfo0 = new QualifierInfo("", 0, keyVector0, keyVector0, true);
      KeyVector keyVector1 = qualifierInfo0.getValidKeys();
      assertTrue(qualifierInfo0.isOnceOnly());
      assertNotNull(keyVector1);
      assertEquals(0, qualifierInfo0.getType());
  }
}
