/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:21:53 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.Graphics;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.ScaledChiAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ScaledChiAlgorithm_ESTest extends ScaledChiAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      // Undeclared exception!
      try { 
        scaledChiAlgorithm0.getValues((-5), 0, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.ScaledChiAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      float[] floatArray0 = new float[4];
      // Undeclared exception!
      try { 
        scaledChiAlgorithm0.getValues(0, 0, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 0 > end: -1
         //
         verifyException("uk.ac.sanger.artemis.plot.ScaledChiAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      ScaledChiAlgorithm scaledChiAlgorithm0 = null;
      try {
        scaledChiAlgorithm0 = new ScaledChiAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.ScaledChiAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      Integer integer0 = scaledChiAlgorithm0.getDefaultStepSize(73);
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
      assertTrue(scaledChiAlgorithm0.scalingFlag());
      assertEquals("Reverse Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      Integer integer0 = scaledChiAlgorithm0.getDefaultStepSize(2);
      assertTrue(scaledChiAlgorithm0.scalingFlag());
      assertNull(integer0);
      assertEquals("Reverse Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      Integer integer0 = scaledChiAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer0);
      assertEquals("Reverse Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
      assertTrue(scaledChiAlgorithm0.scalingFlag());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      Integer integer0 = scaledChiAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer0);
      assertTrue(scaledChiAlgorithm0.scalingFlag());
      assertEquals("Reverse Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
      assertEquals(5000, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      Integer integer0 = scaledChiAlgorithm0.getDefaultWindowSize();
      assertTrue(scaledChiAlgorithm0.scalingFlag());
      assertEquals("Reverse Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
      assertEquals(500, (int)integer0);
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      float[] floatArray0 = new float[4];
      scaledChiAlgorithm0.getValues((-5), 0, floatArray0);
      assertTrue(scaledChiAlgorithm0.scalingFlag());
      assertEquals("Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      float[] floatArray0 = new float[4];
      scaledChiAlgorithm0.getValues(0, 4086, floatArray0);
      assertEquals("Reverse Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
      assertTrue(scaledChiAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      Float float0 = scaledChiAlgorithm0.getMaximumInternal();
      assertTrue(scaledChiAlgorithm0.scalingFlag());
      assertEquals("Reverse Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
      assertEquals(1000.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      int int0 = scaledChiAlgorithm0.getValueCount();
      assertEquals("Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
      assertTrue(scaledChiAlgorithm0.scalingFlag());
      assertEquals(3, int0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      Color[] colorArray0 = new Color[3];
      scaledChiAlgorithm0.drawLegend((Graphics) null, 2, 5617, colorArray0);
      assertEquals("Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
      assertTrue(scaledChiAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      scaledChiAlgorithm0.getAverage();
      assertEquals("Reverse Scaled Chi Square", scaledChiAlgorithm0.getAlgorithmName());
      assertTrue(scaledChiAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      ScaledChiAlgorithm scaledChiAlgorithm0 = new ScaledChiAlgorithm(strand0);
      scaledChiAlgorithm0.getMinimumInternal();
  }
}
