/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:30:47 GMT 2018
 */

package uk.ac.sanger.artemis.components.genebuilder.cv;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JCheckBox;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.genebuilder.cv.ProductBox;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class ProductBox_ESTest extends ProductBox_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("QkXtTvbpGh+rC}N", "QkXtTvbpGh+rC}N");
      Dimension dimension0 = new Dimension();
      ProductBox productBox0 = new ProductBox(qualifier0, "QkXtTvbpGh+rC}N", (-2696), dimension0, dimension0);
      QualifierVector qualifierVector0 = new QualifierVector();
      qualifierVector0.add(qualifier0);
      // Undeclared exception!
      try { 
        productBox0.updateQualifier(qualifierVector0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -2696
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("`?o", "`?o");
      Dimension dimension0 = new Dimension();
      ProductBox productBox0 = null;
      try {
        productBox0 = new ProductBox(qualifier0, (String) null, 869, dimension0, dimension0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.cv.AbstractCvBox", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("term=", "term=");
      Dimension dimension0 = new Dimension();
      QualifierVector qualifierVector0 = new QualifierVector();
      qualifierVector0.add(qualifier0);
      ProductBox productBox0 = new ProductBox(qualifier0, "term=", 0, dimension0, dimension0);
      productBox0.updateQualifier(qualifierVector0);
      assertFalse(qualifierVector0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("n46ra{}%Dy$xS\"BV");
      Dimension dimension0 = new Dimension();
      ProductBox productBox0 = new ProductBox(qualifier0, "|'9u", (-5382), dimension0, dimension0);
      boolean boolean0 = productBox0.isQualifierChanged();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("n46ra{}%Dy$xS\"BV");
      Dimension dimension0 = new Dimension();
      ProductBox productBox0 = new ProductBox(qualifier0, "|'9u", (-5382), dimension0, dimension0);
      QualifierVector qualifierVector0 = new QualifierVector();
      // Undeclared exception!
      try { 
        productBox0.updateQualifier(qualifierVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.cv.ProductBox", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("n46ra{}%Dy$xS\"BV");
      Dimension dimension0 = new Dimension();
      ProductBox productBox0 = new ProductBox(qualifier0, "|'9u", (-5382), dimension0, dimension0);
      Box box0 = productBox0.getHeadingsBox();
      assertTrue(box0.getFocusTraversalKeysEnabled());
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("@H2:7");
      Dimension dimension0 = new Dimension(1425, 1425);
      ProductBox productBox0 = new ProductBox(qualifier0, "@H2:7", 1425, dimension0, dimension0);
      Box box0 = productBox0.getBox();
      assertFalse(box0.isFocusTraversalPolicySet());
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      Qualifier qualifier0 = new Qualifier("@H2:7");
      Dimension dimension0 = new Dimension(1425, 1425);
      ProductBox productBox0 = new ProductBox(qualifier0, "@H2:7", 1425, dimension0, dimension0);
      JCheckBox jCheckBox0 = productBox0.getRecommended();
      assertFalse(jCheckBox0.isFocusTraversalPolicyProvider());
  }
}
