/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.builder;

import com.claritysys.jvm.builder.CodeBlock;
import com.claritysys.jvm.builder.CodeBuilder;
import com.claritysys.jvm.builder.TryBlock;
import com.claritysys.jvm.classfile.CfMethod;
import com.claritysys.jvm.classfile.CpClass;

public class CatchBlock
extends CodeBlock {
    private CpClass catchType;
    private TryBlock tryBlock;

    public CatchBlock(CodeBuilder cb, TryBlock tryBlock, CpClass catchType) {
        super(cb);
        this.catchType = catchType;
        this.tryBlock = tryBlock;
    }

    public TryBlock getTryBlock() {
        return this.tryBlock;
    }

    public void end() {
        super.end();
        int startPC = this.tryBlock.getStartPC();
        int endPC = this.tryBlock.getEndPC();
        int handlerPC = this.getStartPC();
        CfMethod method = this.getMethod();
        method.addHandler(startPC, endPC, handlerPC, this.catchType);
    }
}

