MACRO(checkFontConfig)
	IF (NOT FONTCONFIG_CHECKED)
		OPTION(FONTCONFIG "" ON)

		MESSAGE(STATUS "Checking for FontConfig")
		MESSAGE(STATUS "***********************")

		IF (FONTCONFIG)
			PKG_CHECK_MODULES(FONTCONFIG fontconfig)
			PRINT_LIBRARY_INFO("FontConfig" FONTCONFIG_FOUND "${FONTCONFIG_CFLAGS}" "${FONTCONFIG_LDFLAGS}")

			IF (FONTCONFIG_FOUND)
				SET(HAVE_FONTCONFIG 1)
			ENDIF (FONTCONFIG_FOUND)
		ELSE (FONTCONFIG)
			MESSAGE("${MSG_DISABLE_OPTION}")
		ENDIF (FONTCONFIG)

		SET(ENV{ADM_HAVE_FONTCONFIG} ${FONTCONFIG_FOUND})
		SET(FONTCONFIG_CHECKED 1)

		MESSAGE("")
	ENDIF (NOT FONTCONFIG_CHECKED)
ENDMACRO(checkFontConfig)