/* Copyright (c) 2007  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/* Test of fdim() function. 500 random cases.
   $Id$
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x,y;		/* args		*/
    long z;		/* result	*/
} t[] = {

    /* x, y, fdim(x,y)	*/
    { 0xc01dc55f,0xbf527651,0x00000000 }, /*   1: -2.4651716e+00 -8.2211787e-01  0.0000000e+00 */
    { 0x4099d8c5,0x3fc22552,0x40529ee1 }, /*   2:  4.8077111e+00  1.5167639e+00  3.2909472e+00 */
    { 0xc12e12be,0x3fbe11ad,0x00000000 }, /*   3: -1.0879576e+01  1.4849144e+00  0.0000000e+00 */
    { 0xb002c717,0xc2d0e092,0x42d0e092 }, /*   4: -4.7576648e-10 -1.0443861e+02  1.0443861e+02 */
    { 0x3e3ebe5b,0x4066d198,0x00000000 }, /*   5:  1.8627302e-01  3.6065426e+00  0.0000000e+00 */
    { 0xbfc4380a,0xc1ddbd9f,0x41d17a1e }, /*   6: -1.5329602e+00 -2.7717588e+01  2.6184628e+01 */
    { 0xbf45ec0e,0x42081282,0x00000000 }, /*   7: -7.7313316e-01  3.4018074e+01  0.0000000e+00 */
    { 0x3f6409f9,0xc04cfc36,0x4082ff5a }, /*   8:  8.9077717e-01 -3.2028937e+00  4.0936708e+00 */
    { 0x3eb79151,0xbe764b9e,0x3f195b90 }, /*   9:  3.5853055e-01 -2.4052283e-01  5.9905338e-01 */
    { 0xbda57ab1,0x3f464b25,0x00000000 }, /*  10: -8.0800422e-02  7.7458411e-01  0.0000000e+00 */
    { 0x3d7fabde,0x4196770a,0x00000000 }, /*  11:  6.2419765e-02  1.8808125e+01  0.0000000e+00 */
    { 0xbf72040b,0xbf4ba244,0x00000000 }, /*  12: -9.4537419e-01 -7.9544473e-01  0.0000000e+00 */
    { 0x3ec3c915,0xc06e9bd0,0x40838a79 }, /*  13:  3.8239351e-01 -3.7282600e+00  4.1106534e+00 */
    { 0x3f5e285c,0x4014b723,0x00000000 }, /*  14:  8.6780334e-01  2.3236778e+00  0.0000000e+00 */
    { 0x3e6917b7,0xbeef4747,0x3f31e991 }, /*  15:  2.2762953e-01 -4.6734068e-01  6.9497019e-01 */
    { 0xc1cc62d4,0xc0295158,0x00000000 }, /*  16: -2.5548256e+01 -2.6455898e+00  0.0000000e+00 */
    { 0x43d9ef65,0x3ea9f4f8,0x43d9c4e8 }, /*  17:  4.3587027e+02  3.3194709e-01  4.3553833e+02 */
    { 0xbf4d8882,0xc23f432b,0x423c0d09 }, /*  18: -8.0286419e-01 -4.7815594e+01  4.7012730e+01 */
    { 0x3e0a704a,0x3eeb9ece,0x00000000 }, /*  19:  1.3519397e-01  4.6019596e-01  0.0000000e+00 */
    { 0x400e70f5,0x402e8482,0x00000000 }, /*  20:  2.2256444e+00  2.7268376e+00  0.0000000e+00 */
    { 0xbece7c93,0xbebca1f2,0x00000000 }, /*  21: -4.0329418e-01 -3.6842304e-01  0.0000000e+00 */
    { 0x4012406b,0x3fa52409,0x3f7eb99a }, /*  22:  2.2851818e+00  1.2901622e+00  9.9501956e-01 */
    { 0xc20ff531,0x3fefc748,0x00000000 }, /*  23: -3.5989445e+01  1.8732691e+00  0.0000000e+00 */
    { 0x42a222b2,0x3ec20cf4,0x42a160a5 }, /*  24:  8.1067764e+01  3.7900507e-01  8.0688759e+01 */
    { 0xbfb4634a,0xbff11956,0x3ef2d830 }, /*  25: -1.4092801e+00 -1.8835857e+00  4.7430563e-01 */
    { 0xbf4ebac3,0xbf4b49f6,0x00000000 }, /*  26: -8.0753726e-01 -7.9409730e-01  0.0000000e+00 */
    { 0x3f37b0dd,0xc0189be6,0x4046881d }, /*  27:  7.1754247e-01 -2.3845153e+00  3.1020577e+00 */
    { 0x40dc10c4,0x3fa87761,0x40b1f2ec }, /*  28:  6.8770466e+00  1.3161432e+00  5.5609035e+00 */
    { 0x3e6c56f1,0x3ecfcbc8,0x00000000 }, /*  29:  2.3080041e-01  4.0585160e-01  0.0000000e+00 */
    { 0x4089ea38,0x3af7a5f9,0x4089dabe }, /*  30:  4.3098412e+00  1.8894068e-03  4.3079519e+00 */
    { 0xbf3b61d6,0xbdd279db,0x00000000 }, /*  31: -7.3196161e-01 -1.0277148e-01  0.0000000e+00 */
    { 0xbf418afe,0x53f40aca,0x00000000 }, /*  32: -7.5602710e-01  2.0963061e+12  0.0000000e+00 */
    { 0x3fa8792c,0xc91491bb,0x491491d0 }, /*  33:  1.3161979e+00 -6.0853969e+05  6.0854100e+05 */
    { 0xc0be65d6,0xbf4514e3,0x00000000 }, /*  34: -5.9499311e+00 -7.6984996e-01  0.0000000e+00 */
    { 0x3fa35321,0x3e1e1802,0x3f8f9021 }, /*  35:  1.2759744e+00  1.5438846e-01  1.1215860e+00 */
    { 0xbdc7180a,0x3ebcfde7,0x00000000 }, /*  36: -9.7213820e-02  3.6912462e-01  0.0000000e+00 */
    { 0xc679ebb4,0xbe0ff5ca,0x00000000 }, /*  37: -1.5994926e+04 -1.4058605e-01  0.0000000e+00 */
    { 0xbfb57d1e,0xc0542876,0x3ff2d3ce }, /*  38: -1.4178808e+00 -3.3149695e+00  1.8970888e+00 */
    { 0xc8f326c6,0x42104fd0,0x00000000 }, /*  39: -4.9797419e+05  3.6077942e+01  0.0000000e+00 */
    { 0x4027ad8a,0x402c52a3,0x00000000 }, /*  40:  2.6199670e+00  2.6925437e+00  0.0000000e+00 */
    { 0x3fa56a2d,0xb3f77d7a,0x3fa56a2e }, /*  41:  1.2923027e+00 -1.1524658e-07  1.2923028e+00 */
    { 0xbef4fe1b,0x3edd54af,0x00000000 }, /*  42: -4.7850117e-01  4.3228671e-01  0.0000000e+00 */
    { 0xbd2f433d,0xbf49b2cd,0x3f3ebe99 }, /*  43: -4.2788733e-02 -7.8788453e-01  7.4509579e-01 */
    { 0xbf5184af,0xbea0627f,0x00000000 }, /*  44: -8.1843084e-01 -3.1325147e-01  0.0000000e+00 */
    { 0x401d9bcd,0xbe3af736,0x40294b40 }, /*  45:  2.4626343e+00 -1.8258366e-01  2.6452179e+00 */
    { 0x3f4e4dd7,0x3dc825f9,0x3f354918 }, /*  46:  8.0587524e-01  9.7728677e-02  7.0814657e-01 */
    { 0x3ff74873,0x3fe37025,0x3e1ec270 }, /*  47:  1.9318985e+00  1.7768599e+00  1.5503860e-01 */
    { 0xc09dbffd,0x416db622,0x00000000 }, /*  48: -4.9296861e+00  1.4856966e+01  0.0000000e+00 */
    { 0x3c6dfeae,0xbf090256,0x3f0cba51 }, /*  49:  1.4526052e-02 -5.3519189e-01  5.4971796e-01 */
    { 0xbd1ec264,0xc0b2735e,0x40b135d9 }, /*  50: -3.8759604e-02 -5.5765829e+00  5.5378232e+00 */
    { 0x3f92e1dc,0x4088dc83,0x00000000 }, /*  51:  1.1475177e+00  4.2769179e+00  0.0000000e+00 */
    { 0x40404d78,0xbe8c06f2,0x4051ce56 }, /*  52:  3.0047283e+00 -2.7349049e-01  3.2782187e+00 */
    { 0x3ea8d5f8,0x3f3d340e,0x00000000 }, /*  53:  3.2975745e-01  7.3907554e-01  0.0000000e+00 */
    { 0xbfc0a3dd,0x3df8575f,0x00000000 }, /*  54: -1.5050007e+00  1.2126040e-01  0.0000000e+00 */
    { 0xc05562d2,0x3ddbf37f,0x00000000 }, /*  55: -3.3341565e+00  1.0739803e-01  0.0000000e+00 */
    { 0x3e2c4c0f,0x3e9e4ec6,0x00000000 }, /*  56:  1.6825889e-01  3.0919474e-01  0.0000000e+00 */
    { 0xbf68d9ea,0xbeac5e99,0x00000000 }, /*  57: -9.0957510e-01 -3.3665922e-01  0.0000000e+00 */
    { 0xc2df2291,0xbfb97710,0x00000000 }, /*  58: -1.1156751e+02 -1.4489460e+00  0.0000000e+00 */
    { 0x4072774f,0xbf451a2c,0x4091deed }, /*  59:  3.7885320e+00 -7.6993060e-01  4.5584626e+00 */
    { 0xc1d5a29b,0xb58c2e49,0x00000000 }, /*  60: -2.6704397e+01 -1.0444284e-06  0.0000000e+00 */
    { 0xc5cfb6f0,0x42c576f8,0x00000000 }, /*  61: -6.6468672e+03  9.8732361e+01  0.0000000e+00 */
    { 0xbee50045,0x4e70c02f,0x00000000 }, /*  62: -4.4726768e-01  1.0097817e+09  0.0000000e+00 */
    { 0x3f59008d,0xbf55d75c,0x3fd76bf4 }, /*  63:  8.4766465e-01 -8.3531737e-01  1.6829820e+00 */
    { 0x3c496cdc,0xbf0eb4a0,0x3f11da53 }, /*  64:  1.2294021e-02 -5.5744362e-01  5.6973761e-01 */
    { 0x44b3331d,0xc2f4cedb,0x44c2800b }, /*  65:  1.4335973e+03 -1.2240401e+02  1.5560013e+03 */
    { 0x44510d0f,0x3e6b0efb,0x4450fe5e }, /*  66:  8.3620404e+02  2.2954933e-01  8.3597449e+02 */
    { 0x3a56841a,0x3fc1b65e,0x00000000 }, /*  67:  8.1831368e-04  1.5133779e+00  0.0000000e+00 */
    { 0x3f55d149,0xba004d19,0x3f55f15c }, /*  68:  8.3522469e-01 -4.8943009e-04  8.3571410e-01 */
    { 0xc299108b,0x3fc03fe6,0x00000000 }, /*  69: -7.6532310e+01  1.5019500e+00  0.0000000e+00 */
    { 0x3edbcfa6,0x4032815e,0x00000000 }, /*  70:  4.2931861e-01  2.7891459e+00  0.0000000e+00 */
    { 0x40f7d1bc,0xc06b1caf,0x4136b00a }, /*  71:  7.7443523e+00 -3.6736257e+00  1.1417978e+01 */
    { 0xc0220bcf,0x402d0066,0x00000000 }, /*  72: -2.5319707e+00  2.7031493e+00  0.0000000e+00 */
    { 0xbf504b90,0xbe4dab9a,0x00000000 }, /*  73: -8.1365299e-01 -2.0084992e-01  0.0000000e+00 */
    { 0xbff7bfa4,0xc0c98707,0x408b971e }, /*  74: -1.9355359e+00 -6.2977328e+00  4.3621969e+00 */
    { 0xc06c7ccc,0x39ca663e,0x00000000 }, /*  75: -3.6951170e+00  3.8604619e-04  0.0000000e+00 */
    { 0x40670d68,0x4061a9d1,0x3dac72e0 }, /*  76:  3.6101933e+00  3.5259898e+00  8.4203482e-02 */
    { 0xbba9bf88,0xc0cd30ba,0x40cd064a }, /*  77: -5.1803030e-03 -6.4121981e+00  6.4070177e+00 */
    { 0x3fa457d5,0x3d5fd222,0x3f9d5944 }, /*  78:  1.2839304e+00  5.4643758e-02  1.2292867e+00 */
    { 0xbfa8cc2d,0xbff92540,0x3f20b226 }, /*  79: -1.3187310e+00 -1.9464493e+00  6.2771833e-01 */
    { 0xbf8fa4e9,0xac43ec47,0x00000000 }, /*  80: -1.1222202e+00 -2.7842327e-12  0.0000000e+00 */
    { 0xc0100963,0x3ece6952,0x00000000 }, /*  81: -2.2505729e+00  4.0314728e-01  0.0000000e+00 */
    { 0xbcb96961,0x3f5b7ae8,0x00000000 }, /*  82: -2.2633256e-02  8.5734415e-01  0.0000000e+00 */
    { 0x41e6928b,0x3f558f0f,0x41dfe613 }, /*  83:  2.8821554e+01  8.3421415e-01  2.7987341e+01 */
    { 0x3e6d490c,0x3eda047b,0x00000000 }, /*  84:  2.3172396e-01  4.2581543e-01  0.0000000e+00 */
    { 0xb9035e6c,0xbfaa6abd,0x3faa66a2 }, /*  85: -1.2528308e-04 -1.3313824e+00  1.3312571e+00 */
    { 0x3fce64ec,0xbfbf0ad6,0x4046b7e1 }, /*  86:  1.6124549e+00 -1.4925182e+00  3.1049731e+00 */
    { 0xb7ac2b82,0x3e45667a,0x00000000 }, /*  87: -2.0524258e-05  1.9277373e-01  0.0000000e+00 */
    { 0xbf9ddf9e,0x3f67c299,0x00000000 }, /*  88: -1.2333868e+00  9.0531307e-01  0.0000000e+00 */
    { 0x3ef1e122,0x3f7b5bb6,0x00000000 }, /*  89:  4.7242075e-01  9.8186815e-01  0.0000000e+00 */
    { 0xbf586dae,0xbe84af08,0x00000000 }, /*  90: -8.4542358e-01 -2.5914788e-01  0.0000000e+00 */
    { 0xbfb9bfb7,0x3f3c23a2,0x00000000 }, /*  91: -1.4511632e+00  7.3491871e-01  0.0000000e+00 */
    { 0xbecd487b,0x3faba2e6,0x00000000 }, /*  92: -4.0094361e-01  1.3409088e+00  0.0000000e+00 */
    { 0xbee5e210,0x404ec54f,0x00000000 }, /*  93: -4.4899035e-01  3.2307928e+00  0.0000000e+00 */
    { 0xc11375ec,0xc003ae89,0x00000000 }, /*  94: -9.2162895e+00 -2.0575278e+00  0.0000000e+00 */
    { 0xbfa1b801,0xbea38f7b,0x00000000 }, /*  95: -1.2634279e+00 -3.1945404e-01  0.0000000e+00 */
    { 0x3f4713be,0xc011fe95,0x4043c384 }, /*  96:  7.7764499e-01 -2.2811635e+00  3.0588083e+00 */
    { 0x3d81193d,0x3d327de7,0x3c9f6926 }, /*  97:  6.3036419e-02  4.3577101e-02  1.9459318e-02 */
    { 0x3d5be341,0xbc601350,0x3d89f40a }, /*  98:  5.3683523e-02 -1.3676479e-02  6.7359999e-02 */
    { 0x3fa4af81,0xbfa80cc3,0x40265e22 }, /*  99:  1.2866060e+00 -1.3128895e+00  2.5994954e+00 */
    { 0x42643488,0x403fa89f,0x425839fe }, /* 100:  5.7051300e+01  2.9946668e+00  5.4056633e+01 */
    { 0xbee2e351,0xc0aa3610,0x409c07db }, /* 101: -4.4314054e-01 -5.3190994e+00  4.8759589e+00 */
    { 0x3f96f3c9,0xbfb932c2,0x40281346 }, /* 102:  1.1793147e+00 -1.4468615e+00  2.6261764e+00 */
    { 0x3fafb088,0xbf51977a,0x400c3e22 }, /* 103:  1.3725748e+00 -8.1871760e-01  2.1912923e+00 */
    { 0x3f5bd3e6,0x3fa61da3,0x00000000 }, /* 104:  8.5870206e-01  1.2977794e+00  0.0000000e+00 */
    { 0x40ed82e8,0xc059a481,0x412d2a94 }, /* 105:  7.4222298e+00 -3.4006655e+00  1.0822895e+01 */
    { 0xbfb3e610,0x40582007,0x00000000 }, /* 106: -1.4054585e+00  3.3769548e+00  0.0000000e+00 */
    { 0x3b46d4c5,0xbee9767a,0x3eeb0424 }, /* 107:  3.0339223e-03 -4.5598203e-01  4.5901597e-01 */
    { 0xc2e88a16,0x77003235,0x00000000 }, /* 108: -1.1626970e+02  2.6001262e+33  0.0000000e+00 */
    { 0x3edbe16c,0xbf6df2ab,0x3fadf1b0 }, /* 109:  4.2945421e-01 -9.2948407e-01  1.3589382e+00 */
    { 0x4013e7a9,0x40899737,0x00000000 }, /* 110:  2.3110144e+00  4.2997088e+00  0.0000000e+00 */
    { 0xbe1a9c13,0xbf0264be,0x3eb77b72 }, /* 111: -1.5098600e-01 -5.0934970e-01  3.5836369e-01 */
    { 0xc02194d2,0xbf980b9d,0x00000000 }, /* 112: -2.5247083e+00 -1.1878544e+00  0.0000000e+00 */
    { 0x3f44a53d,0xbeca856f,0x3f94f3fa }, /* 113:  7.6814634e-01 -3.9554927e-01  1.1636956e+00 */
    { 0x3eafba32,0x402788ce,0x00000000 }, /* 114:  3.4321743e-01  2.6177249e+00  0.0000000e+00 */
    { 0x3f4fa170,0xc0582b0f,0x408609b6 }, /* 115:  8.1105709e-01 -3.3776281e+00  4.1886854e+00 */
    { 0xc01eb4a4,0xc0ea5bf8,0x409b01a6 }, /* 116: -2.4797754e+00 -7.3237267e+00  4.8439512e+00 */
    { 0xbdfffae4,0x40734089,0x00000000 }, /* 117: -1.2499025e-01  3.8008139e+00  0.0000000e+00 */
    { 0xbfa7b988,0x3fb7a4ce,0x00000000 }, /* 118: -1.3103495e+00  1.4347169e+00  0.0000000e+00 */
    { 0xbfb64f8d,0xbf50e799,0x00000000 }, /* 119: -1.4243027e+00 -8.1603390e-01  0.0000000e+00 */
    { 0x3f470bad,0xbfacb5ce,0x40081dd2 }, /* 120:  7.7752191e-01 -1.3492982e+00  2.1268201e+00 */
    { 0xbfb6c582,0x404000ed,0x00000000 }, /* 121: -1.4279025e+00  3.0000565e+00  0.0000000e+00 */
    { 0xc044baa9,0xbf565886,0x00000000 }, /* 122: -3.0738928e+00 -8.3728826e-01  0.0000000e+00 */
    { 0x3fb7048f,0x3f4db00e,0x3f205910 }, /* 123:  1.4298266e+00  8.0346763e-01  6.2635899e-01 */
    { 0xc21ed21c,0xbf559825,0x00000000 }, /* 124: -3.9705185e+01 -8.3435279e-01  0.0000000e+00 */
    { 0x3fb47d3c,0xbe343e11,0x3fcb04fe }, /* 125:  1.4100718e+00 -1.7601801e-01  1.5860898e+00 */
    { 0x3f9d6936,0x3fa8e541,0x00000000 }, /* 126:  1.2297733e+00  1.3194963e+00  0.0000000e+00 */
    { 0x32d1587d,0x3edf9b2c,0x00000000 }, /* 127:  2.4371042e-08  4.3673074e-01  0.0000000e+00 */
    { 0x41298b3e,0xbed3a31c,0x41302857 }, /* 128:  1.0596495e+01 -4.1335380e-01  1.1009849e+01 */
    { 0x3f3c2e3b,0x3f40c8da,0x00000000 }, /* 129:  7.3508042e-01  7.5306475e-01  0.0000000e+00 */
    { 0xbd5d6f33,0xc07713d7,0x40739e1a }, /* 130: -5.4061126e-02 -3.8605859e+00  3.8065248e+00 */
    { 0x40a0cd1c,0x3fb7f461,0x4065a008 }, /* 131:  5.0250378e+00  1.4371454e+00  3.5878925e+00 */
    { 0xbf4d39a1,0x3dc7ba12,0x00000000 }, /* 132: -8.0166060e-01  9.7522870e-02  0.0000000e+00 */
    { 0xbc4babd6,0x3f404bd3,0x00000000 }, /* 133: -1.2431106e-02  7.5115699e-01  0.0000000e+00 */
    { 0xbe3cccba,0x3e24aa3c,0x00000000 }, /* 134: -1.8437472e-01  1.6080564e-01  0.0000000e+00 */
    { 0xbe33d75f,0xbd980b04,0x00000000 }, /* 135: -1.7562626e-01 -7.4239761e-02  0.0000000e+00 */
    { 0xbfc357af,0x406d4a0b,0x00000000 }, /* 136: -1.5261134e+00  3.7076442e+00  0.0000000e+00 */
    { 0x3ef90645,0x40403851,0x00000000 }, /* 137:  4.8637596e-01  3.0034373e+00  0.0000000e+00 */
    { 0xbf6f1eb1,0x3f62f7a3,0x00000000 }, /* 138: -9.3406206e-01  8.8659114e-01  0.0000000e+00 */
    { 0x423240eb,0xbfba1ce4,0x423811d2 }, /* 139:  4.4563396e+01 -1.4540067e+00  4.6017403e+01 */
    { 0x3f397bd9,0xc077335e,0x4092c92a }, /* 140:  7.2454602e-01 -3.8625102e+00  4.5870562e+00 */
    { 0x3ff32095,0x41dc0dd4,0x00000000 }, /* 141:  1.8994318e+00  2.7506752e+01  0.0000000e+00 */
    { 0x43322a4f,0xc239a492,0x43609374 }, /* 142:  1.7816527e+02 -4.6410713e+01  2.2457599e+02 */
    { 0xbfae12b5,0xc07b5f8a,0x40245630 }, /* 143: -1.3599459e+00 -3.9277062e+00  2.5677605e+00 */
    { 0xbfa03b12,0xc097e3d6,0x405faa23 }, /* 144: -1.2518027e+00 -4.7465620e+00  3.4947593e+00 */
    { 0x3e54d4a1,0xc0388137,0x4045ce81 }, /* 145:  2.0784236e-01 -2.8828866e+00  3.0907290e+00 */
    { 0x3fc0fbdb,0xc107c579,0x411fe4f4 }, /* 146:  1.5076860e+00 -8.4857111e+00  9.9933968e+00 */
    { 0x3e8e76e5,0x3f5da93b,0x00000000 }, /* 147:  2.7825084e-01  8.6586350e-01  0.0000000e+00 */
    { 0x3fb59141,0x8f78727c,0x3fb59141 }, /* 148:  1.4184953e+00 -1.2249393e-29  1.4184953e+00 */
    { 0xc0312d02,0xc0510f00,0x3eff0ff0 }, /* 149: -2.7683721e+00 -3.2665405e+00  4.9816847e-01 */
    { 0xbf4f28aa,0xbce8119d,0x00000000 }, /* 150: -8.0921423e-01 -2.8328711e-02  0.0000000e+00 */
    { 0xbfb5f033,0x3e59ccac,0x00000000 }, /* 151: -1.4213928e+00  2.1269482e-01  0.0000000e+00 */
    { 0xc187689b,0xc1d69e46,0x411e6b56 }, /* 152: -1.6926077e+01 -2.6827282e+01  9.9012051e+00 */
    { 0xbedef611,0x3e973a44,0x00000000 }, /* 153: -4.3547109e-01  2.9536641e-01  0.0000000e+00 */
    { 0x3f4a4b24,0xc091db56,0x40ab24ba }, /* 154:  7.9020905e-01 -4.5580244e+00  5.3482332e+00 */
    { 0x3f6e91a9,0x3c3f0809,0x3f6b9589 }, /* 155:  9.3191010e-01  1.1659631e-02  9.2025048e-01 */
    { 0x4d92957d,0x3e756b49,0x4d92957d }, /* 156:  3.0740880e+08  2.3966707e-01  3.0740880e+08 */
    { 0x3f9c642b,0xba31369b,0x3f9c7a52 }, /* 157:  1.2218069e+00 -6.7601510e-04  1.2224829e+00 */
    { 0xbe1346de,0xc0258558,0x401c50ea }, /* 158: -1.4382502e-01 -2.5862637e+00  2.4424386e+00 */
    { 0x49a2107c,0xc25ce455,0x49a21236 }, /* 159:  1.3276315e+06 -5.5222980e+01  1.3276868e+06 */
    { 0x3eddd43a,0xc058e13b,0x40749bc2 }, /* 160:  4.3325979e-01 -3.3887470e+00  3.8220067e+00 */
    { 0x3fad31bd,0x3ec29e27,0x3f791466 }, /* 161:  1.3530804e+00  3.8011286e-01  9.7296751e-01 */
    { 0xc02c56e7,0x3ea5cf80,0x00000000 }, /* 162: -2.6928041e+00  3.2384872e-01  0.0000000e+00 */
    { 0xbf0c0f42,0xbb744b3e,0x00000000 }, /* 163: -5.4710782e-01 -3.7276293e-03  0.0000000e+00 */
    { 0x410b17cf,0xbf63d99b,0x41195569 }, /* 164:  8.6933126e+00 -8.9003915e-01  9.5833521e+00 */
    { 0x40d3a4bd,0x3f46c1e9,0x40bacc80 }, /* 165:  6.6138597e+00  7.7639633e-01  5.8374634e+00 */
    { 0x3f5c89e1,0x3f55529a,0x3ce6e8e0 }, /* 166:  8.6147887e-01  8.3329165e-01  2.8187215e-02 */
    { 0xbf9bce29,0x49ca83e3,0x00000000 }, /* 167: -1.2172290e+00  1.6590044e+06  0.0000000e+00 */
    { 0x3fb24064,0xbf52ec34,0x400ddb3f }, /* 168:  1.3925900e+00 -8.2391667e-01  2.2165067e+00 */
    { 0xc22ecf87,0x410e16f8,0x00000000 }, /* 169: -4.3702663e+01  8.8806076e+00  0.0000000e+00 */
    { 0xbfc7dee0,0x3fb96c8a,0x00000000 }, /* 170: -1.5614891e+00  1.4486248e+00  0.0000000e+00 */
    { 0x3eb6ba04,0x3f4239db,0x00000000 }, /* 171:  3.5688794e-01  7.5869530e-01  0.0000000e+00 */
    { 0x4316ae6a,0x3fb7ae02,0x43153f0e }, /* 172:  1.5068130e+02  1.4349978e+00  1.4924631e+02 */
    { 0xbec1efc0,0x3f517fc6,0x00000000 }, /* 173: -3.7878227e-01  8.1835592e-01  0.0000000e+00 */
    { 0xc28242f8,0x3ca24258,0x00000000 }, /* 174: -6.5130798e+01  1.9807026e-02  0.0000000e+00 */
    { 0x3f013259,0xc0ca5482,0x40da7acd }, /* 175:  5.0467449e-01 -6.3228159e+00  6.8274903e+00 */
    { 0x3f3f726a,0x44ef75a1,0x00000000 }, /* 176:  7.4783957e-01  1.9156759e+03  0.0000000e+00 */
    { 0xbbb52383,0xbff41e06,0x3ff368e2 }, /* 177: -5.5279150e-03 -1.9071662e+00  1.9016383e+00 */
    { 0x3c5db2af,0xbe2186e7,0x3e2f6212 }, /* 178:  1.3531371e-02 -1.5774117e-01  1.7127255e-01 */
    { 0x3e278bea,0x3eb4e7ca,0x00000000 }, /* 179:  1.6361967e-01  3.5333091e-01  0.0000000e+00 */
    { 0xbfa9c009,0x3fadd211,0x00000000 }, /* 180: -1.3261729e+00  1.3579732e+00  0.0000000e+00 */
    { 0xbf430600,0xbe34b6ad,0x00000000 }, /* 181: -7.6181030e-01 -1.7647810e-01  0.0000000e+00 */
    { 0xbec88a49,0x3f425390,0x00000000 }, /* 182: -3.9168003e-01  7.5908756e-01  0.0000000e+00 */
    { 0x4292d200,0xc166a189,0x42afa631 }, /* 183:  7.3410156e+01 -1.4414437e+01  8.7824593e+01 */
    { 0x3f45880e,0xc024e814,0x40564a18 }, /* 184:  7.7160728e-01 -2.5766649e+00  3.3482723e+00 */
    { 0x3fb7e695,0x3fbf4031,0x00000000 }, /* 185:  1.4367243e+00  1.4941465e+00  0.0000000e+00 */
    { 0xbf4f65b6,0xc0f616aa,0x40dc29f3 }, /* 186: -8.1014574e-01 -7.6902666e+00  6.8801208e+00 */
    { 0x3f439f52,0xc0cbd678,0x40e44a62 }, /* 187:  7.6414979e-01 -6.3699303e+00  7.1340799e+00 */
    { 0x401cf799,0xbf4fba93,0x4050e63e }, /* 188:  2.4526122e+00 -8.1144065e-01  3.2640529e+00 */
    { 0x3f4f4870,0x3e4f32c0,0x3f1b7bc0 }, /* 189:  8.0969906e-01  2.0234203e-01  6.0735703e-01 */
    { 0xbe1cf98b,0x409770f7,0x00000000 }, /* 190: -1.5329568e-01  4.7325397e+00  0.0000000e+00 */
    { 0x3edea295,0xbfb0d22f,0x3fe87ad4 }, /* 191:  4.3483415e-01 -1.3814143e+00  1.8162484e+00 */
    { 0xc4d3adba,0x4152adb9,0x00000000 }, /* 192: -1.6934290e+03  1.3167413e+01  0.0000000e+00 */
    { 0x40a1f991,0xbd50408c,0x40a39a12 }, /* 193:  5.0617146e+00 -5.0842807e-02  5.1125574e+00 */
    { 0xbf64e2f2,0xbfaaf1d7,0x3ee20178 }, /* 194: -8.9408791e-01 -1.3355054e+00  4.4141746e-01 */
    { 0xbfa43e62,0x3e192bda,0x00000000 }, /* 195: -1.2831538e+00  1.4958134e-01  0.0000000e+00 */
    { 0xbfa7718a,0x3c89a44b,0x00000000 }, /* 196: -1.3081524e+00  1.6801974e-02  0.0000000e+00 */
    { 0x4044f877,0xbef1ca8e,0x406331c9 }, /* 197:  3.0776651e+00 -4.7224849e-01  3.5499136e+00 */
    { 0xc0ec55d1,0x399799b6,0x00000000 }, /* 198: -7.3854756e+00  2.8915488e-04  0.0000000e+00 */
    { 0x40c1366a,0xbfbaf220,0x40eff2f2 }, /* 199:  6.0378923e+00 -1.4605141e+00  7.4984064e+00 */
    { 0x3e10b5d7,0xbee15b64,0x3f14db28 }, /* 200:  1.4131866e-01 -4.4015038e-01  5.8146906e-01 */
    { 0x3fb27ff0,0x3fa566f8,0x3dd18f80 }, /* 201:  1.3945293e+00  1.2922049e+00  1.0232449e-01 */
    { 0x3faea543,0xbe57506c,0x3fc98f50 }, /* 202:  1.3644184e+00 -2.1026772e-01  1.5746861e+00 */
    { 0x3f355395,0xbf9484eb,0x3fef2eb6 }, /* 203:  7.0830661e-01 -1.1603063e+00  1.8686130e+00 */
    { 0xc191ed39,0x403318ef,0x00000000 }, /* 204: -1.8240831e+01  2.7983968e+00  0.0000000e+00 */
    { 0x3f6b5355,0x41655816,0x00000000 }, /* 205:  9.1924030e-01  1.4334005e+01  0.0000000e+00 */
    { 0xb61b1f7d,0x3fc71512,0x00000000 }, /* 206: -2.3115128e-06  1.5553305e+00  0.0000000e+00 */
    { 0xbde66394,0x3ed73369,0x00000000 }, /* 207: -1.1249462e-01  4.2031410e-01  0.0000000e+00 */
    { 0x4068b6f3,0xbfaaebe8,0x409f1674 }, /* 208:  3.6361663e+00 -1.3353243e+00  4.9714909e+00 */
    { 0x40ff00bd,0xc0afd7d7,0x41576c4a }, /* 209:  7.9688401e+00 -5.4950976e+00  1.3463938e+01 */
    { 0xbccba4f6,0xbc5f1954,0x00000000 }, /* 210: -2.4858933e-02 -1.3616879e-02  0.0000000e+00 */
    { 0xbfb32b03,0xbfb44669,0x3c0db300 }, /* 211: -1.3997501e+00 -1.4083987e+00  8.6486340e-03 */
    { 0xc0ba0266,0x3e21f112,0x00000000 }, /* 212: -5.8127928e+00  1.5814617e-01  0.0000000e+00 */
    { 0x3e951ec5,0x3e9b96ef,0x00000000 }, /* 213:  2.9125038e-01  3.0388591e-01  0.0000000e+00 */
    { 0x3f428fca,0x3fa5d472,0x00000000 }, /* 214:  7.6000655e-01  1.2955458e+00  0.0000000e+00 */
    { 0x3edf11ac,0xbec3e603,0x3f517bd8 }, /* 215:  4.3568170e-01 -3.8261423e-01  8.1829596e-01 */
    { 0x4053b6bf,0x40e27196,0x00000000 }, /* 216:  3.3080289e+00  7.0763655e+00  0.0000000e+00 */
    { 0xc1018f18,0x3d0c4b68,0x00000000 }, /* 217: -8.0974350e+00  3.4251601e-02  0.0000000e+00 */
    { 0xbea63c22,0x3f68016b,0x00000000 }, /* 218: -3.2467753e-01  9.0627164e-01  0.0000000e+00 */
    { 0xbef93b9e,0x3d4d15de,0x00000000 }, /* 219: -4.8678297e-01  5.0069682e-02  0.0000000e+00 */
    { 0xbfbfc4d2,0xbf62ac52,0x00000000 }, /* 220: -1.4981940e+00 -8.8544190e-01  0.0000000e+00 */
    { 0xbe5c6596,0x3f9f54b7,0x00000000 }, /* 221: -2.1523127e-01  1.2447728e+00  0.0000000e+00 */
    { 0xbf4bc023,0x3fae9aea,0x00000000 }, /* 222: -7.9590052e-01  1.3641026e+00  0.0000000e+00 */
    { 0xb83ad2b3,0xbf49b289,0x3f49af9e }, /* 223: -4.4542085e-05 -7.8788048e-01  7.8783596e-01 */
    { 0xbf9c0946,0x3ea9da7b,0x00000000 }, /* 224: -1.2190330e+00  3.3174500e-01  0.0000000e+00 */
    { 0xbc247485,0xc0262f27,0x40258ab2 }, /* 225: -1.0037546e-02 -2.5966280e+00  2.5865903e+00 */
    { 0x4076b931,0x3f006af6,0x40569e74 }, /* 226:  3.8550532e+00  5.0163209e-01  3.3534212e+00 */
    { 0xbf3bbdb5,0x3fbb52bd,0x00000000 }, /* 227: -7.3336345e-01  1.4634625e+00  0.0000000e+00 */
    { 0x4014f0cb,0xbfa7f887,0x4068ed0e }, /* 228:  2.3271968e+00 -1.3122720e+00  3.6394687e+00 */
    { 0xb4fde018,0x3e56dfe2,0x00000000 }, /* 229: -4.7287972e-07  2.0983842e-01  0.0000000e+00 */
    { 0xc022d5e6,0x3fb892d5,0x00000000 }, /* 230: -2.5443053e+00  1.4419810e+00  0.0000000e+00 */
    { 0xc1294ccb,0x3f51472b,0x00000000 }, /* 231: -1.0581248e+01  8.1749219e-01  0.0000000e+00 */
    { 0x4e65dde8,0xc184e528,0x4e65dde8 }, /* 232:  9.6413133e+08 -1.6611893e+01  9.6413133e+08 */
    { 0xbf6623f2,0xbfb15cb1,0x3ef92ae0 }, /* 233: -8.9898598e-01 -1.3856412e+00  4.8665524e-01 */
    { 0xbed9f314,0x413c2c46,0x00000000 }, /* 234: -4.2568266e-01  1.1760809e+01  0.0000000e+00 */
    { 0x3d753a67,0xbf47fcd2,0x3f575078 }, /* 235:  5.9870150e-02 -7.8120148e-01  8.4107161e-01 */
    { 0xbf4a06a2,0xbec334c4,0x00000000 }, /* 236: -7.8916371e-01 -3.8126194e-01  0.0000000e+00 */
    { 0xbec62c0f,0x408825b4,0x00000000 }, /* 237: -3.8705489e-01  4.2546024e+00  0.0000000e+00 */
    { 0xbfade1fb,0x3f5947d3,0x00000000 }, /* 238: -1.3584589e+00  8.4875220e-01  0.0000000e+00 */
    { 0xbe96d050,0x3fadb615,0x00000000 }, /* 239: -2.9455805e-01  1.3571192e+00  0.0000000e+00 */
    { 0xbfc06d28,0x4016b3e1,0x00000000 }, /* 240: -1.5033312e+00  2.3547289e+00  0.0000000e+00 */
    { 0xbeaec912,0xbfbacaa6,0x3f8f1862 }, /* 241: -3.4137779e-01 -1.4593093e+00  1.1179316e+00 */
    { 0xbf5d0361,0xbdcc7dc7,0x00000000 }, /* 242: -8.6333281e-01 -9.9849276e-02  0.0000000e+00 */
    { 0xc0bdf6f0,0xbfaf3298,0x00000000 }, /* 243: -5.9363937e+00 -1.3687315e+00  0.0000000e+00 */
    { 0x40073ae8,0x40cbdf1c,0x00000000 }, /* 244:  2.1129704e+00  6.3709850e+00  0.0000000e+00 */
    { 0x3f63111a,0xbeef59a8,0x3fad5ef7 }, /* 245:  8.8697970e-01 -4.6748090e-01  1.3544606e+00 */
    { 0xc1f42cb6,0xbeb04e3b,0x00000000 }, /* 246: -3.0521832e+01 -3.4434685e-01  0.0000000e+00 */
    { 0xd968428e,0x3f630d88,0x00000000 }, /* 247: -4.0859608e+15  8.8692522e-01  0.0000000e+00 */
    { 0x3c719673,0x3f4c1e80,0x00000000 }, /* 248:  1.4745343e-02  7.9734039e-01  0.0000000e+00 */
    { 0x408f12dc,0xc5ba3c67,0x45ba602c }, /* 249:  4.4710522e+00 -5.9595503e+03  5.9640215e+03 */
    { 0xbec90491,0xbfbddd03,0x3f8b9bdf }, /* 250: -3.9261296e-01 -1.4833072e+00  1.0906943e+00 */
    { 0xbeaeade7,0x40ab5a07,0x00000000 }, /* 251: -3.4117052e-01  5.3547397e+00  0.0000000e+00 */
    { 0x3e3e502d,0x3e8c3083,0x00000000 }, /* 252:  1.8585272e-01  2.7380762e-01  0.0000000e+00 */
    { 0x3f9576ce,0xb99b7d13,0x3f958086 }, /* 253:  1.1676881e+00 -2.9657091e-04  1.1679847e+00 */
    { 0x3e60b1b4,0x3a165700,0x3e601b5d }, /* 254:  2.1942788e-01  5.7350099e-04  2.1885438e-01 */
    { 0xbf46229b,0x409e774b,0x00000000 }, /* 255: -7.7396554e-01  4.9520621e+00  0.0000000e+00 */
    { 0x3fa97f20,0x3d85dd7b,0x3fa12148 }, /* 256:  1.3241920e+00  6.5363847e-02  1.2588282e+00 */
    { 0x40e7c2e2,0x400563c9,0x40a510fe }, /* 257:  7.2425394e+00  2.0842154e+00  5.1583242e+00 */
    { 0xc06bd32c,0x3d95fc16,0x00000000 }, /* 258: -3.6847639e+00  7.3234722e-02  0.0000000e+00 */
    { 0x410f17b9,0xc06b4ee9,0x4149eb73 }, /* 259:  8.9432917e+00 -3.6766913e+00  1.2619983e+01 */
    { 0xbe744cfc,0xbf4fe702,0x3f12d3c3 }, /* 260: -2.3857492e-01 -8.1211865e-01  5.7354373e-01 */
    { 0x3e9fe398,0xc05a2e3b,0x406e2aae }, /* 261:  3.1228328e-01 -3.4090717e+00  3.7213550e+00 */
    { 0xbf5f11ba,0x3e9d9b48,0x00000000 }, /* 262: -8.7136424e-01  3.0782533e-01  0.0000000e+00 */
    { 0xc03cdb06,0xbf49009e,0x00000000 }, /* 263: -2.9508681e+00 -7.8516567e-01  0.0000000e+00 */
    { 0xd6b46d94,0x3fb434c7,0x00000000 }, /* 264: -9.9191364e+13  1.4078606e+00  0.0000000e+00 */
    { 0xbef2e4c7,0xbe086244,0x00000000 }, /* 265: -4.7440168e-01 -1.3318735e-01  0.0000000e+00 */
    { 0xc84e4ee3,0xc001a386,0x00000000 }, /* 266: -2.1125955e+05 -2.0256057e+00  0.0000000e+00 */
    { 0x4399130f,0x3e885b43,0x4398f0f8 }, /* 267:  3.0614890e+02  2.6632127e-01  3.0588257e+02 */
    { 0x3fc78794,0xbd84f870,0x3fcfd71b }, /* 268:  1.5588250e+00 -6.4926982e-02  1.6237520e+00 */
    { 0xc014876f,0xbe9782c0,0x00000000 }, /* 269: -2.3207662e+00 -2.9591942e-01  0.0000000e+00 */
    { 0xbf4aeb77,0x3e847a63,0x00000000 }, /* 270: -7.9265541e-01  2.5874624e-01  0.0000000e+00 */
    { 0x3fb7142d,0x3f4b672f,0x3f22c12b }, /* 271:  1.4303032e+00  7.9454321e-01  6.3576001e-01 */
    { 0xbe042c4d,0x6c526e6f,0x00000000 }, /* 272: -1.2907524e-01  1.0175837e+27  0.0000000e+00 */
    { 0xbe650e4a,0xbf5a208b,0x3f20dcf8 }, /* 273: -2.2368732e-01 -8.5205907e-01  6.2837172e-01 */
    { 0xc051d9ab,0xc1674b01,0x4132d496 }, /* 274: -3.2789104e+00 -1.4455812e+01  1.1176901e+01 */
    { 0xc11deae4,0xbec71e2a,0x00000000 }, /* 275: -9.8698463e+00 -3.8890201e-01  0.0000000e+00 */
    { 0xd1aae354,0x3c019166,0x00000000 }, /* 276: -9.1744797e+10  7.9082008e-03  0.0000000e+00 */
    { 0x40590535,0xc0421fad,0x40cd9271 }, /* 277:  3.3909428e+00 -3.0331833e+00  6.4241261e+00 */
    { 0xbf4d655b,0x3e8989f2,0x00000000 }, /* 278: -8.0232781e-01  2.6863056e-01  0.0000000e+00 */
    { 0xbebfb0cf,0xbf489838,0x3ed17fa1 }, /* 279: -3.7439582e-01 -7.8357267e-01  4.0917686e-01 */
    { 0xc06d2967,0x3e75b75b,0x00000000 }, /* 280: -3.7056520e+00  2.3995726e-01  0.0000000e+00 */
    { 0xbfbd8931,0xbf717bcb,0x00000000 }, /* 281: -1.4807492e+00 -9.4329518e-01  0.0000000e+00 */
    { 0xbf5fe49e,0xd92e9088,0x592e9088 }, /* 282: -8.7458217e-01 -3.0709725e+15  3.0709725e+15 */
    { 0xc03a22fc,0xbf91cc4a,0x00000000 }, /* 283: -2.9083853e+00 -1.1390469e+00  0.0000000e+00 */
    { 0xc094bc4c,0x43b4c720,0x00000000 }, /* 284: -4.6479855e+00  3.6155566e+02  0.0000000e+00 */
    { 0x3f56201f,0xbada2104,0x3f568d30 }, /* 285:  8.3642763e-01 -1.6641920e-03  8.3809185e-01 */
    { 0x45f17867,0x3f4dfadb,0x45f171f7 }, /* 286:  7.7270503e+03  8.0460900e-01  7.7262456e+03 */
    { 0x3ebe6cc8,0x3fb9830d,0x00000000 }, /* 287:  3.7192369e-01  1.4493119e+00  0.0000000e+00 */
    { 0xbedb7a5f,0x3f3f8276,0x00000000 }, /* 288: -4.2866799e-01  7.4808443e-01  0.0000000e+00 */
    { 0xc06e6ca5,0x409bdeb9,0x00000000 }, /* 289: -3.7253811e+00  4.8709378e+00  0.0000000e+00 */
    { 0x3fb66059,0xc0b8069b,0x40e59eb1 }, /* 290:  1.4248153e+00 -5.7508063e+00  7.1756215e+00 */
    { 0xbfa6826d,0xc18549c9,0x4175c344 }, /* 291: -1.3008553e+00 -1.6661028e+01  1.5360172e+01 */
    { 0x3da39768,0x4016a041,0x00000000 }, /* 292:  7.9878628e-02  2.3535311e+00  0.0000000e+00 */
    { 0xbbeb159b,0x3c02ab12,0x00000000 }, /* 293: -7.1742064e-03  7.9753567e-03  0.0000000e+00 */
    { 0x406347e9,0xc02e1d32,0x40c8b28e }, /* 294:  3.5512640e+00 -2.7205319e+00  6.2717962e+00 */
    { 0x3f4c021e,0xbe903821,0x3f8a0f17 }, /* 295:  7.9690731e-01 -2.8167823e-01  1.0785855e+00 */
    { 0xbecf6b9d,0xbfb25725,0x3f7cf87c }, /* 296: -4.0511790e-01 -1.3932844e+00  9.8816657e-01 */
    { 0xbf4e71c1,0x3fc87d64,0x00000000 }, /* 297: -8.0642325e-01  1.5663266e+00  0.0000000e+00 */
    { 0x405ad7fc,0x3f4b6f11,0x4027fc38 }, /* 298:  3.4194326e+00  7.9466349e-01  2.6247692e+00 */
    { 0x27b48156,0x3e770123,0x00000000 }, /* 299:  5.0100262e-15  2.4121527e-01  0.0000000e+00 */
    { 0xbe9f4b00,0xbe8377f7,0x00000000 }, /* 300: -3.1111908e-01 -2.5677463e-01  0.0000000e+00 */
    { 0xbfa6daba,0x3e926c8c,0x00000000 }, /* 301: -1.3035500e+00  2.8598440e-01  0.0000000e+00 */
    { 0x406850ab,0xbfbc5d9d,0x40a33fbd }, /* 302:  3.6299236e+00 -1.4716069e+00  5.1015306e+00 */
    { 0x3f54141e,0x3fb53817,0x00000000 }, /* 303:  8.2843196e-01  1.4157742e+00  0.0000000e+00 */
    { 0x3f63b080,0xbfadcd46,0x400fd2c3 }, /* 304:  8.8941193e-01 -1.3578269e+00  2.2472389e+00 */
    { 0xc040b10f,0xbe1e7cbc,0x00000000 }, /* 305: -3.0108068e+00 -1.5477270e-01  0.0000000e+00 */
    { 0x3d8d79f7,0x3f454a54,0x00000000 }, /* 306:  6.9080286e-02  7.7066541e-01  0.0000000e+00 */
    { 0x41592182,0xd221d271,0x5221d271 }, /* 307:  1.3570681e+01 -1.7375509e+11  1.7375509e+11 */
    { 0xc13fdb34,0x3d0a731d,0x00000000 }, /* 308: -1.1991016e+01  3.3801187e-02  0.0000000e+00 */
    { 0xc0885074,0x400eb1cd,0x00000000 }, /* 309: -4.2598209e+00  2.2296021e+00  0.0000000e+00 */
    { 0x3e776099,0x401cf49f,0x00000000 }, /* 310:  2.4157943e-01  2.4524305e+00  0.0000000e+00 */
    { 0xc05361a7,0x3fbc1927,0x00000000 }, /* 311: -3.3028352e+00  1.4695176e+00  0.0000000e+00 */
    { 0xbf43e367,0x3daf5f02,0x00000000 }, /* 312: -7.6518863e-01  8.5630432e-02  0.0000000e+00 */
    { 0x4034f9a3,0xbe55c52d,0x404255f6 }, /* 313:  2.8277366e+00 -2.0875998e-01  3.0364966e+00 */
    { 0x4063f455,0x4900da4b,0x00000000 }, /* 314:  3.5617878e+00  5.2778069e+05  0.0000000e+00 */
    { 0xc039e1e9,0x3f471b39,0x00000000 }, /* 315: -2.9044135e+00  7.7775913e-01  0.0000000e+00 */
    { 0xbf44cbe9,0x4c7e78dc,0x00000000 }, /* 316: -7.6873642e-01  6.6708336e+07  0.0000000e+00 */
    { 0xc03fbc83,0x3ef572d3,0x00000000 }, /* 317: -2.9958808e+00  4.7939166e-01  0.0000000e+00 */
    { 0xbec4cdc0,0x3fa52f9a,0x00000000 }, /* 318: -3.8438225e-01  1.2905152e+00  0.0000000e+00 */
    { 0xbfa058ff,0x40b71cb2,0x00000000 }, /* 319: -1.2527159e+00  5.7222528e+00  0.0000000e+00 */
    { 0x3eb22648,0x40337d57,0x00000000 }, /* 320:  3.4794831e-01  2.8045251e+00  0.0000000e+00 */
    { 0x3faf607d,0x39ab472b,0x3faf55c9 }, /* 321:  1.3701321e+00  3.2668686e-04  1.3698055e+00 */
    { 0xbdf7c144,0xb51b17e4,0x00000000 }, /* 322: -1.2097409e-01 -5.7776765e-07  0.0000000e+00 */
    { 0xbeba8ed7,0x3ebffa13,0x00000000 }, /* 323: -3.6437103e-01  3.7495479e-01  0.0000000e+00 */
    { 0xc0156112,0x401e3180,0x00000000 }, /* 324: -2.3340497e+00  2.4717712e+00  0.0000000e+00 */
    { 0x3e5e9c95,0x3f4a5713,0x00000000 }, /* 325:  2.1739419e-01  7.9039115e-01  0.0000000e+00 */
    { 0x4110a613,0xc0952210,0x415b371b }, /* 326:  9.0405455e+00 -4.6604080e+00  1.3700953e+01 */
    { 0x41aafd83,0xbebc1993,0x41adede9 }, /* 327:  2.1373785e+01 -3.6738262e-01  2.1741167e+01 */
    { 0xc3079fe5,0x4396404b,0x00000000 }, /* 328: -1.3562459e+02  3.0050229e+02  0.0000000e+00 */
    { 0x3e13b9d2,0xebb82611,0x6bb82611 }, /* 329:  1.4426354e-01 -4.4524423e+26  4.4524423e+26 */
    { 0x420fb49a,0x404f7b0c,0x4202bce9 }, /* 330:  3.5926369e+01  3.2418852e+00  3.2684483e+01 */
    { 0x3fb32389,0x40385726,0x00000000 }, /* 331:  1.3995219e+00  2.8803191e+00  0.0000000e+00 */
    { 0xc1270a07,0xc158dc3f,0x404748e0 }, /* 332: -1.0439948e+01 -1.3553771e+01  3.1138229e+00 */
    { 0xc1d564bc,0xb97ea63d,0x00000000 }, /* 333: -2.6674187e+01 -2.4285256e-04  0.0000000e+00 */
    { 0xbf9fa732,0x401da02f,0x00000000 }, /* 334: -1.2472899e+00  2.4629018e+00  0.0000000e+00 */
    { 0xc016c91e,0x42404291,0x00000000 }, /* 335: -2.3560252e+00  4.8065006e+01  0.0000000e+00 */
    { 0xbfa64ac8,0x3f56240a,0x00000000 }, /* 336: -1.2991571e+00  8.3648741e-01  0.0000000e+00 */
    { 0x3e9cea3d,0xbe8d8c71,0x3f153b57 }, /* 337:  3.0647460e-01 -2.7646211e-01  5.8293670e-01 */
    { 0x50272c69,0x3efe998d,0x50272c69 }, /* 338:  1.1218822e+10  4.9726525e-01  1.1218822e+10 */
    { 0xbb49673e,0xbf41e62f,0x3f411cc8 }, /* 339: -3.0731703e-03 -7.5741857e-01  7.5434542e-01 */
    { 0xc3439d88,0x3aab9848,0x00000000 }, /* 340: -1.9561536e+02  1.3091648e-03  0.0000000e+00 */
    { 0x3f800000,0xc08d538d,0x40ad538d }, /* 341:  1.0000000e+00 -4.4164491e+00  5.4164491e+00 */
    { 0xbd674573,0xbf48f4d9,0x3f3a8082 }, /* 342: -5.6462716e-02 -7.8498608e-01  7.2852337e-01 */
    { 0x3de031ae,0xbe9b047a,0x3ed310e6 }, /* 343:  1.0946976e-01 -3.0276853e-01  4.1223830e-01 */
    { 0xbf491011,0xbf60261b,0x3db8b050 }, /* 344: -7.8540140e-01 -8.7558144e-01  9.0180039e-02 */
    { 0xbf9af73b,0x305a1b54,0x00000000 }, /* 345: -1.2106699e+00  7.9346774e-10  0.0000000e+00 */
    { 0xbf4defc9,0x3f507546,0x00000000 }, /* 346: -8.0444008e-01  8.1428945e-01  0.0000000e+00 */
    { 0x3e9b05e7,0x43816769,0x00000000 }, /* 347:  3.0277941e-01  2.5880789e+02  0.0000000e+00 */
    { 0xbed3a3f7,0x41e30552,0x00000000 }, /* 348: -4.1336033e-01  2.8377598e+01  0.0000000e+00 */
    { 0x3824538b,0xbe3d9e48,0x3e3da88d }, /* 349:  3.9178452e-05 -1.8517411e-01  1.8521328e-01 */
    { 0xc0ae818a,0x341534ec,0x00000000 }, /* 350: -5.4533129e+00  1.3895959e-07  0.0000000e+00 */
    { 0xbff9a8a9,0xb20350a2,0x00000000 }, /* 351: -1.9504596e+00 -7.6435374e-09  0.0000000e+00 */
    { 0x3cf9b2c5,0x3e1e9718,0x00000000 }, /* 352:  3.0480752e-02  1.5487325e-01  0.0000000e+00 */
    { 0xc51beef6,0x41fbaffd,0x00000000 }, /* 353: -2.4949351e+03  3.1460932e+01  0.0000000e+00 */
    { 0xbef928f7,0x3ec63eb0,0x00000000 }, /* 354: -4.8664066e-01  3.8719702e-01  0.0000000e+00 */
    { 0xc392cce9,0x3e0d934b,0x00000000 }, /* 355: -2.9360086e+02  1.3825719e-01  0.0000000e+00 */
    { 0x3df8b087,0x3f407a6e,0x00000000 }, /* 356:  1.2143045e-01  7.5186813e-01  0.0000000e+00 */
    { 0xc4f4db7e,0xc127cbc5,0x00000000 }, /* 357: -1.9588591e+03 -1.0487248e+01  0.0000000e+00 */
    { 0xbf55a79a,0xc39ef275,0x439e87a1 }, /* 358: -8.3458865e-01 -3.1789420e+02  3.1705960e+02 */
    { 0xbcebb48a,0xc002bc36,0x4000e4cd }, /* 359: -2.8772611e-02 -2.0427375e+00  2.0139649e+00 */
    { 0xc0b2c4e6,0xbfe8aedb,0x00000000 }, /* 360: -5.5865355e+00 -1.8178362e+00  0.0000000e+00 */
    { 0x414fa14e,0x323dd6ac,0x414fa14e }, /* 361:  1.2976881e+01  1.1050059e-08  1.2976881e+01 */
    { 0xcc75cd50,0xc1f3795c,0x00000000 }, /* 362: -6.4435520e+07 -3.0434258e+01  0.0000000e+00 */
    { 0x3feb6a6f,0x40bccf68,0x00000000 }, /* 363:  1.8391856e+00  5.9003181e+00  0.0000000e+00 */
    { 0xbaca0f3e,0xbfb8bb82,0x3fb888fe }, /* 364: -1.5415919e-03 -1.4432223e+00  1.4416807e+00 */
    { 0xbe6f4767,0x3fed38df,0x00000000 }, /* 365: -2.3367082e-01  1.8532981e+00  0.0000000e+00 */
    { 0x3e855d19,0x3fb9763c,0x00000000 }, /* 366:  2.6047590e-01  1.4489207e+00  0.0000000e+00 */
    { 0xbf74b264,0x3f53769a,0x00000000 }, /* 367: -9.5584702e-01  8.2602847e-01  0.0000000e+00 */
    { 0xbe98c373,0x3eab442a,0x00000000 }, /* 368: -2.9836616e-01  3.3450443e-01  0.0000000e+00 */
    { 0xc05ae697,0xbfbfae75,0x00000000 }, /* 369: -3.4203241e+00 -1.4975115e+00  0.0000000e+00 */
    { 0xbebca1c8,0x3eef7d9a,0x00000000 }, /* 370: -3.6842179e-01  4.6775514e-01  0.0000000e+00 */
    { 0xc49232e5,0xc59ac614,0x456c72b6 }, /* 371: -1.1695905e+03 -4.9527598e+03  3.7831694e+03 */
    { 0xbf63b37a,0xbe57148f,0x00000000 }, /* 372: -8.8945735e-01 -2.1003936e-01  0.0000000e+00 */
    { 0x3e5accbf,0x3ed45909,0x00000000 }, /* 373:  2.1367167e-01  4.1474178e-01  0.0000000e+00 */
    { 0x3ec5cbf3,0x3ed4aadb,0x00000000 }, /* 374:  3.8632163e-01  4.1536602e-01  0.0000000e+00 */
    { 0x40569e9d,0x3fc904d9,0x3fe43861 }, /* 375:  3.3534310e+00  1.5704604e+00  1.7829705e+00 */
    { 0x3f60032a,0xbf55b8b2,0x3fdaddee }, /* 376:  8.7504828e-01 -8.3484948e-01  1.7098978e+00 */
    { 0xbe9190aa,0xbfb2fe55,0x3f8e9a2a }, /* 377: -2.8430682e-01 -1.3983866e+00  1.1140797e+00 */
    { 0xc0106c50,0x3e4dbac1,0x00000000 }, /* 378: -2.2566109e+00  2.0090772e-01  0.0000000e+00 */
    { 0xbe9544c5,0x4057eb30,0x00000000 }, /* 379: -2.9154029e-01  3.3737297e+00  0.0000000e+00 */
    { 0x3e52ecb6,0x3fbf8eae,0x00000000 }, /* 380:  2.0598111e-01  1.4965417e+00  0.0000000e+00 */
    { 0xbf53f0dc,0x3ee87338,0x00000000 }, /* 381: -8.2789397e-01  4.5400405e-01  0.0000000e+00 */
    { 0x3ecd7972,0x4036e963,0x00000000 }, /* 382:  4.0131718e-01  2.8579948e+00  0.0000000e+00 */
    { 0x40a381ad,0x3fe64de7,0x4053dc66 }, /* 383:  5.1095796e+00  1.7992524e+00  3.3103271e+00 */
    { 0x409e187e,0x3fa19902,0x406b647b }, /* 384:  4.9404898e+00  1.2624819e+00  3.6780078e+00 */
    { 0x3bcd0a3a,0xbf41c9bc,0x3f4363d0 }, /* 385:  6.2573226e-03 -7.5698447e-01  7.6324177e-01 */
    { 0xc079c18f,0x3e88f056,0x00000000 }, /* 386: -3.9024389e+00  2.6745862e-01  0.0000000e+00 */
    { 0xc048e664,0x409615c1,0x00000000 }, /* 387: -3.1390619e+00  4.6901555e+00  0.0000000e+00 */
    { 0x4492573f,0x419c2f95,0x448fe681 }, /* 388:  1.1707264e+03  1.9523233e+01  1.1512032e+03 */
    { 0x3982d550,0x416bdd73,0x00000000 }, /* 389:  2.4954462e-04  1.4741565e+01  0.0000000e+00 */
    { 0xc004345e,0x9946168e,0x00000000 }, /* 390: -2.0656962e+00 -1.0240915e-23  0.0000000e+00 */
    { 0x3ed10ae1,0x3ef0031c,0x00000000 }, /* 391:  4.0828612e-01  4.6877372e-01  0.0000000e+00 */
    { 0xc14cd26a,0x43599bb9,0x00000000 }, /* 392: -1.2801371e+01  2.1760829e+02  0.0000000e+00 */
    { 0x3ea1ef76,0x3f477a01,0x00000000 }, /* 393:  3.1628007e-01  7.7920538e-01  0.0000000e+00 */
    { 0x4414122b,0xbf0d7d8a,0x4414358a }, /* 394:  5.9228387e+02 -5.5269682e-01  5.9283655e+02 */
    { 0x3f4849c9,0xbf634683,0x3fd5c826 }, /* 395:  7.8237587e-01 -8.8779467e-01  1.6701705e+00 */
    { 0x4093f7cd,0x3e1ecc92,0x408f0168 }, /* 396:  4.6239991e+00  1.5507725e-01  4.4689217e+00 */
    { 0xc1392e85,0xbf572a26,0x00000000 }, /* 397: -1.1573857e+01 -8.4048688e-01  0.0000000e+00 */
    { 0x40fb2d9b,0x4685a47c,0x00000000 }, /* 398:  7.8493171e+00  1.7106242e+04  0.0000000e+00 */
    { 0xbed30caf,0xbee1c370,0x3ceb6c10 }, /* 399: -4.1220614e-01 -4.4094419e-01  2.8738052e-02 */
    { 0xbfb1f10d,0xc1135d1e,0x40fa3df9 }, /* 400: -1.3901688e+00 -9.2102337e+00  7.8200650e+00 */
    { 0x3f644879,0xbf0cdd0d,0x3fb892c3 }, /* 401:  8.9173084e-01 -5.5024797e-01  1.4419788e+00 */
    { 0xbefeda15,0xc0258018,0x4005a4d5 }, /* 402: -4.9775758e-01 -2.5859432e+00  2.0881855e+00 */
    { 0x403b0db7,0x3ec01c25,0x40230a32 }, /* 403:  2.9227121e+00  3.7521473e-01  2.5474973e+00 */
    { 0xc1278628,0x3fabde7b,0x00000000 }, /* 404: -1.0470253e+01  1.3427271e+00  0.0000000e+00 */
    { 0xbed51a7e,0x3e673283,0x00000000 }, /* 405: -4.1621774e-01  2.2577862e-01  0.0000000e+00 */
    { 0xbefe10ae,0xc04df71c,0x402e3506 }, /* 406: -4.9622101e-01 -3.2182074e+00  2.7219863e+00 */
    { 0xc048afb1,0xc7119f28,0x47119c05 }, /* 407: -3.1357234e+00 -3.7279156e+04  3.7276020e+04 */
    { 0xc1ab59a9,0x4027a6e6,0x00000000 }, /* 408: -2.1418779e+01  2.6195617e+00  0.0000000e+00 */
    { 0x431c1000,0x3f4ef75d,0x431b4109 }, /* 409:  1.5606250e+02  8.0846196e-01  1.5525404e+02 */
    { 0x3e158c8c,0xbea57b5e,0x3ef041a4 }, /* 410:  1.4604396e-01 -3.2320684e-01  4.6925080e-01 */
    { 0xbeeb370c,0xbde8acc1,0x00000000 }, /* 411: -4.5940435e-01 -1.1361075e-01  0.0000000e+00 */
    { 0xc2038198,0xbed0194e,0x00000000 }, /* 412: -3.2876556e+01 -4.0644306e-01  0.0000000e+00 */
    { 0xc05ad177,0x3e305f84,0x00000000 }, /* 413: -3.4190347e+00  1.7223936e-01  0.0000000e+00 */
    { 0xc0cddd54,0x40cade2b,0x00000000 }, /* 414: -6.4332676e+00  6.3396201e+00  0.0000000e+00 */
    { 0xbfc3368f,0xbf9854c5,0x00000000 }, /* 415: -1.5251025e+00 -1.1900870e+00  0.0000000e+00 */
    { 0x3fa59a81,0xdbbdce97,0x5bbdce97 }, /* 416:  1.2937776e+00 -1.0685184e+17  1.0685184e+17 */
    { 0xc02ceefa,0xbdba12a4,0x00000000 }, /* 417: -2.7020860e+00 -9.0855867e-02  0.0000000e+00 */
    { 0xc8db1b8c,0xbfb13381,0x00000000 }, /* 418: -4.4873238e+05 -1.3843843e+00  0.0000000e+00 */
    { 0x3510f318,0x40ab4966,0x00000000 }, /* 419:  5.3997928e-07  5.3527098e+00  0.0000000e+00 */
    { 0x3f4ffd13,0x40a1778d,0x00000000 }, /* 420:  8.1245536e-01  5.0458436e+00  0.0000000e+00 */
    { 0xbe0870e8,0x3e073292,0x00000000 }, /* 421: -1.3324320e-01  1.3202885e-01  0.0000000e+00 */
    { 0xbef82f7b,0x402dd11f,0x00000000 }, /* 422: -4.8473725e-01  2.7158887e+00  0.0000000e+00 */
    { 0xbef7f173,0x40b95ae2,0x00000000 }, /* 423: -4.8426399e-01  5.7923441e+00  0.0000000e+00 */
    { 0xc01945cd,0xbdfe5a2e,0x00000000 }, /* 424: -2.3948853e+00 -1.2419544e-01  0.0000000e+00 */
    { 0x3fa5f6a0,0xcbefad46,0x4befad47 }, /* 425:  1.2965889e+00 -3.1414924e+07  3.1414926e+07 */
    { 0xbf6bd88f,0x421ca087,0x00000000 }, /* 426: -9.2127317e-01  3.9156765e+01  0.0000000e+00 */
    { 0x40980617,0xc11a0ec5,0x416611d0 }, /* 427:  4.7507434e+00 -9.6286058e+00  1.4379349e+01 */
    { 0xc100de2b,0xc3548fd5,0x434c81f2 }, /* 428: -8.0542402e+00 -2.1256184e+02  2.0450760e+02 */
    { 0xbe8fef49,0xbfaaf128,0x3f86f556 }, /* 429: -2.8112248e-01 -1.3354845e+00  1.0543621e+00 */
    { 0x414bc9db,0x3ed3c6bc,0x41452ba5 }, /* 430:  1.2736781e+01  4.1362560e-01  1.2323155e+01 */
    { 0x3a22ec63,0xbedac27d,0x3edb13f3 }, /* 431:  6.2150339e-04 -4.2726508e-01  4.2788658e-01 */
    { 0xbf58788a,0x41a8be65,0x00000000 }, /* 432: -8.4558928e-01  2.1092966e+01  0.0000000e+00 */
    { 0x3ef40800,0xbe947a9f,0x3f444150 }, /* 433:  4.7662354e-01 -2.8999802e-01  7.6662159e-01 */
    { 0xbfabe8d9,0x3ecf00a5,0x00000000 }, /* 434: -1.3430434e+00  4.0430179e-01  0.0000000e+00 */
    { 0xc0830551,0xc4df6ec1,0x44deebbc }, /* 435: -4.0943990e+00 -1.7874611e+03  1.7833667e+03 */
    { 0xc00f25a3,0x406816b0,0x00000000 }, /* 436: -2.2366722e+00  3.6263847e+00  0.0000000e+00 */
    { 0x4cd51644,0xc06a4633,0x4cd51644 }, /* 437:  1.1171894e+08 -3.6605346e+00  1.1171894e+08 */
    { 0x466f13b6,0x3f3c13ed,0x466f10c6 }, /* 438:  1.5300928e+04  7.3467904e-01  1.5300193e+04 */
    { 0xc05a40ff,0xc04808c6,0x00000000 }, /* 439: -3.4102170e+00 -3.1255355e+00  0.0000000e+00 */
    { 0x4062e39e,0xbfafb430,0x409d5edb }, /* 440:  3.5451427e+00 -1.3726864e+00  4.9178290e+00 */
    { 0x3e175c8c,0x3ee3fa1a,0x00000000 }, /* 441:  1.4781398e-01  4.4526750e-01  0.0000000e+00 */
    { 0xbec53e8e,0xbffc1bee,0x3fcacc4a }, /* 442: -3.8524288e-01 -1.9696023e+00  1.5843594e+00 */
    { 0x406cf643,0xc2187402,0x42274366 }, /* 443:  3.7025306e+00 -3.8113289e+01  4.1815819e+01 */
    { 0xc4bb63c8,0xbf6515ff,0x00000000 }, /* 444: -1.4991182e+03 -8.9486688e-01  0.0000000e+00 */
    { 0x40e0ca8e,0xbfbccd37,0x4107feee }, /* 445:  7.0247259e+00 -1.4750127e+00  8.4997387e+00 */
    { 0x9f24fd45,0xbf0a3492,0x3f0a3492 }, /* 446: -3.4937850e-20 -5.3986466e-01  5.3986466e-01 */
    { 0xc06c2f6a,0xc0c8eea6,0x4025ade2 }, /* 447: -3.6903939e+00 -6.2791319e+00  2.5887380e+00 */
    { 0x3eb51ebc,0xbf584d8d,0x3f996e76 }, /* 448:  3.5375011e-01 -8.4493333e-01  1.1986835e+00 */
    { 0xc054d2be,0x40e7bf24,0x00000000 }, /* 449: -3.3253627e+00  7.2420826e+00  0.0000000e+00 */
    { 0x412b1f36,0x3f4bace7,0x411e6468 }, /* 450:  1.0695120e+01  7.9560703e-01  9.8995132e+00 */
    { 0x408a9945,0xc0afe4b8,0x411d3efe }, /* 451:  4.3312097e+00 -5.4966698e+00  9.8278790e+00 */
    { 0x3fc2bdbd,0x40261715,0x00000000 }, /* 452:  1.5214154e+00  2.5951588e+00  0.0000000e+00 */
    { 0xc09dbc96,0xb8255f98,0x00000000 }, /* 453: -4.9292707e+00 -3.9428094e-05  0.0000000e+00 */
    { 0x3fa2abbb,0xc1e70e64,0x41f13920 }, /* 454:  1.2708658e+00 -2.8882027e+01  3.0152893e+01 */
    { 0x3f3efa06,0xbf66475a,0x3fd2a0b0 }, /* 455:  7.4600255e-01 -8.9952624e-01  1.6455288e+00 */
    { 0xc0d4d11a,0xbe95a619,0x00000000 }, /* 456: -6.6505251e+00 -2.9228285e-01  0.0000000e+00 */
    { 0x3d28d7c8,0xc79d94d0,0x479d94d5 }, /* 457:  4.1221410e-02 -8.0681625e+04  8.0681664e+04 */
    { 0xbf29b02a,0x4216ad62,0x00000000 }, /* 458: -6.6284430e-01  3.7669319e+01  0.0000000e+00 */
    { 0x3ead7f0e,0xc07f235e,0x408a69a0 }, /* 459:  3.3885998e-01 -3.9865336e+00  4.3253937e+00 */
    { 0x410fc082,0xc08139bd,0x41505d60 }, /* 460:  8.9844990e+00 -4.0382981e+00  1.3022797e+01 */
    { 0x3fa5e90d,0x4787915c,0x00000000 }, /* 461:  1.2961746e+00  6.9410719e+04  0.0000000e+00 */
    { 0x3fbeeb2c,0xbface61c,0x4035e8a4 }, /* 462:  1.4915519e+00 -1.3507724e+00  2.8423243e+00 */
    { 0x3e845117,0xbf4a1208,0x3f861d4a }, /* 463:  2.5843117e-01 -7.8933764e-01  1.0477688e+00 */
    { 0x3f93197d,0xbf436e84,0x3ff4d0bf }, /* 464:  1.1492153e+00 -7.6340508e-01  1.9126204e+00 */
    { 0x3f57d924,0xbf3dda57,0x3fcad9be }, /* 465:  8.4315705e-01 -7.4161285e-01  1.5847700e+00 */
    { 0x4032edb9,0x3e211fce,0x4028dbbc }, /* 466:  2.7957594e+00  1.5734789e-01  2.6384115e+00 */
    { 0xbf55a229,0xbf39aa03,0x00000000 }, /* 467: -8.3450562e-01 -7.2525042e-01  0.0000000e+00 */
    { 0x3cd89437,0xdf31cb87,0x5f31cb87 }, /* 468:  2.6437862e-02 -1.2811482e+19  1.2811482e+19 */
    { 0x3e9c6dab,0x40194b21,0x00000000 }, /* 469:  3.0552420e-01  2.3952105e+00  0.0000000e+00 */
    { 0xbdb5cf01,0x3f9416fc,0x00000000 }, /* 470: -8.8773735e-02  1.1569514e+00  0.0000000e+00 */
    { 0x3fbc61e2,0x3ef2703d,0x3f7f8ba6 }, /* 471:  1.4717371e+00  4.7351256e-01  9.9822462e-01 */
    { 0xa6d814d6,0x3fa9acaa,0x00000000 }, /* 472: -1.4993658e-15  1.3255818e+00  0.0000000e+00 */
    { 0x421473b2,0xbfb12c66,0x4219fd15 }, /* 473:  3.7112984e+01 -1.3841674e+00  3.8497150e+01 */
    { 0x426c5e06,0xbcd77d56,0x426c78f6 }, /* 474:  5.9091820e+01 -2.6304882e-02  5.9118126e+01 */
    { 0xbf4de2a5,0x3cd08690,0x00000000 }, /* 475: -8.0423957e-01  2.5454789e-02  0.0000000e+00 */
    { 0xc09eb598,0xbfa14c53,0x00000000 }, /* 476: -4.9596672e+00 -1.2601417e+00  0.0000000e+00 */
    { 0x2c8cda8c,0x3fb58c7c,0x00000000 }, /* 477:  4.0033029e-12  1.4183497e+00  0.0000000e+00 */
    { 0xc0e35762,0xbaaf622c,0x00000000 }, /* 478: -7.1044168e+00 -1.3380698e-03  0.0000000e+00 */
    { 0x3ebcc047,0xbbb5244e,0x3ebf94d8 }, /* 479:  3.6865446e-01 -5.5280095e-03  3.7418246e-01 */
    { 0x40254a08,0xbef65c0c,0x4044158a }, /* 480:  2.5826435e+00 -4.8117101e-01  3.0638146e+00 */
    { 0x3f54550b,0x4018bd77,0x00000000 }, /* 481:  8.2942265e-01  2.3865640e+00  0.0000000e+00 */
    { 0x400c870b,0x401d83b9,0x00000000 }, /* 482:  2.1957424e+00  2.4611647e+00  0.0000000e+00 */
    { 0x40bf5f4f,0xc01611ea,0x41053422 }, /* 483:  5.9803843e+00 -2.3448434e+00  8.3252277e+00 */
    { 0x40065316,0x40ade5f6,0x00000000 }, /* 484:  2.0988212e+00  5.4343214e+00  0.0000000e+00 */
    { 0xb9ea3177,0x3ef86341,0x00000000 }, /* 485: -4.4668812e-04  4.8513225e-01  0.0000000e+00 */
    { 0x3d7135c6,0x3f402553,0x00000000 }, /* 486:  5.8889173e-02  7.5056952e-01  0.0000000e+00 */
    { 0xbe3f96c3,0xbee26d22,0x3e82a1c0 }, /* 487: -1.8709855e-01 -4.4223887e-01  2.5514030e-01 */
    { 0xbd50c226,0x3fc61dd1,0x00000000 }, /* 488: -5.0966404e-02  1.5477849e+00  0.0000000e+00 */
    { 0x3f48b058,0xbec56241,0x3f95b0bc }, /* 489:  7.8394079e-01 -3.8551524e-01  1.1694560e+00 */
    { 0xc0fdf0be,0x3eb6da15,0x00000000 }, /* 490: -7.9356375e+00  3.5713258e-01  0.0000000e+00 */
    { 0x48a94f1a,0xbfc41e8d,0x48a94f4b }, /* 491:  3.4674481e+05 -1.5321823e+00  3.4674634e+05 */
    { 0xc02c1a58,0x3ee63cc8,0x00000000 }, /* 492: -2.6891079e+00  4.4968247e-01  0.0000000e+00 */
    { 0x413d3f86,0x40834c08,0x40f73304 }, /* 493:  1.1828009e+01  4.1030312e+00  7.7249775e+00 */
    { 0x3f058476,0xbfb11e5f,0x3ff3e09a }, /* 494:  5.2155244e-01 -1.3837394e+00  1.9052918e+00 */
    { 0xc08a9462,0x3faac9eb,0x00000000 }, /* 495: -4.3306131e+00  1.3342870e+00  0.0000000e+00 */
    { 0xbfc26bfc,0xb8d84d44,0x00000000 }, /* 496: -1.5189204e+00 -1.0314074e-04  0.0000000e+00 */
    { 0xc53df871,0x3edc2b3b,0x00000000 }, /* 497: -3.0395276e+03  4.3001732e-01  0.0000000e+00 */
    { 0xbee7e7c9,0x4189899e,0x00000000 }, /* 498: -4.5294026e-01  1.7192196e+01  0.0000000e+00 */
    { 0x445e86f7,0xbe1b487a,0x445e90ac }, /* 499:  8.9010883e+02 -1.5164366e-01  8.9026050e+02 */
    { 0x3d496be2,0x3f4f084d,0x00000000 }, /* 500:  4.9175151e-02  8.0872041e-01  0.0000000e+00 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, y, z;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	y.lo = pgm_read_dword (& t[i].y);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = fdim (x.fl, y.fl);

	if (v.lo != z.lo)
	    x_exit (i+1);
    }
    return 0;
}
