/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jsnappy;

public class Buffer {
    private byte[] data;
    private int length;

    public Buffer() {
    }

    public Buffer(int capacity) {
        this.data = new byte[capacity];
    }

    public void ensureCapacity(int capacity) {
        if (this.data == null) {
            this.data = new byte[capacity];
        } else if (this.data.length < capacity) {
            byte[] nb = new byte[capacity];
            System.arraycopy(this.data, 0, nb, 0, this.data.length);
            this.data = nb;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) throws IllegalStateException, IllegalArgumentException {
        if (this.data == null) {
            throw new IllegalStateException("Internal buffer not initialized");
        }
        if (length > this.data.length) {
            throw new IllegalArgumentException("Internal buffer length (" + this.data.length + ") is less than length argument (" + length + ")");
        }
        this.length = length;
    }

    public byte[] toByteArray() {
        byte[] res = new byte[this.length];
        System.arraycopy(this.data, 0, res, 0, this.length);
        return res;
    }
}

