/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.io;

import java.io.IOException;
import yuku.bintex.BintexReader;

public class Utf8Decoder {
    public static char[] buf = new char[1000];
    static ThreadLocal<byte[]> byte_buf_ = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[1000];
        }
    };
    static ThreadLocal<char[]> char_buf_ = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[8000];
        }
    };

    public static String toString(byte[] ba) {
        return Utf8Decoder.toString(ba, 0, ba.length);
    }

    public static String toString(byte[] ba, int start, int length) {
        if (buf.length < ba.length) {
            buf = new char[ba.length + 1000];
        }
        int pos = 0;
        try {
            for (int i = start; i < start + length; ++i) {
                int c0 = ba[i] & 0xFF;
                if (c0 < 128) {
                    Utf8Decoder.buf[pos++] = (char)c0;
                    continue;
                }
                int c1 = ba[++i] & 0xFF;
                if (c0 < 224) {
                    Utf8Decoder.buf[pos++] = (char)((c0 & 0x1F) << 6 | c1 & 0x3F);
                    continue;
                }
                int c2 = ba[++i] & 0xFF;
                Utf8Decoder.buf[pos++] = (char)((c0 & 0xF) << 12 | (c1 & 0x3F) << 6 | c2 & 0x3F);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return new String(buf, 0, pos);
    }

    public static String toStringLowerCase(byte[] ba) {
        return Utf8Decoder.toStringLowerCase(ba, 0, ba.length);
    }

    public static String toStringLowerCase(byte[] ba, int start, int length) {
        if (buf.length < ba.length) {
            buf = new char[ba.length + 1000];
        }
        int pos = 0;
        try {
            for (int i = start; i < start + length; ++i) {
                int c0 = ba[i] & 0xFF;
                if (c0 < 128) {
                    if (c0 >= 65 && c0 <= 90) {
                        Utf8Decoder.buf[pos++] = (char)(c0 | 0x20);
                        continue;
                    }
                    Utf8Decoder.buf[pos++] = (char)c0;
                    continue;
                }
                int c1 = ba[++i] & 0xFF;
                if (c0 < 224) {
                    Utf8Decoder.buf[pos++] = (char)((c0 & 0x1F) << 6 | c1 & 0x3F);
                    continue;
                }
                int c2 = ba[++i] & 0xFF;
                Utf8Decoder.buf[pos++] = (char)((c0 & 0xF) << 12 | (c1 & 0x3F) << 6 | c2 & 0x3F);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return new String(buf, 0, pos);
    }

    public static String toStringFromVersesWithPrependedLengths(BintexReader br, int verse_count, boolean lowercased) throws IOException {
        byte[] byte_buf = byte_buf_.get();
        char[] char_buf = char_buf_.get();
        int char_pos = 0;
        for (int v = 0; v < verse_count; ++v) {
            int will_need_char_len;
            int verse_len = br.readVarUint();
            if (verse_len > byte_buf.length) {
                byte_buf = new byte[verse_len + 100];
                byte_buf_.set(byte_buf);
            }
            if ((will_need_char_len = char_pos + verse_len + 1) > char_buf.length) {
                char[] new_char_buf = new char[will_need_char_len + 1000];
                System.arraycopy(char_buf, 0, new_char_buf, 0, char_buf.length);
                char_buf = new_char_buf;
                char_buf_.set(char_buf);
            }
            br.readRaw(byte_buf, 0, verse_len);
            for (int i = 0; i < verse_len; ++i) {
                int c0 = byte_buf[i] & 0xFF;
                if (c0 < 128) {
                    if (lowercased && c0 >= 65 && c0 <= 90) {
                        char_buf[char_pos++] = (char)(c0 | 0x20);
                        continue;
                    }
                    char_buf[char_pos++] = (char)c0;
                    continue;
                }
                int c1 = byte_buf[++i] & 0xFF;
                if (c0 < 224) {
                    char_buf[char_pos++] = (char)((c0 & 0x1F) << 6 | c1 & 0x3F);
                    continue;
                }
                int c2 = byte_buf[++i] & 0xFF;
                char_buf[char_pos++] = (char)((c0 & 0xF) << 12 | (c1 & 0x3F) << 6 | c2 & 0x3F);
            }
            char_buf[char_pos++] = 10;
        }
        return new String(char_buf, 0, char_pos);
    }
}

