/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.util;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public class IntArrayList
implements Parcelable {
    int[] buf;
    int len;
    public static final Parcelable.Creator<IntArrayList> CREATOR = new Parcelable.Creator<IntArrayList>(){

        @Override
        public IntArrayList createFromParcel(Parcel in) {
            int len = in.readInt();
            IntArrayList res = new IntArrayList();
            res.buf = new int[len];
            for (int i = 0; i < len; ++i) {
                res.buf[i] = in.readInt();
            }
            res.len = len;
            return res;
        }

        public IntArrayList[] newArray(int size) {
            return new IntArrayList[size];
        }
    };

    public IntArrayList() {
        this(16);
    }

    public IntArrayList(int capacity) {
        this.buf = new int[capacity];
        this.len = 0;
    }

    public int size() {
        return this.len;
    }

    private void expand() {
        int[] newArray = new int[this.buf.length << 1];
        System.arraycopy(this.buf, 0, newArray, 0, this.len);
        this.buf = newArray;
    }

    public void add(int a) {
        if (this.len >= this.buf.length) {
            this.expand();
        }
        this.buf[this.len++] = a;
    }

    public int pop() {
        return this.buf[--this.len];
    }

    public int get(int i) {
        return this.buf[i];
    }

    public void set(int i, int a) {
        this.buf[i] = a;
    }

    public int[] buffer() {
        return this.buf;
    }

    public void clear() {
        this.len = 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.len);
        for (int i = 0; i < this.len; ++i) {
            dest.writeInt(this.buf[i]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.len * 8);
        sb.append('[');
        for (int i = 0; i < this.len; ++i) {
            sb.append(this.buf[i]);
            if (i == this.len - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArrayList that = (IntArrayList)o;
        if (this.len != that.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.buf[i] == that.buf[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.buf);
        result = 31 * result + this.len;
        return result;
    }
}

