/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.yet;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import yuku.alkitabconverter.util.KjvUtils;
import yuku.alkitabconverter.util.Rec;
import yuku.alkitabconverter.util.TextDb;
import yuku.alkitabconverter.yes_common.Yes2Common;
import yuku.alkitabconverter.yet.YetFileInput;

public class YetToYes2 {
    @Parameter
    private List<String> params = new ArrayList<String>();
    @Parameter(names={"--help"}, help=true, description="Show this help")
    private boolean help = false;
    @Parameter(names={"--no-compress"}, description="Disable compression on the resultant yes file")
    private boolean nocompress = false;

    public static void main(String[] args) throws Exception {
        YetToYes2 main = new YetToYes2();
        JCommander jc = new JCommander((Object)main, args);
        if (main.help) {
            jc.setProgramName("java -jar YetToYes2.jar");
            jc.usage();
            System.exit(0);
        }
        int retval = main.main();
        System.exit(retval);
    }

    private int main() throws Exception {
        if (this.params.size() < 1) {
            System.err.println("Usage parameters: <yet-file> [<yes-file>]");
            return 1;
        }
        String yetfile = this.params.get(0);
        String yesfile = this.params.size() >= 2 ? this.params.get(1) : (yetfile.endsWith(".yet") ? yetfile.substring(0, yetfile.length() - 1) + "s" : yetfile + ".yes");
        System.err.println("input:  " + yetfile);
        System.err.println("output: " + yesfile);
        YetFileInput.YetFileInputResult result = new YetFileInput().parse(yetfile);
        if (result == null) {
            return 1;
        }
        if (result.recs == null) {
            System.err.println("yet file doesn't contain any verses");
            return 1;
        }
        if (result.infos == null) {
            System.err.println("yet file doesn't contain any info");
            return 1;
        }
        if (result.infos.get("longName") == null) {
            System.err.println("yet file doesn't contain info 'longName' which is required");
            return 1;
        }
        if (result.bookNames == null) {
            System.err.println("yet file doesn't contain any book names");
            return 1;
        }
        HashSet<Integer> books_1 = new HashSet<Integer>();
        for (Rec rec : result.recs) {
            books_1.add(rec.book_1);
        }
        for (Integer n : books_1) {
            String bookName = result.bookNames.get(n);
            if (bookName != null) continue;
            System.err.println("yet file doesn't contain book name for book " + n);
            return 1;
        }
        Yes2Common.VersionInfo versionInfo = new Yes2Common.VersionInfo();
        versionInfo.locale = result.infos.get("locale");
        versionInfo.shortName = result.infos.get("shortName");
        versionInfo.longName = result.infos.get("longName");
        versionInfo.description = result.infos.get("description");
        versionInfo.setBookNamesAndAbbreviations(result.getBookNamesAsList(), result.getBookAbbreviationsAsList());
        TextDb textDb = new TextDb();
        for (Rec rec : result.recs) {
            textDb.append(rec.book_1 - 1, rec.chapter_1, rec.verse_1, rec.text, -1);
            if (KjvUtils.isValidKjv(rec.book_1 - 1, rec.chapter_1, rec.verse_1)) continue;
            System.err.println("warning: is not a valid verse in KJV versification: verse " + rec.book_1 + " " + rec.chapter_1 + " " + rec.verse_1);
        }
        boolean bl = !this.nocompress;
        Yes2Common.createYesFile(new File(yesfile), versionInfo, textDb, result.pericopeData, bl, result.xrefEntries, result.footnoteEntries);
        return 0;
    }
}

