/*
 * Decompiled with CFR 0.152.
 */
package yuku.snappy.codec;

import yuku.snappy.codec.SnappyImplJava;
import yuku.snappy.codec.SnappyImplNative;

public abstract class Snappy {
    public abstract int compress(byte[] var1, int var2, byte[] var3, int var4, int var5);

    public abstract int decompress(byte[] var1, int var2, byte[] var3, int var4, int var5);

    public int maxCompressedLength(int sourceLength) {
        return 32 + sourceLength + sourceLength / 6;
    }

    public int uncompressedLength(byte[] in, int offset, int len) throws IllegalArgumentException {
        int sourceIndex = offset;
        int max = offset + len;
        int i = 0;
        int targetLength = 0;
        do {
            if (sourceIndex >= max) {
                throw new IllegalArgumentException("no length obtained");
            }
            targetLength += (in[sourceIndex] & 0x7F) << i++ * 7;
        } while ((in[sourceIndex++] & 0x80) == 128);
        return targetLength;
    }

    abstract String getImplementationName();

    public static class Factory {
        private static int nativeAvailable = 0;

        public Snappy newInstanceJava() {
            return new SnappyImplJava();
        }

        public Snappy newInstanceNative() {
            return new SnappyImplNative();
        }

        public Snappy newInstance() {
            if (nativeAvailable == 0) {
                try {
                    System.loadLibrary("snappy");
                    nativeAvailable = 1;
                }
                catch (UnsatisfiedLinkError e) {
                    nativeAvailable = 2;
                }
                catch (SecurityException e) {
                    nativeAvailable = 2;
                }
            }
            if (nativeAvailable == 1) {
                return this.newInstanceNative();
            }
            if (nativeAvailable == 2) {
                return this.newInstanceJava();
            }
            return null;
        }
    }
}

