# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to Sanyo Katana-II (SCP-6650)"""

from prototypes import *

# Make all sanyo stuff available in this module as well
from p_sanyo import *
from p_sanyomedia import *
from p_sanyonewer import *
from p_sanyo4930 import *
from p_sanyo6600 import *

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb
NUMPHONEBOOKENTRIES=300
MAXNUMBERS=500
MAXEMAILS=600
MAXURLS=300
MAXMEMOS=300
MAXADDRESSES=300
_NUMSPEEDDIALS=8
_NUMLONGNUMBERS=5
_LONGPHONENUMBERLEN=30
_NUMEVENTSLOTS=100
_NUMCALLALARMSLOTS=15

MAXNUMBERLEN=32
MAXEMAILLEN=96
MAXURLLEN=96
MAXMEMOLEN=96
HASRINGPICBUF=0
NUMGROUPS=20
NUMPHONENUMBERS=7
NUMEMAILS=2
FIRSTSPEEDDIAL=2
LASTSPEEDDIAL=9


class pbsortbuffer(BaseProtogenClass):
    "Various arrays for sorting the phone book, speed dial, determining which"
    __fields=['startcommand', 'bufsize', 'comment', 'groupslotsused', 'pad', 'groupslotusedflags', 'slotsused', 'usedflags', 'speeddialindex', 'nameslotsused', 'nameusedflags', 'sortorder', 'pbfirstletters', 'numslotsused', 'numusedflags', 'emailslotsused', 'emailusedflags', 'urlslotsused', 'urlusedflags', 'num_address', 'addressusedflags', 'num_memo', 'memousedflags', 'junk']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbsortbuffer,self).__init__(**dict)
        if self.__class__ is pbsortbuffer:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbsortbuffer,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbsortbuffer,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_startcommand
        except:
            self.__field_startcommand=UINT(**{'constant': 0x76})
        try: self.__field_bufsize
        except:
            self.__field_bufsize=UINT(**{'constant': 4096})
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "sort buffer"})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_groupslotsused.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.writetobuffer(buf)
        try: self.__field_groupslotusedflags
        except:
            self.__field_groupslotusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_67, 'length': NUMGROUPS, 'createdefault': True})
        self.__field_groupslotusedflags.writetobuffer(buf)
        self.__field_slotsused.writetobuffer(buf)
        try: self.__field_usedflags
        except:
            self.__field_usedflags=LIST(**{'elementclass': _gen_p_sanyo6650_71, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        self.__field_usedflags.writetobuffer(buf)
        try: self.__field_speeddialindex
        except:
            self.__field_speeddialindex=LIST(**{'elementclass': _gen_p_sanyo6650_73, 'length': _NUMSPEEDDIALS})
        self.__field_speeddialindex.writetobuffer(buf)
        self.__field_nameslotsused.writetobuffer(buf)
        try: self.__field_nameusedflags
        except:
            self.__field_nameusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_77, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        self.__field_nameusedflags.writetobuffer(buf)
        try: self.__field_sortorder
        except:
            self.__field_sortorder=LIST(**{'elementclass': _gen_p_sanyo6650_79, 'length': NUMPHONEBOOKENTRIES})
        self.__field_sortorder.writetobuffer(buf)
        self.__field_pbfirstletters.writetobuffer(buf)
        self.__field_numslotsused.writetobuffer(buf)
        try: self.__field_numusedflags
        except:
            self.__field_numusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_84, 'length': MAXNUMBERS, 'createdefault': True})
        self.__field_numusedflags.writetobuffer(buf)
        self.__field_emailslotsused.writetobuffer(buf)
        try: self.__field_emailusedflags
        except:
            self.__field_emailusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_88, 'length': MAXEMAILS, 'createdefault': True})
        self.__field_emailusedflags.writetobuffer(buf)
        self.__field_urlslotsused.writetobuffer(buf)
        try: self.__field_urlusedflags
        except:
            self.__field_urlusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_91, 'length': MAXURLS, 'createdefault': True})
        self.__field_urlusedflags.writetobuffer(buf)
        self.__field_num_address.writetobuffer(buf)
        try: self.__field_addressusedflags
        except:
            self.__field_addressusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_95, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        self.__field_addressusedflags.writetobuffer(buf)
        self.__field_num_memo.writetobuffer(buf)
        try: self.__field_memousedflags
        except:
            self.__field_memousedflags=LIST(**{'elementclass': _gen_p_sanyo6650_99, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        self.__field_memousedflags.writetobuffer(buf)
        try: self.__field_junk
        except:
            self.__field_junk=UNKNOWN(**{'sizeinbytes': 543})
        self.__field_junk.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_groupslotsused=UINT(**{'sizeinbytes': 1})
        self.__field_groupslotsused.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.readfrombuffer(buf)
        self.__field_groupslotusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_67, 'length': NUMGROUPS, 'createdefault': True})
        self.__field_groupslotusedflags.readfrombuffer(buf)
        self.__field_slotsused=UINT(**{'sizeinbytes': 2})
        self.__field_slotsused.readfrombuffer(buf)
        self.__field_usedflags=LIST(**{'elementclass': _gen_p_sanyo6650_71, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        self.__field_usedflags.readfrombuffer(buf)
        self.__field_speeddialindex=LIST(**{'elementclass': _gen_p_sanyo6650_73, 'length': _NUMSPEEDDIALS})
        self.__field_speeddialindex.readfrombuffer(buf)
        self.__field_nameslotsused=UINT(**{'sizeinbytes': 2})
        self.__field_nameslotsused.readfrombuffer(buf)
        self.__field_nameusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_77, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        self.__field_nameusedflags.readfrombuffer(buf)
        self.__field_sortorder=LIST(**{'elementclass': _gen_p_sanyo6650_79, 'length': NUMPHONEBOOKENTRIES})
        self.__field_sortorder.readfrombuffer(buf)
        self.__field_pbfirstletters=USTRING(**{'terminator': None, 'sizeinbytes': NUMPHONEBOOKENTRIES})
        self.__field_pbfirstletters.readfrombuffer(buf)
        self.__field_numslotsused=UINT(**{'sizeinbytes': 2})
        self.__field_numslotsused.readfrombuffer(buf)
        self.__field_numusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_84, 'length': MAXNUMBERS, 'createdefault': True})
        self.__field_numusedflags.readfrombuffer(buf)
        self.__field_emailslotsused=UINT(**{'sizeinbytes': 2})
        self.__field_emailslotsused.readfrombuffer(buf)
        self.__field_emailusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_88, 'length': MAXEMAILS, 'createdefault': True})
        self.__field_emailusedflags.readfrombuffer(buf)
        self.__field_urlslotsused=UINT(**{'sizeinbytes': 2})
        self.__field_urlslotsused.readfrombuffer(buf)
        self.__field_urlusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_91, 'length': MAXURLS, 'createdefault': True})
        self.__field_urlusedflags.readfrombuffer(buf)
        self.__field_num_address=UINT(**{'sizeinbytes': 2})
        self.__field_num_address.readfrombuffer(buf)
        self.__field_addressusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_95, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        self.__field_addressusedflags.readfrombuffer(buf)
        self.__field_num_memo=UINT(**{'sizeinbytes': 2})
        self.__field_num_memo.readfrombuffer(buf)
        self.__field_memousedflags=LIST(**{'elementclass': _gen_p_sanyo6650_99, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        self.__field_memousedflags.readfrombuffer(buf)
        self.__field_junk=UNKNOWN(**{'sizeinbytes': 543})
        self.__field_junk.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_startcommand(self):
        return self.__field_startcommand.getvalue()

    def __setfield_startcommand(self, value):
        if isinstance(value,UINT):
            self.__field_startcommand=value
        else:
            self.__field_startcommand=UINT(value,**{'constant': 0x76})

    def __delfield_startcommand(self): del self.__field_startcommand

    startcommand=property(__getfield_startcommand, __setfield_startcommand, __delfield_startcommand, "Starting command for R/W buf parts")

    def __getfield_bufsize(self):
        return self.__field_bufsize.getvalue()

    def __setfield_bufsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufsize=value
        else:
            self.__field_bufsize=UINT(value,**{'constant': 4096})

    def __delfield_bufsize(self): del self.__field_bufsize

    bufsize=property(__getfield_bufsize, __setfield_bufsize, __delfield_bufsize, None)

    def __getfield_comment(self):
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "sort buffer"})
        return self.__field_comment.getvalue()

    def __setfield_comment(self, value):
        if isinstance(value,USTRING):
            self.__field_comment=value
        else:
            self.__field_comment=USTRING(value,**{'default': "sort buffer"})

    def __delfield_comment(self): del self.__field_comment

    comment=property(__getfield_comment, __setfield_comment, __delfield_comment, None)

    def __getfield_groupslotsused(self):
        return self.__field_groupslotsused.getvalue()

    def __setfield_groupslotsused(self, value):
        if isinstance(value,UINT):
            self.__field_groupslotsused=value
        else:
            self.__field_groupslotsused=UINT(value,**{'sizeinbytes': 1})

    def __delfield_groupslotsused(self): del self.__field_groupslotsused

    groupslotsused=property(__getfield_groupslotsused, __setfield_groupslotsused, __delfield_groupslotsused, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 2})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def __getfield_groupslotusedflags(self):
        try: self.__field_groupslotusedflags
        except:
            self.__field_groupslotusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_67, 'length': NUMGROUPS, 'createdefault': True})
        return self.__field_groupslotusedflags.getvalue()

    def __setfield_groupslotusedflags(self, value):
        if isinstance(value,LIST):
            self.__field_groupslotusedflags=value
        else:
            self.__field_groupslotusedflags=LIST(value,**{'elementclass': _gen_p_sanyo6650_67, 'length': NUMGROUPS, 'createdefault': True})

    def __delfield_groupslotusedflags(self): del self.__field_groupslotusedflags

    groupslotusedflags=property(__getfield_groupslotusedflags, __setfield_groupslotusedflags, __delfield_groupslotusedflags, None)

    def __getfield_slotsused(self):
        return self.__field_slotsused.getvalue()

    def __setfield_slotsused(self, value):
        if isinstance(value,UINT):
            self.__field_slotsused=value
        else:
            self.__field_slotsused=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slotsused(self): del self.__field_slotsused

    slotsused=property(__getfield_slotsused, __setfield_slotsused, __delfield_slotsused, None)

    def __getfield_usedflags(self):
        try: self.__field_usedflags
        except:
            self.__field_usedflags=LIST(**{'elementclass': _gen_p_sanyo6650_71, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        return self.__field_usedflags.getvalue()

    def __setfield_usedflags(self, value):
        if isinstance(value,LIST):
            self.__field_usedflags=value
        else:
            self.__field_usedflags=LIST(value,**{'elementclass': _gen_p_sanyo6650_71, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})

    def __delfield_usedflags(self): del self.__field_usedflags

    usedflags=property(__getfield_usedflags, __setfield_usedflags, __delfield_usedflags, None)

    def __getfield_speeddialindex(self):
        try: self.__field_speeddialindex
        except:
            self.__field_speeddialindex=LIST(**{'elementclass': _gen_p_sanyo6650_73, 'length': _NUMSPEEDDIALS})
        return self.__field_speeddialindex.getvalue()

    def __setfield_speeddialindex(self, value):
        if isinstance(value,LIST):
            self.__field_speeddialindex=value
        else:
            self.__field_speeddialindex=LIST(value,**{'elementclass': _gen_p_sanyo6650_73, 'length': _NUMSPEEDDIALS})

    def __delfield_speeddialindex(self): del self.__field_speeddialindex

    speeddialindex=property(__getfield_speeddialindex, __setfield_speeddialindex, __delfield_speeddialindex, None)

    def __getfield_nameslotsused(self):
        return self.__field_nameslotsused.getvalue()

    def __setfield_nameslotsused(self, value):
        if isinstance(value,UINT):
            self.__field_nameslotsused=value
        else:
            self.__field_nameslotsused=UINT(value,**{'sizeinbytes': 2})

    def __delfield_nameslotsused(self): del self.__field_nameslotsused

    nameslotsused=property(__getfield_nameslotsused, __setfield_nameslotsused, __delfield_nameslotsused, "Always seems to be the same.  Why duplicated?")

    def __getfield_nameusedflags(self):
        try: self.__field_nameusedflags
        except:
            self.__field_nameusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_77, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        return self.__field_nameusedflags.getvalue()

    def __setfield_nameusedflags(self, value):
        if isinstance(value,LIST):
            self.__field_nameusedflags=value
        else:
            self.__field_nameusedflags=LIST(value,**{'elementclass': _gen_p_sanyo6650_77, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})

    def __delfield_nameusedflags(self): del self.__field_nameusedflags

    nameusedflags=property(__getfield_nameusedflags, __setfield_nameusedflags, __delfield_nameusedflags, None)

    def __getfield_sortorder(self):
        try: self.__field_sortorder
        except:
            self.__field_sortorder=LIST(**{'elementclass': _gen_p_sanyo6650_79, 'length': NUMPHONEBOOKENTRIES})
        return self.__field_sortorder.getvalue()

    def __setfield_sortorder(self, value):
        if isinstance(value,LIST):
            self.__field_sortorder=value
        else:
            self.__field_sortorder=LIST(value,**{'elementclass': _gen_p_sanyo6650_79, 'length': NUMPHONEBOOKENTRIES})

    def __delfield_sortorder(self): del self.__field_sortorder

    sortorder=property(__getfield_sortorder, __setfield_sortorder, __delfield_sortorder, None)

    def __getfield_pbfirstletters(self):
        return self.__field_pbfirstletters.getvalue()

    def __setfield_pbfirstletters(self, value):
        if isinstance(value,USTRING):
            self.__field_pbfirstletters=value
        else:
            self.__field_pbfirstletters=USTRING(value,**{'terminator': None, 'sizeinbytes': NUMPHONEBOOKENTRIES})

    def __delfield_pbfirstletters(self): del self.__field_pbfirstletters

    pbfirstletters=property(__getfield_pbfirstletters, __setfield_pbfirstletters, __delfield_pbfirstletters, None)

    def __getfield_numslotsused(self):
        return self.__field_numslotsused.getvalue()

    def __setfield_numslotsused(self, value):
        if isinstance(value,UINT):
            self.__field_numslotsused=value
        else:
            self.__field_numslotsused=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numslotsused(self): del self.__field_numslotsused

    numslotsused=property(__getfield_numslotsused, __setfield_numslotsused, __delfield_numslotsused, "Number of phone number slots used")

    def __getfield_numusedflags(self):
        try: self.__field_numusedflags
        except:
            self.__field_numusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_84, 'length': MAXNUMBERS, 'createdefault': True})
        return self.__field_numusedflags.getvalue()

    def __setfield_numusedflags(self, value):
        if isinstance(value,LIST):
            self.__field_numusedflags=value
        else:
            self.__field_numusedflags=LIST(value,**{'elementclass': _gen_p_sanyo6650_84, 'length': MAXNUMBERS, 'createdefault': True})

    def __delfield_numusedflags(self): del self.__field_numusedflags

    numusedflags=property(__getfield_numusedflags, __setfield_numusedflags, __delfield_numusedflags, None)

    def __getfield_emailslotsused(self):
        return self.__field_emailslotsused.getvalue()

    def __setfield_emailslotsused(self, value):
        if isinstance(value,UINT):
            self.__field_emailslotsused=value
        else:
            self.__field_emailslotsused=UINT(value,**{'sizeinbytes': 2})

    def __delfield_emailslotsused(self): del self.__field_emailslotsused

    emailslotsused=property(__getfield_emailslotsused, __setfield_emailslotsused, __delfield_emailslotsused, None)

    def __getfield_emailusedflags(self):
        try: self.__field_emailusedflags
        except:
            self.__field_emailusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_88, 'length': MAXEMAILS, 'createdefault': True})
        return self.__field_emailusedflags.getvalue()

    def __setfield_emailusedflags(self, value):
        if isinstance(value,LIST):
            self.__field_emailusedflags=value
        else:
            self.__field_emailusedflags=LIST(value,**{'elementclass': _gen_p_sanyo6650_88, 'length': MAXEMAILS, 'createdefault': True})

    def __delfield_emailusedflags(self): del self.__field_emailusedflags

    emailusedflags=property(__getfield_emailusedflags, __setfield_emailusedflags, __delfield_emailusedflags, None)

    def __getfield_urlslotsused(self):
        return self.__field_urlslotsused.getvalue()

    def __setfield_urlslotsused(self, value):
        if isinstance(value,UINT):
            self.__field_urlslotsused=value
        else:
            self.__field_urlslotsused=UINT(value,**{'sizeinbytes': 2})

    def __delfield_urlslotsused(self): del self.__field_urlslotsused

    urlslotsused=property(__getfield_urlslotsused, __setfield_urlslotsused, __delfield_urlslotsused, None)

    def __getfield_urlusedflags(self):
        try: self.__field_urlusedflags
        except:
            self.__field_urlusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_91, 'length': MAXURLS, 'createdefault': True})
        return self.__field_urlusedflags.getvalue()

    def __setfield_urlusedflags(self, value):
        if isinstance(value,LIST):
            self.__field_urlusedflags=value
        else:
            self.__field_urlusedflags=LIST(value,**{'elementclass': _gen_p_sanyo6650_91, 'length': MAXURLS, 'createdefault': True})

    def __delfield_urlusedflags(self): del self.__field_urlusedflags

    urlusedflags=property(__getfield_urlusedflags, __setfield_urlusedflags, __delfield_urlusedflags, None)

    def __getfield_num_address(self):
        return self.__field_num_address.getvalue()

    def __setfield_num_address(self, value):
        if isinstance(value,UINT):
            self.__field_num_address=value
        else:
            self.__field_num_address=UINT(value,**{'sizeinbytes': 2})

    def __delfield_num_address(self): del self.__field_num_address

    num_address=property(__getfield_num_address, __setfield_num_address, __delfield_num_address, None)

    def __getfield_addressusedflags(self):
        try: self.__field_addressusedflags
        except:
            self.__field_addressusedflags=LIST(**{'elementclass': _gen_p_sanyo6650_95, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        return self.__field_addressusedflags.getvalue()

    def __setfield_addressusedflags(self, value):
        if isinstance(value,LIST):
            self.__field_addressusedflags=value
        else:
            self.__field_addressusedflags=LIST(value,**{'elementclass': _gen_p_sanyo6650_95, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})

    def __delfield_addressusedflags(self): del self.__field_addressusedflags

    addressusedflags=property(__getfield_addressusedflags, __setfield_addressusedflags, __delfield_addressusedflags, None)

    def __getfield_num_memo(self):
        return self.__field_num_memo.getvalue()

    def __setfield_num_memo(self, value):
        if isinstance(value,UINT):
            self.__field_num_memo=value
        else:
            self.__field_num_memo=UINT(value,**{'sizeinbytes': 2})

    def __delfield_num_memo(self): del self.__field_num_memo

    num_memo=property(__getfield_num_memo, __setfield_num_memo, __delfield_num_memo, None)

    def __getfield_memousedflags(self):
        try: self.__field_memousedflags
        except:
            self.__field_memousedflags=LIST(**{'elementclass': _gen_p_sanyo6650_99, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})
        return self.__field_memousedflags.getvalue()

    def __setfield_memousedflags(self, value):
        if isinstance(value,LIST):
            self.__field_memousedflags=value
        else:
            self.__field_memousedflags=LIST(value,**{'elementclass': _gen_p_sanyo6650_99, 'length': NUMPHONEBOOKENTRIES, 'createdefault': True})

    def __delfield_memousedflags(self): del self.__field_memousedflags

    memousedflags=property(__getfield_memousedflags, __setfield_memousedflags, __delfield_memousedflags, None)

    def __getfield_junk(self):
        try: self.__field_junk
        except:
            self.__field_junk=UNKNOWN(**{'sizeinbytes': 543})
        return self.__field_junk.getvalue()

    def __setfield_junk(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_junk=value
        else:
            self.__field_junk=UNKNOWN(value,**{'sizeinbytes': 543})

    def __delfield_junk(self): del self.__field_junk

    junk=property(__getfield_junk, __setfield_junk, __delfield_junk, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('startcommand', self.__field_startcommand, "Starting command for R/W buf parts")
        yield ('bufsize', self.__field_bufsize, None)
        yield ('comment', self.__field_comment, None)
        yield ('groupslotsused', self.__field_groupslotsused, None)
        yield ('pad', self.__field_pad, None)
        yield ('groupslotusedflags', self.__field_groupslotusedflags, None)
        yield ('slotsused', self.__field_slotsused, None)
        yield ('usedflags', self.__field_usedflags, None)
        yield ('speeddialindex', self.__field_speeddialindex, None)
        yield ('nameslotsused', self.__field_nameslotsused, "Always seems to be the same.  Why duplicated?")
        yield ('nameusedflags', self.__field_nameusedflags, None)
        yield ('sortorder', self.__field_sortorder, None)
        yield ('pbfirstletters', self.__field_pbfirstletters, None)
        yield ('numslotsused', self.__field_numslotsused, "Number of phone number slots used")
        yield ('numusedflags', self.__field_numusedflags, None)
        yield ('emailslotsused', self.__field_emailslotsused, None)
        yield ('emailusedflags', self.__field_emailusedflags, None)
        yield ('urlslotsused', self.__field_urlslotsused, None)
        yield ('urlusedflags', self.__field_urlusedflags, None)
        yield ('num_address', self.__field_num_address, None)
        yield ('addressusedflags', self.__field_addressusedflags, None)
        yield ('num_memo', self.__field_num_memo, None)
        yield ('memousedflags', self.__field_memousedflags, None)
        yield ('junk', self.__field_junk, None)




class _gen_p_sanyo6650_67(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_67,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_67:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_67,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_67,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




class _gen_p_sanyo6650_71(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_71,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_71:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_71,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_71,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




class _gen_p_sanyo6650_73(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['numslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_73,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_73:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_73,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_73,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_numslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_numslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numslot(self):
        return self.__field_numslot.getvalue()

    def __setfield_numslot(self, value):
        if isinstance(value,UINT):
            self.__field_numslot=value
        else:
            self.__field_numslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_numslot(self): del self.__field_numslot

    numslot=property(__getfield_numslot, __setfield_numslot, __delfield_numslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numslot', self.__field_numslot, None)




class _gen_p_sanyo6650_77(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_77,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_77:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_77,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_77,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




class _gen_p_sanyo6650_79(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_79,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_79:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_79,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_79,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslot(self):
        return self.__field_pbslot.getvalue()

    def __setfield_pbslot(self, value):
        if isinstance(value,UINT):
            self.__field_pbslot=value
        else:
            self.__field_pbslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslot(self): del self.__field_pbslot

    pbslot=property(__getfield_pbslot, __setfield_pbslot, __delfield_pbslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslot', self.__field_pbslot, None)




class _gen_p_sanyo6650_84(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_84,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_84:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_84,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_84,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




class _gen_p_sanyo6650_88(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_88,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_88:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_88,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_88,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




class _gen_p_sanyo6650_91(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_91,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_91:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_91,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_91,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




class _gen_p_sanyo6650_95(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_95,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_95:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_95,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_95,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




class _gen_p_sanyo6650_99(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo6650_99,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo6650_99:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo6650_99,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo6650_99,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




