//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/MaskAllView.h
//! @brief     Defines MaskAllView class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_MASKALLVIEW_H
#define BORNAGAIN_GUI_VIEW_MASK_MASKALLVIEW_H

#include "GUI/View/Mask/IShape2DView.h"

class MaskAllItem;

//! This is a view of MaskAllItem which covers whole detector plane with mask value=true.

class MaskAllView : public IShape2DView {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::MASKALL; }

    explicit MaskAllView(MaskAllItem* item);

    MaskItemObject* parameterizedItem() const override;

protected slots:
    void update_view() override;

protected:
    void paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*) override;

private:
    MaskAllItem* m_item;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_MASKALLVIEW_H
