//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/LayerEditorUtil.h
//! @brief     Defines class LayerEditorUtil
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LAYEREDITORUTIL_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LAYEREDITORUTIL_H

#include "GUI/Model/Descriptor/DoubleProperty.h"
#include "GUI/Model/Sample/FormFactorItemCatalog.h"
#include "GUI/Model/Sample/ItemWithParticlesCatalog.h"
#include <QLabel>
#include <QPushButton>
#include <functional>

class DoubleSpinBox;
class FormFactorItem;
class ItemWithParticles;
class Profile1DItem;
class Profile2DItem;
class QGridLayout;
class RotationItem;
class RoughnessItem;
class SampleEditorController;
class VectorProperty;

//! Utility functions to support layer oriented sample editor
namespace LayerEditorUtil {

void updateLabelUnit(QLabel* label);
void updateLabelUnit(QLabel* label, DoubleSpinBox* editor);

//! Create DoubleSpinBoxes for the DoubleProperties and connect them to
//! SampleEditorController::setDouble()
void addMultiPropertyToGrid(QGridLayout* m_gridLayout, int firstCol,
                            const DoubleProperties& valueProperties, SampleEditorController* ec,
                            bool vertically, bool addSpacer);

//! Create DoubleSpinBoxes for the DoubleProperties and connect them to the given setNewValue()
void addMultiPropertyToGrid(QGridLayout* m_gridLayout, int firstCol,
                            const DoubleProperties& valueProperties,
                            std::function<void(double, DoubleProperty&)> setNewValue,
                            bool vertically, bool addSpacer);

void addMultiPropertyToGrid(QGridLayout* m_gridLayout, int firstCol,
                            const DoubleProperties& valueProperties, SampleEditorController* ec,
                            bool addSpacer);

//! Create DoubleSpinBoxes for the DoubleProperties and connect them to
//! SampleEditorController::setDouble()
void addVectorToGrid(QGridLayout* m_gridLayout, int firstCol, VectorProperty& v,
                     SampleEditorController* ec, bool vertically, bool addSpacer);

//! Create DoubleSpinBoxes for the DoubleProperties and connect them to the given setNewValue()
void addVectorToGrid(QGridLayout* m_gridLayout, int firstCol, VectorProperty& v,
                     std::function<void(double, DoubleProperty&)> setNewValue, bool vertically,
                     bool addSpacer);
void addMagnetizationToGrid(QGridLayout* m_gridLayout, int firstCol, VectorProperty& v,
                            std::function<void(double, DoubleProperty&)> setNewValue,
                            bool vertically, bool addSpacer, bool with_z);

QLabel* createBoldLabel(const QString& text);

DoubleProperties doublePropertiesOfItem(RoughnessItem* item);
DoubleProperties doublePropertiesOfItem(FormFactorItem* item);
DoubleProperties doublePropertiesOfItem(Profile1DItem* item);
DoubleProperties doublePropertiesOfItem(Profile2DItem* item);
DoubleProperties doublePropertiesOfItem(RotationItem* item);

QWidget* createWidgetForItemWithParticles(QWidget* parentWidget,
                                          ItemWithParticles* itemWithParticles, bool allowAbundance,
                                          SampleEditorController* ec, bool allowRemove = true);

QPushButton*
createAddParticleButton(QWidget* parentWidget,
                        std::function<void(FormFactorItemCatalog::Type t)> slotAddFormFactor,
                        std::function<void(ItemWithParticlesCatalog::Type t)> slotAddParticle);

QList<QColor> predefinedLayerColors();

} // namespace LayerEditorUtil

#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_LAYEREDITORUTIL_H
