/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// pml
#include <pml/MultiComponent.h>
#include <pml/StructuralComponent.h>

// Camitk Core
#include <Component.h>

// pm component
#include "MultiComponentDCPopup.h"
#include "MultiComponentDC.h"
#include "StructuralComponentDC.h"

// ---------------------- constructor  ----------------------------
MultiComponentDCPopup::MultiComponentDCPopup(camitk::Component *dc, QWidget *parent) : camitk::ComponentPopupMenu(dc,parent) {
    addAction("New multiple component", SLOT(addNewMultiComponent()));
    addAction("New structural component", SLOT(addNewStructuralComponent()));
}

// ---------------------- addNewMultiComponent ----------------------------
void MultiComponentDCPopup::addNewMultiComponent() {
    // get the MC we are working on
    MultiComponent *myMC = dynamic_cast<MultiComponentDC *>(myComponent)->getMultiComponent();
    // Create a new empty multi component
    MultiComponent *mc = new MultiComponent(myMC->getPhysicalModel(), "new MC");
    // set the exclusive state (inherited from myMC)
    mc->setExclusive(myMC->isExclusive());
    // add the new MC to myMC
    myMC->addSubComponent(mc);
    // create a new DC and insert it in the physical model
    dynamic_cast<MultiComponentDC *>(myComponent)->addSubMC(mc);

    // tell the datamanager something has changed
    dynamic_cast<MultiComponentDC *>(myComponent)->getTopLevelComponent()->setModified();

    // refresh the explorer and auto select the new item
    myComponent->refresh();
}

// ---------------------- addNewStructuralComponent ----------------------------
void MultiComponentDCPopup::addNewStructuralComponent() {
    // get the MC we are working on
    MultiComponent *myMC = dynamic_cast<MultiComponentDC *>(myComponent)->getMultiComponent();
    // Create a new empty multi component
    StructuralComponent *sc = new StructuralComponent(myMC->getPhysicalModel(), "new SC");
    // set the exclusive state (inherited from myMC)
    sc->setExclusive(myMC->isExclusive());
    // set the default mode (by default = surface)
    sc->setMode(RenderingMode::SURFACE);
    // add the new MC to myMC
    myMC->addSubComponent(sc);
    // create a new DC and insert it in the physical model
    dynamic_cast<MultiComponentDC *>(myComponent)->addSubSC(sc);

    // tell the datamanager something has changed
    dynamic_cast<MultiComponentDC *>(myComponent)->getTopLevelComponent()->setModified();

    // refresh the explorer and auto select the new item
    myComponent->refresh();
}

