#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <p12.h>
#include <pk11pub.h>
#include <keyhi.h>
#include <nspr.h>
#include <nss.h>
#include <ssl.h>
#include <prerror.h>
#include <base64.h>
#include <pkcs12.h>
#include <p12plcy.h>
#include <cryptohi.h>
#include <secerr.h>
#include <certdb.h>

#include <sstream>
#include <string.h>
#include <stdio.h>

#include <string>
#include <iostream>

  static char* nss_get_password(PK11SlotInfo* slot, PRBool retry, void *arg) {
    (void)slot; /* unused */
    if(retry || NULL == arg)
      return NULL;
    else
      return (char *)PORT_Strdup((char *)arg);
  }

int main(void) {
    std::string configdir = "/home/wzqiang/nss_db";
    SECStatus rv;
    //Initialize NSPR
    PR_Init(PR_USER_THREAD, PR_PRIORITY_NORMAL, 256);
    //Set the PKCS #11 strings for the internal token
    char* db_name = PL_strdup("internal (software)              ");
    PK11_ConfigurePKCS11(NULL,NULL,NULL, db_name, NULL, NULL,NULL,NULL,8,1);
    //Initialize NSS and open the certificate database read-only
    rv = NSS_Initialize(configdir.c_str(), NULL, NULL, "secmod.db", 0);// NSS_INIT_READONLY);
    if (rv != SECSuccess) {
      rv = NSS_NoDB_Init(configdir.c_str());
    }
    if (rv != SECSuccess) {
      NSS_Shutdown();
      std::cout<<"NSS initialization failed on certificate database: "<<configdir<<std::endl;
      return -1;
    }
    NSS_SetDomesticPolicy();

    PK11_SetPasswordFunc(nss_get_password);

    SEC_PKCS12EnableCipher(PKCS12_RC4_40, 1);
    SEC_PKCS12EnableCipher(PKCS12_RC4_128, 1);
    SEC_PKCS12EnableCipher(PKCS12_RC2_CBC_40, 1);
    SEC_PKCS12EnableCipher(PKCS12_RC2_CBC_128, 1);
    SEC_PKCS12EnableCipher(PKCS12_DES_56, 1);
    SEC_PKCS12EnableCipher(PKCS12_DES_EDE3_168, 1);
    SEC_PKCS12SetPreferredCipher(PKCS12_DES_EDE3_168, 1);


    //Generate the rsa key
    PK11RSAGenParams rsaParams;
    rsaParams.keySizeInBits = 1024;
    rsaParams.pe = 0x10001;

    char* slotpw = (char*)"secretpw";
    PK11SlotInfo* slot = NULL;
    slot = PK11_GetInternalKeySlot();
    if(PK11_Authenticate(slot, PR_TRUE, slotpw) != SECSuccess) {
      std::cout<<"Failed to authenticate to key database"<<std::endl;;
      if(slot) PK11_FreeSlot(slot);
      return -1;
    }

    SECKEYPrivateKey* privk;
    SECKEYPublicKey* pubk;
    privk = PK11_GenerateKeyPair(slot, CKM_RSA_PKCS_KEY_PAIR_GEN, &rsaParams,
        &pubk, PR_TRUE, PR_FALSE, NULL);//PR_TRUE, PR_TRUE, slotpw);
    if(privk != NULL && pubk != NULL)
      std::cout<<"Succeeded to generate public/private key pair"<<std::endl;
    else {
      std::cout<<"Failed to generate public/private key pair"<<std::endl;
      if(slot) PK11_FreeSlot(slot);
      return -1;
    }
    char* privkey_name = (char*)"mytestkey";
    PK11_SetPrivateKeyNickname(privk, privkey_name);

    //Read the attributes
    if (privk) {
      PRBool isExtractable;
      SECItem value;
      SECStatus rv;
      //read CKA_EXTRACTABLE 
      rv = PK11_ReadRawAttribute(PK11_TypePrivKey, privk, CKA_EXTRACTABLE, &value);
      if (rv != SECSuccess) {
        std::cout<<"Failed to read CKA_EXTRACTABLE attribute from private key."<<std::endl;
        return -1;
      }
      if ((value.len == 1) && (value.data != NULL))
        isExtractable = !!(*(CK_BBOOL*)value.data);
      else
        rv = SECFailure;
      SECITEM_FreeItem(&value, PR_FALSE);
      if (rv == SECSuccess && !isExtractable) {
        std::cout<<"Private key is not extractable."<<std::endl;
        return -1;
      }
      //read CKA_SENSITIVE
      rv = PK11_ReadRawAttribute(PK11_TypePrivKey, privk, CKA_SENSITIVE,&value);
      if (rv != SECSuccess) {
        std::cout<<"Failed to read CKA_SENSITIVE attribute from private key."<<std::endl;
      }
      if ((value.len == 1)&&  (value.data != NULL))
        std::cout<<  ((!!(*(CK_BBOOL*)value.data)) ? "The key is sensitive":"The key is not sensitive") <<std::endl;
      SECITEM_FreeItem(&value, PR_FALSE);
      //read CKA_PRIVATE_EXPONENT
      rv = PK11_ReadRawAttribute(PK11_TypePrivKey, privk, CKA_PRIVATE_EXPONENT, &value);
      if (rv != SECSuccess) {
        std::cout<<"Failed to read CKA_PRIVATE_EXPONENT attribute from private key."<<std::endl;
        return -1;
      }
      SECITEM_FreeItem(&value, PR_FALSE);
      //read CKA_PRIME_1
      rv = PK11_ReadRawAttribute(PK11_TypePrivKey, privk, CKA_PRIME_1, &value);
      if (rv != SECSuccess) {
        std::cout<<"Failed to read CKA_PRIME_1 attribute from private key."<<std::endl;
        return -1;
      }
      SECITEM_FreeItem(&value, PR_FALSE);
      //read CKA_PRIME_2
      rv = PK11_ReadRawAttribute(PK11_TypePrivKey, privk, CKA_PRIME_2, &value);
      if (rv != SECSuccess) {
        std::cout<<"Failed to read CKA_PRIME_2 attribute from private key."<<std::endl;
        return -1;
      }
      SECITEM_FreeItem(&value, PR_FALSE);
      //read CKA_EXPONENT_1
      rv = PK11_ReadRawAttribute(PK11_TypePrivKey, privk, CKA_EXPONENT_1, &value);
      if (rv != SECSuccess) {
        std::cout<<"Failed to read CKA_EXPONENT_1 attribute from private key."<<std::endl;
        return -1;
      }
      SECITEM_FreeItem(&value, PR_FALSE);
      //read CKA_EXPONENT_2
      rv = PK11_ReadRawAttribute(PK11_TypePrivKey, privk, CKA_EXPONENT_2, &value);
      if (rv != SECSuccess) {
        std::cout<<"Failed to read CKA_EXPONENT_2 attribute from private key."<<std::endl;
        return -1;
      }
      SECITEM_FreeItem(&value, PR_FALSE);
      //read CKA_COEFFICIENT
      rv = PK11_ReadRawAttribute(PK11_TypePrivKey, privk, CKA_COEFFICIENT, &value);
      if (rv != SECSuccess) {
        std::cout<<"Failed to read CKA_COEFFICIENT attribute from private key."<<std::endl;
        return -1;
      }
      SECITEM_FreeItem(&value, PR_FALSE);
    }
    else { std::cout<<"The private key is not accessible."<<std::endl; return -1;}

    if(pubk) SECKEY_DestroyPublicKey(pubk);
    if(privk) SECKEY_DestroyPrivateKey(privk);
    if(slot) PK11_FreeSlot(slot);

    return 0;
}
